;*********************************************************************************
;
; @file    startup_es32f0930.s
; @brief   ES32F0930 Device Startup File
;
; @date    19 Sep 2022
; @author  AE Team
; @note
;          Change Logs:
;          Date            Author          Notes
;          28 Mar 2023     AE Team         the first version
;
; Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
;
; SPDX-License-Identifier: Apache-2.0
;
; Licensed under the Apache License, Version 2.0 (the License); you may
; not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an AS IS BASIS, WITHOUT
; WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.
;
;*********************************************************************************

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)
        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table

        DATA
__vector_table
        DCD     sfe(CSTACK)				    ;0,  load top of stack
        DCD     Reset_Handler			    ;1,  reset handler
        DCD     NMI_Handler				    ;2,  nmi handler
        DCD     HardFault_Handler		    ;3,  hard fault handler
        DCD     0					        ;4,  MPU Fault Handler
        DCD     0					        ;5,  Bus Fault Handler
        DCD     0					        ;6,  Usage Fault Handler
        DCD     0					        ;7,  Reserved
        DCD     0					        ;8,  Reserved
        DCD     0					        ;9,  Reserved
        DCD     0					        ;10, Reserved
        DCD     SVC_Handler				    ;11, svcall handler
        DCD     0					        ;12, Reserved
        DCD     0					        ;13, Reserved
        DCD     PENDSV_Handler              ;14, PENDSV Handler
        DCD     SYSTICK_Handler             ;15, SYSTICK Handler
        DCD     WWDT_IRQHandler             ;16, WWDT IRQHandler
        DCD     PVD_IRQHandler              ;17, PVD IRQHandler
        DCD     0                           ;18, Reserved
        DCD     LowPowerWakeup_IRQHandler   ;19, LowPowerWakeup IRQHandler
        DCD     RCU_IRQHandler              ;20, RCU IRQHandler
        DCD     EXTI0_1_IRQHandler          ;21, EXTI01_1 IRQHandler
        DCD     EXTI2_3_IRQHandler          ;22, EXTI2_3 IRQHandler
        DCD     EXTI4_15_IRQHandler         ;23, EXTI4_15 IRQHandler
        DCD     0                           ;24, Reserved
        DCD     0                           ;25, Reserved 
        DCD     LCD_IRQHandler              ;26, LCD IRQHandler
        DCD     MMC_IRQHandler              ;27, MMC IRQHandler
        DCD     EXTI_16to19_IRQHandler      ;28, EXTI_16to19 IRQHandler
        DCD     0                           ;29, Reserved
        DCD     BS16T1_IRQHandler           ;30, BS16T1 IRQHandler
        DCD     GP32C4T1_IRQHandler         ;31, GP32C4T1 IRQHandler
        DCD     0                           ;32, Reserved
        DCD     0                           ;33, Reserved
        DCD     0                           ;34, Reserved
        DCD     GP16C2T1_IRQHandler         ;35, GP16C2T1 IRQHandler
        DCD     GP16C2T2_IRQHandler         ;36, GP16C2T2 IRQHandler
        DCD     0                           ;37, Reserved
        DCD     0                           ;38, Reserved
        DCD     I2C1_IRQHandler             ;39, I2C1 IRQHandler
        DCD     0                           ;40, Reserved
        DCD     SPI1_IRQHandler             ;41, SPI1 IRQHandler
        DCD     0                           ;42, Reserved
        DCD     UART1_IRQHandler            ;43, UART1 IRQHandler
        DCD     0                           ;44, Reserved
        DCD     0                           ;45, Reserved
        DCD     SUART1_IRQHandler           ;46, SUART1 IRQHandler
        DCD     0                           ;47, Reserved
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:NOROOT:REORDER(2)
Reset_Handler
        LDR     R0, =__iar_program_start
        BX      R0
        
        PUBWEAK NMI_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
NMI_Handler
        B NMI_Handler

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
HardFault_Handler
        B HardFault_Handler

        PUBWEAK SVC_Handler
        SECTION .text:CODE:NOROOT:REORDER(1)
SVC_Handler
        B SVC_Handler
		
    	PUBWEAK PENDSV_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
PENDSV_Handler
    	B PENDSV_Handler

   	PUBWEAK SYSTICK_Handler
    	SECTION .text:CODE:NOROOT:REORDER(1)
SYSTICK_Handler
    	B SYSTICK_Handler

        PUBWEAK WWDT_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
WWDT_IRQHandler
        B WWDT_IRQHandler

	PUBWEAK PVD_IRQHandler
	SECTION .text:CODE:NOROOT:REORDER(1)
PVD_IRQHandler
	B PVD_IRQHandler
		
        PUBWEAK LowPowerWakeup_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LowPowerWakeup_IRQHandler
        B LowPowerWakeup_IRQHandler
        
        PUBWEAK RCU_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
RCU_IRQHandler
        B RCU_IRQHandler

        PUBWEAK EXTI0_1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI0_1_IRQHandler
        B EXTI0_1_IRQHandler

        PUBWEAK EXTI2_3_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI2_3_IRQHandler
        B EXTI2_3_IRQHandler

        PUBWEAK EXTI4_15_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI4_15_IRQHandler
        B EXTI4_15_IRQHandler

        PUBWEAK LCD_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
LCD_IRQHandler
        B LCD_IRQHandler
        
        PUBWEAK MMC_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
MMC_IRQHandler
        B MMC_IRQHandler
        
        PUBWEAK EXTI_16to19_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
EXTI_16to19_IRQHandler
        B EXTI_16to19_IRQHandler

     	PUBWEAK BS16T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
BS16T1_IRQHandler
        B BS16T1_IRQHandler

        PUBWEAK GP32C4T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP32C4T1_IRQHandler
        B GP32C4T1_IRQHandler

        PUBWEAK GP16C2T1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T1_IRQHandler
        B GP16C2T1_IRQHandler

        PUBWEAK GP16C2T2_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
GP16C2T2_IRQHandler
        B GP16C2T2_IRQHandler

        PUBWEAK I2C1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
I2C1_IRQHandler
        B I2C1_IRQHandler

        PUBWEAK SPI1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SPI1_IRQHandler
        B SPI1_IRQHandler

		PUBWEAK UART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
UART1_IRQHandler
        B UART1_IRQHandler

        PUBWEAK SUART1_IRQHandler
        SECTION .text:CODE:NOROOT:REORDER(1)
SUART1_IRQHandler
        B SUART1_IRQHandler

        END
