/**********************************************************************************
 *
 * @file    reg_wwdt.h
 * @brief   WWDT Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __WWDT_H__
#define __WWDT_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for WWDT_CON register ************************/

#define  WWDT_CON_WDGA_POS  7U
#define  WWDT_CON_WDGA_MSK  BIT(WWDT_CON_WDGA_POS)

#define  WWDT_CON_T_POSS  0U
#define  WWDT_CON_T_POSE  6U
#define  WWDT_CON_T_MSK  BITS(WWDT_CON_T_POSS,WWDT_CON_T_POSE)

/****************** Bit definition for WWDT_CFG register ************************/

#define  WWDT_CFG_WDGTB_POSS  7U
#define  WWDT_CFG_WDGTB_POSE  8U
#define  WWDT_CFG_WDGTB_MSK  BITS(WWDT_CFG_WDGTB_POSS,WWDT_CFG_WDGTB_POSE)

#define  WWDT_CFG_W_POSS  0U
#define  WWDT_CFG_W_POSE  6U
#define  WWDT_CFG_W_MSK  BITS(WWDT_CFG_W_POSS,WWDT_CFG_W_POSE)

/****************** Bit definition for WWDT_IER register ************************/

#define  WWDT_IER_EWIE_POS  0U
#define  WWDT_IER_EWIE_MSK  BIT(WWDT_IER_EWIE_POS)

/****************** Bit definition for WWDT_IDR register ************************/

#define  WWDT_IDR_EWID_POS  0U
#define  WWDT_IDR_EWID_MSK  BIT(WWDT_IDR_EWID_POS)

/****************** Bit definition for WWDT_IVS register ************************/

#define  WWDT_IVS_EWIS_POS  0U
#define  WWDT_IVS_EWIS_MSK  BIT(WWDT_IVS_EWIS_POS)

/****************** Bit definition for WWDT_RIF register ************************/

#define  WWDT_RIF_EWIF_POS  0U
#define  WWDT_RIF_EWIF_MSK  BIT(WWDT_RIF_EWIF_POS)

/****************** Bit definition for WWDT_IFM register ************************/

#define  WWDT_IFM_EWIM_POS  0U
#define  WWDT_IFM_EWIM_MSK  BIT(WWDT_IFM_EWIM_POS)

/****************** Bit definition for WWDT_ICR register ************************/

#define  WWDT_ICR_EWIC_POS  0U
#define  WWDT_ICR_EWIC_MSK  BIT(WWDT_ICR_EWIC_POS)

typedef struct
{
    __IO uint32_t CON;
    __IO uint32_t CFG;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
} WWDT_TypeDef;

#endif
