/**********************************************************************************
 *
 * @file    reg_timer.h
 * @brief   TIMER Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __TIMER_H__
#define __TIMER_H__

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for TIMER_CON1 register ************************/

#define  TIMER_CON1_DBGSEL_POS  15U
#define  TIMER_CON1_DBGSEL_MSK  BIT(TIMER_CON1_DBGSEL_POS)

#define  TIMER_CON1_DFCKSEL_POSS  8U
#define  TIMER_CON1_DFCKSEL_POSE  9U
#define  TIMER_CON1_DFCKSEL_MSK  BITS(TIMER_CON1_DFCKSEL_POSS,TIMER_CON1_DFCKSEL_POSE)

#define  TIMER_CON1_ARPEN_POS  7U
#define  TIMER_CON1_ARPEN_MSK  BIT(TIMER_CON1_ARPEN_POS)

#define  TIMER_CON1_CMSEL_POSS  5U
#define  TIMER_CON1_CMSEL_POSE  6U
#define  TIMER_CON1_CMSEL_MSK  BITS(TIMER_CON1_CMSEL_POSS,TIMER_CON1_CMSEL_POSE)

#define  TIMER_CON1_DIRSEL_POS  4U
#define  TIMER_CON1_DIRSEL_MSK  BIT(TIMER_CON1_DIRSEL_POS)

#define  TIMER_CON1_SPMEN_POS  3U
#define  TIMER_CON1_SPMEN_MSK  BIT(TIMER_CON1_SPMEN_POS)

#define  TIMER_CON1_UERSEL_POS  2U
#define  TIMER_CON1_UERSEL_MSK  BIT(TIMER_CON1_UERSEL_POS)

#define  TIMER_CON1_DISUE_POS  1U
#define  TIMER_CON1_DISUE_MSK  BIT(TIMER_CON1_DISUE_POS)

#define  TIMER_CON1_CNTEN_POS  0U
#define  TIMER_CON1_CNTEN_MSK  BIT(TIMER_CON1_CNTEN_POS)

/****************** Bit definition for TIMER_CON2 register ************************/

#define  TIMER_CON2_OISS2_POS  10U
#define  TIMER_CON2_OISS2_MSK  BIT(TIMER_CON2_OISS2_POS)

#define  TIMER_CON2_OISS1N_POS  9U
#define  TIMER_CON2_OISS1N_MSK  BIT(TIMER_CON2_OISS1N_POS)

#define  TIMER_CON2_OISS1_POS  8U
#define  TIMER_CON2_OISS1_MSK  BIT(TIMER_CON2_OISS1_POS)

#define  TIMER_CON2_I1SEL_POS  7U
#define  TIMER_CON2_I1SEL_MSK  BIT(TIMER_CON2_I1SEL_POS)

#define  TIMER_CON2_MMSEL_POSS  4U
#define  TIMER_CON2_MMSEL_POSE  6U
#define  TIMER_CON2_MMSEL_MSK  BITS(TIMER_CON2_MMSEL_POSS,TIMER_CON2_MMSEL_POSE)


#define  TIMER_CON2_CCUSEL_POS  2U
#define  TIMER_CON2_CCUSEL_MSK  BIT(TIMER_CON2_CCUSEL_POS)

#define  TIMER_CON2_CCPCEN_POS  0U
#define  TIMER_CON2_CCPCEN_MSK  BIT(TIMER_CON2_CCPCEN_POS)


/****************** Bit definition for TIMER_SMCON register ************************/

#define  TIMER_SMCON_ETPOL_POS  15U
#define  TIMER_SMCON_ETPOL_MSK  BIT(TIMER_SMCON_ETPOL_POS)

#define  TIMER_SMCON_ECM2EN_POS  14U
#define  TIMER_SMCON_ECM2EN_MSK  BIT(TIMER_SMCON_ECM2EN_POS)

#define  TIMER_SMCON_ETFLT_POSS  8U
#define  TIMER_SMCON_ETFLT_POSE  11U
#define  TIMER_SMCON_ETFLT_MSK  BITS(TIMER_SMCON_ETFLT_POSS,TIMER_SMCON_ETFLT_POSE)

#define  TIMER_SMCON_MSCFG_POS  7U
#define  TIMER_SMCON_MSCFG_MSK  BIT(TIMER_SMCON_MSCFG_POS)

#define  TIMER_SMCON_TSSEL_POSS  4U
#define  TIMER_SMCON_TSSEL_POSE  6U
#define  TIMER_SMCON_TSSEL_MSK  BITS(TIMER_SMCON_TSSEL_POSS,TIMER_SMCON_TSSEL_POSE)

#define  TIMER_SMCON_CHCSEL_POS  3U
#define  TIMER_SMCON_CHCSEL_MSK  BIT(TIMER_SMCON_CHCSEL_POS)

#define  TIMER_SMCON_SMODS_POSS  0U
#define  TIMER_SMCON_SMODS_POSE  2U
#define  TIMER_SMCON_SMODS_MSK  BITS(TIMER_SMCON_SMODS_POSS,TIMER_SMCON_SMODS_POSE)

/****************** Bit definition for TIMER_IER register ************************/

#define  TIMER_IER_CH4OVI_POS  12U
#define  TIMER_IER_CH4OVI_MSK  BIT(TIMER_IER_CH4OVI_POS)

#define  TIMER_IER_CH3OVI_POS  11U
#define  TIMER_IER_CH3OVI_MSK  BIT(TIMER_IER_CH3OVI_POS)

#define  TIMER_IER_CH2OVI_POS  10U
#define  TIMER_IER_CH2OVI_MSK  BIT(TIMER_IER_CH2OVI_POS)

#define  TIMER_IER_CH1OVI_POS  9U
#define  TIMER_IER_CH1OVI_MSK  BIT(TIMER_IER_CH1OVI_POS)

#define  TIMER_IER_BRKI_POS  7U
#define  TIMER_IER_BRKI_MSK  BIT(TIMER_IER_BRKI_POS)

#define  TIMER_IER_TRGI_POS  6U
#define  TIMER_IER_TRGI_MSK  BIT(TIMER_IER_TRGI_POS)

#define  TIMER_IER_COMI_POS  5U
#define  TIMER_IER_COMI_MSK  BIT(TIMER_IER_COMI_POS)

#define  TIMER_IER_CH4I_POS  4U
#define  TIMER_IER_CH4I_MSK  BIT(TIMER_IER_CH4I_POS)

#define  TIMER_IER_CH3I_POS  3U
#define  TIMER_IER_CH3I_MSK  BIT(TIMER_IER_CH3I_POS)

#define  TIMER_IER_CH2I_POS  2U
#define  TIMER_IER_CH2I_MSK  BIT(TIMER_IER_CH2I_POS)

#define  TIMER_IER_CH1I_POS  1U
#define  TIMER_IER_CH1I_MSK  BIT(TIMER_IER_CH1I_POS)

#define  TIMER_IER_UI_POS  0U
#define  TIMER_IER_UI_MSK  BIT(TIMER_IER_UI_POS)

/****************** Bit definition for TIMER_IDR register ************************/

#define  TIMER_IDR_CH4OVI_POS  12U
#define  TIMER_IDR_CH4OVI_MSK  BIT(TIMER_IDR_CH4OVI_POS)

#define  TIMER_IDR_CH3OVI_POS  11U
#define  TIMER_IDR_CH3OVI_MSK  BIT(TIMER_IDR_CH3OVI_POS)

#define  TIMER_IDR_CH2OVI_POS  10U
#define  TIMER_IDR_CH2OVI_MSK  BIT(TIMER_IDR_CH2OVI_POS)

#define  TIMER_IDR_CH1OVI_POS  9U
#define  TIMER_IDR_CH1OVI_MSK  BIT(TIMER_IDR_CH1OVI_POS)

#define  TIMER_IDR_BRKI_POS  7U
#define  TIMER_IDR_BRKI_MSK  BIT(TIMER_IDR_BRKI_POS)


#define  TIMER_IDR_TRGI_POS  6U
#define  TIMER_IDR_TRGI_MSK  BIT(TIMER_IDR_TRGI_POS)

#define  TIMER_IDR_COMI_POS  5U
#define  TIMER_IDR_COMI_MSK  BIT(TIMER_IDR_COMI_POS)

#define  TIMER_IDR_CH4I_POS  4U
#define  TIMER_IDR_CH4I_MSK  BIT(TIMER_IDR_CH4I_POS)

#define  TIMER_IDR_CH3I_POS  3U
#define  TIMER_IDR_CH3I_MSK  BIT(TIMER_IDR_CH3I_POS)

#define  TIMER_IDR_CH2I_POS  2U
#define  TIMER_IDR_CH2I_MSK  BIT(TIMER_IDR_CH2I_POS)

#define  TIMER_IDR_CH1I_POS  1U
#define  TIMER_IDR_CH1I_MSK  BIT(TIMER_IDR_CH1I_POS)

#define  TIMER_IDR_UI_POS  0U
#define  TIMER_IDR_UI_MSK  BIT(TIMER_IDR_UI_POS)

/****************** Bit definition for TIMER_IVS register ************************/

#define  TIMER_IVS_CH4OVI_POS  12U
#define  TIMER_IVS_CH4OVI_MSK  BIT(TIMER_IVS_CH4OVI_POS)

#define  TIMER_IVS_CH3OVI_POS  11U
#define  TIMER_IVS_CH3OVI_MSK  BIT(TIMER_IVS_CH3OVI_POS)

#define  TIMER_IVS_CH2OVI_POS  10U
#define  TIMER_IVS_CH2OVI_MSK  BIT(TIMER_IVS_CH2OVI_POS)

#define  TIMER_IVS_CH1OVI_POS  9U
#define  TIMER_IVS_CH1OVI_MSK  BIT(TIMER_IVS_CH1OVI_POS)

#define  TIMER_IVS_BRKI_POS  7U
#define  TIMER_IVS_BRKI_MSK  BIT(TIMER_IVS_BRKI_POS)


#define  TIMER_IVS_TRGI_POS  6U
#define  TIMER_IVS_TRGI_MSK  BIT(TIMER_IVS_TRGI_POS)

#define  TIMER_IVS_COMI_POS  5U
#define  TIMER_IVS_COMI_MSK  BIT(TIMER_IVS_COMI_POS)

#define  TIMER_IVS_CH4I_POS  4U
#define  TIMER_IVS_CH4I_MSK  BIT(TIMER_IVS_CH4I_POS)

#define  TIMER_IVS_CH3I_POS  3U
#define  TIMER_IVS_CH3I_MSK  BIT(TIMER_IVS_CH3I_POS)

#define  TIMER_IVS_CH2I_POS  2U
#define  TIMER_IVS_CH2I_MSK  BIT(TIMER_IVS_CH2I_POS)

#define  TIMER_IVS_CH1I_POS  1U
#define  TIMER_IVS_CH1I_MSK  BIT(TIMER_IVS_CH1I_POS)

#define  TIMER_IVS_UI_POS  0U
#define  TIMER_IVS_UI_MSK  BIT(TIMER_IVS_UI_POS)

/****************** Bit definition for TIMER_RIF register ************************/

#define  TIMER_RIF_CH4OVI_POS  12U
#define  TIMER_RIF_CH4OVI_MSK  BIT(TIMER_RIF_CH4OVI_POS)

#define  TIMER_RIF_CH3OVI_POS  11U
#define  TIMER_RIF_CH3OVI_MSK  BIT(TIMER_RIF_CH3OVI_POS)

#define  TIMER_RIF_CH2OVI_POS  10U
#define  TIMER_RIF_CH2OVI_MSK  BIT(TIMER_RIF_CH2OVI_POS)

#define  TIMER_RIF_CH1OVI_POS  9U
#define  TIMER_RIF_CH1OVI_MSK  BIT(TIMER_RIF_CH1OVI_POS)

#define  TIMER_RIF_BRKI_POS  7U
#define  TIMER_RIF_BRKI_MSK  BIT(TIMER_RIF_BRKI_POS)


#define  TIMER_RIF_TRGI_POS  6U
#define  TIMER_RIF_TRGI_MSK  BIT(TIMER_RIF_TRGI_POS)

#define  TIMER_RIF_COMI_POS  5U
#define  TIMER_RIF_COMI_MSK  BIT(TIMER_RIF_COMI_POS)

#define  TIMER_RIF_CH4I_POS  4U
#define  TIMER_RIF_CH4I_MSK  BIT(TIMER_RIF_CH4I_POS)

#define  TIMER_RIF_CH3I_POS  3U
#define  TIMER_RIF_CH3I_MSK  BIT(TIMER_RIF_CH3I_POS)

#define  TIMER_RIF_CH2I_POS  2U
#define  TIMER_RIF_CH2I_MSK  BIT(TIMER_RIF_CH2I_POS)

#define  TIMER_RIF_CH1I_POS  1U
#define  TIMER_RIF_CH1I_MSK  BIT(TIMER_RIF_CH1I_POS)

#define  TIMER_RIF_UI_POS  0U
#define  TIMER_RIF_UI_MSK  BIT(TIMER_RIF_UI_POS)

/****************** Bit definition for TIMER_IFM register ************************/

#define  TIMER_IFM_CH4OVI_POS  12U
#define  TIMER_IFM_CH4OVI_MSK  BIT(TIMER_IFM_CH4OVI_POS)

#define  TIMER_IFM_CH3OVI_POS  11U
#define  TIMER_IFM_CH3OVI_MSK  BIT(TIMER_IFM_CH3OVI_POS)

#define  TIMER_IFM_CH2OVI_POS  10U
#define  TIMER_IFM_CH2OVI_MSK  BIT(TIMER_IFM_CH2OVI_POS)

#define  TIMER_IFM_CH1OVI_POS  9U
#define  TIMER_IFM_CH1OVI_MSK  BIT(TIMER_IFM_CH1OVI_POS)

#define  TIMER_IFM_BRKI_POS  7U
#define  TIMER_IFM_BRKI_MSK  BIT(TIMER_IFM_BRKI_POS)

#define  TIMER_IFM_TRGI_POS  6U
#define  TIMER_IFM_TRGI_MSK  BIT(TIMER_IFM_TRGI_POS)

#define  TIMER_IFM_COMI_POS  5U
#define  TIMER_IFM_COMI_MSK  BIT(TIMER_IFM_COMI_POS)

#define  TIMER_IFM_CH4I_POS  4U
#define  TIMER_IFM_CH4I_MSK  BIT(TIMER_IFM_CH4I_POS)

#define  TIMER_IFM_CH3I_POS  3U
#define  TIMER_IFM_CH3I_MSK  BIT(TIMER_IFM_CH3I_POS)

#define  TIMER_IFM_CH2I_POS  2U
#define  TIMER_IFM_CH2I_MSK  BIT(TIMER_IFM_CH2I_POS)

#define  TIMER_IFM_CH1I_POS  1U
#define  TIMER_IFM_CH1I_MSK  BIT(TIMER_IFM_CH1I_POS)

#define  TIMER_IFM_UI_POS  0U
#define  TIMER_IFM_UI_MSK  BIT(TIMER_IFM_UI_POS)

/****************** Bit definition for TIMER_ICR register ************************/

#define  TIMER_ICR_CH4OVI_POS  12U
#define  TIMER_ICR_CH4OVI_MSK  BIT(TIMER_ICR_CH4OVI_POS)

#define  TIMER_ICR_CH3OVI_POS  11U
#define  TIMER_ICR_CH3OVI_MSK  BIT(TIMER_ICR_CH3OVI_POS)

#define  TIMER_ICR_CH2OVI_POS  10U
#define  TIMER_ICR_CH2OVI_MSK  BIT(TIMER_ICR_CH2OVI_POS)

#define  TIMER_ICR_CH1OVI_POS  9U
#define  TIMER_ICR_CH1OVI_MSK  BIT(TIMER_ICR_CH1OVI_POS)

#define  TIMER_ICR_BRKI_POS  7U
#define  TIMER_ICR_BRKI_MSK  BIT(TIMER_ICR_BRKI_POS)


#define  TIMER_ICR_TRGI_POS  6U
#define  TIMER_ICR_TRGI_MSK  BIT(TIMER_ICR_TRGI_POS)

#define  TIMER_ICR_COMI_POS  5U
#define  TIMER_ICR_COMI_MSK  BIT(TIMER_ICR_COMI_POS)

#define  TIMER_ICR_CH4I_POS  4U
#define  TIMER_ICR_CH4I_MSK  BIT(TIMER_ICR_CH4I_POS)

#define  TIMER_ICR_CH3I_POS  3U
#define  TIMER_ICR_CH3I_MSK  BIT(TIMER_ICR_CH3I_POS)

#define  TIMER_ICR_CH2I_POS  2U
#define  TIMER_ICR_CH2I_MSK  BIT(TIMER_ICR_CH2I_POS)

#define  TIMER_ICR_CH1I_POS  1U
#define  TIMER_ICR_CH1I_MSK  BIT(TIMER_ICR_CH1I_POS)

#define  TIMER_ICR_UI_POS  0U
#define  TIMER_ICR_UI_MSK  BIT(TIMER_ICR_UI_POS)

/****************** Bit definition for TIMER_SGE register ************************/

#define  TIMER_SGE_SGBRK_POS  7U
#define  TIMER_SGE_SGBRK_MSK  BIT(TIMER_SGE_SGBRK_POS)


#define  TIMER_SGE_SGTRG_POS  6U
#define  TIMER_SGE_SGTRG_MSK  BIT(TIMER_SGE_SGTRG_POS)

#define  TIMER_SGE_SGCOM_POS  5U
#define  TIMER_SGE_SGCOM_MSK  BIT(TIMER_SGE_SGCOM_POS)


#define  TIMER_SGE_SGCH4_POS  4U
#define  TIMER_SGE_SGCH4_MSK  BIT(TIMER_SGE_SGCH4_POS)

#define  TIMER_SGE_SGCH3_POS  3U
#define  TIMER_SGE_SGCH3_MSK  BIT(TIMER_SGE_SGCH3_POS)

#define  TIMER_SGE_SGCH2_POS  2U
#define  TIMER_SGE_SGCH2_MSK  BIT(TIMER_SGE_SGCH2_POS)

#define  TIMER_SGE_SGCH1_POS  1U
#define  TIMER_SGE_SGCH1_MSK  BIT(TIMER_SGE_SGCH1_POS)

#define  TIMER_SGE_SGU_POS  0U
#define  TIMER_SGE_SGU_MSK  BIT(TIMER_SGE_SGU_POS)

/****************** Bit definition for TIMER_CHMR1_OUTPUT register ************************/

#define TIMER_CHMR1_OUTPUT_CH2OCLREN_POS 15U
#define TIMER_CHMR1_OUTPUT_CH2OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2OCLREN_POS)

#define TIMER_CHMR1_OUTPUT_CH2MOD_POSS 12U
#define TIMER_CHMR1_OUTPUT_CH2MOD_POSE 14U
#define TIMER_CHMR1_OUTPUT_CH2MOD_MSK BITS(TIMER_CHMR1_OUTPUT_CH2MOD_POSS,TIMER_CHMR1_OUTPUT_CH2MOD_POSE)

#define TIMER_CHMR1_OUTPUT_CH2PEN_POS 11U
#define TIMER_CHMR1_OUTPUT_CH2PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2PEN_POS)

#define TIMER_CHMR1_OUTPUT_CH2FEN_POS 10U
#define TIMER_CHMR1_OUTPUT_CH2FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2FEN_POS)

#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_MSK BITS(TIMER_CHMR1_OUTPUT_CC2SSEL_POSS,TIMER_CHMR1_OUTPUT_CC2SSEL_POSE)

#define TIMER_CHMR1_OUTPUT_CH1OCLREN_POS 7U
#define TIMER_CHMR1_OUTPUT_CH1OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1OCLREN_POS)

#define TIMER_CHMR1_OUTPUT_CH1MOD_POSS 4U
#define TIMER_CHMR1_OUTPUT_CH1MOD_POSE 6U
#define TIMER_CHMR1_OUTPUT_CH1MOD_MSK BITS(TIMER_CHMR1_OUTPUT_CH1MOD_POSS,TIMER_CHMR1_OUTPUT_CH1MOD_POSE)

#define TIMER_CHMR1_OUTPUT_CH1PEN_POS 3U
#define TIMER_CHMR1_OUTPUT_CH1PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1PEN_POS)

#define TIMER_CHMR1_OUTPUT_CH1FEN_POS 2U
#define TIMER_CHMR1_OUTPUT_CH1FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1FEN_POS)

#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_MSK BITS(TIMER_CHMR1_OUTPUT_CC1SSEL_POSS,TIMER_CHMR1_OUTPUT_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR1_INPUT register ************************/

#define TIMER_CHMR1_INPUT_I2FLT_POSS 12U
#define TIMER_CHMR1_INPUT_I2FLT_POSE 15U
#define TIMER_CHMR1_INPUT_I2FLT_MSK BITS(TIMER_CHMR1_INPUT_I2FLT_POSS,TIMER_CHMR1_INPUT_I2FLT_POSE)

#define TIMER_CHMR1_INPUT_I2PRES_POSS 10U
#define TIMER_CHMR1_INPUT_I2PRES_POSE 11U
#define TIMER_CHMR1_INPUT_I2PRES_MSK BITS(TIMER_CHMR1_INPUT_I2PRES_POSS,TIMER_CHMR1_INPUT_I2PRES_POSE)

#define TIMER_CHMR1_INPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_INPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_INPUT_CC2SSEL_MSK BITS(TIMER_CHMR1_INPUT_CC2SSEL_POSS,TIMER_CHMR1_INPUT_CC2SSEL_POSE)

#define TIMER_CHMR1_INPUT_I1FLT_POSS 4U
#define TIMER_CHMR1_INPUT_I1FLT_POSE 7U
#define TIMER_CHMR1_INPUT_I1FLT_MSK BITS(TIMER_CHMR1_INPUT_I1FLT_POSS,TIMER_CHMR1_INPUT_I1FLT_POSE)

#define TIMER_CHMR1_INPUT_I1PRES_POSS 2U
#define TIMER_CHMR1_INPUT_I1PRES_POSE 3U
#define TIMER_CHMR1_INPUT_I1PRES_MSK BITS(TIMER_CHMR1_INPUT_I1PRES_POSS,TIMER_CHMR1_INPUT_I1PRES_POSE)

#define TIMER_CHMR1_INPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_INPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_INPUT_CC1SSEL_MSK BITS(TIMER_CHMR1_INPUT_CC1SSEL_POSS,TIMER_CHMR1_INPUT_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2_OUTPUT register ************************/

#define TIMER_CHMR2_OUTPUT_CH4OCLREN_POS 15U
#define TIMER_CHMR2_OUTPUT_CH4OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4OCLREN_POS)

#define TIMER_CHMR2_OUTPUT_CH4MOD_POSS 12U
#define TIMER_CHMR2_OUTPUT_CH4MOD_POSE 14U
#define TIMER_CHMR2_OUTPUT_CH4MOD_MSK BITS(TIMER_CHMR2_OUTPUT_CH4MOD_POSS,TIMER_CHMR2_OUTPUT_CH4MOD_POSE)

#define TIMER_CHMR2_OUTPUT_CH4PEN_POS 11U
#define TIMER_CHMR2_OUTPUT_CH4PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4PEN_POS)

#define TIMER_CHMR2_OUTPUT_CH4FEN_POS 10U
#define TIMER_CHMR2_OUTPUT_CH4FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4FEN_POS)

#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_MSK BITS(TIMER_CHMR2_OUTPUT_CC4SSEL_POSS,TIMER_CHMR2_OUTPUT_CC4SSEL_POSE)

#define TIMER_CHMR2_OUTPUT_CH3OCLREN_POS 7U
#define TIMER_CHMR2_OUTPUT_CH3OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3OCLREN_POS)

#define TIMER_CHMR2_OUTPUT_CH3MOD_POSS 4U
#define TIMER_CHMR2_OUTPUT_CH3MOD_POSE 6U
#define TIMER_CHMR2_OUTPUT_CH3MOD_MSK BITS(TIMER_CHMR2_OUTPUT_CH3MOD_POSS,TIMER_CHMR2_OUTPUT_CH3MOD_POSE)

#define TIMER_CHMR2_OUTPUT_CH3PEN_POS 3U
#define TIMER_CHMR2_OUTPUT_CH3PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3PEN_POS)

#define TIMER_CHMR2_OUTPUT_CH3FEN_POS 2U
#define TIMER_CHMR2_OUTPUT_CH3FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3FEN_POS)

#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_MSK BITS(TIMER_CHMR2_OUTPUT_CC3SSEL_POSS,TIMER_CHMR2_OUTPUT_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2_INPUT register ************************/

#define TIMER_CHMR2_INPUT_I4FLT_POSS 12U
#define TIMER_CHMR2_INPUT_I4FLT_POSE 15U
#define TIMER_CHMR2_INPUT_I4FLT_MSK BITS(TIMER_CHMR2_INPUT_I4FLT_POSS,TIMER_CHMR2_INPUT_I4FLT_POSE)

#define TIMER_CHMR2_INPUT_I4PRES_POSS 10U
#define TIMER_CHMR2_INPUT_I4PRES_POSE 11U
#define TIMER_CHMR2_INPUT_I4PRES_MSK BITS(TIMER_CHMR2_INPUT_I4PRES_POSS,TIMER_CHMR2_INPUT_I4PRES_POSE)

#define TIMER_CHMR2_INPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_INPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_INPUT_CC4SSEL_MSK BITS(TIMER_CHMR2_INPUT_CC4SSEL_POSS,TIMER_CHMR2_INPUT_CC4SSEL_POSE)

#define TIMER_CHMR2_INPUT_I3FLT_POSS 4U
#define TIMER_CHMR2_INPUT_I3FLT_POSE 7U
#define TIMER_CHMR2_INPUT_I3FLT_MSK BITS(TIMER_CHMR2_INPUT_I3FLT_POSS,TIMER_CHMR2_INPUT_I3FLT_POSE)

#define TIMER_CHMR2_INPUT_I3PRES_POSS 2U
#define TIMER_CHMR2_INPUT_I3PRES_POSE 3U
#define TIMER_CHMR2_INPUT_I3PRES_MSK BITS(TIMER_CHMR2_INPUT_I3PRES_POSS,TIMER_CHMR2_INPUT_I3PRES_POSE)

#define TIMER_CHMR2_INPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_INPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_INPUT_CC3SSEL_MSK BITS(TIMER_CHMR2_INPUT_CC3SSEL_POSS,TIMER_CHMR2_INPUT_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CCEP register ************************/

#define  TIMER_CCEP_CC4NPOL_POS  15U
#define  TIMER_CCEP_CC4NPOL_MSK  BIT(TIMER_CCEP_CC4NPOL_POS)

#define  TIMER_CCEP_CC4POL_POS  13U
#define  TIMER_CCEP_CC4POL_MSK  BIT(TIMER_CCEP_CC4POL_POS)

#define  TIMER_CCEP_CC4EN_POS  12U
#define  TIMER_CCEP_CC4EN_MSK  BIT(TIMER_CCEP_CC4EN_POS)

#define  TIMER_CCEP_CC3NPOL_POS  11U
#define  TIMER_CCEP_CC3NPOL_MSK  BIT(TIMER_CCEP_CC3NPOL_POS)

#define  TIMER_CCEP_CC3POL_POS  9U
#define  TIMER_CCEP_CC3POL_MSK  BIT(TIMER_CCEP_CC3POL_POS)

#define  TIMER_CCEP_CC3EN_POS  8U
#define  TIMER_CCEP_CC3EN_MSK  BIT(TIMER_CCEP_CC3EN_POS)

#define  TIMER_CCEP_CC2NPOL_POS  7U
#define  TIMER_CCEP_CC2NPOL_MSK  BIT(TIMER_CCEP_CC2NPOL_POS)

#define  TIMER_CCEP_CC2POL_POS  5U
#define  TIMER_CCEP_CC2POL_MSK  BIT(TIMER_CCEP_CC2POL_POS)

#define  TIMER_CCEP_CC2EN_POS  4U
#define  TIMER_CCEP_CC2EN_MSK  BIT(TIMER_CCEP_CC2EN_POS)

#define  TIMER_CCEP_CC1NPOL_POS  3U
#define  TIMER_CCEP_CC1NPOL_MSK  BIT(TIMER_CCEP_CC1NPOL_POS)

#define  TIMER_CCEP_CC1NEN_POS  2U
#define  TIMER_CCEP_CC1NEN_MSK  BIT(TIMER_CCEP_CC1NEN_POS)
#define  TIMER_CCEP_CC1POL_POS  1U
#define  TIMER_CCEP_CC1POL_MSK  BIT(TIMER_CCEP_CC1POL_POS)

#define  TIMER_CCEP_CC1EN_POS  0U
#define  TIMER_CCEP_CC1EN_MSK  BIT(TIMER_CCEP_CC1EN_POS)

/****************** Bit definition for TIMER_COUNT register ************************/

#define  TIMER_COUNT_CNTV_POSS  0U
#define  TIMER_COUNT_CNTV_POSE  31U
#define  TIMER_COUNT_CNTV_MSK  BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)

/****************** Bit definition for TIMER_PRES register ************************/

#define  TIMER_PRES_PSCV_POSS  0U
#define  TIMER_PRES_PSCV_POSE  15U
#define  TIMER_PRES_PSCV_MSK  BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)

/****************** Bit definition for TIMER_AR register ************************/

#define  TIMER_AR_ARV_POSS  0U
#define  TIMER_AR_ARV_POSE  31U
#define  TIMER_AR_ARV_MSK  BITS(TIMER_AR_ARV_POSS,TIMER_AR_ARV_POSE)

/****************** Bit definition for TIMER_REPAR register ************************/

#define  TIMER_REPAR_REPV_POSS  0U
#define  TIMER_REPAR_REPV_POSE  7U
#define  TIMER_REPAR_REPV_MSK  BITS(TIMER_REPAR_REPV_POSS,TIMER_REPAR_REPV_POSE)

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define  TIMER_CCVAL1_CCRV1_POSS  0U
#define  TIMER_CCVAL1_CCRV1_POSE  31U
#define  TIMER_CCVAL1_CCRV1_MSK  BITS(TIMER_CCVAL1_CCRV1_POSS,TIMER_CCVAL1_CCRV1_POSE)

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define  TIMER_CCVAL2_CCRV2_POSS  0U
#define  TIMER_CCVAL2_CCRV2_POSE  31U
#define  TIMER_CCVAL2_CCRV2_MSK  BITS(TIMER_CCVAL2_CCRV2_POSS,TIMER_CCVAL2_CCRV2_POSE)

/****************** Bit definition for TIMER_BDCFG register ************************/

#define  TIMER_BDCFG_GOEN_POS  15U
#define  TIMER_BDCFG_GOEN_MSK  BIT(TIMER_BDCFG_GOEN_POS)

#define  TIMER_BDCFG_AOEN_POS  14U
#define  TIMER_BDCFG_AOEN_MSK  BIT(TIMER_BDCFG_AOEN_POS)

#define  TIMER_BDCFG_BRKP_POS  13U
#define  TIMER_BDCFG_BRKP_MSK  BIT(TIMER_BDCFG_BRKP_POS)

#define  TIMER_BDCFG_BRKEN_POS  12U
#define  TIMER_BDCFG_BRKEN_MSK  BIT(TIMER_BDCFG_BRKEN_POS)

#define  TIMER_BDCFG_OFFSSR_POS  11U
#define  TIMER_BDCFG_OFFSSR_MSK  BIT(TIMER_BDCFG_OFFSSR_POS)

#define  TIMER_BDCFG_OFFSSI_POS  10U
#define  TIMER_BDCFG_OFFSSI_MSK  BIT(TIMER_BDCFG_OFFSSI_POS)

#define  TIMER_BDCFG_LOCKLVL_POSS  8U
#define  TIMER_BDCFG_LOCKLVL_POSE  9U
#define  TIMER_BDCFG_LOCKLVL_MSK  BITS(TIMER_BDCFG_LOCKLVL_POSS,TIMER_BDCFG_LOCKLVL_POSE)

#define  TIMER_BDCFG_DT_POSS  0U
#define  TIMER_BDCFG_DT_POSE  7U
#define  TIMER_BDCFG_DT_MSK  BITS(TIMER_BDCFG_DT_POSS,TIMER_BDCFG_DT_POSE)


/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define  TIMER_CCVAL3_CCRV3_POSS  0U
#define  TIMER_CCVAL3_CCRV3_POSE  31U
#define  TIMER_CCVAL3_CCRV3_MSK  BITS(TIMER_CCVAL3_CCRV3_POSS,TIMER_CCVAL3_CCRV3_POSE)

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define  TIMER_CCVAL4_CCRV4_POSS  0U
#define  TIMER_CCVAL4_CCRV4_POSE  31U
#define  TIMER_CCVAL4_CCRV4_MSK  BITS(TIMER_CCVAL4_CCRV4_POSS,TIMER_CCVAL4_CCRV4_POSE)

typedef struct
{
    __IO uint32_t CON1;         /* 0x000 TIMER_CON1   Control register 1                */
    __IO uint32_t CON2;         /* 0x004 TIMER_CON2   Control register 2                */
    __IO uint32_t SMCON;        /* 0x008 TIMER_SMCON  Slave mode control register       */
    __O  uint32_t IER;           /* 0x00C TIMER_IER    Interrupt Enable register         */
    __O  uint32_t IDR;           /* 0x010 TIMER_IDR    Interrupt Disable register        */
    __I  uint32_t IVS;           /* 0x014 TIMER_IVS    Interrupt Valid status register   */
    __I  uint32_t RIF;           /* 0x018 TIMER_RIF    Interrupt Raw interrupt Flag      */
    __I  uint32_t IFM;           /* 0x01C TIMER_IFM    Interrupt Masked interrupt Flag   */
    __O  uint32_t ICR;           /* 0x020 TIMER_ICR    Interrupt Clear status register   */
    __O  uint32_t SGE;           /* 0x024 TIMER_SGE    Event generation register         */
    __IO uint32_t CHMR1;        /* 0x028 TIMER_CHMR1  Capture/compare mode register 1   */
    __IO uint32_t CHMR2;        /* 0x02C TIMER_CHMR2  Capture/compare mode register 2   */
    __IO uint32_t CCEP;         /* 0x030 TIMER_CCEP   Capture/compare enable register   */
    __IO uint32_t COUNT;        /* 0x034 TIMER_COUNT  Timer Counter                     */
    __IO uint32_t PRES;         /* 0x038 TIMER_PRES   Prescaler                         */
    __IO uint32_t AR;           /* 0x03C TIMER_AR     Auto-reload register              */
    __IO uint32_t REPAR;        /* 0x040 TIMER_REPAR  Repetition counter register       */
    __IO uint32_t CCVAL1;       /* 0x044 TIMER_CCVAL1 Capture/compare register 1        */
    __IO uint32_t CCVAL2;       /* 0x048 TIMER_CCVAL2 Capture/compare register 2        */
    __IO uint32_t CCVAL3;
    __IO uint32_t CCVAL4;
    __IO uint32_t BDCFG;        /* 0x054 TIMER_BDCFG  Break and dead-time register      */

} TIMER_TypeDef;

#endif


