/**********************************************************************************
 *
 * @file    reg_syscfg.h
 * @brief   SYSCFG Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __SYSCFG_H__
#define __SYSCFG_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for SYSCFG_REMAP register ************************/

#define  SYSCFG_REMAP_REALMOD_POSS  10U
#define  SYSCFG_REMAP_REALMOD_POSE  11U
#define  SYSCFG_REMAP_REALMOD_MSK  BITS(SYSCFG_REMAP_REALMOD_POSS,SYSCFG_REMAP_REALMOD_POSE)

#define  SYSCFG_REMAP_EFBASE_POSS  4U
#define  SYSCFG_REMAP_EFBASE_POSE  7U
#define  SYSCFG_REMAP_EFBASE_MSK  BITS(SYSCFG_REMAP_EFBASE_POSS,SYSCFG_REMAP_EFBASE_POSE)

#define  SYSCFG_REMAP_MEMMOD_POSS  2U
#define  SYSCFG_REMAP_MEMMOD_POSE  3U
#define  SYSCFG_REMAP_MEMMOD_MSK  BITS(SYSCFG_REMAP_MEMMOD_POSS,SYSCFG_REMAP_MEMMOD_POSE)

#define  SYSCFG_REMAP_REMAP_POS  0U
#define  SYSCFG_REMAP_REMAP_MSK  BIT(SYSCFG_REMAP_REMAP_POS)

/****************** Bit definition for SYSCFG_IRSEL register ************************/

#define  SYSCFG_IRSEL_PLR_POS  8U
#define  SYSCFG_IRSEL_PLR_MSK  BIT(SYSCFG_IRSEL_PLR_POS)

#define  SYSCFG_IRSEL_SEL2_POSS  4U
#define  SYSCFG_IRSEL_SEL2_POSE  7U
#define  SYSCFG_IRSEL_SEL2_MSK  BITS(SYSCFG_IRSEL_SEL2_POSS,SYSCFG_IRSEL_SEL2_POSE)

#define  SYSCFG_IRSEL_SEL1_POSS  0U
#define  SYSCFG_IRSEL_SEL1_POSE  3U
#define  SYSCFG_IRSEL_SEL1_MSK  BITS(SYSCFG_IRSEL_SEL1_POSS,SYSCFG_IRSEL_SEL1_POSE)

/****************** Bit definition for SYSCFG_SYSTRIM register ************************/

#define SYSCFG_SYSTRIM_MMCLDOTRIM_POSS  24U
#define SYSCFG_SYSTRIM_MMCLDOTRIM_POSE  25U
#define SYSCFG_SYSTRIM_MMCLDOTRIM_MSK   BITS(SYSCFG_SYSTRIM_MMCLDOTRIM_POSS,SYSCFG_SYSTRIM_MMCLDOTRIM_POSE)

#define SYSCFG_SYSTRIM_LCDCPTRIM_POSS   16U
#define SYSCFG_SYSTRIM_LCDCPTRIM_POSE   17U
#define SYSCFG_SYSTRIM_LCDCPTRIM_MSK    BITS(SYSCFG_SYSTRIM_LCDCPTRIM_POSS,SYSCFG_SYSTRIM_LCDCPTRIM_POSE)

#define SYSCFG_SYSTRIM_PVDTRIM_POSS 8U
#define SYSCFG_SYSTRIM_PVDTRIM_POSE 9U
#define SYSCFG_SYSTRIM_PVDTRIM_MSK  BITS(SYSCFG_SYSTRIM_PVDTRIM_POSS,SYSCFG_SYSTRIM_PVDTRIM_POSE)

#define SYSCFG_SYSTRIM_BGTRIM_POSS  0U
#define SYSCFG_SYSTRIM_BGTRIM_POSE  3U
#define SYSCFG_SYSTRIM_BGTRIM_MSK   BITS(SYSCFG_SYSTRIM_BGTRIM_POSS,SYSCFG_SYSTRIM_BGTRIM_POSE)

/****************** Bit definition for SYSCFG_CLKTRIM register ************************/

#define SYSCFG_CLKTRIM_HOSCRDYCNT_POSS  16U
#define SYSCFG_CLKTRIM_HOSCRDYCNT_POSE  31U
#define SYSCFG_CLKTRIM_HOSCRDYCNT_MSK   BITS(SYSCFG_CLKTRIM_HOSCRDYCNT_POSS,SYSCFG_CLKTRIM_HOSCRDYCNT_POSE)

#define SYSCFG_CLKTRIM_LRCTRIM_POSS 8U
#define SYSCFG_CLKTRIM_LRCTRIM_POSE 14U
#define SYSCFG_CLKTRIM_LRCTRIM_MSK  BITS(SYSCFG_CLKTRIM_LRCTRIM_POSS,SYSCFG_CLKTRIM_LRCTRIM_POSE)

#define SYSCFG_CLKTRIM_HRCTRIM_POSS 0U
#define SYSCFG_CLKTRIM_HRCTRIM_POSE 7U
#define SYSCFG_CLKTRIM_HRCTRIM_MSK  BITS(SYSCFG_CLKTRIM_HRCTRIM_POSS,SYSCFG_CLKTRIM_HRCTRIM_POSE)

/****************** Bit definition for SYSCFG_MMCTRIM register ************************/

#define SYSCFG_MMCTRIM_MMCVBGTRIM_POSS  24U
#define SYSCFG_MMCTRIM_MMCVBGTRIM_POSE  30U
#define SYSCFG_MMCTRIM_MMCVBGTRIM_MSK   BITS(SYSCFG_MMCTRIM_MMCVBGTRIM_POSS,SYSCFG_MMCTRIM_MMCVBGTRIM_POSE)

#define SYSCFG_MMCTRIM_LVDOSTRIM_POSS   16U
#define SYSCFG_MMCTRIM_LVDOSTRIM_POSE   23U
#define SYSCFG_MMCTRIM_LVDOSTRIM_MSK    BITS(SYSCFG_MMCTRIM_LVDOSTRIM_POSS,SYSCFG_MMCTRIM_LVDOSTRIM_POSE)

#define SYSCFG_MMCTRIM_CMPOSUTRIM_POSS  8U
#define SYSCFG_MMCTRIM_CMPOSUTRIM_POSE  15U
#define SYSCFG_MMCTRIM_CMPOSUTRIM_MSK   BITS(SYSCFG_MMCTRIM_CMPOSUTRIM_POSS,SYSCFG_MMCTRIM_CMPOSUTRIM_POSE)

#define SYSCFG_MMCTRIM_CMPOSDTRIM_POSS  0U
#define SYSCFG_MMCTRIM_CMPOSDTRIM_POSE  7U
#define SYSCFG_MMCTRIM_CMPOSDTRIM_MSK   BITS(SYSCFG_MMCTRIM_CMPOSDTRIM_POSS,SYSCFG_MMCTRIM_CMPOSDTRIM_POSE)

/****************** Bit definition for SYSCFG_CFG register ************************/

#define  SYSCFG_CFG_DBGH_EN_POSS  16U
#define  SYSCFG_CFG_DBGH_EN_POSE  31U
#define  SYSCFG_CFG_DBGH_EN_MSK  BITS(SYSCFG_CFG_DBGH_EN_POSS,SYSCFG_CFG_DBGH_EN_POSE)

#define  SYSCFG_CFG_PVD_LCK_POS  14U
#define  SYSCFG_CFG_PVD_LCK_MSK  BIT(SYSCFG_CFG_PVD_LCK_POS)

#define  SYSCFG_CFG_CSS_LCK_POS  13U
#define  SYSCFG_CFG_CSS_LCK_MSK  BIT(SYSCFG_CFG_CSS_LCK_POS)

#define  SYSCFG_CFG_CPU_LCK_POS  12U
#define  SYSCFG_CFG_CPU_LCK_MSK  BIT(SYSCFG_CFG_CPU_LCK_POS)

#define SYSCFG_CFG_BKREADY_POS  0U
#define SYSCFG_CFG_BKREADY_MSK  BIT(SYSCFG_CFG_BKREADY_POS)

/****************** Bit definition for SYSCFG_PWCON register ************************/

#define SYSCFG_PWCON_BOREN_POS  11U
#define SYSCFG_PWCON_BOREN_MSK  BIT(SYSCFG_PWCON_BOREN_POS)

#define SYSCFG_PWCON_BORLS_POSS 8U
#define SYSCFG_PWCON_BORLS_POSE 10U
#define SYSCFG_PWCON_BORLS_MSK  BITS(SYSCFG_PWCON_BORLS_POSS,SYSCFG_PWCON_BORLS_POSE)

#define SYSCFG_PWCON_PVDEN_POS  4U
#define SYSCFG_PWCON_PVDEN_MSK  BIT(SYSCFG_PWCON_PVDEN_POS)

#define SYSCFG_PWCON_PVDLS_POSS 0U
#define SYSCFG_PWCON_PVDLS_POSE 3U
#define SYSCFG_PWCON_PVDLS_MSK  BITS(SYSCFG_PWCON_PVDLS_POSS,SYSCFG_PWCON_PVDLS_POSE)
/****************** Bit definition for SYSCFG_WKCON register ************************/

#define  SYSCFG_WKCON_WKCLR_POS  31U
#define  SYSCFG_WKCON_WKCLR_MSK  BIT(SYSCFG_WKCON_WKCLR_POS)

#define  SYSCFG_WKCON_LPLS_POSS  28U
#define  SYSCFG_WKCON_LPLS_POSE  30U
#define  SYSCFG_WKCON_LPLS_MSK  BITS(SYSCFG_WKCON_LPLS_POSS,SYSCFG_WKCON_LPLS_POSE)

#define  SYSCFG_WKCON_WKEG_POSS  16U
#define  SYSCFG_WKCON_WKEG_POSE  27U
#define  SYSCFG_WKCON_WKEG_MSK  BITS(SYSCFG_WKCON_WKEG_POSS,SYSCFG_WKCON_WKEG_POSE)

#define  SYSCFG_WKCON_WKEN_POSS  0U
#define  SYSCFG_WKCON_WKEN_POSE  11U
#define  SYSCFG_WKCON_WKEN_MSK  BITS(SYSCFG_WKCON_WKEN_POSS,SYSCFG_WKCON_WKEN_POSE)

/****************** Bit definition for SYSCFG_WKSTAT register ************************/

#define  SYSCFG_WKSTAT_FLAG_POS  16U
#define  SYSCFG_WKSTAT_FLAG_MSK  BIT(SYSCFG_WKSTAT_FLAG_POS)

#define  SYSCFG_WKSTAT_FG_POSS  0U
#define  SYSCFG_WKSTAT_FG_POSE  11U
#define  SYSCFG_WKSTAT_FG_MSK  BITS(SYSCFG_WKSTAT_FG_POSS,SYSCFG_WKSTAT_FG_POSE)

/****************** Bit definition for SYSCFG_BKREG0 register ************************/

#define  SYSCFG_BKREG0_BKREG0_POSS  0U
#define  SYSCFG_BKREG0_BKREG0_POSE  31U
#define  SYSCFG_BKREG0_BKREG0_MSK  BITS(SYSCFG_BKREG0_BKREG0_POSS,SYSCFG_BKREG0_BKREG0_POSE)

/****************** Bit definition for SYSCFG_BKREG1 register ************************/

#define  SYSCFG_BKREG1_BKREG1_POSS  0U
#define  SYSCFG_BKREG1_BKREG1_POSE  31U
#define  SYSCFG_BKREG1_BKREG1_MSK  BITS(SYSCFG_BKREG1_BKREG1_POSS,SYSCFG_BKREG1_BKREG1_POSE)

/****************** Bit definition for SYSCFG_BKREG2 register ************************/

#define  SYSCFG_BKREG2_BKREG2_POSS  0U
#define  SYSCFG_BKREG2_BKREG2_POSE  31U
#define  SYSCFG_BKREG2_BKREG2_MSK  BITS(SYSCFG_BKREG2_BKREG2_POSS,SYSCFG_BKREG2_BKREG2_POSE)

/****************** Bit definition for SYSCFG_BKREG3 register ************************/

#define  SYSCFG_BKREG3_BKREG3_POSS  0U
#define  SYSCFG_BKREG3_BKREG3_POSE  31U
#define  SYSCFG_BKREG3_BKREG3_MSK  BITS(SYSCFG_BKREG3_BKREG3_POSS,SYSCFG_BKREG3_BKREG3_POSE)

typedef struct
{
    __IO uint32_t REMAP;
    uint32_t RESERVED0[2] ;
    __IO uint32_t IRSEL;
    uint32_t RESERVED1[4] ;
    __I uint32_t SYSTRIM;
    __I uint32_t CLKTRIM;
    __I uint32_t MMCTRIM;
    uint32_t RESERVED2[4] ;
    __IO uint32_t CFG;
    __IO uint32_t PWCON;
    uint32_t RESERVED3 ;
    __IO uint32_t WKCON;
    __I uint32_t WKSTAT;
    __IO uint32_t BKREG0;
    __IO uint32_t BKREG1;
    __IO uint32_t BKREG2;
    __IO uint32_t BKREG3;
} SYSCFG_TypeDef;

#endif
