﻿/**********************************************************************************
 *
 * @file    reg_suart.h
 * @brief   SUART Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __SUART_H__
#define __SUART_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for SUART_RXBUF register ************************/

#define SUART_RXBUF_RXBUF_POSS  0U
#define SUART_RXBUF_RXBUF_POSE  8U
#define SUART_RXBUF_RXBUF_MSK   BITS(SUART_RXBUF_RXBUF_POSS,SUART_RXBUF_RXBUF_POSE)

/****************** Bit definition for SUART_TXBUF register ************************/

#define SUART_TXBUF_TXBUF_POSS  0U
#define SUART_TXBUF_TXBUF_POSE  8U
#define SUART_TXBUF_TXBUF_MSK   BITS(SUART_TXBUF_TXBUF_POSS,SUART_TXBUF_TXBUF_POSE)

/****************** Bit definition for SUART_BRR register ************************/

#define SUART_BRR_BRR_POSS  0U
#define SUART_BRR_BRR_POSE  15U
#define SUART_BRR_BRR_MSK   BITS(SUART_BRR_BRR_POSS,SUART_BRR_BRR_POSE)

/****************** Bit definition for SUART_LCON register ************************/

#define SUART_LCON_TXEN_POS 15U
#define SUART_LCON_TXEN_MSK BIT(SUART_LCON_TXEN_POS)

#define SUART_LCON_RXEN_POS 14U
#define SUART_LCON_RXEN_MSK BIT(SUART_LCON_RXEN_POS)

#define SUART_LCON_DBCEN_POS    13U
#define SUART_LCON_DBCEN_MSK    BIT(SUART_LCON_DBCEN_POS)

#define SUART_LCON_BREAK_POS    10U
#define SUART_LCON_BREAK_MSK    BIT(SUART_LCON_BREAK_POS)

#define SUART_LCON_SWAP_POS 9U
#define SUART_LCON_SWAP_MSK BIT(SUART_LCON_SWAP_POS)

#define SUART_LCON_TXINV_POS    8U
#define SUART_LCON_TXINV_MSK    BIT(SUART_LCON_TXINV_POS)

#define SUART_LCON_RXINV_POS    7U
#define SUART_LCON_RXINV_MSK    BIT(SUART_LCON_RXINV_POS)

#define SUART_LCON_DATAINV_POS  6U
#define SUART_LCON_DATAINV_MSK  BIT(SUART_LCON_DATAINV_POS)

#define SUART_LCON_MSB_POS  5U
#define SUART_LCON_MSB_MSK  BIT(SUART_LCON_MSB_POS)

#define SUART_LCON_PS_POS   4U
#define SUART_LCON_PS_MSK   BIT(SUART_LCON_PS_POS)

#define SUART_LCON_PE_POS   3U
#define SUART_LCON_PE_MSK   BIT(SUART_LCON_PE_POS)

#define SUART_LCON_STOP_POS 2U
#define SUART_LCON_STOP_MSK BIT(SUART_LCON_STOP_POS)

#define SUART_LCON_DLS_POSS 0U
#define SUART_LCON_DLS_POSE 1U
#define SUART_LCON_DLS_MSK  BITS(SUART_LCON_DLS_POSS,SUART_LCON_DLS_POSE)

/****************** Bit definition for SUART_MCON register ************************/

#define SUART_MCON_ABRREPT_POS  11U
#define SUART_MCON_ABRREPT_MSK  BIT(SUART_MCON_ABRREPT_POS)

#define SUART_MCON_ABRMOD_POSS  9U
#define SUART_MCON_ABRMOD_POSE  10U
#define SUART_MCON_ABRMOD_MSK   BITS(SUART_MCON_ABRMOD_POSS,SUART_MCON_ABRMOD_POSE)

#define SUART_MCON_ABREN_POS    8U
#define SUART_MCON_ABREN_MSK    BIT(SUART_MCON_ABREN_POS)

#define SUART_MCON_BKREQ_POS    5U
#define SUART_MCON_BKREQ_MSK    BIT(SUART_MCON_BKREQ_POS)

#define SUART_MCON_HDEN_POS 4U
#define SUART_MCON_HDEN_MSK BIT(SUART_MCON_HDEN_POS)

#define SUART_MCON_IREN_POS 3U
#define SUART_MCON_IREN_MSK BIT(SUART_MCON_IREN_POS)

#define SUART_MCON_AFCEN_POS    2U
#define SUART_MCON_AFCEN_MSK    BIT(SUART_MCON_AFCEN_POS)

#define SUART_MCON_RTSSET_POS   1U
#define SUART_MCON_RTSSET_MSK   BIT(SUART_MCON_RTSSET_POS)

#define SUART_MCON_LPBKEN_POS   0U
#define SUART_MCON_LPBKEN_MSK   BIT(SUART_MCON_LPBKEN_POS)

/****************** Bit definition for SUART_RS485 register ************************/

#define SUART_RS485_DLY_POSS    16U
#define SUART_RS485_DLY_POSE    23U
#define SUART_RS485_DLY_MSK BITS(SUART_RS485_DLY_POSS,SUART_RS485_DLY_POSE)

#define SUART_RS485_ADDR_POSS   8U
#define SUART_RS485_ADDR_POSE   15U
#define SUART_RS485_ADDR_MSK    BITS(SUART_RS485_ADDR_POSS,SUART_RS485_ADDR_POSE)

#define SUART_RS485_AADINV_POS  3U
#define SUART_RS485_AADINV_MSK  BIT(SUART_RS485_AADINV_POS)

#define SUART_RS485_AADACEN_POS 2U
#define SUART_RS485_AADACEN_MSK BIT(SUART_RS485_AADACEN_POS)

#define SUART_RS485_AADNEN_POS  1U
#define SUART_RS485_AADNEN_MSK  BIT(SUART_RS485_AADNEN_POS)

#define SUART_RS485_AADEN_POS   0U
#define SUART_RS485_AADEN_MSK   BIT(SUART_RS485_AADEN_POS)

/****************** Bit definition for SUART_RTOR register ************************/

#define SUART_RTOR_RTOEN_POS    24U
#define SUART_RTOR_RTOEN_MSK    BIT(SUART_RTOR_RTOEN_POS)

#define SUART_RTOR_RTO_POSS 0U
#define SUART_RTOR_RTO_POSE 23U
#define SUART_RTOR_RTO_MSK  BITS(SUART_RTOR_RTO_POSS,SUART_RTOR_RTO_POSE)

/****************** Bit definition for SUART_FCON register ************************/

#define SUART_FCON_TXFL_POSS    11U
#define SUART_FCON_TXFL_POSE    15U
#define SUART_FCON_TXFL_MSK BITS(SUART_FCON_TXFL_POSS,SUART_FCON_TXFL_POSE)

#define SUART_FCON_TXTH_POSS    9U
#define SUART_FCON_TXTH_POSE    10U
#define SUART_FCON_TXTH_MSK BITS(SUART_FCON_TXTH_POSS,SUART_FCON_TXTH_POSE)

#define SUART_FCON_TFRST_POS    8U
#define SUART_FCON_TFRST_MSK    BIT(SUART_FCON_TFRST_POS)

#define SUART_FCON_RXFL_POSS    3U
#define SUART_FCON_RXFL_POSE    7U
#define SUART_FCON_RXFL_MSK BITS(SUART_FCON_RXFL_POSS,SUART_FCON_RXFL_POSE)

#define SUART_FCON_RXTH_POSS    1U
#define SUART_FCON_RXTH_POSE    2U
#define SUART_FCON_RXTH_MSK BITS(SUART_FCON_RXTH_POSS,SUART_FCON_RXTH_POSE)

#define SUART_FCON_RFRST_POS    0U
#define SUART_FCON_RFRST_MSK    BIT(SUART_FCON_RFRST_POS)

/****************** Bit definition for SUART_STAT register ************************/

#define SUART_STAT_TFOERR_POS   18U
#define SUART_STAT_TFOERR_MSK   BIT(SUART_STAT_TFOERR_POS)

#define SUART_STAT_TFFULL_POS   17U
#define SUART_STAT_TFFULL_MSK   BIT(SUART_STAT_TFFULL_POS)

#define SUART_STAT_TFEMPTY_POS  16U
#define SUART_STAT_TFEMPTY_MSK  BIT(SUART_STAT_TFEMPTY_POS)

#define SUART_STAT_TFTH_POS 15U
#define SUART_STAT_TFTH_MSK BIT(SUART_STAT_TFTH_POS)

#define SUART_STAT_TSBUSY_POS   14U
#define SUART_STAT_TSBUSY_MSK   BIT(SUART_STAT_TSBUSY_POS)

#define SUART_STAT_RFUERR_POS   13U
#define SUART_STAT_RFUERR_MSK   BIT(SUART_STAT_RFUERR_POS)

#define SUART_STAT_RFOERR_POS   12U
#define SUART_STAT_RFOERR_MSK   BIT(SUART_STAT_RFOERR_POS)

#define SUART_STAT_RFFULL_POS   11U
#define SUART_STAT_RFFULL_MSK   BIT(SUART_STAT_RFFULL_POS)

#define SUART_STAT_RFEMPTY_POS  10U
#define SUART_STAT_RFEMPTY_MSK  BIT(SUART_STAT_RFEMPTY_POS)

#define SUART_STAT_RFTH_POS 9U
#define SUART_STAT_RFTH_MSK BIT(SUART_STAT_RFTH_POS)

#define SUART_STAT_RSBUSY_POS   8U
#define SUART_STAT_RSBUSY_MSK   BIT(SUART_STAT_RSBUSY_POS)

#define SUART_STAT_CTSSTA_POS   3U
#define SUART_STAT_CTSSTA_MSK   BIT(SUART_STAT_CTSSTA_POS)

#define SUART_STAT_BKERR_POS    2U
#define SUART_STAT_BKERR_MSK    BIT(SUART_STAT_BKERR_POS)

#define SUART_STAT_FERR_POS 1U
#define SUART_STAT_FERR_MSK BIT(SUART_STAT_FERR_POS)

#define SUART_STAT_PERR_POS 0U
#define SUART_STAT_PERR_MSK BIT(SUART_STAT_PERR_POS)

/****************** Bit definition for SUART_IER register ************************/

#define SUART_IER_TFOVER_POS    18U
#define SUART_IER_TFOVER_MSK    BIT(SUART_IER_TFOVER_POS)

#define SUART_IER_TFEMPTY_POS   16U
#define SUART_IER_TFEMPTY_MSK   BIT(SUART_IER_TFEMPTY_POS)

#define SUART_IER_TFTH_POS  15U
#define SUART_IER_TFTH_MSK  BIT(SUART_IER_TFTH_POS)

#define SUART_IER_TBC_POS   14U
#define SUART_IER_TBC_MSK   BIT(SUART_IER_TBC_POS)

#define SUART_IER_RFUERR_POS    13U
#define SUART_IER_RFUERR_MSK    BIT(SUART_IER_RFUERR_POS)

#define SUART_IER_RFOERR_POS    12U
#define SUART_IER_RFOERR_MSK    BIT(SUART_IER_RFOERR_POS)

#define SUART_IER_RFFULL_POS    11U
#define SUART_IER_RFFULL_MSK    BIT(SUART_IER_RFFULL_POS)

#define SUART_IER_RFTH_POS  9U
#define SUART_IER_RFTH_MSK  BIT(SUART_IER_RFTH_POS)

#define SUART_IER_NOISE_POS 8U
#define SUART_IER_NOISE_MSK BIT(SUART_IER_NOISE_POS)

#define SUART_IER_EOB_POS   7U
#define SUART_IER_EOB_MSK   BIT(SUART_IER_EOB_POS)

#define SUART_IER_LINBK_POS 6U
#define SUART_IER_LINBK_MSK BIT(SUART_IER_LINBK_POS)

#define SUART_IER_ADDRM_POS 5U
#define SUART_IER_ADDRM_MSK BIT(SUART_IER_ADDRM_POS)

#define SUART_IER_RXTO_POS  4U
#define SUART_IER_RXTO_MSK  BIT(SUART_IER_RXTO_POS)

#define SUART_IER_DCTS_POS  3U
#define SUART_IER_DCTS_MSK  BIT(SUART_IER_DCTS_POS)

#define SUART_IER_ABTO_POS  2U
#define SUART_IER_ABTO_MSK  BIT(SUART_IER_ABTO_POS)

#define SUART_IER_ABEND_POS 1U
#define SUART_IER_ABEND_MSK BIT(SUART_IER_ABEND_POS)

#define SUART_IER_RXBERR_POS    0U
#define SUART_IER_RXBERR_MSK    BIT(SUART_IER_RXBERR_POS)

/****************** Bit definition for SUART_IDR register ************************/

#define SUART_IDR_TFOVER_POS    18U
#define SUART_IDR_TFOVER_MSK    BIT(SUART_IDR_TFOVER_POS)

#define SUART_IDR_TFEMPTY_POS   16U
#define SUART_IDR_TFEMPTY_MSK   BIT(SUART_IDR_TFEMPTY_POS)

#define SUART_IDR_TFTH_POS  15U
#define SUART_IDR_TFTH_MSK  BIT(SUART_IDR_TFTH_POS)

#define SUART_IDR_TBC_POS   14U
#define SUART_IDR_TBC_MSK   BIT(SUART_IDR_TBC_POS)

#define SUART_IDR_RFUERR_POS    13U
#define SUART_IDR_RFUERR_MSK    BIT(SUART_IDR_RFUERR_POS)

#define SUART_IDR_RFOERR_POS    12U
#define SUART_IDR_RFOERR_MSK    BIT(SUART_IDR_RFOERR_POS)

#define SUART_IDR_RFFULL_POS    11U
#define SUART_IDR_RFFULL_MSK    BIT(SUART_IDR_RFFULL_POS)

#define SUART_IDR_RFTH_POS  9U
#define SUART_IDR_RFTH_MSK  BIT(SUART_IDR_RFTH_POS)

#define SUART_IDR_NOISE_POS 8U
#define SUART_IDR_NOISE_MSK BIT(SUART_IDR_NOISE_POS)

#define SUART_IDR_EOB_POS   7U
#define SUART_IDR_EOB_MSK   BIT(SUART_IDR_EOB_POS)

#define SUART_IDR_LINBK_POS 6U
#define SUART_IDR_LINBK_MSK BIT(SUART_IDR_LINBK_POS)

#define SUART_IDR_ADDRM_POS 5U
#define SUART_IDR_ADDRM_MSK BIT(SUART_IDR_ADDRM_POS)

#define SUART_IDR_RXTO_POS  4U
#define SUART_IDR_RXTO_MSK  BIT(SUART_IDR_RXTO_POS)

#define SUART_IDR_DCTS_POS  3U
#define SUART_IDR_DCTS_MSK  BIT(SUART_IDR_DCTS_POS)

#define SUART_IDR_ABTO_POS  2U
#define SUART_IDR_ABTO_MSK  BIT(SUART_IDR_ABTO_POS)

#define SUART_IDR_ABEND_POS 1U
#define SUART_IDR_ABEND_MSK BIT(SUART_IDR_ABEND_POS)

#define SUART_IDR_RXBERR_POS    0U
#define SUART_IDR_RXBERR_MSK    BIT(SUART_IDR_RXBERR_POS)

/****************** Bit definition for SUART_IVS register ************************/

#define SUART_IVS_TFOVER_POS    18U
#define SUART_IVS_TFOVER_MSK    BIT(SUART_IVS_TFOVER_POS)

#define SUART_IVS_TFEMPTY_POS   16U
#define SUART_IVS_TFEMPTY_MSK   BIT(SUART_IVS_TFEMPTY_POS)

#define SUART_IVS_TFTH_POS  15U
#define SUART_IVS_TFTH_MSK  BIT(SUART_IVS_TFTH_POS)

#define SUART_IVS_TBC_POS   14U
#define SUART_IVS_TBC_MSK   BIT(SUART_IVS_TBC_POS)

#define SUART_IVS_RFUERR_POS    13U
#define SUART_IVS_RFUERR_MSK    BIT(SUART_IVS_RFUERR_POS)

#define SUART_IVS_RFOERR_POS    12U
#define SUART_IVS_RFOERR_MSK    BIT(SUART_IVS_RFOERR_POS)

#define SUART_IVS_RFFULL_POS    11U
#define SUART_IVS_RFFULL_MSK    BIT(SUART_IVS_RFFULL_POS)

#define SUART_IVS_RFTH_POS  9U
#define SUART_IVS_RFTH_MSK  BIT(SUART_IVS_RFTH_POS)

#define SUART_IVS_NOISE_POS 8U
#define SUART_IVS_NOISE_MSK BIT(SUART_IVS_NOISE_POS)

#define SUART_IVS_EOB_POS   7U
#define SUART_IVS_EOB_MSK   BIT(SUART_IVS_EOB_POS)

#define SUART_IVS_LINBK_POS 6U
#define SUART_IVS_LINBK_MSK BIT(SUART_IVS_LINBK_POS)

#define SUART_IVS_ADDRM_POS 5U
#define SUART_IVS_ADDRM_MSK BIT(SUART_IVS_ADDRM_POS)

#define SUART_IVS_RXTO_POS  4U
#define SUART_IVS_RXTO_MSK  BIT(SUART_IVS_RXTO_POS)

#define SUART_IVS_DCTS_POS  3U
#define SUART_IVS_DCTS_MSK  BIT(SUART_IVS_DCTS_POS)

#define SUART_IVS_ABTO_POS  2U
#define SUART_IVS_ABTO_MSK  BIT(SUART_IVS_ABTO_POS)

#define SUART_IVS_ABEND_POS 1U
#define SUART_IVS_ABEND_MSK BIT(SUART_IVS_ABEND_POS)

#define SUART_IVS_RXBERR_POS    0U
#define SUART_IVS_RXBERR_MSK    BIT(SUART_IVS_RXBERR_POS)

/****************** Bit definition for SUART_RIF register ************************/

#define SUART_RIF_TFOVER_POS    18U
#define SUART_RIF_TFOVER_MSK    BIT(SUART_RIF_TFOVER_POS)

#define SUART_RIF_TFEMPTY_POS   16U
#define SUART_RIF_TFEMPTY_MSK   BIT(SUART_RIF_TFEMPTY_POS)

#define SUART_RIF_TFTH_POS  15U
#define SUART_RIF_TFTH_MSK  BIT(SUART_RIF_TFTH_POS)

#define SUART_RIF_TBC_POS   14U
#define SUART_RIF_TBC_MSK   BIT(SUART_RIF_TBC_POS)

#define SUART_RIF_RFUERR_POS    13U
#define SUART_RIF_RFUERR_MSK    BIT(SUART_RIF_RFUERR_POS)

#define SUART_RIF_RFOERR_POS    12U
#define SUART_RIF_RFOERR_MSK    BIT(SUART_RIF_RFOERR_POS)

#define SUART_RIF_RFFULL_POS    11U
#define SUART_RIF_RFFULL_MSK    BIT(SUART_RIF_RFFULL_POS)

#define SUART_RIF_RFTH_POS  9U
#define SUART_RIF_RFTH_MSK  BIT(SUART_RIF_RFTH_POS)

#define SUART_RIF_NOISE_POS 8U
#define SUART_RIF_NOISE_MSK BIT(SUART_RIF_NOISE_POS)

#define SUART_RIF_EOB_POS   7U
#define SUART_RIF_EOB_MSK   BIT(SUART_RIF_EOB_POS)

#define SUART_RIF_LINBK_POS 6U
#define SUART_RIF_LINBK_MSK BIT(SUART_RIF_LINBK_POS)

#define SUART_RIF_ADDRM_POS 5U
#define SUART_RIF_ADDRM_MSK BIT(SUART_RIF_ADDRM_POS)

#define SUART_RIF_RXTO_POS  4U
#define SUART_RIF_RXTO_MSK  BIT(SUART_RIF_RXTO_POS)

#define SUART_RIF_DCTS_POS  3U
#define SUART_RIF_DCTS_MSK  BIT(SUART_RIF_DCTS_POS)

#define SUART_RIF_ABTO_POS  2U
#define SUART_RIF_ABTO_MSK  BIT(SUART_RIF_ABTO_POS)

#define SUART_RIF_ABEND_POS 1U
#define SUART_RIF_ABEND_MSK BIT(SUART_RIF_ABEND_POS)

#define SUART_RIF_RXBERR_POS    0U
#define SUART_RIF_RXBERR_MSK    BIT(SUART_RIF_RXBERR_POS)

/****************** Bit definition for SUART_IFM register ************************/

#define SUART_IFM_TFOVER_POS    18U
#define SUART_IFM_TFOVER_MSK    BIT(SUART_IFM_TFOVER_POS)

#define SUART_IFM_TFEMPTY_POS   16U
#define SUART_IFM_TFEMPTY_MSK   BIT(SUART_IFM_TFEMPTY_POS)

#define SUART_IFM_TFTH_POS  15U
#define SUART_IFM_TFTH_MSK  BIT(SUART_IFM_TFTH_POS)

#define SUART_IFM_TBC_POS   14U
#define SUART_IFM_TBC_MSK   BIT(SUART_IFM_TBC_POS)

#define SUART_IFM_RFUERR_POS    13U
#define SUART_IFM_RFUERR_MSK    BIT(SUART_IFM_RFUERR_POS)

#define SUART_IFM_RFOERR_POS    12U
#define SUART_IFM_RFOERR_MSK    BIT(SUART_IFM_RFOERR_POS)

#define SUART_IFM_RFFULL_POS    11U
#define SUART_IFM_RFFULL_MSK    BIT(SUART_IFM_RFFULL_POS)

#define SUART_IFM_RFTH_POS  9U
#define SUART_IFM_RFTH_MSK  BIT(SUART_IFM_RFTH_POS)

#define SUART_IFM_NOISE_POS 8U
#define SUART_IFM_NOISE_MSK BIT(SUART_IFM_NOISE_POS)

#define SUART_IFM_EOB_POS   7U
#define SUART_IFM_EOB_MSK   BIT(SUART_IFM_EOB_POS)

#define SUART_IFM_LINBK_POS 6U
#define SUART_IFM_LINBK_MSK BIT(SUART_IFM_LINBK_POS)

#define SUART_IFM_ADDRM_POS 5U
#define SUART_IFM_ADDRM_MSK BIT(SUART_IFM_ADDRM_POS)

#define SUART_IFM_RXTO_POS  4U
#define SUART_IFM_RXTO_MSK  BIT(SUART_IFM_RXTO_POS)

#define SUART_IFM_DCTS_POS  3U
#define SUART_IFM_DCTS_MSK  BIT(SUART_IFM_DCTS_POS)

#define SUART_IFM_ABTO_POS  2U
#define SUART_IFM_ABTO_MSK  BIT(SUART_IFM_ABTO_POS)

#define SUART_IFM_ABEND_POS 1U
#define SUART_IFM_ABEND_MSK BIT(SUART_IFM_ABEND_POS)

#define SUART_IFM_RXBERR_POS    0U
#define SUART_IFM_RXBERR_MSK    BIT(SUART_IFM_RXBERR_POS)

/****************** Bit definition for SUART_ICR register ************************/

#define SUART_ICR_TFOVER_POS    18U
#define SUART_ICR_TFOVER_MSK    BIT(SUART_ICR_TFOVER_POS)

#define SUART_ICR_TFEMPTY_POS   16U
#define SUART_ICR_TFEMPTY_MSK   BIT(SUART_ICR_TFEMPTY_POS)

#define SUART_ICR_TFTH_POS  15U
#define SUART_ICR_TFTH_MSK  BIT(SUART_ICR_TFTH_POS)

#define SUART_ICR_TBC_POS   14U
#define SUART_ICR_TBC_MSK   BIT(SUART_ICR_TBC_POS)

#define SUART_ICR_RFUERR_POS    13U
#define SUART_ICR_RFUERR_MSK    BIT(SUART_ICR_RFUERR_POS)

#define SUART_ICR_RFOERR_POS    12U
#define SUART_ICR_RFOERR_MSK    BIT(SUART_ICR_RFOERR_POS)

#define SUART_ICR_RFFULL_POS    11U
#define SUART_ICR_RFFULL_MSK    BIT(SUART_ICR_RFFULL_POS)

#define SUART_ICR_RFTH_POS  9U
#define SUART_ICR_RFTH_MSK  BIT(SUART_ICR_RFTH_POS)

#define SUART_ICR_NOISE_POS 8U
#define SUART_ICR_NOISE_MSK BIT(SUART_ICR_NOISE_POS)

#define SUART_ICR_EOB_POS   7U
#define SUART_ICR_EOB_MSK   BIT(SUART_ICR_EOB_POS)

#define SUART_ICR_LINBK_POS 6U
#define SUART_ICR_LINBK_MSK BIT(SUART_ICR_LINBK_POS)

#define SUART_ICR_ADDRM_POS 5U
#define SUART_ICR_ADDRM_MSK BIT(SUART_ICR_ADDRM_POS)

#define SUART_ICR_RXTO_POS  4U
#define SUART_ICR_RXTO_MSK  BIT(SUART_ICR_RXTO_POS)

#define SUART_ICR_DCTS_POS  3U
#define SUART_ICR_DCTS_MSK  BIT(SUART_ICR_DCTS_POS)

#define SUART_ICR_ABTO_POS  2U
#define SUART_ICR_ABTO_MSK  BIT(SUART_ICR_ABTO_POS)

#define SUART_ICR_ABEND_POS 1U
#define SUART_ICR_ABEND_MSK BIT(SUART_ICR_ABEND_POS)

#define SUART_ICR_RXBERR_POS    0U
#define SUART_ICR_RXBERR_MSK    BIT(SUART_ICR_RXBERR_POS)

typedef struct
{
    __I uint32_t RXBUF;
    __IO uint32_t TXBUF;
    __IO uint32_t BRR;
    __IO uint32_t LCON;
    __IO uint32_t MCON;
    __IO uint32_t RS485;
    uint32_t RESERVED0[2];
    __IO uint32_t RTOR;
    __IO uint32_t FCON;
    __I uint32_t STAT;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
} SUART_TypeDef;

#endif
