/**********************************************************************************
 *
 * @file    reg_rcu.h
 * @brief   RCU Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __RCU_H__
#define __RCU_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for RCU_CON register ************************/

#define RCU_CON_CSSHOSCON_POS   24U
#define RCU_CON_CSSHOSCON_MSK   BIT(RCU_CON_CSSHOSCON_POS)

#define RCU_CON_LRCRDY_POS  9U
#define RCU_CON_LRCRDY_MSK  BIT(RCU_CON_LRCRDY_POS)

#define RCU_CON_LRCON_POS   8U
#define RCU_CON_LRCON_MSK   BIT(RCU_CON_LRCON_POS)

#define RCU_CON_HOSCFILTBPY_POS 7U
#define RCU_CON_HOSCFILTBPY_MSK BIT(RCU_CON_HOSCFILTBPY_POS)

#define RCU_CON_HOSCBPY_POS 6U
#define RCU_CON_HOSCBPY_MSK BIT(RCU_CON_HOSCBPY_POS)

#define RCU_CON_HOSCRDY_POS 5U
#define RCU_CON_HOSCRDY_MSK BIT(RCU_CON_HOSCRDY_POS)

#define RCU_CON_HOSCON_POS  4U
#define RCU_CON_HOSCON_MSK  BIT(RCU_CON_HOSCON_POS)

#define RCU_CON_HRCRDY_POS  1U
#define  RCU_CON_HRCRDY_MSK  BIT(RCU_CON_HRCRDY_POS)

#define  RCU_CON_HRCON_POS  0U
#define  RCU_CON_HRCON_MSK  BIT(RCU_CON_HRCON_POS)

/****************** Bit definition for RCU_CFG register ************************/

#define  RCU_CFG_MPRE_POSS  28U
#define  RCU_CFG_MPRE_POSE  30U
#define  RCU_CFG_MPRE_MSK  BITS(RCU_CFG_MPRE_POSS,RCU_CFG_MPRE_POSE)

#define  RCU_CFG_MSW_POSS  24U
#define  RCU_CFG_MSW_POSE  27U
#define  RCU_CFG_MSW_MSK  BITS(RCU_CFG_MSW_POSS,RCU_CFG_MSW_POSE)

#define RCU_CFG_HRCDIV_POSS 13U
#define RCU_CFG_HRCDIV_POSE 15U
#define RCU_CFG_HRCDIV_MSK  BITS(RCU_CFG_HRCDIV_POSS,RCU_CFG_HRCDIV_POSE)

#define RCU_CFG_PPRE_POSS   10U
#define RCU_CFG_PPRE_POSE   12U
#define  RCU_CFG_PPRE_MSK  BITS(RCU_CFG_PPRE_POSS,RCU_CFG_PPRE_POSE)

#define RCU_CFG_HPRE_POSS   6U
#define RCU_CFG_HPRE_POSE   9U
#define  RCU_CFG_HPRE_MSK  BITS(RCU_CFG_HPRE_POSS,RCU_CFG_HPRE_POSE)

#define RCU_CFG_SWS_POSS    3U
#define RCU_CFG_SWS_POSE    5U
#define RCU_CFG_SWS_MSK BITS(RCU_CFG_SWS_POSS,RCU_CFG_SWS_POSE)

#define  RCU_CFG_SW_POSS  0U
#define  RCU_CFG_SW_POSE  2U
#define  RCU_CFG_SW_MSK  BITS(RCU_CFG_SW_POSS,RCU_CFG_SW_POSE)

/****************** Bit definition for RCU_IPCFG register ************************/

#define RCU_IPCFG_LCDDIV_POSS   24U
#define RCU_IPCFG_LCDDIV_POSE   31U
#define RCU_IPCFG_LCDDIV_MSK    BITS(RCU_IPCFG_LCDDIV_POSS,RCU_IPCFG_LCDDIV_POSE)

#define RCU_IPCFG_LCDSW_POSS    22U
#define RCU_IPCFG_LCDSW_POSE    23U
#define RCU_IPCFG_LCDSW_MSK BITS(RCU_IPCFG_LCDSW_POSS,RCU_IPCFG_LCDSW_POSE)

#define RCU_IPCFG_MMCSW_POS 19U
#define RCU_IPCFG_MMCSW_MSK BIT(RCU_IPCFG_MMCSW_POS)

#define RCU_IPCFG_MMCEN_POS 18U
#define RCU_IPCFG_MMCEN_MSK BIT(RCU_IPCFG_MMCEN_POS)

#define RCU_IPCFG_MMCDIV_POSS   16U
#define RCU_IPCFG_MMCDIV_POSE   17U
#define RCU_IPCFG_MMCDIV_MSK    BITS(RCU_IPCFG_MMCDIV_POSS,RCU_IPCFG_MMCDIV_POSE)

#define RCU_IPCFG_VLCDSW_POS    15U
#define RCU_IPCFG_VLCDSW_MSK    BIT(RCU_IPCFG_VLCDSW_POS)

#define RCU_IPCFG_VLCDEN_POS    14U
#define RCU_IPCFG_VLCDEN_MSK    BIT(RCU_IPCFG_VLCDEN_POS)

#define RCU_IPCFG_VLCDDIV_POSS  8U
#define RCU_IPCFG_VLCDDIV_POSE  13U
#define RCU_IPCFG_VLCDDIV_MSK   BITS(RCU_IPCFG_VLCDDIV_POSS,RCU_IPCFG_VLCDDIV_POSE)

#define RCU_IPCFG_VPUMPSW_POS   7U
#define RCU_IPCFG_VPUMPSW_MSK   BIT(RCU_IPCFG_VPUMPSW_POS)

#define RCU_IPCFG_VPUMPEN_POS   6U
#define RCU_IPCFG_VPUMPEN_MSK   BIT(RCU_IPCFG_VPUMPEN_POS)

#define RCU_IPCFG_VPUMPDIV_POSS 0U
#define RCU_IPCFG_VPUMPDIV_POSE 5U
#define RCU_IPCFG_VPUMPDIV_MSK  BITS(RCU_IPCFG_VPUMPDIV_POSS,RCU_IPCFG_VPUMPDIV_POSE)

/****************** Bit definition for RCU_IER register ************************/

#define RCU_IER_CSSHOSC_POS 8U
#define RCU_IER_CSSHOSC_MSK BIT(RCU_IER_CSSHOSC_POS)

#define RCU_IER_HOSCRDY_POS 3U
#define RCU_IER_HOSCRDY_MSK BIT(RCU_IER_HOSCRDY_POS)

#define RCU_IER_HRCRDY_POS  2U
#define RCU_IER_HRCRDY_MSK  BIT(RCU_IER_HRCRDY_POS)

#define RCU_IER_LRCRDY_POS  0U
#define RCU_IER_LRCRDY_MSK  BIT(RCU_IER_LRCRDY_POS)

/****************** Bit definition for RCU_IDR register ************************/

#define RCU_IDR_CSSHOSC_POS 8U
#define RCU_IDR_CSSHOSC_MSK BIT(RCU_IDR_CSSHOSC_POS)

#define RCU_IDR_HOSCRDY_POS 3U
#define RCU_IDR_HOSCRDY_MSK BIT(RCU_IDR_HOSCRDY_POS)

#define RCU_IDR_HRCRDY_POS  2U
#define RCU_IDR_HRCRDY_MSK  BIT(RCU_IDR_HRCRDY_POS)

#define RCU_IDR_LRCRDY_POS  0U
#define RCU_IDR_LRCRDY_MSK  BIT(RCU_IDR_LRCRDY_POS)

/****************** Bit definition for RCU_IVS register ************************/

#define RCU_IVS_CSSHOSC_POS 8U
#define RCU_IVS_CSSHOSC_MSK BIT(RCU_IVS_CSSHOSC_POS)

#define RCU_IVS_HOSCRDY_POS 3U
#define RCU_IVS_HOSCRDY_MSK BIT(RCU_IVS_HOSCRDY_POS)

#define RCU_IVS_HRCRDY_POS  2U
#define RCU_IVS_HRCRDY_MSK  BIT(RCU_IVS_HRCRDY_POS)

#define RCU_IVS_LRCRDY_POS  0U
#define RCU_IVS_LRCRDY_MSK  BIT(RCU_IVS_LRCRDY_POS)

/****************** Bit definition for RCU_RIF register ************************/

#define RCU_RIF_CSSHOSC_POS 8U
#define RCU_RIF_CSSHOSC_MSK BIT(RCU_RIF_CSSHOSC_POS)

#define RCU_RIF_HOSCRDY_POS 3U
#define RCU_RIF_HOSCRDY_MSK BIT(RCU_RIF_HOSCRDY_POS)

#define RCU_RIF_HRCRDY_POS  2U
#define RCU_RIF_HRCRDY_MSK  BIT(RCU_RIF_HRCRDY_POS)

#define RCU_RIF_LRCRDY_POS  0U
#define RCU_RIF_LRCRDY_MSK  BIT(RCU_RIF_LRCRDY_POS)

/****************** Bit definition for RCU_IFM register ************************/

#define RCU_IFM_CSSHOSC_POS 8U
#define RCU_IFM_CSSHOSC_MSK BIT(RCU_IFM_CSSHOSC_POS)

#define RCU_IFM_HOSCRDY_POS 3U
#define RCU_IFM_HOSCRDY_MSK BIT(RCU_IFM_HOSCRDY_POS)

#define RCU_IFM_HRCRDY_POS  2U
#define RCU_IFM_HRCRDY_MSK  BIT(RCU_IFM_HRCRDY_POS)

#define RCU_IFM_LRCRDY_POS  0U
#define RCU_IFM_LRCRDY_MSK  BIT(RCU_IFM_LRCRDY_POS)

/****************** Bit definition for RCU_ICR register ************************/

#define RCU_ICR_CSSHOSC_POS 8U
#define RCU_ICR_CSSHOSC_MSK BIT(RCU_ICR_CSSHOSC_POS)

#define RCU_ICR_HOSCRDY_POS 3U
#define RCU_ICR_HOSCRDY_MSK BIT(RCU_ICR_HOSCRDY_POS)

#define RCU_ICR_HRCRDY_POS  2U
#define RCU_ICR_HRCRDY_MSK  BIT(RCU_ICR_HRCRDY_POS)

#define RCU_ICR_LRCRDY_POS  0U
#define RCU_ICR_LRCRDY_MSK  BIT(RCU_ICR_LRCRDY_POS)

/****************** Bit definition for RCU_RSTAT register ************************/

#define RCU_RSTAT_BORRSTF_POS   23U
#define RCU_RSTAT_BORRSTF_MSK   BIT(RCU_RSTAT_BORRSTF_POS)

#define RCU_RSTAT_LPRSTF_POS    22U
#define RCU_RSTAT_LPRSTF_MSK    BIT(RCU_RSTAT_LPRSTF_POS)

#define RCU_RSTAT_WWDTRSTF_POS  21U
#define RCU_RSTAT_WWDTRSTF_MSK  BIT(RCU_RSTAT_WWDTRSTF_POS)

#define RCU_RSTAT_IWDTRSTF_POS  20U
#define RCU_RSTAT_IWDTRSTF_MSK  BIT(RCU_RSTAT_IWDTRSTF_POS)

#define RCU_RSTAT_SWRSTF_POS    19U
#define RCU_RSTAT_SWRSTF_MSK    BIT(RCU_RSTAT_SWRSTF_POS)

#define RCU_RSTAT_OBLRSTF_POS   18U
#define RCU_RSTAT_OBLRSTF_MSK   BIT(RCU_RSTAT_OBLRSTF_POS)

#define RCU_RSTAT_NRSTF_POS 17U
#define RCU_RSTAT_NRSTF_MSK BIT(RCU_RSTAT_NRSTF_POS)

#define RCU_RSTAT_PORRSTF_POS   16U
#define RCU_RSTAT_PORRSTF_MSK   BIT(RCU_RSTAT_PORRSTF_POS)

#define RCU_RSTAT_CLRFLG_POS    15U
#define RCU_RSTAT_CLRFLG_MSK    BIT(RCU_RSTAT_CLRFLG_POS)

/****************** Bit definition for RCU_AHBRST register ************************/

#define RCU_AHBRST_GPDEN_POS    19U
#define RCU_AHBRST_GPDEN_MSK    BIT(RCU_AHBRST_GPDEN_POS)

#define RCU_AHBRST_GPCEN_POS    18U
#define RCU_AHBRST_GPCEN_MSK    BIT(RCU_AHBRST_GPCEN_POS)

#define RCU_AHBRST_HDIVEN_POS   15U
#define RCU_AHBRST_HDIVEN_MSK   BIT(RCU_AHBRST_HDIVEN_POS)

/****************** Bit definition for RCU_APB1RST register ************************/

#define  RCU_APB1RST_I2C1EN_POS  21U
#define  RCU_APB1RST_I2C1EN_MSK  BIT(RCU_APB1RST_I2C1EN_POS)

#define  RCU_APB1RST_SUART1EN_POS  19U
#define  RCU_APB1RST_SUART1EN_MSK  BIT(RCU_APB1RST_SUART1EN_POS)

#define  RCU_APB1RST_IWDTEN_POS  12U
#define  RCU_APB1RST_IWDTEN_MSK  BIT(RCU_APB1RST_IWDTEN_POS)

#define  RCU_APB1RST_WWDTEN_POS  11U
#define  RCU_APB1RST_WWDTEN_MSK  BIT(RCU_APB1RST_WWDTEN_POS)

#define  RCU_APB1RST_BS16T1EN_POS  4U
#define  RCU_APB1RST_BS16T1EN_MSK  BIT(RCU_APB1RST_BS16T1EN_POS)

#define  RCU_APB1RST_GP32C4T1EN_POS  0U
#define  RCU_APB1RST_GP32C4T1EN_MSK  BIT(RCU_APB1RST_GP32C4T1EN_POS)

/****************** Bit definition for RCU_APB2RST register ************************/

#define  RCU_APB2RST_GP16C2T2EN_POS  17U
#define  RCU_APB2RST_GP16C2T2EN_MSK  BIT(RCU_APB2RST_GP16C2T2EN_POS)

#define  RCU_APB2RST_GP16C2T1EN_POS  16U
#define  RCU_APB2RST_GP16C2T1EN_MSK  BIT(RCU_APB2RST_GP16C2T1EN_POS)

#define  RCU_APB2RST_UART1EN_POS  14U
#define  RCU_APB2RST_UART1EN_MSK  BIT(RCU_APB2RST_UART1EN_POS)

#define  RCU_APB2RST_SPI1EN_POS  12U
#define  RCU_APB2RST_SPI1EN_MSK  BIT(RCU_APB2RST_SPI1EN_POS)

#define RCU_APB2RST_MMCEN_POS   3U
#define RCU_APB2RST_MMCEN_MSK   BIT(RCU_APB2RST_MMCEN_POS)

#define RCU_APB2RST_LCDEN_POS   2U
#define RCU_APB2RST_LCDEN_MSK   BIT(RCU_APB2RST_LCDEN_POS)

/****************** Bit definition for RCU_AHBEN register ************************/

#define  RCU_AHBEN_GPDEN_POS  19U
#define  RCU_AHBEN_GPDEN_MSK  BIT(RCU_AHBEN_GPDEN_POS)

#define  RCU_AHBEN_GPCEN_POS  18U
#define  RCU_AHBEN_GPCEN_MSK  BIT(RCU_AHBEN_GPCEN_POS)

#define  RCU_AHBEN_HDIVEN_POS  15U
#define  RCU_AHBEN_HDIVEN_MSK  BIT(RCU_AHBEN_HDIVEN_POS)

/****************** Bit definition for RCU_APB1EN register ************************/

#define  RCU_APB1EN_I2C1EN_POS  21U
#define  RCU_APB1EN_I2C1EN_MSK  BIT(RCU_APB1EN_I2C1EN_POS)

#define  RCU_APB1EN_SUART1EN_POS  19U
#define  RCU_APB1EN_SUART1EN_MSK  BIT(RCU_APB1EN_SUART1EN_POS)

#define  RCU_APB1EN_IWDTEN_POS  12U
#define  RCU_APB1EN_IWDTEN_MSK  BIT(RCU_APB1EN_IWDTEN_POS)

#define  RCU_APB1EN_WWDTEN_POS  11U
#define  RCU_APB1EN_WWDTEN_MSK  BIT(RCU_APB1EN_WWDTEN_POS)

#define  RCU_APB1EN_BS16T1EN_POS  4U
#define  RCU_APB1EN_BS16T1EN_MSK  BIT(RCU_APB1EN_BS16T1EN_POS)

#define  RCU_APB1EN_GP32C4T1EN_POS  0U
#define  RCU_APB1EN_GP32C4T1EN_MSK  BIT(RCU_APB1EN_GP32C4T1EN_POS)

/****************** Bit definition for RCU_APB2EN register ************************/

#define  RCU_APB2EN_GP16C2T2EN_POS  17U
#define  RCU_APB2EN_GP16C2T2EN_MSK  BIT(RCU_APB2EN_GP16C2T2EN_POS)

#define  RCU_APB2EN_GP16C2T1EN_POS  16U
#define  RCU_APB2EN_GP16C2T1EN_MSK  BIT(RCU_APB2EN_GP16C2T1EN_POS)

#define  RCU_APB2EN_UART1EN_POS  14U
#define  RCU_APB2EN_UART1EN_MSK  BIT(RCU_APB2EN_UART1EN_POS)

#define  RCU_APB2EN_SPI1EN_POS  12U
#define  RCU_APB2EN_SPI1EN_MSK  BIT(RCU_APB2EN_SPI1EN_POS)

#define RCU_APB2EN_MMCEN_POS    3U
#define RCU_APB2EN_MMCEN_MSK    BIT(RCU_APB2EN_MMCEN_POS)

#define RCU_APB2EN_LCDEN_POS    2U
#define RCU_APB2EN_LCDEN_MSK    BIT(RCU_APB2EN_LCDEN_POS)

/****************** Bit definition for RCU_AHBSL register ************************/

#define  RCU_AHBSL_GPDEN_POS  19U
#define  RCU_AHBSL_GPDEN_MSK  BIT(RCU_AHBSL_GPDEN_POS)

#define  RCU_AHBSL_GPCEN_POS  18U
#define  RCU_AHBSL_GPCEN_MSK  BIT(RCU_AHBSL_GPCEN_POS)

#define  RCU_AHBSL_HDIVEN_POS  15U
#define  RCU_AHBSL_HDIVEN_MSK  BIT(RCU_AHBSL_HDIVEN_POS)

/****************** Bit definition for RCU_APB1SL register ************************/

#define  RCU_APB1SL_I2C1EN_POS  21U
#define  RCU_APB1SL_I2C1EN_MSK  BIT(RCU_APB1SL_I2C1EN_POS)

#define  RCU_APB1SL_SUART1EN_POS  19U
#define  RCU_APB1SL_SUART1EN_MSK  BIT(RCU_APB1SL_SUART1EN_POS)

#define  RCU_APB1SL_IWDTEN_POS  12U
#define  RCU_APB1SL_IWDTEN_MSK  BIT(RCU_APB1SL_IWDTEN_POS)

#define  RCU_APB1SL_WWDTEN_POS  11U
#define  RCU_APB1SL_WWDTEN_MSK  BIT(RCU_APB1SL_WWDTEN_POS)

#define  RCU_APB1SL_BS16T1EN_POS  4U
#define  RCU_APB1SL_BS16T1EN_MSK  BIT(RCU_APB1SL_BS16T1EN_POS)

#define  RCU_APB1SL_GP32C4T1EN_POS  0U
#define  RCU_APB1SL_GP32C4T1EN_MSK  BIT(RCU_APB1SL_GP32C4T1EN_POS)

/****************** Bit definition for RCU_APB2SL register ************************/

#define  RCU_APB2SL_GP16C2T2EN_POS  17U
#define  RCU_APB2SL_GP16C2T2EN_MSK  BIT(RCU_APB2SL_GP16C2T2EN_POS)

#define  RCU_APB2SL_GP16C2T1EN_POS  16U
#define  RCU_APB2SL_GP16C2T1EN_MSK  BIT(RCU_APB2SL_GP16C2T1EN_POS)

#define  RCU_APB2SL_UART1EN_POS  14U
#define  RCU_APB2SL_UART1EN_MSK  BIT(RCU_APB2SL_UART1EN_POS)

#define  RCU_APB2SL_SPI1EN_POS  12U
#define  RCU_APB2SL_SPI1EN_MSK  BIT(RCU_APB2SL_SPI1EN_POS)

#define RCU_APB2SL_MMCEN_POS    3U
#define RCU_APB2SL_MMCEN_MSK    BIT(RCU_APB2SL_MMCEN_POS)

#define RCU_APB2SL_LCDEN_POS    2U
#define RCU_APB2SL_LCDEN_MSK    BIT(RCU_APB2SL_LCDEN_POS)

/****************** Bit definition for RCU_AHBDSL register ************************/

#define  RCU_AHBDSL_GPDEN_POS  19U
#define  RCU_AHBDSL_GPDEN_MSK  BIT(RCU_AHBDSL_GPDEN_POS)

#define  RCU_AHBDSL_GPCEN_POS  18U
#define  RCU_AHBDSL_GPCEN_MSK  BIT(RCU_AHBDSL_GPCEN_POS)

#define  RCU_AHBDSL_HDIVEN_POS  15U
#define  RCU_AHBDSL_HDIVEN_MSK  BIT(RCU_AHBDSL_HDIVEN_POS)

/****************** Bit definition for RCU_APB1DSL register ************************/

#define  RCU_APB1DSL_I2C1EN_POS  21U
#define  RCU_APB1DSL_I2C1EN_MSK  BIT(RCU_APB1DSL_I2C1EN_POS)

#define  RCU_APB1DSL_SUART1EN_POS  19U
#define  RCU_APB1DSL_SUART1EN_MSK  BIT(RCU_APB1DSL_SUART1EN_POS)

#define  RCU_APB1DSL_IWDTEN_POS  12U
#define  RCU_APB1DSL_IWDTEN_MSK  BIT(RCU_APB1DSL_IWDTEN_POS)

#define  RCU_APB1DSL_WWDTEN_POS  11U
#define  RCU_APB1DSL_WWDTEN_MSK  BIT(RCU_APB1DSL_WWDTEN_POS)

#define  RCU_APB1DSL_BS16T1EN_POS  4U
#define  RCU_APB1DSL_BS16T1EN_MSK  BIT(RCU_APB1DSL_BS16T1EN_POS)

#define  RCU_APB1DSL_GP32C4T1EN_POS  0U
#define  RCU_APB1DSL_GP32C4T1EN_MSK  BIT(RCU_APB1DSL_GP32C4T1EN_POS)

/****************** Bit definition for RCU_APB2DSL register ************************/

#define  RCU_APB2DSL_GP16C2T2EN_POS  17U
#define  RCU_APB2DSL_GP16C2T2EN_MSK  BIT(RCU_APB2DSL_GP16C2T2EN_POS)

#define  RCU_APB2DSL_GP16C2T1EN_POS  16U
#define  RCU_APB2DSL_GP16C2T1EN_MSK  BIT(RCU_APB2DSL_GP16C2T1EN_POS)

#define  RCU_APB2DSL_UART1EN_POS  14U
#define  RCU_APB2DSL_UART1EN_MSK  BIT(RCU_APB2DSL_UART1EN_POS)

#define  RCU_APB2DSL_SPI1EN_POS  12U
#define  RCU_APB2DSL_SPI1EN_MSK  BIT(RCU_APB2DSL_SPI1EN_POS)

#define RCU_APB2DSL_MMCEN_POS   3U
#define RCU_APB2DSL_MMCEN_MSK   BIT(RCU_APB2DSL_MMCEN_POS)

#define RCU_APB2DSL_LCDEN_POS   2U
#define RCU_APB2DSL_LCDEN_MSK   BIT(RCU_APB2DSL_LCDEN_POS)

/****************** Bit definition for RCU_HTRIM register ************************/

#define RCU_HTRIM_CNT_POSS  20U
#define RCU_HTRIM_CNT_POSE  31U
#define RCU_HTRIM_CNT_MSK   BITS(RCU_HTRIM_CNT_POSS,RCU_HTRIM_CNT_POSE)

#define RCU_HTRIM_FAIL_POS  18U
#define RCU_HTRIM_FAIL_MSK  BIT(RCU_HTRIM_FAIL_POS)

#define RCU_HTRIM_NOTEQU_POS    17U
#define RCU_HTRIM_NOTEQU_MSK    BIT(RCU_HTRIM_NOTEQU_POS)

#define RCU_HTRIM_BUSY_POS  16U
#define RCU_HTRIM_BUSY_MSK  BIT(RCU_HTRIM_BUSY_POS)

#define RCU_HTRIM_HRCTRIM_POSS  8U
#define RCU_HTRIM_HRCTRIM_POSE  15U
#define RCU_HTRIM_HRCTRIM_MSK   BITS(RCU_HTRIM_HRCTRIM_POSS,RCU_HTRIM_HRCTRIM_POSE)

#define RCU_HTRIM_INSEL_POS 7U
#define RCU_HTRIM_INSEL_MSK BIT(RCU_HTRIM_INSEL_POS)

#define RCU_HTRIM_RANGE_POSS    2U
#define RCU_HTRIM_RANGE_POSE    6U
#define RCU_HTRIM_RANGE_MSK BITS(RCU_HTRIM_RANGE_POSS,RCU_HTRIM_RANGE_POSE)

#define RCU_HTRIM_SWEN_POS  1U
#define RCU_HTRIM_SWEN_MSK  BIT(RCU_HTRIM_SWEN_POS)

#define RCU_HTRIM_TRIM_POS  0U
#define RCU_HTRIM_TRIM_MSK  BIT(RCU_HTRIM_TRIM_POS)

/****************** Bit definition for RCU_HCON register ************************/

#define RCU_HCON_TRIM_TAR_POSS  20U
#define RCU_HCON_TRIM_TAR_POSE  31U
#define RCU_HCON_TRIM_TAR_MSK   BITS(RCU_HCON_TRIM_TAR_POSS,RCU_HCON_TRIM_TAR_POSE)

#define RCU_HCON_OPT_HRCTRIM_POSS   8U
#define RCU_HCON_OPT_HRCTRIM_POSE   15U
#define RCU_HCON_OPT_HRCTRIM_MSK    BITS(RCU_HCON_OPT_HRCTRIM_POSS,RCU_HCON_OPT_HRCTRIM_POSE)

#define RCU_HCON_SETTLE_POSS    0U
#define RCU_HCON_SETTLE_POSE    7U
#define RCU_HCON_SETTLE_MSK BITS(RCU_HCON_SETTLE_POSS,RCU_HCON_SETTLE_POSE)

/****************** Bit definition for RCU_LTRIM register ************************/

#define RCU_LTRIM_CNT_POSS  20U
#define RCU_LTRIM_CNT_POSE  29U
#define RCU_LTRIM_CNT_MSK   BITS(RCU_LTRIM_CNT_POSS,RCU_LTRIM_CNT_POSE)

#define RCU_LTRIM_FAIL_POS  18U
#define RCU_LTRIM_FAIL_MSK  BIT(RCU_LTRIM_FAIL_POS)

#define RCU_LTRIM_NOTEQU_POS    17U
#define RCU_LTRIM_NOTEQU_MSK    BIT(RCU_LTRIM_NOTEQU_POS)

#define RCU_LTRIM_BUSY_POS  16U
#define RCU_LTRIM_BUSY_MSK  BIT(RCU_LTRIM_BUSY_POS)

#define RCU_LTRIM_LRCTRIM_POSS  8U
#define RCU_LTRIM_LRCTRIM_POSE  12U
#define RCU_LTRIM_LRCTRIM_MSK   BITS(RCU_LTRIM_LRCTRIM_POSS,RCU_LTRIM_LRCTRIM_POSE)

#define RCU_LTRIM_INSEL_POS 7U
#define RCU_LTRIM_INSEL_MSK BIT(RCU_LTRIM_INSEL_POS)

#define RCU_LTRIM_RANGE_POSS    2U
#define RCU_LTRIM_RANGE_POSE    6U
#define RCU_LTRIM_RANGE_MSK BITS(RCU_LTRIM_RANGE_POSS,RCU_LTRIM_RANGE_POSE)

#define RCU_LTRIM_SWEN_POS  1U
#define RCU_LTRIM_SWEN_MSK  BIT(RCU_LTRIM_SWEN_POS)

#define RCU_LTRIM_TRIM_POS  0U
#define RCU_LTRIM_TRIM_MSK  BIT(RCU_LTRIM_TRIM_POS)

/****************** Bit definition for RCU_LCON register ************************/

#define RCU_LCON_TRIM_TAR_POSS  20U
#define RCU_LCON_TRIM_TAR_POSE  29U
#define RCU_LCON_TRIM_TAR_MSK   BITS(RCU_LCON_TRIM_TAR_POSS,RCU_LCON_TRIM_TAR_POSE)

#define RCU_LCON_OPT_LRCTRIM_POSS   8U
#define RCU_LCON_OPT_LRCTRIM_POSE   14U
#define RCU_LCON_OPT_LRCTRIM_MSK    BITS(RCU_LCON_OPT_LRCTRIM_POSS,RCU_LCON_OPT_LRCTRIM_POSE)

#define RCU_LCON_SETTLE_POSS    0U
#define RCU_LCON_SETTLE_POSE    7U
#define RCU_LCON_SETTLE_MSK BITS(RCU_LCON_SETTLE_POSS,RCU_LCON_SETTLE_POSE)

typedef struct
{
    __IO uint32_t CON;
    __IO uint32_t CFG;
    __IO uint32_t IPCFG;
    uint32_t RESERVED0 ;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __IO uint32_t RSTAT;
    uint32_t RESERVED1 ;
    __IO uint32_t AHBRST;
    __IO uint32_t APB1RST;
    __IO uint32_t APB2RST;
    __IO uint32_t AHBEN;
    __IO uint32_t APB1EN;
    __IO uint32_t APB2EN;
    __IO uint32_t AHBSL;
    __IO uint32_t APB1SL;
    __IO uint32_t APB2SL;
    __IO uint32_t AHBDSL;
    __IO uint32_t APB1DSL;
    __IO uint32_t APB2DSL;
    uint32_t RESERVED2[8] ;
    __IO uint32_t HTRIM;
    __IO uint32_t HCON;
    __IO uint32_t LTRIM;
    __IO uint32_t LCON;
} RCU_TypeDef;

#endif
