/**********************************************************************************
 *
 * @file    reg_mmc.h
 * @brief   MMC Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __MMC_H__
#define __MMC_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions
/****************** Bit definition for MMC_CTRL register ************************/

#define MMC_CTRL_EN_FUNC_OP_POS 30U
#define MMC_CTRL_EN_FUNC_OP_MSK BIT(MMC_CTRL_EN_FUNC_OP_POS)

#define MMC_CTRL_VREFO_CKSEL_POS    29U
#define MMC_CTRL_VREFO_CKSEL_MSK    BIT(MMC_CTRL_VREFO_CKSEL_POS)

#define MMC_CTRL_VREFO_CHOP_POS 28U
#define MMC_CTRL_VREFO_CHOP_MSK BIT(MMC_CTRL_VREFO_CHOP_POS)

#define MMC_CTRL_VPUMP_BYP_POS  27U
#define MMC_CTRL_VPUMP_BYP_MSK  BIT(MMC_CTRL_VPUMP_BYP_POS)

#define MMC_CTRL_SEL_VPUMP_POSS 25U
#define MMC_CTRL_SEL_VPUMP_POSE 26U
#define MMC_CTRL_SEL_VPUMP_MSK  BITS(MMC_CTRL_SEL_VPUMP_POSS,MMC_CTRL_SEL_VPUMP_POSE)

#define MMC_CTRL_EN_VDDA_FLOAT_POS  24U
#define MMC_CTRL_EN_VDDA_FLOAT_MSK  BIT(MMC_CTRL_EN_VDDA_FLOAT_POS)

#define MMC_CTRL_MODE_POSS  16U
#define MMC_CTRL_MODE_POSE  23U
#define MMC_CTRL_MODE_MSK   BITS(MMC_CTRL_MODE_POSS,MMC_CTRL_MODE_POSE)

#define MMC_CTRL_VREF_SEL_POSS  12U
#define MMC_CTRL_VREF_SEL_POSE  15U
#define MMC_CTRL_VREF_SEL_MSK   BITS(MMC_CTRL_VREF_SEL_POSS,MMC_CTRL_VREF_SEL_POSE)

#define MMC_CTRL_SEL_VDDA_POSS  10U
#define MMC_CTRL_SEL_VDDA_POSE  11U
#define MMC_CTRL_SEL_VDDA_MSK   BITS(MMC_CTRL_SEL_VDDA_POSS,MMC_CTRL_SEL_VDDA_POSE)

#define MMC_CTRL_SEL_GREF_POSS  8U
#define MMC_CTRL_SEL_GREF_POSE  9U
#define MMC_CTRL_SEL_GREF_MSK   BITS(MMC_CTRL_SEL_GREF_POSS,MMC_CTRL_SEL_GREF_POSE)

#define MMC_CTRL_VRG_K2_POS 7U
#define MMC_CTRL_VRG_K2_MSK BIT(MMC_CTRL_VRG_K2_POS)

#define MMC_CTRL_VREF_SRC_POS   6U
#define MMC_CTRL_VREF_SRC_MSK   BIT(MMC_CTRL_VREF_SRC_POS)

#define MMC_CTRL_BN02_CTRL_POS  5U
#define MMC_CTRL_BN02_CTRL_MSK  BIT(MMC_CTRL_BN02_CTRL_POS)

#define MMC_CTRL_EN_VPUMP_POS   4U
#define MMC_CTRL_EN_VPUMP_MSK   BIT(MMC_CTRL_EN_VPUMP_POS)

#define MMC_CTRL_EN_VDDA_POS    3U
#define MMC_CTRL_EN_VDDA_MSK    BIT(MMC_CTRL_EN_VDDA_POS)

#define MMC_CTRL_EN_VREFO_POS   2U
#define MMC_CTRL_EN_VREFO_MSK   BIT(MMC_CTRL_EN_VREFO_POS)

#define MMC_CTRL_EN_VRGEN_POS   1U
#define MMC_CTRL_EN_VRGEN_MSK   BIT(MMC_CTRL_EN_VRGEN_POS)

#define MMC_CTRL_EN_MMC_POS 0U
#define MMC_CTRL_EN_MMC_MSK BIT(MMC_CTRL_EN_MMC_POS)

/****************** Bit definition for MMC_PA_SWCTRL register ************************/

#define MMC_AN_SWCTRL_AN6_PWCTRL_POS    27U
#define MMC_AN_SWCTRL_AN6_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN6_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN6_OPCTRL_POS    26U
#define MMC_AN_SWCTRL_AN6_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN6_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN6_FBCTRL_POS    25U
#define MMC_AN_SWCTRL_AN6_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN6_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN6_SSCTRL_POS    24U
#define MMC_AN_SWCTRL_AN6_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN6_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN5_PWCTRL_POS    23U
#define MMC_AN_SWCTRL_AN5_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN5_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN5_OPCTRL_POS    22U
#define MMC_AN_SWCTRL_AN5_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN5_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN5_FBCTRL_POS    21U
#define MMC_AN_SWCTRL_AN5_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN5_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN5_SSCTRL_POS    20U
#define MMC_AN_SWCTRL_AN5_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN5_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN4_PWCTRL_POS    19U
#define MMC_AN_SWCTRL_AN4_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN4_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN4_OPCTRL_POS    18U
#define MMC_AN_SWCTRL_AN4_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN4_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN4_FBCTRL_POS    17U
#define MMC_AN_SWCTRL_AN4_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN4_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN4_SSCTRL_POS    16U
#define MMC_AN_SWCTRL_AN4_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN4_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN3_PWCTRL_POS    15U
#define MMC_AN_SWCTRL_AN3_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN3_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN3_OPCTRL_POS    14U
#define MMC_AN_SWCTRL_AN3_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN3_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN3_FBCTRL_POS    13U
#define MMC_AN_SWCTRL_AN3_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN3_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN3_SSCTRL_POS    12U
#define MMC_AN_SWCTRL_AN3_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN3_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN2_PWCTRL_POS    11U
#define MMC_AN_SWCTRL_AN2_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN2_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN2_OPCTRL_POS    10U
#define MMC_AN_SWCTRL_AN2_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN2_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN2_FBCTRL_POS    9U
#define MMC_AN_SWCTRL_AN2_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN2_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN2_SSCTRL_POS    8U
#define MMC_AN_SWCTRL_AN2_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN2_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN1_PWCTRL_POS    7U
#define MMC_AN_SWCTRL_AN1_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN1_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN1_OPCTRL_POS    6U
#define MMC_AN_SWCTRL_AN1_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN1_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN1_FBCTRL_POS    5U
#define MMC_AN_SWCTRL_AN1_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN1_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN1_SSCTRL_POS    4U
#define MMC_AN_SWCTRL_AN1_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN1_SSCTRL_POS)

#define MMC_AN_SWCTRL_AN0_PWCTRL_POS    3U
#define MMC_AN_SWCTRL_AN0_PWCTRL_MSK    BIT(MMC_AN_SWCTRL_AN0_PWCTRL_POS)

#define MMC_AN_SWCTRL_AN0_OPCTRL_POS    2U
#define MMC_AN_SWCTRL_AN0_OPCTRL_MSK    BIT(MMC_AN_SWCTRL_AN0_OPCTRL_POS)

#define MMC_AN_SWCTRL_AN0_FBCTRL_POS    1U
#define MMC_AN_SWCTRL_AN0_FBCTRL_MSK    BIT(MMC_AN_SWCTRL_AN0_FBCTRL_POS)

#define MMC_AN_SWCTRL_AN0_SSCTRL_POS    0U
#define MMC_AN_SWCTRL_AN0_SSCTRL_MSK    BIT(MMC_AN_SWCTRL_AN0_SSCTRL_POS)

/****************** Bit definition for MMC_ADC_CTRL0 register ************************/

#define MMC_ADC_CTRL0_RST_AD_POS    31U
#define MMC_ADC_CTRL0_RST_AD_MSK    BIT(MMC_ADC_CTRL0_RST_AD_POS)

#define MMC_ADC_CTRL0_AD_NFILT_POSS 28U
#define MMC_ADC_CTRL0_AD_NFILT_POSE 30U
#define MMC_ADC_CTRL0_AD_NFILT_MSK  BITS(MMC_ADC_CTRL0_AD_NFILT_POSS,MMC_ADC_CTRL0_AD_NFILT_POSE)

#define MMC_ADC_CTRL0_AD_PFILT_POSS 24U
#define MMC_ADC_CTRL0_AD_PFILT_POSE 27U
#define MMC_ADC_CTRL0_AD_PFILT_MSK  BITS(MMC_ADC_CTRL0_AD_PFILT_POSS,MMC_ADC_CTRL0_AD_PFILT_POSE)

#define MMC_ADC_CTRL0_PFILT_CH_POSS 22U
#define MMC_ADC_CTRL0_PFILT_CH_POSE 23U
#define MMC_ADC_CTRL0_PFILT_CH_MSK  BITS(MMC_ADC_CTRL0_PFILT_CH_POSS,MMC_ADC_CTRL0_PFILT_CH_POSE)

#define MMC_ADC_CTRL0_AD_CHOP_POSS  20U
#define MMC_ADC_CTRL0_AD_CHOP_POSE  21U
#define MMC_ADC_CTRL0_AD_CHOP_MSK   BITS(MMC_ADC_CTRL0_AD_CHOP_POSS,MMC_ADC_CTRL0_AD_CHOP_POSE)

#define MMC_ADC_CTRL0_EN_TS_POS 19U
#define MMC_ADC_CTRL0_EN_TS_MSK BIT(MMC_ADC_CTRL0_EN_TS_POS)

#define MMC_ADC_CTRL0_SEL_VCM_POS   18U
#define MMC_ADC_CTRL0_SEL_VCM_MSK   BIT(MMC_ADC_CTRL0_SEL_VCM_POS)

#define MMC_ADC_CTRL0_SEL_FRQ_POSS  16U
#define MMC_ADC_CTRL0_SEL_FRQ_POSE  17U
#define MMC_ADC_CTRL0_SEL_FRQ_MSK   BITS(MMC_ADC_CTRL0_SEL_FRQ_POSS,MMC_ADC_CTRL0_SEL_FRQ_POSE)

#define MMC_ADC_CTRL0_SEL_NADR_POSS 13U
#define MMC_ADC_CTRL0_SEL_NADR_POSE 15U
#define MMC_ADC_CTRL0_SEL_NADR_MSK  BITS(MMC_ADC_CTRL0_SEL_NADR_POSS,MMC_ADC_CTRL0_SEL_NADR_POSE)

#define MMC_ADC_CTRL0_SEL_PADR_POSS 10U
#define MMC_ADC_CTRL0_SEL_PADR_POSE 12U
#define MMC_ADC_CTRL0_SEL_PADR_MSK  BITS(MMC_ADC_CTRL0_SEL_PADR_POSS,MMC_ADC_CTRL0_SEL_PADR_POSE)

#define MMC_ADC_CTRL0_SEL_ADI_POSS  8U
#define MMC_ADC_CTRL0_SEL_ADI_POSE  9U
#define MMC_ADC_CTRL0_SEL_ADI_MSK   BITS(MMC_ADC_CTRL0_SEL_ADI_POSS,MMC_ADC_CTRL0_SEL_ADI_POSE)

#define MMC_ADC_CTRL0_ADR_NBUF_POS  7U
#define MMC_ADC_CTRL0_ADR_NBUF_MSK  BIT(MMC_ADC_CTRL0_ADR_NBUF_POS)

#define MMC_ADC_CTRL0_ADR_PBUF_POS  6U
#define MMC_ADC_CTRL0_ADR_PBUF_MSK  BIT(MMC_ADC_CTRL0_ADR_PBUF_POS)

#define MMC_ADC_CTRL0_ADI_NBUF_POS  5U
#define MMC_ADC_CTRL0_ADI_NBUF_MSK  BIT(MMC_ADC_CTRL0_ADI_NBUF_POS)

#define MMC_ADC_CTRL0_ADI_PBUF_POS  4U
#define MMC_ADC_CTRL0_ADI_PBUF_MSK  BIT(MMC_ADC_CTRL0_ADI_PBUF_POS)

#define MMC_ADC_CTRL0_ADR_GAIN_POS  3U
#define MMC_ADC_CTRL0_ADR_GAIN_MSK  BIT(MMC_ADC_CTRL0_ADR_GAIN_POS)

#define MMC_ADC_CTRL0_ADI_GAIN_POSS 1U
#define MMC_ADC_CTRL0_ADI_GAIN_POSE 2U
#define MMC_ADC_CTRL0_ADI_GAIN_MSK  BITS(MMC_ADC_CTRL0_ADI_GAIN_POSS,MMC_ADC_CTRL0_ADI_GAIN_POSE)

#define MMC_ADC_CTRL0_EN_AD_POS 0U
#define MMC_ADC_CTRL0_EN_AD_MSK BIT(MMC_ADC_CTRL0_EN_AD_POS)

/****************** Bit definition for MMC_ADC_CTRL1 register ************************/

#define MMC_ADC_CTRL1_ADRST_DIG_POS    31U
#define MMC_ADC_CTRL1_ADRST_DIG_MSK    BIT(MMC_ADC_CTRL1_ADRST_DIG_POS)

#define MMC_ADC_CTRL1_AVFILT_MODE_POSS  28U
#define MMC_ADC_CTRL1_AVFILT_MODE_POSE  30U
#define MMC_ADC_CTRL1_AVFILT_MODE_MSK   BITS(MMC_ADC_CTRL1_AVFILT_MODE_POSS,MMC_ADC_CTRL1_AVFILT_MODE_POSE)

#define MMC_ADC_CTRL1_SKIP_CNTINT_POSS  24U
#define MMC_ADC_CTRL1_SKIP_CNTINT_POSE  27U
#define MMC_ADC_CTRL1_SKIP_CNTINT_MSK   BITS(MMC_ADC_CTRL1_SKIP_CNTINT_POSS,MMC_ADC_CTRL1_SKIP_CNTINT_POSE)

#define MMC_ADC_CTRL1_DECIM_MODE_POS    23U
#define MMC_ADC_CTRL1_DECIM_MODE_MSK    BIT(MMC_ADC_CTRL1_DECIM_MODE_POS)

#define MMC_ADC_CTRL1_CHOP_FREQ_POSS    21U
#define MMC_ADC_CTRL1_CHOP_FREQ_POSE    22U
#define MMC_ADC_CTRL1_CHOP_FREQ_MSK BITS(MMC_ADC_CTRL1_CHOP_FREQ_POSS,MMC_ADC_CTRL1_CHOP_FREQ_POSE)

#define MMC_ADC_CTRL1_AD_BUFCHOP_POS    20U
#define MMC_ADC_CTRL1_AD_BUFCHOP_MSK    BIT(MMC_ADC_CTRL1_AD_BUFCHOP_POS)

#define MMC_ADC_CTRL1_AD_ACMBUF_POS 19U
#define MMC_ADC_CTRL1_AD_ACMBUF_MSK BIT(MMC_ADC_CTRL1_AD_ACMBUF_POS)

#define MMC_ADC_CTRL1_AD_PGA_SEL_POSS   16U
#define MMC_ADC_CTRL1_AD_PGA_SEL_POSE   18U
#define MMC_ADC_CTRL1_AD_PGA_SEL_MSK    BITS(MMC_ADC_CTRL1_AD_PGA_SEL_POSS,MMC_ADC_CTRL1_AD_PGA_SEL_POSE)

#define MMC_ADC_CTRL1_EN_DROOP_POS  15U
#define MMC_ADC_CTRL1_EN_DROOP_MSK  BIT(MMC_ADC_CTRL1_EN_DROOP_POS)

#define MMC_ADC_CTRL1_RMS_MODE_POSS 13U
#define MMC_ADC_CTRL1_RMS_MODE_POSE 14U
#define MMC_ADC_CTRL1_RMS_MODE_MSK  BITS(MMC_ADC_CTRL1_RMS_MODE_POSS,MMC_ADC_CTRL1_RMS_MODE_POSE)

#define MMC_ADC_CTRL1_SEL_LPFOSR_POSS   11U
#define MMC_ADC_CTRL1_SEL_LPFOSR_POSE   12U
#define MMC_ADC_CTRL1_SEL_LPFOSR_MSK    BITS(MMC_ADC_CTRL1_SEL_LPFOSR_POSS,MMC_ADC_CTRL1_SEL_LPFOSR_POSE)

#define MMC_ADC_CTRL1_AD_OSR_POSS   8U
#define MMC_ADC_CTRL1_AD_OSR_POSE   10U
#define MMC_ADC_CTRL1_AD_OSR_MSK    BITS(MMC_ADC_CTRL1_AD_OSR_POSS,MMC_ADC_CTRL1_AD_OSR_POSE)

#define MMC_ADC_CTRL1_RST_PKHCMP_POS    7U
#define MMC_ADC_CTRL1_RST_PKHCMP_MSK    BIT(MMC_ADC_CTRL1_RST_PKHCMP_POS)

#define MMC_ADC_CTRL1_RST_RMS_POS   6U
#define MMC_ADC_CTRL1_RST_RMS_MSK   BIT(MMC_ADC_CTRL1_RST_RMS_POS)

#define MMC_ADC_CTRL1_RST_LPF_POS   5U
#define MMC_ADC_CTRL1_RST_LPF_MSK   BIT(MMC_ADC_CTRL1_RST_LPF_POS)

#define MMC_ADC_CTRL1_RST_COMB_POS  4U
#define MMC_ADC_CTRL1_RST_COMB_MSK  BIT(MMC_ADC_CTRL1_RST_COMB_POS)

#define MMC_ADC_CTRL1_EN_PKHCMP_POS 3U
#define MMC_ADC_CTRL1_EN_PKHCMP_MSK BIT(MMC_ADC_CTRL1_EN_PKHCMP_POS)

#define MMC_ADC_CTRL1_EN_RMS_POS    2U
#define MMC_ADC_CTRL1_EN_RMS_MSK    BIT(MMC_ADC_CTRL1_EN_RMS_POS)

#define MMC_ADC_CTRL1_EN_LPF_POS    1U
#define MMC_ADC_CTRL1_EN_LPF_MSK    BIT(MMC_ADC_CTRL1_EN_LPF_POS)

#define MMC_ADC_CTRL1_EN_COMB_POS   0U
#define MMC_ADC_CTRL1_EN_COMB_MSK   BIT(MMC_ADC_CTRL1_EN_COMB_POS)

/****************** Bit definition for MMC_CMP_CTRL register ************************/

#define MMC_CMP_CTRL_CMPHO_POS    26U
#define MMC_CMP_CTRL_CMPHO_MSK    BIT(MMC_CMP_CTRL_CMPHO_POS)

#define MMC_CMP_CTRL_CMPLO_POS    25U
#define MMC_CMP_CTRL_CMPLO_MSK    BIT(MMC_CMP_CTRL_CMPLO_POS)

#define MMC_CMP_CTRL_CMPO_POS 24U
#define MMC_CMP_CTRL_CMPO_MSK BIT(MMC_CMP_CTRL_CMPO_POS)

#define MMC_CMP_CTRL_CMP_HIGH_POSS  12U
#define MMC_CMP_CTRL_CMP_HIGH_POSE  15U
#define MMC_CMP_CTRL_CMP_HIGH_MSK   BITS(MMC_CMP_CTRL_CMP_HIGH_POSS,MMC_CMP_CTRL_CMP_HIGH_POSE)

#define MMC_CMP_CTRL_CMP_LOW_POSS   8U
#define MMC_CMP_CTRL_CMP_LOW_POSE   11U
#define MMC_CMP_CTRL_CMP_LOW_MSK    BITS(MMC_CMP_CTRL_CMP_LOW_POSS,MMC_CMP_CTRL_CMP_LOW_POSE)

#define MMC_CMP_CTRL_CMP_MID_POSS   4U
#define MMC_CMP_CTRL_CMP_MID_POSE   6U
#define MMC_CMP_CTRL_CMP_MID_MSK    BITS(MMC_CMP_CTRL_CMP_MID_POSS,MMC_CMP_CTRL_CMP_MID_POSE)

#define MMC_CMP_CTRL_HYS_CMP_POS    1U
#define MMC_CMP_CTRL_HYS_CMP_MSK    BIT(MMC_CMP_CTRL_HYS_CMP_POS)

#define MMC_CMP_CTRL_EN_CMP_POS 0U
#define MMC_CMP_CTRL_EN_CMP_MSK BIT(MMC_CMP_CTRL_EN_CMP_POS)

/****************** Bit definition for MMC_LVD_CTRL register ************************/

#define MMC_LVD_CTRL_ST_LVD_POS 24U
#define MMC_LVD_CTRL_ST_LVD_MSK BIT(MMC_LVD_CTRL_ST_LVD_POS)

#define MMC_LVD_CTRL_SEL_NIN_POSS   12U
#define MMC_LVD_CTRL_SEL_NIN_POSE   15U
#define MMC_LVD_CTRL_SEL_NIN_MSK    BITS(MMC_LVD_CTRL_SEL_NIN_POSS,MMC_LVD_CTRL_SEL_NIN_POSE)

#define MMC_LVD_CTRL_SEL_PIN_POSS   8U
#define MMC_LVD_CTRL_SEL_PIN_POSE   10U
#define MMC_LVD_CTRL_SEL_PIN_MSK    BITS(MMC_LVD_CTRL_SEL_PIN_POSS,MMC_LVD_CTRL_SEL_PIN_POSE)

#define MMC_LVD_CTRL_LVD_MODE_POSS  4U
#define MMC_LVD_CTRL_LVD_MODE_POSE  7U
#define MMC_LVD_CTRL_LVD_MODE_MSK   BITS(MMC_LVD_CTRL_LVD_MODE_POSS,MMC_LVD_CTRL_LVD_MODE_POSE)

#define MMC_LVD_CTRL_HYS_LVD_POS    1U
#define MMC_LVD_CTRL_HYS_LVD_MSK    BIT(MMC_LVD_CTRL_HYS_LVD_POS)

#define MMC_LVD_CTRL_EN_LVD_POS 0U
#define MMC_LVD_CTRL_EN_LVD_MSK BIT(MMC_LVD_CTRL_EN_LVD_POS)

/****************** Bit definition for MMC_CNT_CTRL register ************************/

#define MMC_CNT_CTRL_RST_FQCNT_POS  31U
#define MMC_CNT_CTRL_RST_FQCNT_MSK  BIT(MMC_CNT_CTRL_RST_FQCNT_POS)

#define MMC_CNT_CTRL_FQCNT_DIV_POSS 28U
#define MMC_CNT_CTRL_FQCNT_DIV_POSE 30U
#define MMC_CNT_CTRL_FQCNT_DIV_MSK  BITS(MMC_CNT_CTRL_FQCNT_DIV_POSS,MMC_CNT_CTRL_FQCNT_DIV_POSE)

#define MMC_CNT_CTRL_FQCNTI_POS   26U
#define MMC_CNT_CTRL_FQCNTI_MSK   BIT(MMC_CNT_CTRL_FQCNTI_POS)

#define MMC_CNT_CTRL_EN_FQCNTI_POS  25U
#define MMC_CNT_CTRL_EN_FQCNTI_MSK  BIT(MMC_CNT_CTRL_EN_FQCNTI_POS)

#define MMC_CNT_CTRL_EN_FQCNT_POS   24U
#define MMC_CNT_CTRL_EN_FQCNT_MSK   BIT(MMC_CNT_CTRL_EN_FQCNT_POS)

#define MMC_CNT_CTRL_INIT_CNTA_POSS 8U
#define MMC_CNT_CTRL_INIT_CNTA_POSE 23U
#define MMC_CNT_CTRL_INIT_CNTA_MSK  BITS(MMC_CNT_CTRL_INIT_CNTA_POSS,MMC_CNT_CTRL_INIT_CNTA_POSE)

/****************** Bit definition for MMC_FQ_CNTA register ************************/

#define MMC_FQ_CNTA_FQ_CNTA_POSS    0U
#define MMC_FQ_CNTA_FQ_CNTA_POSE    23U
#define MMC_FQ_CNTA_FQ_CNTA_MSK BITS(MMC_FQ_CNTA_FQ_CNTA_POSS,MMC_FQ_CNTA_FQ_CNTA_POSE)

/****************** Bit definition for MMC_FQ_CNTB register ************************/

#define MMC_FQ_CNTB_FQ_CNTB_POSS    0U
#define MMC_FQ_CNTB_FQ_CNTB_POSE    23U
#define MMC_FQ_CNTB_FQ_CNTB_MSK BITS(MMC_FQ_CNTB_FQ_CNTB_POSS,MMC_FQ_CNTB_FQ_CNTB_POSE)

/****************** Bit definition for MMC_FQ_CNTC register ************************/

#define MMC_FQ_CNTC_FQ_CNTC_POSS    0U
#define MMC_FQ_CNTC_FQ_CNTC_POSE    23U
#define MMC_FQ_CNTC_FQ_CNTC_MSK BITS(MMC_FQ_CNTC_FQ_CNTC_POSS,MMC_FQ_CNTC_FQ_CNTC_POSE)

/****************** Bit definition for MMC_PKH_MAX register ************************/

#define MMC_PKH_MAX_PKH_MAX_POSS    0U
#define MMC_PKH_MAX_PKH_MAX_POSE    31U
#define MMC_PKH_MAX_PKH_MAX_MSK BITS(MMC_PKH_MAX_PKH_MAX_POSS,MMC_PKH_MAX_PKH_MAX_POSE)

/****************** Bit definition for MMC_PKH_MIN register ************************/

#define MMC_PKH_MIN_PKH_MIN_POSS    0U
#define MMC_PKH_MIN_PKH_MIN_POSE    31U
#define MMC_PKH_MIN_PKH_MIN_MSK BITS(MMC_PKH_MIN_PKH_MIN_POSS,MMC_PKH_MIN_PKH_MIN_POSE)

/****************** Bit definition for MMC_DCEST_VAL register ************************/

#define MMC_DCEST_VAL_DCEST_VAL_POSS    0U
#define MMC_DCEST_VAL_DCEST_VAL_POSE    31U
#define MMC_DCEST_VAL_DCEST_VAL_MSK BITS(MMC_DCEST_VAL_DCEST_VAL_POSS,MMC_DCEST_VAL_DCEST_VAL_POSE)

/****************** Bit definition for MMC_RMS_VAL register ************************/

#define MMC_RMS_VAL_RMS_VAL_POSS    0U
#define MMC_RMS_VAL_RMS_VAL_POSE    31U
#define MMC_RMS_VAL_RMS_VAL_MSK BITS(MMC_RMS_VAL_RMS_VAL_POSS,MMC_RMS_VAL_RMS_VAL_POSE)

/****************** Bit definition for MMC_LPF_VAL register ************************/

#define MMC_LPF_VAL_LPF_VAL_POSS    0U
#define MMC_LPF_VAL_LPF_VAL_POSE    31U
#define MMC_LPF_VAL_LPF_VAL_MSK BITS(MMC_LPF_VAL_LPF_VAL_POSS,MMC_LPF_VAL_LPF_VAL_POSE)

/****************** Bit definition for MMC_ADC_VAL register ************************/

#define MMC_ADC_VAL_ADC_VAL_POSS    0U
#define MMC_ADC_VAL_ADC_VAL_POSE    31U
#define MMC_ADC_VAL_ADC_VAL_MSK BITS(MMC_ADC_VAL_ADC_VAL_POSS,MMC_ADC_VAL_ADC_VAL_POSE)

/****************** Bit definition for MMC_IER register ************************/

#define MMC_IER_CNTB_OV_POS 15U
#define MMC_IER_CNTB_OV_MSK BIT(MMC_IER_CNTB_OV_POS)

#define MMC_IER_FRQCNT_ABN_POS  14U
#define MMC_IER_FRQCNT_ABN_MSK  BIT(MMC_IER_FRQCNT_ABN_POS)

#define MMC_IER_FRQCNT_DONE_POS 13U
#define MMC_IER_FRQCNT_DONE_MSK BIT(MMC_IER_FRQCNT_DONE_POS)

#define MMC_IER_LVDO_CHG_POS    11U
#define MMC_IER_LVDO_CHG_MSK    BIT(MMC_IER_LVDO_CHG_POS)

#define MMC_IER_CMPO_CHG_POS    10U
#define MMC_IER_CMPO_CHG_MSK    BIT(MMC_IER_CMPO_CHG_POS)

#define MMC_IER_CMPL_CHG_POS    9U
#define MMC_IER_CMPL_CHG_MSK    BIT(MMC_IER_CMPL_CHG_POS)

#define MMC_IER_CMPH_CHG_POS    8U
#define MMC_IER_CMPH_CHG_MSK    BIT(MMC_IER_CMPH_CHG_POS)

#define MMC_IER_PKH_DONE_POS    3U
#define MMC_IER_PKH_DONE_MSK    BIT(MMC_IER_PKH_DONE_POS)

#define MMC_IER_RMS_DONE_POS    2U
#define MMC_IER_RMS_DONE_MSK    BIT(MMC_IER_RMS_DONE_POS)

#define MMC_IER_LPF_DONE_POS    1U
#define MMC_IER_LPF_DONE_MSK    BIT(MMC_IER_LPF_DONE_POS)

#define MMC_IER_ADC_DONE_POS    0U
#define MMC_IER_ADC_DONE_MSK    BIT(MMC_IER_ADC_DONE_POS)

/****************** Bit definition for MMC_IDR register ************************/

#define MMC_IDR_CNTB_OV_POS 15U
#define MMC_IDR_CNTB_OV_MSK BIT(MMC_IDR_CNTB_OV_POS)

#define MMC_IDR_FRQCNT_ABN_POS  14U
#define MMC_IDR_FRQCNT_ABN_MSK  BIT(MMC_IDR_FRQCNT_ABN_POS)

#define MMC_IDR_FRQCNT_DONE_POS 13U
#define MMC_IDR_FRQCNT_DONE_MSK BIT(MMC_IDR_FRQCNT_DONE_POS)

#define MMC_IDR_LVDO_CHG_POS    11U
#define MMC_IDR_LVDO_CHG_MSK    BIT(MMC_IDR_LVDO_CHG_POS)

#define MMC_IDR_CMPO_CHG_POS    10U
#define MMC_IDR_CMPO_CHG_MSK    BIT(MMC_IDR_CMPO_CHG_POS)

#define MMC_IDR_CMPL_CHG_POS    9U
#define MMC_IDR_CMPL_CHG_MSK    BIT(MMC_IDR_CMPL_CHG_POS)

#define MMC_IDR_CMPH_CHG_POS    8U
#define MMC_IDR_CMPH_CHG_MSK    BIT(MMC_IDR_CMPH_CHG_POS)

#define MMC_IDR_PKH_DONE_POS    3U
#define MMC_IDR_PKH_DONE_MSK    BIT(MMC_IDR_PKH_DONE_POS)

#define MMC_IDR_RMS_DONE_POS    2U
#define MMC_IDR_RMS_DONE_MSK    BIT(MMC_IDR_RMS_DONE_POS)

#define MMC_IDR_LPF_DONE_POS    1U
#define MMC_IDR_LPF_DONE_MSK    BIT(MMC_IDR_LPF_DONE_POS)

#define MMC_IDR_ADC_DONE_POS    0U
#define MMC_IDR_ADC_DONE_MSK    BIT(MMC_IDR_ADC_DONE_POS)

/****************** Bit definition for MMC_IVS register ************************/

#define MMC_IVS_CNTB_OV_POS 15U
#define MMC_IVS_CNTB_OV_MSK BIT(MMC_IVS_CNTB_OV_POS)

#define MMC_IVS_FRQCNT_ABN_POS  14U
#define MMC_IVS_FRQCNT_ABN_MSK  BIT(MMC_IVS_FRQCNT_ABN_POS)

#define MMC_IVS_FRQCNT_DONE_POS 13U
#define MMC_IVS_FRQCNT_DONE_MSK BIT(MMC_IVS_FRQCNT_DONE_POS)

#define MMC_IVS_LVDO_CHG_POS    11U
#define MMC_IVS_LVDO_CHG_MSK    BIT(MMC_IVS_LVDO_CHG_POS)

#define MMC_IVS_CMPO_CHG_POS    10U
#define MMC_IVS_CMPO_CHG_MSK    BIT(MMC_IVS_CMPO_CHG_POS)

#define MMC_IVS_CMPL_CHG_POS    9U
#define MMC_IVS_CMPL_CHG_MSK    BIT(MMC_IVS_CMPL_CHG_POS)

#define MMC_IVS_CMPH_CHG_POS    8U
#define MMC_IVS_CMPH_CHG_MSK    BIT(MMC_IVS_CMPH_CHG_POS)

#define MMC_IVS_PKH_DONE_POS    3U
#define MMC_IVS_PKH_DONE_MSK    BIT(MMC_IVS_PKH_DONE_POS)

#define MMC_IVS_RMS_DONE_POS    2U
#define MMC_IVS_RMS_DONE_MSK    BIT(MMC_IVS_RMS_DONE_POS)

#define MMC_IVS_LPF_DONE_POS    1U
#define MMC_IVS_LPF_DONE_MSK    BIT(MMC_IVS_LPF_DONE_POS)

#define MMC_IVS_ADC_DONE_POS    0U
#define MMC_IVS_ADC_DONE_MSK    BIT(MMC_IVS_ADC_DONE_POS)

/****************** Bit definition for MMC_RIF register ************************/

#define MMC_RIF_CNTB_OV_POS 15U
#define MMC_RIF_CNTB_OV_MSK BIT(MMC_RIF_CNTB_OV_POS)

#define MMC_RIF_FRQCNT_ABN_POS  14U
#define MMC_RIF_FRQCNT_ABN_MSK  BIT(MMC_RIF_FRQCNT_ABN_POS)

#define MMC_RIF_FRQCNT_DONE_POS 13U
#define MMC_RIF_FRQCNT_DONE_MSK BIT(MMC_RIF_FRQCNT_DONE_POS)

#define MMC_RIF_LVDO_CHG_POS    11U
#define MMC_RIF_LVDO_CHG_MSK    BIT(MMC_RIF_LVDO_CHG_POS)

#define MMC_RIF_CMPO_CHG_POS    10U
#define MMC_RIF_CMPO_CHG_MSK    BIT(MMC_RIF_CMPO_CHG_POS)

#define MMC_RIF_CMPL_CHG_POS    9U
#define MMC_RIF_CMPL_CHG_MSK    BIT(MMC_RIF_CMPL_CHG_POS)

#define MMC_RIF_CMPH_CHG_POS    8U
#define MMC_RIF_CMPH_CHG_MSK    BIT(MMC_RIF_CMPH_CHG_POS)

#define MMC_RIF_PKH_DONE_POS    3U
#define MMC_RIF_PKH_DONE_MSK    BIT(MMC_RIF_PKH_DONE_POS)

#define MMC_RIF_RMS_DONE_POS    2U
#define MMC_RIF_RMS_DONE_MSK    BIT(MMC_RIF_RMS_DONE_POS)

#define MMC_RIF_LPF_DONE_POS    1U
#define MMC_RIF_LPF_DONE_MSK    BIT(MMC_RIF_LPF_DONE_POS)

#define MMC_RIF_ADC_DONE_POS    0U
#define MMC_RIF_ADC_DONE_MSK    BIT(MMC_RIF_ADC_DONE_POS)

/****************** Bit definition for MMC_IFM register ************************/

#define MMC_IFM_CNTB_OV_POS 15U
#define MMC_IFM_CNTB_OV_MSK BIT(MMC_IFM_CNTB_OV_POS)

#define MMC_IFM_FRQCNT_ABN_POS  14U
#define MMC_IFM_FRQCNT_ABN_MSK  BIT(MMC_IFM_FRQCNT_ABN_POS)

#define MMC_IFM_FRQCNT_DONE_POS 13U
#define MMC_IFM_FRQCNT_DONE_MSK BIT(MMC_IFM_FRQCNT_DONE_POS)

#define MMC_IFM_LVDO_CHG_POS    11U
#define MMC_IFM_LVDO_CHG_MSK    BIT(MMC_IFM_LVDO_CHG_POS)

#define MMC_IFM_CMPO_CHG_POS    10U
#define MMC_IFM_CMPO_CHG_MSK    BIT(MMC_IFM_CMPO_CHG_POS)

#define MMC_IFM_CMPL_CHG_POS    9U
#define MMC_IFM_CMPL_CHG_MSK    BIT(MMC_IFM_CMPL_CHG_POS)

#define MMC_IFM_CMPH_CHG_POS    8U
#define MMC_IFM_CMPH_CHG_MSK    BIT(MMC_IFM_CMPH_CHG_POS)

#define MMC_IFM_PKH_DONE_POS    3U
#define MMC_IFM_PKH_DONE_MSK    BIT(MMC_IFM_PKH_DONE_POS)

#define MMC_IFM_RMS_DONE_POS    2U
#define MMC_IFM_RMS_DONE_MSK    BIT(MMC_IFM_RMS_DONE_POS)

#define MMC_IFM_LPF_DONE_POS    1U
#define MMC_IFM_LPF_DONE_MSK    BIT(MMC_IFM_LPF_DONE_POS)

#define MMC_IFM_ADC_DONE_POS    0U
#define MMC_IFM_ADC_DONE_MSK    BIT(MMC_IFM_ADC_DONE_POS)

/****************** Bit definition for MMC_ICR register ************************/

#define MMC_ICR_CNTB_OV_POS 15U
#define MMC_ICR_CNTB_OV_MSK BIT(MMC_ICR_CNTB_OV_POS)

#define MMC_ICR_FRQCNT_ABN_POS  14U
#define MMC_ICR_FRQCNT_ABN_MSK  BIT(MMC_ICR_FRQCNT_ABN_POS)

#define MMC_ICR_FRQCNT_DONE_POS 13U
#define MMC_ICR_FRQCNT_DONE_MSK BIT(MMC_ICR_FRQCNT_DONE_POS)

#define MMC_ICR_LVDO_CHG_POS    11U
#define MMC_ICR_LVDO_CHG_MSK    BIT(MMC_ICR_LVDO_CHG_POS)

#define MMC_ICR_CMPO_CHG_POS    10U
#define MMC_ICR_CMPO_CHG_MSK    BIT(MMC_ICR_CMPO_CHG_POS)

#define MMC_ICR_CMPL_CHG_POS    9U
#define MMC_ICR_CMPL_CHG_MSK    BIT(MMC_ICR_CMPL_CHG_POS)

#define MMC_ICR_CMPH_CHG_POS    8U
#define MMC_ICR_CMPH_CHG_MSK    BIT(MMC_ICR_CMPH_CHG_POS)

#define MMC_ICR_PKH_DONE_POS    3U
#define MMC_ICR_PKH_DONE_MSK    BIT(MMC_ICR_PKH_DONE_POS)

#define MMC_ICR_RMS_DONE_POS    2U
#define MMC_ICR_RMS_DONE_MSK    BIT(MMC_ICR_RMS_DONE_POS)

#define MMC_ICR_LPF_DONE_POS    1U
#define MMC_ICR_LPF_DONE_MSK    BIT(MMC_ICR_LPF_DONE_POS)

#define MMC_ICR_ADC_DONE_POS    0U
#define MMC_ICR_ADC_DONE_MSK    BIT(MMC_ICR_ADC_DONE_POS)

typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t AN_SWCTRL;
    __IO uint32_t ADC_CTRL0;
    __IO uint32_t ADC_CTRL1;
    __IO uint32_t CMP_CTRL;
    __IO uint32_t LVD_CTRL;
    __I  uint32_t RESERVED0[2] ;
    __IO uint32_t CNT_CTRL;
    __IO uint32_t FQ_CNTA;
    __IO uint32_t FQ_CNTB;
    __IO uint32_t FQ_CNTC;
    __IO uint32_t PKH_MAX;
    __IO uint32_t PKH_MIN;
    __I  uint32_t RESERVED1;
    __IO uint32_t DCEST_VAL;
    __IO uint32_t RMS_VAL;
    __IO uint32_t LPF_VAL;
    __IO uint32_t ADC_VAL;
    __I  uint32_t RESERVED2;
    __O  uint32_t IER;
    __O  uint32_t IDR;
    __I  uint32_t IVS;
    __I  uint32_t RIF;
    __I  uint32_t IFM;
    __O  uint32_t ICR;
} MMC_TypeDef;

#endif
