/**********************************************************************************
 *
 * @file    reg_lcd.h
 * @brief   LCD Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __LCD_H__
#define __LCD_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for LCD_MODE register ************************/

#define LCD_MODE_VSL_POSS   8U
#define LCD_MODE_VSL_POSE   9U
#define LCD_MODE_VSL_MSK    BITS(LCD_MODE_VSL_POSS,LCD_MODE_VSL_POSE)

#define LCD_MODE_CPEN_POS   7U
#define LCD_MODE_CPEN_MSK   BIT(LCD_MODE_CPEN_POS)

#define LCD_MODE_BUFEN_POS  6U
#define LCD_MODE_BUFEN_MSK  BIT(LCD_MODE_BUFEN_POS)

#define LCD_MODE_RSEL_POS   5U
#define LCD_MODE_RSEL_MSK   BIT(LCD_MODE_RSEL_POS)

#define LCD_MODE_TYPE_POS   4U
#define LCD_MODE_TYPE_MSK   BIT(LCD_MODE_TYPE_POS)

#define LCD_MODE_BIAS_POSS  2U
#define LCD_MODE_BIAS_POSE  3U
#define LCD_MODE_BIAS_MSK   BITS(LCD_MODE_BIAS_POSS,LCD_MODE_BIAS_POSE)

#define LCD_MODE_DUTY_POSS  0U
#define LCD_MODE_DUTY_POSE  1U
#define LCD_MODE_DUTY_MSK   BITS(LCD_MODE_DUTY_POSS,LCD_MODE_DUTY_POSE)

/****************** Bit definition for LCD_CTRL register ************************/

#define LCD_CTRL_WSBLINK_POSS   19U
#define LCD_CTRL_WSBLINK_POSE   20U
#define LCD_CTRL_WSBLINK_MSK    BITS(LCD_CTRL_WSBLINK_POSS,LCD_CTRL_WSBLINK_POSE)

#define LCD_CTRL_FCVALUE_POSS   12U
#define LCD_CTRL_FCVALUE_POSE   18U
#define LCD_CTRL_FCVALUE_MSK    BITS(LCD_CTRL_FCVALUE_POSS,LCD_CTRL_FCVALUE_POSE)

#define LCD_CTRL_FCCTRL_POS 11U
#define LCD_CTRL_FCCTRL_MSK BIT(LCD_CTRL_FCCTRL_POS)

#define LCD_CTRL_SWUPDATE_POS   10U
#define LCD_CTRL_SWUPDATE_MSK   BIT(LCD_CTRL_SWUPDATE_POS)

#define LCD_CTRL_UPDCTRL_POSS   8U
#define LCD_CTRL_UPDCTRL_POSE   9U
#define LCD_CTRL_UPDCTRL_MSK    BITS(LCD_CTRL_UPDCTRL_POSS,LCD_CTRL_UPDCTRL_POSE)

#define LCD_CTRL_FRDIV_POSS 1U
#define LCD_CTRL_FRDIV_POSE 7U
#define LCD_CTRL_FRDIV_MSK  BITS(LCD_CTRL_FRDIV_POSS,LCD_CTRL_FRDIV_POSE)

#define LCD_CTRL_LCDEN_POS  0U
#define LCD_CTRL_LCDEN_MSK  BIT(LCD_CTRL_LCDEN_POS)

/****************** Bit definition for LCD_BLINK register ************************/

#define LCD_BLINK_UPDATE_POSS   0U
#define LCD_BLINK_UPDATE_POSE   31U
#define LCD_BLINK_UPDATE_MSK    BITS(LCD_BLINK_UPDATE_POSS,LCD_BLINK_UPDATE_POSE)

/****************** Bit definition for LCD_IER register ************************/

#define LCD_IER_UPDATE_POS  0U
#define LCD_IER_UPDATE_MSK  BIT(LCD_IER_UPDATE_POS)

/****************** Bit definition for LCD_IDR register ************************/

#define LCD_IDR_UPDATE_POS  0U
#define LCD_IDR_UPDATE_MSK  BIT(LCD_IDR_UPDATE_POS)

/****************** Bit definition for LCD_IVS register ************************/

#define LCD_IVS_UPDATE_POS  0U
#define LCD_IVS_UPDATE_MSK  BIT(LCD_IVS_UPDATE_POS)

/****************** Bit definition for LCD_RIF register ************************/

#define LCD_RIF_UPDATE_POS  0U
#define LCD_RIF_UPDATE_MSK  BIT(LCD_RIF_UPDATE_POS)

/****************** Bit definition for LCD_IFM register ************************/

#define LCD_IFM_UPDATE_POS  0U
#define LCD_IFM_UPDATE_MSK  BIT(LCD_IFM_UPDATE_POS)

/****************** Bit definition for LCD_ICR register ************************/

#define LCD_ICR_UPDATE_POS  0U
#define LCD_ICR_UPDATE_MSK  BIT(LCD_ICR_UPDATE_POS)

/****************** Bit definition for LCD_BUSY register ************************/

#define LCD_BUSY_UPDATE_POS 0U
#define LCD_BUSY_UPDATE_MSK BIT(LCD_BUSY_UPDATE_POS)

/****************** Bit definition for LCD_COM0 register ************************/

#define LCD_COM0_COM0_POSS  0U
#define LCD_COM0_COM0_POSE  14U
#define LCD_COM0_COM0_MSK   BITS(LCD_COM0_COM0_POSS,LCD_COM0_COM0_POSE)

/****************** Bit definition for LCD_COM1 register ************************/

#define LCD_COM1_COM1_POSS  0U
#define LCD_COM1_COM1_POSE  14U
#define LCD_COM1_COM1_MSK   BITS(LCD_COM1_COM1_POSS,LCD_COM1_COM1_POSE)

/****************** Bit definition for LCD_COM2 register ************************/

#define LCD_COM2_COM2_POSS  0U
#define LCD_COM2_COM2_POSE  14U
#define LCD_COM2_COM2_MSK   BITS(LCD_COM2_COM2_POSS,LCD_COM2_COM2_POSE)

/****************** Bit definition for LCD_COM3 register ************************/

#define LCD_COM3_COM3_POSS  0U
#define LCD_COM3_COM3_POSE  14U
#define LCD_COM3_COM3_MSK   BITS(LCD_COM3_COM3_POSS,LCD_COM3_COM3_POSE)

/****************** Bit definition for LCD_COMEN register ************************/

#define LCD_COMEN_COM_EN_POSS   0U
#define LCD_COMEN_COM_EN_POSE   3U
#define LCD_COMEN_COM_EN_MSK    BITS(LCD_COMEN_COM_EN_POSS,LCD_COMEN_COM_EN_POSE)

/****************** Bit definition for LCD_SEGEN register ************************/

#define LCD_SEGEN_SEG_EN_POSS   0U
#define LCD_SEGEN_SEG_EN_POSE   14U
#define LCD_SEGEN_SEG_EN_MSK    BITS(LCD_SEGEN_SEG_EN_POSS,LCD_SEGEN_SEG_EN_POSE)

typedef struct
{
    __IO uint32_t MODE;
    __IO uint32_t CTRL;
    __O uint32_t BLINK;
    uint32_t RESERVED0 ;
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __I uint32_t BUSY;
    uint32_t RESERVED1 ;
    __IO uint32_t COM0;
    __IO uint32_t COM1;
    __IO uint32_t COM2;
    __IO uint32_t COM3;
    __IO uint32_t COMEN;
    __IO uint32_t SEGEN;
} LCD_TypeDef;

#endif
