/**********************************************************************************
 *
 * @file    reg_iwdt.h
 * @brief   IWDT Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __IWDT_H__
#define __IWDT_H__

/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for IWDT_KR register ************************/

#define  IWDT_KR_KEY_POSS  0U
#define  IWDT_KR_KEY_POSE  15U
#define  IWDT_KR_KEY_MSK  BITS(IWDT_KR_KEY_POSS,IWDT_KR_KEY_POSE)

/****************** Bit definition for IWDT_PR register ************************/

#define  IWDT_PR_PR_POSS  0U
#define  IWDT_PR_PR_POSE  2U
#define  IWDT_PR_PR_MSK  BITS(IWDT_PR_PR_POSS,IWDT_PR_PR_POSE)

/****************** Bit definition for IWDT_RLR register ************************/

#define  IWDT_RLR_RL_POSS  0U
#define  IWDT_RLR_RL_POSE  11U
#define  IWDT_RLR_RL_MSK  BITS(IWDT_RLR_RL_POSS,IWDT_RLR_RL_POSE)

/****************** Bit definition for IWDT_FR register ************************/

#define  IWDT_FR_BUSY_POS  15U
#define  IWDT_FR_BUSY_MSK  BIT(IWDT_FR_BUSY_POS)

/****************** Bit definition for IWDT_WINR register ************************/

#define IWDT_WINR_WIN_POSS  0U
#define IWDT_WINR_WIN_POSE  11U
#define IWDT_WINR_WIN_MSK   BITS(IWDT_WINR_WIN_POSS,IWDT_WINR_WIN_POSE)

/****************** Bit definition for IWDT_SR register ************************/

#define IWDT_SR_CNT_POSS  0U
#define IWDT_SR_CNT_POSE  11U
#define IWDT_SR_CNT_MSK   BITS(IWDT_SR_CNT_POSS,IWDT_SR_CNT_POSE)

typedef struct
{
    __IO uint32_t RESERVED0[32];            // 0x000-0x07c    
    __O  uint32_t KR;
    __IO uint32_t PR;
    __IO uint32_t RLR;
    __I  uint32_t FR;
    __IO uint32_t WINR;
    __I  uint32_t SR;
} IWDT_TypeDef;

#endif
