/**********************************************************************************
 *
 * @file    reg_hdiv.h
 * @brief   HDIV Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __HDIV_H__
#define __HDIV_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for HDIV_DIVDR register ************************/

#define HDIV_DIVDR_DIVD_POSS    0U
#define HDIV_DIVDR_DIVD_POSE    31U
#define  HDIV_DIVDR_DIVD_MSK  BITS(HDIV_DIVDR_DIVD_POSS,HDIV_DIVDR_DIVD_POSE)

/****************** Bit definition for HDIV_DIVSR register ************************/

#define  HDIV_DIVSR_DIVS_POSS  0U
#define  HDIV_DIVSR_DIVS_POSE  31U
#define  HDIV_DIVSR_DIVS_MSK  BITS(HDIV_DIVSR_DIVS_POSS,HDIV_DIVSR_DIVS_POSE)

/****************** Bit definition for HDIV_DIVQR register ************************/

#define  HDIV_DIVQR_DIVQ_POSS  0U
#define  HDIV_DIVQR_DIVQ_POSE  31U
#define  HDIV_DIVQR_DIVQ_MSK  BITS(HDIV_DIVQR_DIVQ_POSS,HDIV_DIVQR_DIVQ_POSE)

/****************** Bit definition for HDIV_DIVRR register ************************/

#define  HDIV_DIVRR_DIVR_POSS  0U
#define  HDIV_DIVRR_DIVR_POSE  31U
#define  HDIV_DIVRR_DIVR_MSK  BITS(HDIV_DIVRR_DIVR_POSS,HDIV_DIVRR_DIVR_POSE)

/****************** Bit definition for HDIV_DIVSTAT register ************************/

#define  HDIV_DIVSTAT_SIGN_POS  2U
#define  HDIV_DIVSTAT_SIGN_MSK  BIT(HDIV_DIVSTAT_SIGN_POS)

#define  HDIV_DIVSTAT_DIV0_POS  1U
#define  HDIV_DIVSTAT_DIV0_MSK  BIT(HDIV_DIVSTAT_DIV0_POS)

#define  HDIV_DIVSTAT_BUSY_POS  0U
#define  HDIV_DIVSTAT_BUSY_MSK  BIT(HDIV_DIVSTAT_BUSY_POS)

typedef struct
{
    __IO uint32_t DIVDR;
    __IO uint32_t DIVSR;
    __I  uint32_t DIVQR;
    __I  uint32_t DIVRR;
    __IO uint32_t DIVSTAT;
} HDIV_TypeDef;

#endif
