/**********************************************************************************
 *
 * @file    reg_fc.h
 * @brief   FC Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __FC_H__
#define __FC_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for FC_CMD register ************************/

#define  FC_CMD_FC_CMD_POSS  0U
#define  FC_CMD_FC_CMD_POSE  7U
#define  FC_CMD_FC_CMD_MSK  BITS(FC_CMD_FC_CMD_POSS,FC_CMD_FC_CMD_POSE)

/****************** Bit definition for FC_PA register ************************/

#define  FC_PA_PCNT_POSS  25U
#define  FC_PA_PCNT_POSE  31U
#define  FC_PA_PCNT_MSK  BITS(FC_PA_PCNT_POSS,FC_PA_PCNT_POSE)

#define  FC_PA_IFREN_POS  24U
#define  FC_PA_IFREN_MSK  BIT(FC_PA_IFREN_POS)

#define  FC_PA_PROG_ADDR_POSS  0U
#define  FC_PA_PROG_ADDR_POSE  23U
#define  FC_PA_PROG_ADDR_MSK  BITS(FC_PA_PROG_ADDR_POSS,FC_PA_PROG_ADDR_POSE)

/****************** Bit definition for FC_PLD register ************************/

#define  FC_PLD_PROG_DATA_L_POSS  0U
#define  FC_PLD_PROG_DATA_L_POSE  31U
#define  FC_PLD_PROG_DATA_L_MSK  BITS(FC_PLD_PROG_DATA_L_POSS,FC_PLD_PROG_DATA_L_POSE)

/****************** Bit definition for FC_CON register ************************/

#define FC_CON_OPRLD_POSS   4U
#define FC_CON_OPRLD_POSE   7U
#define FC_CON_OPRLD_MSK    BITS(FC_CON_OPRLD_POSS,FC_CON_OPRLD_POSE)

#define FC_CON_WAIT_POSS    0U
#define FC_CON_WAIT_POSE    1U
#define FC_CON_WAIT_MSK BITS(FC_CON_WAIT_POSS,FC_CON_WAIT_POSE)

/****************** Bit definition for FC_STAT register ************************/

#define FC_STAT_FCUNLOCK_POS    5U
#define FC_STAT_FCUNLOCK_MSK    BIT(FC_STAT_FCUNLOCK_POS)

#define FC_STAT_FCBUSY_POS  4U
#define FC_STAT_FCBUSY_MSK  BIT(FC_STAT_FCBUSY_POS)

#define FC_STAT_WPDIS_POS   3U
#define FC_STAT_WPDIS_MSK   BIT(FC_STAT_WPDIS_POS)

#define FC_STAT_RPLV_POSS   1U
#define FC_STAT_RPLV_POSE   2U
#define FC_STAT_RPLV_MSK    BITS(FC_STAT_RPLV_POSS,FC_STAT_RPLV_POSE)

#define FC_STAT_UCRPDIS_POS 0U
#define FC_STAT_UCRPDIS_MSK BIT(FC_STAT_UCRPDIS_POS)

/****************** Bit definition for FC_UPL register ************************/

#define  FC_UPL_UPL_POSS  0U
#define  FC_UPL_UPL_POSE  31U
#define  FC_UPL_UPL_MSK  BITS(FC_UPL_UPL_POSS,FC_UPL_UPL_POSE)

/****************** Bit definition for FC_UPH register ************************/

#define  FC_UPH_UPH_POSS  0U
#define  FC_UPH_UPH_POSE  31U
#define  FC_UPH_UPH_MSK  BITS(FC_UPH_UPH_POSS,FC_UPH_UPH_POSE)

/****************** Bit definition for FC_UL register ************************/

#define FC_UL_UL_POSS   0U
#define FC_UL_UL_POSE   31U
#define FC_UL_UL_MSK    BITS(FC_UL_UL_POSS,FC_UL_UL_POSE)

/****************** Bit definition for FC_UCRPL register ************************/

#define FC_UCRPL_UCRPL_POSS 0U
#define FC_UCRPL_UCRPL_POSE 31U
#define FC_UCRPL_UCRPL_MSK  BITS(FC_UCRPL_UCRPL_POSS,FC_UCRPL_UCRPL_POSE)

/****************** Bit definition for FC_UCRPH register ************************/

#define FC_UCRPH_UCRPH_POSS 0U
#define FC_UCRPH_UCRPH_POSE 31U
#define FC_UCRPH_UCRPH_MSK  BITS(FC_UCRPH_UCRPH_POSS,FC_UCRPH_UCRPH_POSE)

/****************** Bit definition for FC_RP register ************************/

#define FC_RP_RP_POSS   0U
#define FC_RP_RP_POSE   31U
#define FC_RP_RP_MSK    BITS(FC_RP_RP_POSS,FC_RP_RP_POSE)

/****************** Bit definition for FC_WPL register ************************/

#define FC_WPL_WPL_POSS 0U
#define FC_WPL_WPL_POSE 31U
#define FC_WPL_WPL_MSK  BITS(FC_WPL_WPL_POSS,FC_WPL_WPL_POSE)

/****************** Bit definition for FC_WPH register ************************/

#define FC_WPH_WPH_POSS 0U
#define FC_WPH_WPH_POSE 31U
#define FC_WPH_WPH_MSK  BITS(FC_WPH_WPH_POSS,FC_WPH_WPH_POSE)

/****************** Bit definition for FC_REMAP register ************************/

#define FC_REMAP_HREMAP_POSS    16U
#define FC_REMAP_HREMAP_POSE    23U
#define FC_REMAP_HREMAP_MSK BITS(FC_REMAP_HREMAP_POSS,FC_REMAP_HREMAP_POSE)

#define FC_REMAP_SREMAP_POSS    8U
#define FC_REMAP_SREMAP_POSE    15U
#define FC_REMAP_SREMAP_MSK BITS(FC_REMAP_SREMAP_POSS,FC_REMAP_SREMAP_POSE)

#define FC_REMAP_SEFBASE_POSS   0U
#define FC_REMAP_SEFBASE_POSE   7U
#define FC_REMAP_SEFBASE_MSK    BITS(FC_REMAP_SEFBASE_POSS,FC_REMAP_SEFBASE_POSE)

typedef struct
{
    __IO uint32_t CMD;
    __IO uint32_t PA;
    __IO uint32_t PLD;
    uint32_t RESERVED0 ;
    __IO uint32_t CON;
    __I uint32_t STAT;
    uint32_t RESERVED1[2] ;
    __IO uint32_t UPL;
    __IO uint32_t UPH;
    __IO uint32_t UL;
    uint32_t RESERVED2[5] ;
    __I uint32_t UCRPL;
    __I uint32_t UCRPH;
    __I uint32_t RP;
    __I uint32_t WPL;
    __I uint32_t WPH;
    __I uint32_t REMAP;
} FC_TypeDef;

#endif
