/**********************************************************************************
 *
 * @file    reg_exti.h
 * @brief   EXTI Head File
 *
 * @date    19 Sep 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          19 Sep 2022     AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __EXTI_H__
#define __EXTI_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for EXTI_IER register ************************/
#define EXTI_IER_IE21_POS   21U
#define EXTI_IER_IE21_MSK   BIT(EXTI_IER_IE21_POS)

#define EXTI_IER_IE20_POS   20U
#define EXTI_IER_IE20_MSK   BIT(EXTI_IER_IE20_POS)

#define EXTI_IER_IE19_POS   19U
#define EXTI_IER_IE19_MSK   BIT(EXTI_IER_IE19_POS)

#define EXTI_IER_IE18_POS   18U
#define EXTI_IER_IE18_MSK   BIT(EXTI_IER_IE18_POS)

#define EXTI_IER_IE17_POS   17U
#define EXTI_IER_IE17_MSK   BIT(EXTI_IER_IE17_POS)

#define EXTI_IER_IE16_POS   16U
#define EXTI_IER_IE16_MSK   BIT(EXTI_IER_IE16_POS)

#define EXTI_IER_IE15_POS   15U
#define EXTI_IER_IE15_MSK   BIT(EXTI_IER_IE15_POS)

#define EXTI_IER_IE14_POS   14U
#define EXTI_IER_IE14_MSK   BIT(EXTI_IER_IE14_POS)

#define EXTI_IER_IE13_POS   13U
#define EXTI_IER_IE13_MSK   BIT(EXTI_IER_IE13_POS)

#define EXTI_IER_IE12_POS   12U
#define EXTI_IER_IE12_MSK   BIT(EXTI_IER_IE12_POS)

#define EXTI_IER_IE11_POS   11U
#define EXTI_IER_IE11_MSK   BIT(EXTI_IER_IE11_POS)

#define EXTI_IER_IE10_POS   10U
#define EXTI_IER_IE10_MSK   BIT(EXTI_IER_IE10_POS)

#define EXTI_IER_IE9_POS    9U
#define EXTI_IER_IE9_MSK    BIT(EXTI_IER_IE9_POS)

#define EXTI_IER_IE8_POS    8U
#define EXTI_IER_IE8_MSK    BIT(EXTI_IER_IE8_POS)

#define EXTI_IER_IE7_POS    7U
#define EXTI_IER_IE7_MSK    BIT(EXTI_IER_IE7_POS)

#define EXTI_IER_IE6_POS    6U
#define EXTI_IER_IE6_MSK    BIT(EXTI_IER_IE6_POS)

#define EXTI_IER_IE5_POS    5U
#define EXTI_IER_IE5_MSK    BIT(EXTI_IER_IE5_POS)

#define EXTI_IER_IE4_POS    4U
#define EXTI_IER_IE4_MSK    BIT(EXTI_IER_IE4_POS)

#define EXTI_IER_IE3_POS    3U
#define EXTI_IER_IE3_MSK    BIT(EXTI_IER_IE3_POS)

#define EXTI_IER_IE2_POS    2U
#define EXTI_IER_IE2_MSK    BIT(EXTI_IER_IE2_POS)

#define EXTI_IER_IE1_POS    1U
#define EXTI_IER_IE1_MSK    BIT(EXTI_IER_IE1_POS)

#define EXTI_IER_IE0_POS    0U
#define EXTI_IER_IE0_MSK    BIT(EXTI_IER_IE0_POS)

/****************** Bit definition for EXTI_IDR register ************************/

#define EXTI_IDR_ID21_POS   21U
#define EXTI_IDR_ID21_MSK   BIT(EXTI_IDR_ID21_POS)

#define EXTI_IDR_ID20_POS   20U
#define EXTI_IDR_ID20_MSK   BIT(EXTI_IDR_ID20_POS)

#define EXTI_IDR_ID19_POS   19U
#define EXTI_IDR_ID19_MSK   BIT(EXTI_IDR_ID19_POS)

#define EXTI_IDR_ID18_POS   18U
#define EXTI_IDR_ID18_MSK   BIT(EXTI_IDR_ID18_POS)

#define EXTI_IDR_ID17_POS   17U
#define EXTI_IDR_ID17_MSK   BIT(EXTI_IDR_ID17_POS)

#define EXTI_IDR_ID16_POS   16U
#define EXTI_IDR_ID16_MSK   BIT(EXTI_IDR_ID16_POS)

#define EXTI_IDR_ID15_POS   15U
#define EXTI_IDR_ID15_MSK   BIT(EXTI_IDR_ID15_POS)

#define EXTI_IDR_ID14_POS   14U
#define EXTI_IDR_ID14_MSK   BIT(EXTI_IDR_ID14_POS)

#define EXTI_IDR_ID13_POS   13U
#define EXTI_IDR_ID13_MSK   BIT(EXTI_IDR_ID13_POS)

#define EXTI_IDR_ID12_POS   12U
#define EXTI_IDR_ID12_MSK   BIT(EXTI_IDR_ID12_POS)

#define EXTI_IDR_ID11_POS   11U
#define EXTI_IDR_ID11_MSK   BIT(EXTI_IDR_ID11_POS)

#define EXTI_IDR_ID10_POS   10U
#define EXTI_IDR_ID10_MSK   BIT(EXTI_IDR_ID10_POS)

#define EXTI_IDR_ID9_POS    9U
#define EXTI_IDR_ID9_MSK    BIT(EXTI_IDR_ID9_POS)

#define EXTI_IDR_ID8_POS    8U
#define EXTI_IDR_ID8_MSK    BIT(EXTI_IDR_ID8_POS)

#define EXTI_IDR_ID7_POS    7U
#define EXTI_IDR_ID7_MSK    BIT(EXTI_IDR_ID7_POS)

#define EXTI_IDR_ID6_POS    6U
#define EXTI_IDR_ID6_MSK    BIT(EXTI_IDR_ID6_POS)

#define EXTI_IDR_ID5_POS    5U
#define EXTI_IDR_ID5_MSK    BIT(EXTI_IDR_ID5_POS)

#define EXTI_IDR_ID4_POS    4U
#define EXTI_IDR_ID4_MSK    BIT(EXTI_IDR_ID4_POS)

#define EXTI_IDR_ID3_POS    3U
#define EXTI_IDR_ID3_MSK    BIT(EXTI_IDR_ID3_POS)

#define EXTI_IDR_ID2_POS    2U
#define EXTI_IDR_ID2_MSK    BIT(EXTI_IDR_ID2_POS)

#define EXTI_IDR_ID1_POS    1U
#define EXTI_IDR_ID1_MSK    BIT(EXTI_IDR_ID1_POS)

#define EXTI_IDR_ID0_POS    0U
#define EXTI_IDR_ID0_MSK    BIT(EXTI_IDR_ID0_POS)

/****************** Bit definition for EXTI_IVS register ************************/

#define EXTI_IVS_IV21_POS   21U
#define EXTI_IVS_IV21_MSK   BIT(EXTI_IVS_IV21_POS)

#define EXTI_IVS_IV20_POS   20U
#define EXTI_IVS_IV20_MSK   BIT(EXTI_IVS_IV20_POS)

#define EXTI_IVS_IV19_POS   19U
#define EXTI_IVS_IV19_MSK   BIT(EXTI_IVS_IV19_POS)

#define EXTI_IVS_IV18_POS   18U
#define EXTI_IVS_IV18_MSK   BIT(EXTI_IVS_IV18_POS)

#define EXTI_IVS_IV17_POS   17U
#define EXTI_IVS_IV17_MSK   BIT(EXTI_IVS_IV17_POS)

#define EXTI_IVS_IV16_POS   16U
#define EXTI_IVS_IV16_MSK   BIT(EXTI_IVS_IV16_POS)

#define EXTI_IVS_IV15_POS   15U
#define EXTI_IVS_IV15_MSK   BIT(EXTI_IVS_IV15_POS)

#define EXTI_IVS_IV14_POS   14U
#define EXTI_IVS_IV14_MSK   BIT(EXTI_IVS_IV14_POS)

#define EXTI_IVS_IV13_POS   13U
#define EXTI_IVS_IV13_MSK   BIT(EXTI_IVS_IV13_POS)

#define EXTI_IVS_IV12_POS   12U
#define EXTI_IVS_IV12_MSK   BIT(EXTI_IVS_IV12_POS)

#define EXTI_IVS_IV11_POS   11U
#define EXTI_IVS_IV11_MSK   BIT(EXTI_IVS_IV11_POS)

#define EXTI_IVS_IV10_POS   10U
#define EXTI_IVS_IV10_MSK   BIT(EXTI_IVS_IV10_POS)

#define EXTI_IVS_IV9_POS    9U
#define EXTI_IVS_IV9_MSK    BIT(EXTI_IVS_IV9_POS)

#define EXTI_IVS_IV8_POS    8U
#define EXTI_IVS_IV8_MSK    BIT(EXTI_IVS_IV8_POS)

#define EXTI_IVS_IV7_POS    7U
#define EXTI_IVS_IV7_MSK    BIT(EXTI_IVS_IV7_POS)

#define EXTI_IVS_IV6_POS    6U
#define EXTI_IVS_IV6_MSK    BIT(EXTI_IVS_IV6_POS)

#define EXTI_IVS_IV5_POS    5U
#define EXTI_IVS_IV5_MSK    BIT(EXTI_IVS_IV5_POS)

#define EXTI_IVS_IV4_POS    4U
#define EXTI_IVS_IV4_MSK    BIT(EXTI_IVS_IV4_POS)

#define EXTI_IVS_IV3_POS    3U
#define EXTI_IVS_IV3_MSK    BIT(EXTI_IVS_IV3_POS)

#define EXTI_IVS_IV2_POS    2U
#define EXTI_IVS_IV2_MSK    BIT(EXTI_IVS_IV2_POS)

#define EXTI_IVS_IV1_POS    1U
#define EXTI_IVS_IV1_MSK    BIT(EXTI_IVS_IV1_POS)

#define EXTI_IVS_IV0_POS    0U
#define EXTI_IVS_IV0_MSK    BIT(EXTI_IVS_IV0_POS)

/****************** Bit definition for EXTI_RIF register ************************/

#define EXTI_RIF_IF21_POS   21U
#define EXTI_RIF_IF21_MSK   BIT(EXTI_RIF_IF21_POS)

#define EXTI_RIF_IF20_POS   20U
#define EXTI_RIF_IF20_MSK   BIT(EXTI_RIF_IF20_POS)

#define EXTI_RIF_IF19_POS   19U
#define EXTI_RIF_IF19_MSK   BIT(EXTI_RIF_IF19_POS)

#define EXTI_RIF_IF18_POS   18U
#define EXTI_RIF_IF18_MSK   BIT(EXTI_RIF_IF18_POS)

#define EXTI_RIF_IF17_POS   17U
#define EXTI_RIF_IF17_MSK   BIT(EXTI_RIF_IF17_POS)

#define EXTI_RIF_IF16_POS   16U
#define EXTI_RIF_IF16_MSK   BIT(EXTI_RIF_IF16_POS)

#define EXTI_RIF_IF15_POS   15U
#define EXTI_RIF_IF15_MSK   BIT(EXTI_RIF_IF15_POS)

#define EXTI_RIF_IF14_POS   14U
#define EXTI_RIF_IF14_MSK   BIT(EXTI_RIF_IF14_POS)

#define EXTI_RIF_IF13_POS   13U
#define EXTI_RIF_IF13_MSK   BIT(EXTI_RIF_IF13_POS)

#define EXTI_RIF_IF12_POS   12U
#define EXTI_RIF_IF12_MSK   BIT(EXTI_RIF_IF12_POS)

#define EXTI_RIF_IF11_POS   11U
#define EXTI_RIF_IF11_MSK   BIT(EXTI_RIF_IF11_POS)

#define EXTI_RIF_IF10_POS   10U
#define EXTI_RIF_IF10_MSK   BIT(EXTI_RIF_IF10_POS)

#define EXTI_RIF_IF9_POS    9U
#define EXTI_RIF_IF9_MSK    BIT(EXTI_RIF_IF9_POS)

#define EXTI_RIF_IF8_POS    8U
#define EXTI_RIF_IF8_MSK    BIT(EXTI_RIF_IF8_POS)

#define EXTI_RIF_IF7_POS    7U
#define EXTI_RIF_IF7_MSK    BIT(EXTI_RIF_IF7_POS)

#define EXTI_RIF_IF6_POS    6U
#define EXTI_RIF_IF6_MSK    BIT(EXTI_RIF_IF6_POS)

#define EXTI_RIF_IF5_POS    5U
#define EXTI_RIF_IF5_MSK    BIT(EXTI_RIF_IF5_POS)

#define EXTI_RIF_IF4_POS    4U
#define EXTI_RIF_IF4_MSK    BIT(EXTI_RIF_IF4_POS)

#define EXTI_RIF_IF3_POS    3U
#define EXTI_RIF_IF3_MSK    BIT(EXTI_RIF_IF3_POS)

#define EXTI_RIF_IF2_POS    2U
#define EXTI_RIF_IF2_MSK    BIT(EXTI_RIF_IF2_POS)

#define EXTI_RIF_IF1_POS    1U
#define EXTI_RIF_IF1_MSK    BIT(EXTI_RIF_IF1_POS)

#define EXTI_RIF_IF0_POS    0U
#define EXTI_RIF_IF0_MSK    BIT(EXTI_RIF_IF0_POS)

/****************** Bit definition for EXTI_IFM register ************************/

#define EXTI_IFM_IF21_POS   21U
#define EXTI_IFM_IF21_MSK   BIT(EXTI_IFM_IF21_POS)

#define EXTI_IFM_IF20_POS   20U
#define EXTI_IFM_IF20_MSK   BIT(EXTI_IFM_IF20_POS)

#define EXTI_IFM_IF19_POS   19U
#define EXTI_IFM_IF19_MSK   BIT(EXTI_IFM_IF19_POS)

#define EXTI_IFM_IF18_POS   18U
#define EXTI_IFM_IF18_MSK   BIT(EXTI_IFM_IF18_POS)

#define EXTI_IFM_IF17_POS   17U
#define EXTI_IFM_IF17_MSK   BIT(EXTI_IFM_IF17_POS)

#define EXTI_IFM_IF16_POS   16U
#define EXTI_IFM_IF16_MSK   BIT(EXTI_IFM_IF16_POS)

#define EXTI_IFM_IF15_POS   15U
#define EXTI_IFM_IF15_MSK   BIT(EXTI_IFM_IF15_POS)

#define EXTI_IFM_IF14_POS   14U
#define EXTI_IFM_IF14_MSK   BIT(EXTI_IFM_IF14_POS)

#define EXTI_IFM_IF13_POS   13U
#define EXTI_IFM_IF13_MSK   BIT(EXTI_IFM_IF13_POS)

#define EXTI_IFM_IF12_POS   12U
#define EXTI_IFM_IF12_MSK   BIT(EXTI_IFM_IF12_POS)

#define EXTI_IFM_IF11_POS   11U
#define EXTI_IFM_IF11_MSK   BIT(EXTI_IFM_IF11_POS)

#define EXTI_IFM_IF10_POS   10U
#define EXTI_IFM_IF10_MSK   BIT(EXTI_IFM_IF10_POS)

#define EXTI_IFM_IF9_POS    9U
#define EXTI_IFM_IF9_MSK    BIT(EXTI_IFM_IF9_POS)

#define EXTI_IFM_IF8_POS    8U
#define EXTI_IFM_IF8_MSK    BIT(EXTI_IFM_IF8_POS)

#define EXTI_IFM_IF7_POS    7U
#define EXTI_IFM_IF7_MSK    BIT(EXTI_IFM_IF7_POS)

#define EXTI_IFM_IF6_POS    6U
#define EXTI_IFM_IF6_MSK    BIT(EXTI_IFM_IF6_POS)

#define EXTI_IFM_IF5_POS    5U
#define EXTI_IFM_IF5_MSK    BIT(EXTI_IFM_IF5_POS)

#define EXTI_IFM_IF4_POS    4U
#define EXTI_IFM_IF4_MSK    BIT(EXTI_IFM_IF4_POS)

#define EXTI_IFM_IF3_POS    3U
#define EXTI_IFM_IF3_MSK    BIT(EXTI_IFM_IF3_POS)

#define EXTI_IFM_IF2_POS    2U
#define EXTI_IFM_IF2_MSK    BIT(EXTI_IFM_IF2_POS)

#define EXTI_IFM_IF1_POS    1U
#define EXTI_IFM_IF1_MSK    BIT(EXTI_IFM_IF1_POS)

#define EXTI_IFM_IF0_POS    0U
#define EXTI_IFM_IF0_MSK    BIT(EXTI_IFM_IF0_POS)

/****************** Bit definition for EXTI_ICR register ************************/

#define EXTI_ICR_IC21_POS   21U
#define EXTI_ICR_IC21_MSK   BIT(EXTI_ICR_IC21_POS)

#define EXTI_ICR_IC20_POS   20U
#define EXTI_ICR_IC20_MSK   BIT(EXTI_ICR_IC20_POS)

#define EXTI_ICR_IC19_POS   19U
#define EXTI_ICR_IC19_MSK   BIT(EXTI_ICR_IC19_POS)

#define EXTI_ICR_IC18_POS   18U
#define EXTI_ICR_IC18_MSK   BIT(EXTI_ICR_IC18_POS)

#define EXTI_ICR_IC17_POS   17U
#define EXTI_ICR_IC17_MSK   BIT(EXTI_ICR_IC17_POS)

#define EXTI_ICR_IC16_POS   16U
#define EXTI_ICR_IC16_MSK   BIT(EXTI_ICR_IC16_POS)

#define EXTI_ICR_IC15_POS   15U
#define EXTI_ICR_IC15_MSK   BIT(EXTI_ICR_IC15_POS)

#define EXTI_ICR_IC14_POS   14U
#define EXTI_ICR_IC14_MSK   BIT(EXTI_ICR_IC14_POS)

#define EXTI_ICR_IC13_POS   13U
#define EXTI_ICR_IC13_MSK   BIT(EXTI_ICR_IC13_POS)

#define EXTI_ICR_IC12_POS   12U
#define EXTI_ICR_IC12_MSK   BIT(EXTI_ICR_IC12_POS)

#define EXTI_ICR_IC11_POS   11U
#define EXTI_ICR_IC11_MSK   BIT(EXTI_ICR_IC11_POS)

#define EXTI_ICR_IC10_POS   10U
#define EXTI_ICR_IC10_MSK   BIT(EXTI_ICR_IC10_POS)

#define EXTI_ICR_IC9_POS    9U
#define EXTI_ICR_IC9_MSK    BIT(EXTI_ICR_IC9_POS)

#define EXTI_ICR_IC8_POS    8U
#define EXTI_ICR_IC8_MSK    BIT(EXTI_ICR_IC8_POS)

#define EXTI_ICR_IC7_POS    7U
#define EXTI_ICR_IC7_MSK    BIT(EXTI_ICR_IC7_POS)

#define EXTI_ICR_IC6_POS    6U
#define EXTI_ICR_IC6_MSK    BIT(EXTI_ICR_IC6_POS)

#define EXTI_ICR_IC5_POS    5U
#define EXTI_ICR_IC5_MSK    BIT(EXTI_ICR_IC5_POS)

#define EXTI_ICR_IC4_POS    4U
#define EXTI_ICR_IC4_MSK    BIT(EXTI_ICR_IC4_POS)

#define EXTI_ICR_IC3_POS    3U
#define EXTI_ICR_IC3_MSK    BIT(EXTI_ICR_IC3_POS)

#define EXTI_ICR_IC2_POS    2U
#define EXTI_ICR_IC2_MSK    BIT(EXTI_ICR_IC2_POS)

#define EXTI_ICR_IC1_POS    1U
#define EXTI_ICR_IC1_MSK    BIT(EXTI_ICR_IC1_POS)

#define EXTI_ICR_IC0_POS    0U
#define EXTI_ICR_IC0_MSK    BIT(EXTI_ICR_IC0_POS)

/****************** Bit definition for EXTI_RTS register ************************/

#define EXTI_RTS_RTS21_POS  21U
#define EXTI_RTS_RTS21_MSK  BIT(EXTI_RTS_RTS21_POS)

#define EXTI_RTS_RTS20_POS  20U
#define EXTI_RTS_RTS20_MSK  BIT(EXTI_RTS_RTS20_POS)

#define EXTI_RTS_RTS19_POS  19U
#define EXTI_RTS_RTS19_MSK  BIT(EXTI_RTS_RTS19_POS)

#define EXTI_RTS_RTS18_POS  18U
#define EXTI_RTS_RTS18_MSK  BIT(EXTI_RTS_RTS18_POS)

#define EXTI_RTS_RTS17_POS  17U
#define EXTI_RTS_RTS17_MSK  BIT(EXTI_RTS_RTS17_POS)

#define EXTI_RTS_RTS16_POS  16U
#define EXTI_RTS_RTS16_MSK  BIT(EXTI_RTS_RTS16_POS)

#define EXTI_RTS_RTS15_POS  15U
#define EXTI_RTS_RTS15_MSK  BIT(EXTI_RTS_RTS15_POS)

#define EXTI_RTS_RTS14_POS  14U
#define EXTI_RTS_RTS14_MSK  BIT(EXTI_RTS_RTS14_POS)

#define EXTI_RTS_RTS13_POS  13U
#define EXTI_RTS_RTS13_MSK  BIT(EXTI_RTS_RTS13_POS)

#define EXTI_RTS_RTS12_POS  12U
#define EXTI_RTS_RTS12_MSK  BIT(EXTI_RTS_RTS12_POS)

#define EXTI_RTS_RTS11_POS  11U
#define EXTI_RTS_RTS11_MSK  BIT(EXTI_RTS_RTS11_POS)

#define EXTI_RTS_RTS10_POS  10U
#define EXTI_RTS_RTS10_MSK  BIT(EXTI_RTS_RTS10_POS)

#define EXTI_RTS_RTS9_POS   9U
#define EXTI_RTS_RTS9_MSK   BIT(EXTI_RTS_RTS9_POS)

#define EXTI_RTS_RTS8_POS   8U
#define EXTI_RTS_RTS8_MSK   BIT(EXTI_RTS_RTS8_POS)

#define EXTI_RTS_RTS7_POS   7U
#define EXTI_RTS_RTS7_MSK   BIT(EXTI_RTS_RTS7_POS)

#define EXTI_RTS_RTS6_POS   6U
#define EXTI_RTS_RTS6_MSK   BIT(EXTI_RTS_RTS6_POS)

#define EXTI_RTS_RTS5_POS   5U
#define EXTI_RTS_RTS5_MSK   BIT(EXTI_RTS_RTS5_POS)

#define EXTI_RTS_RTS4_POS   4U
#define EXTI_RTS_RTS4_MSK   BIT(EXTI_RTS_RTS4_POS)

#define EXTI_RTS_RTS3_POS   3U
#define EXTI_RTS_RTS3_MSK   BIT(EXTI_RTS_RTS3_POS)

#define EXTI_RTS_RTS2_POS   2U
#define EXTI_RTS_RTS2_MSK   BIT(EXTI_RTS_RTS2_POS)

#define EXTI_RTS_RTS1_POS   1U
#define EXTI_RTS_RTS1_MSK   BIT(EXTI_RTS_RTS1_POS)

#define EXTI_RTS_RTS0_POS   0U
#define EXTI_RTS_RTS0_MSK   BIT(EXTI_RTS_RTS0_POS)

/****************** Bit definition for EXTI_FTS register ************************/

#define EXTI_FTS_FTS21_POS  21U
#define EXTI_FTS_FTS21_MSK  BIT(EXTI_FTS_FTS21_POS)

#define EXTI_FTS_FTS20_POS  20U
#define EXTI_FTS_FTS20_MSK  BIT(EXTI_FTS_FTS20_POS)

#define EXTI_FTS_FTS19_POS  19U
#define EXTI_FTS_FTS19_MSK  BIT(EXTI_FTS_FTS19_POS)

#define EXTI_FTS_FTS18_POS  18U
#define EXTI_FTS_FTS18_MSK  BIT(EXTI_FTS_FTS18_POS)

#define EXTI_FTS_FTS17_POS  17U
#define EXTI_FTS_FTS17_MSK  BIT(EXTI_FTS_FTS17_POS)

#define EXTI_FTS_FTS16_POS  16U
#define EXTI_FTS_FTS16_MSK  BIT(EXTI_FTS_FTS16_POS)

#define EXTI_FTS_FTS15_POS  15U
#define EXTI_FTS_FTS15_MSK  BIT(EXTI_FTS_FTS15_POS)

#define EXTI_FTS_FTS14_POS  14U
#define EXTI_FTS_FTS14_MSK  BIT(EXTI_FTS_FTS14_POS)

#define EXTI_FTS_FTS13_POS  13U
#define EXTI_FTS_FTS13_MSK  BIT(EXTI_FTS_FTS13_POS)

#define EXTI_FTS_FTS12_POS  12U
#define EXTI_FTS_FTS12_MSK  BIT(EXTI_FTS_FTS12_POS)

#define EXTI_FTS_FTS11_POS  11U
#define EXTI_FTS_FTS11_MSK  BIT(EXTI_FTS_FTS11_POS)

#define EXTI_FTS_FTS10_POS  10U
#define EXTI_FTS_FTS10_MSK  BIT(EXTI_FTS_FTS10_POS)

#define EXTI_FTS_FTS9_POS   9U
#define EXTI_FTS_FTS9_MSK   BIT(EXTI_FTS_FTS9_POS)

#define EXTI_FTS_FTS8_POS   8U
#define EXTI_FTS_FTS8_MSK   BIT(EXTI_FTS_FTS8_POS)

#define EXTI_FTS_FTS7_POS   7U
#define EXTI_FTS_FTS7_MSK   BIT(EXTI_FTS_FTS7_POS)

#define EXTI_FTS_FTS6_POS   6U
#define EXTI_FTS_FTS6_MSK   BIT(EXTI_FTS_FTS6_POS)

#define EXTI_FTS_FTS5_POS   5U
#define EXTI_FTS_FTS5_MSK   BIT(EXTI_FTS_FTS5_POS)

#define EXTI_FTS_FTS4_POS   4U
#define EXTI_FTS_FTS4_MSK   BIT(EXTI_FTS_FTS4_POS)

#define EXTI_FTS_FTS3_POS   3U
#define EXTI_FTS_FTS3_MSK   BIT(EXTI_FTS_FTS3_POS)

#define EXTI_FTS_FTS2_POS   2U
#define EXTI_FTS_FTS2_MSK   BIT(EXTI_FTS_FTS2_POS)

#define EXTI_FTS_FTS1_POS   1U
#define EXTI_FTS_FTS1_MSK   BIT(EXTI_FTS_FTS1_POS)

#define EXTI_FTS_FTS0_POS   0U
#define EXTI_FTS_FTS0_MSK   BIT(EXTI_FTS_FTS0_POS)

/****************** Bit definition for EXTI_SWI register ************************/

#define EXTI_SWI_SWI21_POS  21U
#define EXTI_SWI_SWI21_MSK  BIT(EXTI_SWI_SWI21_POS)

#define EXTI_SWI_SWI20_POS  20U
#define EXTI_SWI_SWI20_MSK  BIT(EXTI_SWI_SWI20_POS)

#define EXTI_SWI_SWI19_POS  19U
#define EXTI_SWI_SWI19_MSK  BIT(EXTI_SWI_SWI19_POS)

#define EXTI_SWI_SWI18_POS  18U
#define EXTI_SWI_SWI18_MSK  BIT(EXTI_SWI_SWI18_POS)

#define EXTI_SWI_SWI17_POS  17U
#define EXTI_SWI_SWI17_MSK  BIT(EXTI_SWI_SWI17_POS)

#define EXTI_SWI_SWI16_POS  16U
#define EXTI_SWI_SWI16_MSK  BIT(EXTI_SWI_SWI16_POS)

#define EXTI_SWI_SWI15_POS  15U
#define EXTI_SWI_SWI15_MSK  BIT(EXTI_SWI_SWI15_POS)

#define EXTI_SWI_SWI14_POS  14U
#define EXTI_SWI_SWI14_MSK  BIT(EXTI_SWI_SWI14_POS)

#define EXTI_SWI_SWI13_POS  13U
#define EXTI_SWI_SWI13_MSK  BIT(EXTI_SWI_SWI13_POS)

#define EXTI_SWI_SWI12_POS  12U
#define EXTI_SWI_SWI12_MSK  BIT(EXTI_SWI_SWI12_POS)

#define EXTI_SWI_SWI11_POS  11U
#define EXTI_SWI_SWI11_MSK  BIT(EXTI_SWI_SWI11_POS)

#define EXTI_SWI_SWI10_POS  10U
#define EXTI_SWI_SWI10_MSK  BIT(EXTI_SWI_SWI10_POS)

#define EXTI_SWI_SWI9_POS   9U
#define EXTI_SWI_SWI9_MSK   BIT(EXTI_SWI_SWI9_POS)

#define EXTI_SWI_SWI8_POS   8U
#define EXTI_SWI_SWI8_MSK   BIT(EXTI_SWI_SWI8_POS)

#define EXTI_SWI_SWI7_POS   7U
#define EXTI_SWI_SWI7_MSK   BIT(EXTI_SWI_SWI7_POS)

#define EXTI_SWI_SWI6_POS   6U
#define EXTI_SWI_SWI6_MSK   BIT(EXTI_SWI_SWI6_POS)

#define EXTI_SWI_SWI5_POS   5U
#define EXTI_SWI_SWI5_MSK   BIT(EXTI_SWI_SWI5_POS)

#define EXTI_SWI_SWI4_POS   4U
#define EXTI_SWI_SWI4_MSK   BIT(EXTI_SWI_SWI4_POS)

#define EXTI_SWI_SWI3_POS   3U
#define EXTI_SWI_SWI3_MSK   BIT(EXTI_SWI_SWI3_POS)

#define EXTI_SWI_SWI2_POS   2U
#define EXTI_SWI_SWI2_MSK   BIT(EXTI_SWI_SWI2_POS)

#define EXTI_SWI_SWI1_POS   1U
#define EXTI_SWI_SWI1_MSK   BIT(EXTI_SWI_SWI1_POS)

#define EXTI_SWI_SWI0_POS   0U
#define EXTI_SWI_SWI0_MSK   BIT(EXTI_SWI_SWI0_POS)

/****************** Bit definition for EXTI_ADTE register ************************/

#define EXTI_ADTE_ADTE21_POS    21U
#define EXTI_ADTE_ADTE21_MSK    BIT(EXTI_ADTE_ADTE21_POS)

#define EXTI_ADTE_ADTE20_POS    20U
#define EXTI_ADTE_ADTE20_MSK    BIT(EXTI_ADTE_ADTE20_POS)

#define EXTI_ADTE_ADTE19_POS    19U
#define EXTI_ADTE_ADTE19_MSK    BIT(EXTI_ADTE_ADTE19_POS)

#define EXTI_ADTE_ADTE18_POS    18U
#define EXTI_ADTE_ADTE18_MSK    BIT(EXTI_ADTE_ADTE18_POS)

#define EXTI_ADTE_ADTE17_POS    17U
#define EXTI_ADTE_ADTE17_MSK    BIT(EXTI_ADTE_ADTE17_POS)

#define EXTI_ADTE_ADTE16_POS    16U
#define EXTI_ADTE_ADTE16_MSK    BIT(EXTI_ADTE_ADTE16_POS)

#define EXTI_ADTE_ADTE15_POS    15U
#define EXTI_ADTE_ADTE15_MSK    BIT(EXTI_ADTE_ADTE15_POS)

#define EXTI_ADTE_ADTE14_POS    14U
#define EXTI_ADTE_ADTE14_MSK    BIT(EXTI_ADTE_ADTE14_POS)

#define EXTI_ADTE_ADTE13_POS    13U
#define EXTI_ADTE_ADTE13_MSK    BIT(EXTI_ADTE_ADTE13_POS)

#define EXTI_ADTE_ADTE12_POS    12U
#define EXTI_ADTE_ADTE12_MSK    BIT(EXTI_ADTE_ADTE12_POS)

#define EXTI_ADTE_ADTE11_POS    11U
#define EXTI_ADTE_ADTE11_MSK    BIT(EXTI_ADTE_ADTE11_POS)

#define EXTI_ADTE_ADTE10_POS    10U
#define EXTI_ADTE_ADTE10_MSK    BIT(EXTI_ADTE_ADTE10_POS)

#define EXTI_ADTE_ADTE9_POS 9U
#define EXTI_ADTE_ADTE9_MSK BIT(EXTI_ADTE_ADTE9_POS)

#define EXTI_ADTE_ADTE8_POS 8U
#define EXTI_ADTE_ADTE8_MSK BIT(EXTI_ADTE_ADTE8_POS)

#define EXTI_ADTE_ADTE7_POS 7U
#define EXTI_ADTE_ADTE7_MSK BIT(EXTI_ADTE_ADTE7_POS)

#define EXTI_ADTE_ADTE6_POS 6U
#define EXTI_ADTE_ADTE6_MSK BIT(EXTI_ADTE_ADTE6_POS)

#define EXTI_ADTE_ADTE5_POS 5U
#define EXTI_ADTE_ADTE5_MSK BIT(EXTI_ADTE_ADTE5_POS)

#define EXTI_ADTE_ADTE4_POS 4U
#define EXTI_ADTE_ADTE4_MSK BIT(EXTI_ADTE_ADTE4_POS)

#define EXTI_ADTE_ADTE3_POS 3U
#define EXTI_ADTE_ADTE3_MSK BIT(EXTI_ADTE_ADTE3_POS)

#define EXTI_ADTE_ADTE2_POS 2U
#define EXTI_ADTE_ADTE2_MSK BIT(EXTI_ADTE_ADTE2_POS)

#define EXTI_ADTE_ADTE1_POS 1U
#define EXTI_ADTE_ADTE1_MSK BIT(EXTI_ADTE_ADTE1_POS)

#define EXTI_ADTE_ADTE0_POS 0U
#define EXTI_ADTE_ADTE0_MSK BIT(EXTI_ADTE_ADTE0_POS)

/****************** Bit definition for EXTI_DB register ************************/

#define EXTI_DB_DBEN21_POS  21U
#define EXTI_DB_DBEN21_MSK  BIT(EXTI_DB_DBEN21_POS)

#define EXTI_DB_DBEN20_POS  20U
#define EXTI_DB_DBEN20_MSK  BIT(EXTI_DB_DBEN20_POS)

#define EXTI_DB_DBEN19_POS  19U
#define EXTI_DB_DBEN19_MSK  BIT(EXTI_DB_DBEN19_POS)

#define EXTI_DB_DBEN18_POS  18U
#define EXTI_DB_DBEN18_MSK  BIT(EXTI_DB_DBEN18_POS)

#define EXTI_DB_DBEN17_POS  17U
#define EXTI_DB_DBEN17_MSK  BIT(EXTI_DB_DBEN17_POS)

#define EXTI_DB_DBEN16_POS  16U
#define EXTI_DB_DBEN16_MSK  BIT(EXTI_DB_DBEN16_POS)

#define EXTI_DB_DBEN15_POS  15U
#define EXTI_DB_DBEN15_MSK  BIT(EXTI_DB_DBEN15_POS)

#define EXTI_DB_DBEN14_POS  14U
#define EXTI_DB_DBEN14_MSK  BIT(EXTI_DB_DBEN14_POS)

#define EXTI_DB_DBEN13_POS  13U
#define EXTI_DB_DBEN13_MSK  BIT(EXTI_DB_DBEN13_POS)

#define EXTI_DB_DBEN12_POS  12U
#define EXTI_DB_DBEN12_MSK  BIT(EXTI_DB_DBEN12_POS)

#define EXTI_DB_DBEN11_POS  11U
#define EXTI_DB_DBEN11_MSK  BIT(EXTI_DB_DBEN11_POS)

#define EXTI_DB_DBEN10_POS  10U
#define EXTI_DB_DBEN10_MSK  BIT(EXTI_DB_DBEN10_POS)

#define EXTI_DB_DBEN9_POS   9U
#define EXTI_DB_DBEN9_MSK   BIT(EXTI_DB_DBEN9_POS)

#define EXTI_DB_DBEN8_POS   8U
#define EXTI_DB_DBEN8_MSK   BIT(EXTI_DB_DBEN8_POS)

#define EXTI_DB_DBEN7_POS   7U
#define EXTI_DB_DBEN7_MSK   BIT(EXTI_DB_DBEN7_POS)

#define EXTI_DB_DBEN6_POS   6U
#define EXTI_DB_DBEN6_MSK   BIT(EXTI_DB_DBEN6_POS)

#define EXTI_DB_DBEN5_POS   5U
#define EXTI_DB_DBEN5_MSK   BIT(EXTI_DB_DBEN5_POS)

#define EXTI_DB_DBEN4_POS   4U
#define EXTI_DB_DBEN4_MSK   BIT(EXTI_DB_DBEN4_POS)

#define EXTI_DB_DBEN3_POS   3U
#define EXTI_DB_DBEN3_MSK   BIT(EXTI_DB_DBEN3_POS)

#define EXTI_DB_DBEN2_POS   2U
#define EXTI_DB_DBEN2_MSK   BIT(EXTI_DB_DBEN2_POS)

#define EXTI_DB_DBEN1_POS   1U
#define EXTI_DB_DBEN1_MSK   BIT(EXTI_DB_DBEN1_POS)

#define EXTI_DB_DBEN0_POS   0U
#define EXTI_DB_DBEN0_MSK   BIT(EXTI_DB_DBEN0_POS)

/****************** Bit definition for EXTI_DBCON register ************************/

#define EXTI_DBCON_DBPRE_POSS   8U
#define EXTI_DBCON_DBPRE_POSE   15U
#define EXTI_DBCON_DBPRE_MSK    BITS(EXTI_DBCON_DBPRE_POSS,EXTI_DBCON_DBPRE_POSE)

#define EXTI_DBCON_DBCNT_POSS   0U
#define EXTI_DBCON_DBCNT_POSE   2U
#define EXTI_DBCON_DBCNT_MSK    BITS(EXTI_DBCON_DBCNT_POSS,EXTI_DBCON_DBCNT_POSE)

/****************** Bit definition for EXTI_ICFG1 register ************************/

#define EXTI_ICFG1_EXTI7_POSS   28U
#define EXTI_ICFG1_EXTI7_POSE   31U
#define EXTI_ICFG1_EXTI7_MSK    BITS(EXTI_ICFG1_EXTI7_POSS,EXTI_ICFG1_EXTI7_POSE)

#define EXTI_ICFG1_EXTI6_POSS   24U
#define EXTI_ICFG1_EXTI6_POSE   27U
#define EXTI_ICFG1_EXTI6_MSK    BITS(EXTI_ICFG1_EXTI6_POSS,EXTI_ICFG1_EXTI6_POSE)

#define EXTI_ICFG1_EXTI5_POSS   20U
#define EXTI_ICFG1_EXTI5_POSE   23U
#define EXTI_ICFG1_EXTI5_MSK    BITS(EXTI_ICFG1_EXTI5_POSS,EXTI_ICFG1_EXTI5_POSE)

#define EXTI_ICFG1_EXTI4_POSS   16U
#define EXTI_ICFG1_EXTI4_POSE   19U
#define EXTI_ICFG1_EXTI4_MSK    BITS(EXTI_ICFG1_EXTI4_POSS,EXTI_ICFG1_EXTI4_POSE)

#define EXTI_ICFG1_EXTI3_POSS   12U
#define EXTI_ICFG1_EXTI3_POSE   15U
#define EXTI_ICFG1_EXTI3_MSK    BITS(EXTI_ICFG1_EXTI3_POSS,EXTI_ICFG1_EXTI3_POSE)

#define EXTI_ICFG1_EXTI2_POSS   8U
#define EXTI_ICFG1_EXTI2_POSE   11U
#define EXTI_ICFG1_EXTI2_MSK    BITS(EXTI_ICFG1_EXTI2_POSS,EXTI_ICFG1_EXTI2_POSE)

#define EXTI_ICFG1_EXTI1_POSS   4U
#define EXTI_ICFG1_EXTI1_POSE   7U
#define EXTI_ICFG1_EXTI1_MSK    BITS(EXTI_ICFG1_EXTI1_POSS,EXTI_ICFG1_EXTI1_POSE)

#define EXTI_ICFG1_EXTI0_POSS   0U
#define EXTI_ICFG1_EXTI0_POSE   3U
#define EXTI_ICFG1_EXTI0_MSK    BITS(EXTI_ICFG1_EXTI0_POSS,EXTI_ICFG1_EXTI0_POSE)

#define EXTI_ICFG1_EXTIy        BITS(EXTI_ICFG1_EXTI0_POSS,EXTI_ICFG1_EXTI7_POSE)

/****************** Bit definition for EXTI_ICFG2 register ************************/

#define EXTI_ICFG2_EXTI15_POSS  28U
#define EXTI_ICFG2_EXTI15_POSE  31U
#define EXTI_ICFG2_EXTI15_MSK   BITS(EXTI_ICFG2_EXTI15_POSS,EXTI_ICFG2_EXTI15_POSE)

#define EXTI_ICFG2_EXTI14_POSS  24U
#define EXTI_ICFG2_EXTI14_POSE  27U
#define EXTI_ICFG2_EXTI14_MSK   BITS(EXTI_ICFG2_EXTI14_POSS,EXTI_ICFG2_EXTI14_POSE)

#define EXTI_ICFG2_EXTI13_POSS  20U
#define EXTI_ICFG2_EXTI13_POSE  23U
#define EXTI_ICFG2_EXTI13_MSK   BITS(EXTI_ICFG2_EXTI13_POSS,EXTI_ICFG2_EXTI13_POSE)

#define EXTI_ICFG2_EXTI12_POSS  16U
#define EXTI_ICFG2_EXTI12_POSE  19U
#define EXTI_ICFG2_EXTI12_MSK   BITS(EXTI_ICFG2_EXTI12_POSS,EXTI_ICFG2_EXTI12_POSE)

#define EXTI_ICFG2_EXTI11_POSS  12U
#define EXTI_ICFG2_EXTI11_POSE  15U
#define EXTI_ICFG2_EXTI11_MSK   BITS(EXTI_ICFG2_EXTI11_POSS,EXTI_ICFG2_EXTI11_POSE)

#define EXTI_ICFG2_EXTI10_POSS  8U
#define EXTI_ICFG2_EXTI10_POSE  11U
#define EXTI_ICFG2_EXTI10_MSK   BITS(EXTI_ICFG2_EXTI10_POSS,EXTI_ICFG2_EXTI10_POSE)

#define EXTI_ICFG2_EXTI9_POSS   4U
#define EXTI_ICFG2_EXTI9_POSE   7U
#define EXTI_ICFG2_EXTI9_MSK    BITS(EXTI_ICFG2_EXTI9_POSS,EXTI_ICFG2_EXTI9_POSE)

#define EXTI_ICFG2_EXTI8_POSS   0U
#define EXTI_ICFG2_EXTI8_POSE   3U
#define EXTI_ICFG2_EXTI8_MSK    BITS(EXTI_ICFG2_EXTI8_POSS,EXTI_ICFG2_EXTI8_POSE)

#define EXTI_ICFG2_EXTIy        BITS(EXTI_ICFG2_EXTI8_POSS,EXTI_ICFG2_EXTI15_POSE)

typedef struct
{
    __O uint32_t IER;
    __O uint32_t IDR;
    __I uint32_t IVS;
    __I uint32_t RIF;
    __I uint32_t IFM;
    __O uint32_t ICR;
    __IO uint32_t RTS;
    __IO uint32_t FTS;
    __IO uint32_t SWI;
    __IO uint32_t ADTE;
    __IO uint32_t DB;
    __IO uint32_t DBCON;
    __IO uint32_t ICFG1;
    __IO uint32_t ICFG2;
} EXTI_TypeDef;

#endif
