/**********************************************************************************
 *
 * @file    reg_timer.h
 * @brief   TIMER Head File
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov 2021     Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __TIMER_H__
#define __TIMER_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for TIMER_CON1 register ************************/

#define TIMER_CON1_DBGSEL_POS 15U
#define TIMER_CON1_DBGSEL_MSK BIT(TIMER_CON1_DBGSEL_POS)
#define TIMER_CON1_DBGSEL     TIMER_CON1_DBGSEL_MSK

#define TIMER_CON1_DFCKSEL_POSS 8U
#define TIMER_CON1_DFCKSEL_POSE 9U
#define TIMER_CON1_DFCKSEL_MSK  BITS(TIMER_CON1_DFCKSEL_POSS, TIMER_CON1_DFCKSEL_POSE)
#define TIMER_CON1_DFCKSEL      TIMER_CON1_DFCKSEL_MSK

#define TIMER_CON1_ARPEN_POS 7U
#define TIMER_CON1_ARPEN_MSK BIT(TIMER_CON1_ARPEN_POS)
#define TIMER_CON1_ARPEN     TIMER_CON1_ARPEN_MSK

#define TIMER_CON1_CMSEL_POSS 5U
#define TIMER_CON1_CMSEL_POSE 6U
#define TIMER_CON1_CMSEL_MSK  BITS(TIMER_CON1_CMSEL_POSS, TIMER_CON1_CMSEL_POSE)
#define TIMER_CON1_CMSEL      TIMER_CON1_CMSEL_MSK

#define TIMER_CON1_DIRSEL_POS 4U
#define TIMER_CON1_DIRSEL_MSK BIT(TIMER_CON1_DIRSEL_POS)
#define TIMER_CON1_DIRSEL     TIMER_CON1_DIRSEL_MSK

#define TIMER_CON1_SPMEN_POS 3U
#define TIMER_CON1_SPMEN_MSK BIT(TIMER_CON1_SPMEN_POS)
#define TIMER_CON1_SPMEN     TIMER_CON1_SPMEN_MSK

#define TIMER_CON1_UERSEL_POS 2U
#define TIMER_CON1_UERSEL_MSK BIT(TIMER_CON1_UERSEL_POS)
#define TIMER_CON1_UERSEL     TIMER_CON1_UERSEL_MSK

#define TIMER_CON1_DISUE_POS 1U
#define TIMER_CON1_DISUE_MSK BIT(TIMER_CON1_DISUE_POS)
#define TIMER_CON1_DISUE     TIMER_CON1_DISUE_MSK

#define TIMER_CON1_CNTEN_POS 0U
#define TIMER_CON1_CNTEN_MSK BIT(TIMER_CON1_CNTEN_POS)
#define TIMER_CON1_CNTEN     TIMER_CON1_CNTEN_MSK

/****************** Bit definition for TIMER_CON2 register ************************/

#define TIMER_CON2_OISS4_POS 14U
#define TIMER_CON2_OISS4_MSK BIT(TIMER_CON2_OISS4_POS)
#define TIMER_CON2_OISS4     TIMER_CON2_OISS4_MSK

#define TIMER_CON2_OISS3N_POS 13U
#define TIMER_CON2_OISS3N_MSK BIT(TIMER_CON2_OISS3N_POS)
#define TIMER_CON2_OISS3N     TIMER_CON2_OISS3N_MSK

#define TIMER_CON2_OISS3_POS 12U
#define TIMER_CON2_OISS3_MSK BIT(TIMER_CON2_OISS3_POS)
#define TIMER_CON2_OISS3     TIMER_CON2_OISS3_MSK

#define TIMER_CON2_OISS2N_POS 11U
#define TIMER_CON2_OISS2N_MSK BIT(TIMER_CON2_OISS2N_POS)
#define TIMER_CON2_OISS2N     TIMER_CON2_OISS2N_MSK

#define TIMER_CON2_OISS2_POS 10U
#define TIMER_CON2_OISS2_MSK BIT(TIMER_CON2_OISS2_POS)
#define TIMER_CON2_OISS2     TIMER_CON2_OISS2_MSK

#define TIMER_CON2_OISS1N_POS 9U
#define TIMER_CON2_OISS1N_MSK BIT(TIMER_CON2_OISS1N_POS)
#define TIMER_CON2_OISS1N     TIMER_CON2_OISS1N_MSK

#define TIMER_CON2_OISS1_POS 8U
#define TIMER_CON2_OISS1_MSK BIT(TIMER_CON2_OISS1_POS)
#define TIMER_CON2_OISS1     TIMER_CON2_OISS1_MSK

#define TIMER_CON2_I1SEL_POS 7U
#define TIMER_CON2_I1SEL_MSK BIT(TIMER_CON2_I1SEL_POS)
#define TIMER_CON2_I1SEL     TIMER_CON2_I1SEL_MSK

#define TIMER_CON2_MMSEL_POSS 4U
#define TIMER_CON2_MMSEL_POSE 6U
#define TIMER_CON2_MMSEL_MSK  BITS(TIMER_CON2_MMSEL_POSS, TIMER_CON2_MMSEL_POSE)
#define TIMER_CON2_MMSEL      TIMER_CON2_MMSEL_MSK

#define TIMER_CON2_CCDMASEL_POS 3U
#define TIMER_CON2_CCDMASEL_MSK BIT(TIMER_CON2_CCDMASEL_POS)
#define TIMER_CON2_CCDMASEL     TIMER_CON2_CCDMASEL_MSK

#define TIMER_CON2_CCUSEL_POS 2U
#define TIMER_CON2_CCUSEL_MSK BIT(TIMER_CON2_CCUSEL_POS)
#define TIMER_CON2_CCUSEL     TIMER_CON2_CCUSEL_MSK

#define TIMER_CON2_CCPCEN_POS 0U
#define TIMER_CON2_CCPCEN_MSK BIT(TIMER_CON2_CCPCEN_POS)
#define TIMER_CON2_CCPCEN     TIMER_CON2_CCPCEN_MSK

/****************** Bit definition for TIMER_SMCON register ************************/

#define TIMER_SMCON_TSSEL2_POSS 20U
#define TIMER_SMCON_TSSEL2_POSE 21U
#define TIMER_SMCON_TSSEL2_MSK  BITS(TIMER_SMCON_TSSEL2_POSS, TIMER_SMCON_TSSEL2_POSE)
#define TIMER_SMCON_TSSEL2      TIMER_SMCON_TSSEL2_MSK

#define TIMER_SMCON_ETPOL_POS 15U
#define TIMER_SMCON_ETPOL_MSK BIT(TIMER_SMCON_ETPOL_POS)
#define TIMER_SMCON_ETPOL     TIMER_SMCON_ETPOL_MSK

#define TIMER_SMCON_ECM2EN_POS 14U
#define TIMER_SMCON_ECM2EN_MSK BIT(TIMER_SMCON_ECM2EN_POS)
#define TIMER_SMCON_ECM2EN     TIMER_SMCON_ECM2EN_MSK

#define TIMER_SMCON_ETPRES_POSS 12U
#define TIMER_SMCON_ETPRES_POSE 13U
#define TIMER_SMCON_ETPRES_MSK  BITS(TIMER_SMCON_ETPRES_POSS, TIMER_SMCON_ETPRES_POSE)
#define TIMER_SMCON_ETPRES      TIMER_SMCON_ETPRES_MSK

#define TIMER_SMCON_ETFLT_POSS 8U
#define TIMER_SMCON_ETFLT_POSE 11U
#define TIMER_SMCON_ETFLT_MSK  BITS(TIMER_SMCON_ETFLT_POSS, TIMER_SMCON_ETFLT_POSE)
#define TIMER_SMCON_ETFLT      TIMER_SMCON_ETFLT_MSK

#define TIMER_SMCON_MSCFG_POS 7U
#define TIMER_SMCON_MSCFG_MSK BIT(TIMER_SMCON_MSCFG_POS)
#define TIMER_SMCON_MSCFG     TIMER_SMCON_MSCFG_MSK

#define TIMER_SMCON_TSSEL1_POSS 4U
#define TIMER_SMCON_TSSEL1_POSE 6U
#define TIMER_SMCON_TSSEL1_MSK  BITS(TIMER_SMCON_TSSEL1_POSS, TIMER_SMCON_TSSEL1_POSE)
#define TIMER_SMCON_TSSEL1      TIMER_SMCON_TSSEL1_MSK

#define TIMER_SMCON_SMODS_POSS 0U
#define TIMER_SMCON_SMODS_POSE 2U
#define TIMER_SMCON_SMODS_MSK  BITS(TIMER_SMCON_SMODS_POSS, TIMER_SMCON_SMODS_POSE)
#define TIMER_SMCON_SMODS      TIMER_SMCON_SMODS_MSK

/****************** Bit definition for TIMER_IER register ************************/

#define TIMER_IER_CH4OV_POS 12U
#define TIMER_IER_CH4OV_MSK BIT(TIMER_IER_CH4OV_POS)
#define TIMER_IER_CH4OV     TIMER_IER_CH4OV_MSK

#define TIMER_IER_CH3OV_POS 11U
#define TIMER_IER_CH3OV_MSK BIT(TIMER_IER_CH3OV_POS)
#define TIMER_IER_CH3OV     TIMER_IER_CH3OV_MSK

#define TIMER_IER_CH2OV_POS 10U
#define TIMER_IER_CH2OV_MSK BIT(TIMER_IER_CH2OV_POS)
#define TIMER_IER_CH2OV     TIMER_IER_CH2OV_MSK

#define TIMER_IER_CH1OV_POS 9U
#define TIMER_IER_CH1OV_MSK BIT(TIMER_IER_CH1OV_POS)
#define TIMER_IER_CH1OV     TIMER_IER_CH1OV_MSK

#define TIMER_IER_BRK_POS 7U
#define TIMER_IER_BRK_MSK BIT(TIMER_IER_BRK_POS)
#define TIMER_IER_BRK     TIMER_IER_BRK_MSK

#define TIMER_IER_TRGI_POS 6U
#define TIMER_IER_TRGI_MSK BIT(TIMER_IER_TRGI_POS)
#define TIMER_IER_TRGI     TIMER_IER_TRGI_MSK

#define TIMER_IER_COM_POS 5U
#define TIMER_IER_COM_MSK BIT(TIMER_IER_COM_POS)
#define TIMER_IER_COM     TIMER_IER_COM_MSK

#define TIMER_IER_CH4_POS 4U
#define TIMER_IER_CH4_MSK BIT(TIMER_IER_CH4_POS)
#define TIMER_IER_CH4     TIMER_IER_CH4_MSK

#define TIMER_IER_CH3_POS 3U
#define TIMER_IER_CH3_MSK BIT(TIMER_IER_CH3_POS)
#define TIMER_IER_CH3     TIMER_IER_CH3_MSK

#define TIMER_IER_CH2_POS 2U
#define TIMER_IER_CH2_MSK BIT(TIMER_IER_CH2_POS)
#define TIMER_IER_CH2     TIMER_IER_CH2_MSK

#define TIMER_IER_CH1_POS 1U
#define TIMER_IER_CH1_MSK BIT(TIMER_IER_CH1_POS)
#define TIMER_IER_CH1     TIMER_IER_CH1_MSK

#define TIMER_IER_UPD_POS 0U
#define TIMER_IER_UPD_MSK BIT(TIMER_IER_UPD_POS)
#define TIMER_IER_UPD     TIMER_IER_UPD_MSK

/****************** Bit definition for TIMER_IDR register ************************/

#define TIMER_IDR_CH4OV_POS 12U
#define TIMER_IDR_CH4OV_MSK BIT(TIMER_IDR_CH4OV_POS)
#define TIMER_IDR_CH4OV     TIMER_IDR_CH4OV_MSK

#define TIMER_IDR_CH3OV_POS 11U
#define TIMER_IDR_CH3OV_MSK BIT(TIMER_IDR_CH3OV_POS)
#define TIMER_IDR_CH3OV     TIMER_IDR_CH3OV_MSK

#define TIMER_IDR_CH2OV_POS 10U
#define TIMER_IDR_CH2OV_MSK BIT(TIMER_IDR_CH2OV_POS)
#define TIMER_IDR_CH2OV     TIMER_IDR_CH2OV_MSK

#define TIMER_IDR_CH1OV_POS 9U
#define TIMER_IDR_CH1OV_MSK BIT(TIMER_IDR_CH1OV_POS)
#define TIMER_IDR_CH1OV     TIMER_IDR_CH1OV_MSK

#define TIMER_IDR_BRK_POS 7U
#define TIMER_IDR_BRK_MSK BIT(TIMER_IDR_BRK_POS)
#define TIMER_IDR_BRK     TIMER_IDR_BRK_MSK

#define TIMER_IDR_TRGI_POS 6U
#define TIMER_IDR_TRGI_MSK BIT(TIMER_IDR_TRGI_POS)
#define TIMER_IDR_TRGI     TIMER_IDR_TRGI_MSK

#define TIMER_IDR_COM_POS 5U
#define TIMER_IDR_COM_MSK BIT(TIMER_IDR_COM_POS)
#define TIMER_IDR_COM     TIMER_IDR_COM_MSK

#define TIMER_IDR_CH4_POS 4U
#define TIMER_IDR_CH4_MSK BIT(TIMER_IDR_CH4_POS)
#define TIMER_IDR_CH4     TIMER_IDR_CH4_MSK

#define TIMER_IDR_CH3_POS 3U
#define TIMER_IDR_CH3_MSK BIT(TIMER_IDR_CH3_POS)
#define TIMER_IDR_CH3     TIMER_IDR_CH3_MSK

#define TIMER_IDR_CH2_POS 2U
#define TIMER_IDR_CH2_MSK BIT(TIMER_IDR_CH2_POS)
#define TIMER_IDR_CH2     TIMER_IDR_CH2_MSK

#define TIMER_IDR_CH1_POS 1U
#define TIMER_IDR_CH1_MSK BIT(TIMER_IDR_CH1_POS)
#define TIMER_IDR_CH1     TIMER_IDR_CH1_MSK

#define TIMER_IDR_UPD_POS 0U
#define TIMER_IDR_UPD_MSK BIT(TIMER_IDR_UPD_POS)
#define TIMER_IDR_UPD     TIMER_IDR_UPD_MSK

/****************** Bit definition for TIMER_IVS register ************************/

#define TIMER_IVS_CH4OV_POS 12U
#define TIMER_IVS_CH4OV_MSK BIT(TIMER_IVS_CH4OV_POS)
#define TIMER_IVS_CH4OV     TIMER_IVS_CH4OV_MSK

#define TIMER_IVS_CH3OV_POS 11U
#define TIMER_IVS_CH3OV_MSK BIT(TIMER_IVS_CH3OV_POS)
#define TIMER_IVS_CH3OV     TIMER_IVS_CH3OV_MSK

#define TIMER_IVS_CH2OV_POS 10U
#define TIMER_IVS_CH2OV_MSK BIT(TIMER_IVS_CH2OV_POS)
#define TIMER_IVS_CH2OV     TIMER_IVS_CH2OV_MSK

#define TIMER_IVS_CH1OV_POS 9U
#define TIMER_IVS_CH1OV_MSK BIT(TIMER_IVS_CH1OV_POS)
#define TIMER_IVS_CH1OV     TIMER_IVS_CH1OV_MSK

#define TIMER_IVS_BRK_POS 7U
#define TIMER_IVS_BRK_MSK BIT(TIMER_IVS_BRK_POS)
#define TIMER_IVS_BRK     TIMER_IVS_BRK_MSK

#define TIMER_IVS_TRGI_POS 6U
#define TIMER_IVS_TRGI_MSK BIT(TIMER_IVS_TRGI_POS)
#define TIMER_IVS_TRGI     TIMER_IVS_TRGI_MSK

#define TIMER_IVS_COM_POS 5U
#define TIMER_IVS_COM_MSK BIT(TIMER_IVS_COM_POS)
#define TIMER_IVS_COM     TIMER_IVS_COM_MSK

#define TIMER_IVS_CH4_POS 4U
#define TIMER_IVS_CH4_MSK BIT(TIMER_IVS_CH4_POS)
#define TIMER_IVS_CH4     TIMER_IVS_CH4_MSK

#define TIMER_IVS_CH3_POS 3U
#define TIMER_IVS_CH3_MSK BIT(TIMER_IVS_CH3_POS)
#define TIMER_IVS_CH3     TIMER_IVS_CH3_MSK

#define TIMER_IVS_CH2_POS 2U
#define TIMER_IVS_CH2_MSK BIT(TIMER_IVS_CH2_POS)
#define TIMER_IVS_CH2     TIMER_IVS_CH2_MSK

#define TIMER_IVS_CH1_POS 1U
#define TIMER_IVS_CH1_MSK BIT(TIMER_IVS_CH1_POS)
#define TIMER_IVS_CH1     TIMER_IVS_CH1_MSK

#define TIMER_IVS_UPD_POS 0U
#define TIMER_IVS_UPD_MSK BIT(TIMER_IVS_UPD_POS)
#define TIMER_IVS_UPD     TIMER_IVS_UPD_MSK

/****************** Bit definition for TIMER_RIF register ************************/

#define TIMER_RIF_CH4OV_POS 12U
#define TIMER_RIF_CH4OV_MSK BIT(TIMER_RIF_CH4OV_POS)
#define TIMER_RIF_CH4OV     TIMER_RIF_CH4OV_MSK

#define TIMER_RIF_CH3OV_POS 11U
#define TIMER_RIF_CH3OV_MSK BIT(TIMER_RIF_CH3OV_POS)
#define TIMER_RIF_CH3OV     TIMER_RIF_CH3OV_MSK

#define TIMER_RIF_CH2OV_POS 10U
#define TIMER_RIF_CH2OV_MSK BIT(TIMER_RIF_CH2OV_POS)
#define TIMER_RIF_CH2OV     TIMER_RIF_CH2OV_MSK

#define TIMER_RIF_CH1OV_POS 9U
#define TIMER_RIF_CH1OV_MSK BIT(TIMER_RIF_CH1OV_POS)
#define TIMER_RIF_CH1OV     TIMER_RIF_CH1OV_MSK

#define TIMER_RIF_BRK_POS 7U
#define TIMER_RIF_BRK_MSK BIT(TIMER_RIF_BRK_POS)
#define TIMER_RIF_BRK     TIMER_RIF_BRK_MSK

#define TIMER_RIF_TRGI_POS 6U
#define TIMER_RIF_TRGI_MSK BIT(TIMER_RIF_TRGI_POS)
#define TIMER_RIF_TRGI     TIMER_RIF_TRGI_MSK

#define TIMER_RIF_COM_POS 5U
#define TIMER_RIF_COM_MSK BIT(TIMER_RIF_COM_POS)
#define TIMER_RIF_COM     TIMER_RIF_COM_MSK

#define TIMER_RIF_CH4_POS 4U
#define TIMER_RIF_CH4_MSK BIT(TIMER_RIF_CH4_POS)
#define TIMER_RIF_CH4     TIMER_RIF_CH4_MSK

#define TIMER_RIF_CH3_POS 3U
#define TIMER_RIF_CH3_MSK BIT(TIMER_RIF_CH3_POS)
#define TIMER_RIF_CH3     TIMER_RIF_CH3_MSK

#define TIMER_RIF_CH2_POS 2U
#define TIMER_RIF_CH2_MSK BIT(TIMER_RIF_CH2_POS)
#define TIMER_RIF_CH2     TIMER_RIF_CH2_MSK

#define TIMER_RIF_CH1_POS 1U
#define TIMER_RIF_CH1_MSK BIT(TIMER_RIF_CH1_POS)
#define TIMER_RIF_CH1     TIMER_RIF_CH1_MSK

#define TIMER_RIF_UPD_POS 0U
#define TIMER_RIF_UPD_MSK BIT(TIMER_RIF_UPD_POS)
#define TIMER_RIF_UPD     TIMER_RIF_UPD_MSK

/****************** Bit definition for TIMER_IFM register ************************/

#define TIMER_IFM_CH4OV_POS 12U
#define TIMER_IFM_CH4OV_MSK BIT(TIMER_IFM_CH4OV_POS)
#define TIMER_IFM_CH4OV     TIMER_IFM_CH4OV_MSK

#define TIMER_IFM_CH3OV_POS 11U
#define TIMER_IFM_CH3OV_MSK BIT(TIMER_IFM_CH3OV_POS)
#define TIMER_IFM_CH3OV     TIMER_IFM_CH3OV_MSK

#define TIMER_IFM_CH2OV_POS 10U
#define TIMER_IFM_CH2OV_MSK BIT(TIMER_IFM_CH2OV_POS)
#define TIMER_IFM_CH2OV     TIMER_IFM_CH2OV_MSK

#define TIMER_IFM_CH1OV_POS 9U
#define TIMER_IFM_CH1OV_MSK BIT(TIMER_IFM_CH1OV_POS)
#define TIMER_IFM_CH1OV     TIMER_IFM_CH1OV_MSK

#define TIMER_IFM_BRK_POS 7U
#define TIMER_IFM_BRK_MSK BIT(TIMER_IFM_BRK_POS)
#define TIMER_IFM_BRK     TIMER_IFM_BRK_MSK

#define TIMER_IFM_TRGI_POS 6U
#define TIMER_IFM_TRGI_MSK BIT(TIMER_IFM_TRGI_POS)
#define TIMER_IFM_TRGI     TIMER_IFM_TRGI_MSK

#define TIMER_IFM_COM_POS 5U
#define TIMER_IFM_COM_MSK BIT(TIMER_IFM_COM_POS)
#define TIMER_IFM_COM     TIMER_IFM_COM_MSK

#define TIMER_IFM_CH4_POS 4U
#define TIMER_IFM_CH4_MSK BIT(TIMER_IFM_CH4_POS)
#define TIMER_IFM_CH4     TIMER_IFM_CH4_MSK

#define TIMER_IFM_CH3_POS 3U
#define TIMER_IFM_CH3_MSK BIT(TIMER_IFM_CH3_POS)
#define TIMER_IFM_CH3     TIMER_IFM_CH3_MSK

#define TIMER_IFM_CH2_POS 2U
#define TIMER_IFM_CH2_MSK BIT(TIMER_IFM_CH2_POS)
#define TIMER_IFM_CH2     TIMER_IFM_CH2_MSK

#define TIMER_IFM_CH1_POS 1U
#define TIMER_IFM_CH1_MSK BIT(TIMER_IFM_CH1_POS)
#define TIMER_IFM_CH1     TIMER_IFM_CH1_MSK

#define TIMER_IFM_UPD_POS 0U
#define TIMER_IFM_UPD_MSK BIT(TIMER_IFM_UPD_POS)
#define TIMER_IFM_UPD     TIMER_IFM_UPD_MSK

/****************** Bit definition for TIMER_ICR register ************************/

#define TIMER_ICR_CH4OV_POS 12U
#define TIMER_ICR_CH4OV_MSK BIT(TIMER_ICR_CH4OV_POS)
#define TIMER_ICR_CH4OV     TIMER_ICR_CH4OV_MSK

#define TIMER_ICR_CH3OV_POS 11U
#define TIMER_ICR_CH3OV_MSK BIT(TIMER_ICR_CH3OV_POS)
#define TIMER_ICR_CH3OV     TIMER_ICR_CH3OV_MSK

#define TIMER_ICR_CH2OV_POS 10U
#define TIMER_ICR_CH2OV_MSK BIT(TIMER_ICR_CH2OV_POS)
#define TIMER_ICR_CH2OV     TIMER_ICR_CH2OV_MSK

#define TIMER_ICR_CH1OV_POS 9U
#define TIMER_ICR_CH1OV_MSK BIT(TIMER_ICR_CH1OV_POS)
#define TIMER_ICR_CH1OV     TIMER_ICR_CH1OV_MSK

#define TIMER_ICR_BRK_POS 7U
#define TIMER_ICR_BRK_MSK BIT(TIMER_ICR_BRK_POS)
#define TIMER_ICR_BRK     TIMER_ICR_BRK_MSK

#define TIMER_ICR_TRGI_POS 6U
#define TIMER_ICR_TRGI_MSK BIT(TIMER_ICR_TRGI_POS)
#define TIMER_ICR_TRGI     TIMER_ICR_TRGI_MSK

#define TIMER_ICR_COM_POS 5U
#define TIMER_ICR_COM_MSK BIT(TIMER_ICR_COM_POS)
#define TIMER_ICR_COM     TIMER_ICR_COM_MSK

#define TIMER_ICR_CH4_POS 4U
#define TIMER_ICR_CH4_MSK BIT(TIMER_ICR_CH4_POS)
#define TIMER_ICR_CH4     TIMER_ICR_CH4_MSK

#define TIMER_ICR_CH3_POS 3U
#define TIMER_ICR_CH3_MSK BIT(TIMER_ICR_CH3_POS)
#define TIMER_ICR_CH3     TIMER_ICR_CH3_MSK

#define TIMER_ICR_CH2_POS 2U
#define TIMER_ICR_CH2_MSK BIT(TIMER_ICR_CH2_POS)
#define TIMER_ICR_CH2     TIMER_ICR_CH2_MSK

#define TIMER_ICR_CH1_POS 1U
#define TIMER_ICR_CH1_MSK BIT(TIMER_ICR_CH1_POS)
#define TIMER_ICR_CH1     TIMER_ICR_CH1_MSK

#define TIMER_ICR_UPD_POS 0U
#define TIMER_ICR_UPD_MSK BIT(TIMER_ICR_UPD_POS)
#define TIMER_ICR_UPD     TIMER_ICR_UPD_MSK

/****************** Bit definition for TIMER_SGE register ************************/

#define TIMER_SGE_SGBRK_POS 7U
#define TIMER_SGE_SGBRK_MSK BIT(TIMER_SGE_SGBRK_POS)
#define TIMER_SGE_SGBRK     TIMER_SGE_SGBRK_MSK

#define TIMER_SGE_SGTRGI_POS 6U
#define TIMER_SGE_SGTRGI_MSK BIT(TIMER_SGE_SGTRGI_POS)
#define TIMER_SGE_SGTRGI     TIMER_SGE_SGTRGI_MSK

#define TIMER_SGE_SGCOM_POS 5U
#define TIMER_SGE_SGCOM_MSK BIT(TIMER_SGE_SGCOM_POS)
#define TIMER_SGE_SGCOM     TIMER_SGE_SGCOM_MSK

#define TIMER_SGE_SGCH4_POS 4U
#define TIMER_SGE_SGCH4_MSK BIT(TIMER_SGE_SGCH4_POS)
#define TIMER_SGE_SGCH4     TIMER_SGE_SGCH4_MSK

#define TIMER_SGE_SGCH3_POS 3U
#define TIMER_SGE_SGCH3_MSK BIT(TIMER_SGE_SGCH3_POS)
#define TIMER_SGE_SGCH3     TIMER_SGE_SGCH3_MSK

#define TIMER_SGE_SGCH2_POS 2U
#define TIMER_SGE_SGCH2_MSK BIT(TIMER_SGE_SGCH2_POS)
#define TIMER_SGE_SGCH2     TIMER_SGE_SGCH2_MSK

#define TIMER_SGE_SGCH1_POS 1U
#define TIMER_SGE_SGCH1_MSK BIT(TIMER_SGE_SGCH1_POS)
#define TIMER_SGE_SGCH1     TIMER_SGE_SGCH1_MSK

#define TIMER_SGE_SGUPD_POS 0U
#define TIMER_SGE_SGUPD_MSK BIT(TIMER_SGE_SGUPD_POS)
#define TIMER_SGE_SGUPD     TIMER_SGE_SGUPD_MSK

/****************** Bit definition for TIMER_CHMR1_OUTPUT register ************************/

#define TIMER_CHMR1_OUTPUT_CH2OCLREN_POS 15U
#define TIMER_CHMR1_OUTPUT_CH2OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2OCLREN_POS)
#define TIMER_CHMR1_OUTPUT_CH2OCLREN     TIMER_CHMR1_OUTPUT_CH2OCLREN_MSK

#define TIMER_CHMR1_OUTPUT_CH2MOD_POSS 12U
#define TIMER_CHMR1_OUTPUT_CH2MOD_POSE 14U
#define TIMER_CHMR1_OUTPUT_CH2MOD_MSK  BITS(TIMER_CHMR1_OUTPUT_CH2MOD_POSS, TIMER_CHMR1_OUTPUT_CH2MOD_POSE)
#define TIMER_CHMR1_OUTPUT_CH2MOD      TIMER_CHMR1_OUTPUT_CH2MOD_MSK

#define TIMER_CHMR1_OUTPUT_CH2PEN_POS 11U
#define TIMER_CHMR1_OUTPUT_CH2PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2PEN_POS)
#define TIMER_CHMR1_OUTPUT_CH2PEN     TIMER_CHMR1_OUTPUT_CH2PEN_MSK

#define TIMER_CHMR1_OUTPUT_CH2FEN_POS 10U
#define TIMER_CHMR1_OUTPUT_CH2FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH2FEN_POS)
#define TIMER_CHMR1_OUTPUT_CH2FEN     TIMER_CHMR1_OUTPUT_CH2FEN_MSK

#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_OUTPUT_CC2SSEL_MSK  BITS(TIMER_CHMR1_OUTPUT_CC2SSEL_POSS, TIMER_CHMR1_OUTPUT_CC2SSEL_POSE)
#define TIMER_CHMR1_OUTPUT_CC2SSEL      TIMER_CHMR1_OUTPUT_CC2SSEL_MSK

#define TIMER_CHMR1_OUTPUT_CH1OCLREN_POS 7U
#define TIMER_CHMR1_OUTPUT_CH1OCLREN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1OCLREN_POS)
#define TIMER_CHMR1_OUTPUT_CH1OCLREN     TIMER_CHMR1_OUTPUT_CH1OCLREN_MSK

#define TIMER_CHMR1_OUTPUT_CH1MOD_POSS 4U
#define TIMER_CHMR1_OUTPUT_CH1MOD_POSE 6U
#define TIMER_CHMR1_OUTPUT_CH1MOD_MSK  BITS(TIMER_CHMR1_OUTPUT_CH1MOD_POSS, TIMER_CHMR1_OUTPUT_CH1MOD_POSE)
#define TIMER_CHMR1_OUTPUT_CH1MOD      TIMER_CHMR1_OUTPUT_CH1MOD_MSK

#define TIMER_CHMR1_OUTPUT_CH1PEN_POS 3U
#define TIMER_CHMR1_OUTPUT_CH1PEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1PEN_POS)
#define TIMER_CHMR1_OUTPUT_CH1PEN     TIMER_CHMR1_OUTPUT_CH1PEN_MSK

#define TIMER_CHMR1_OUTPUT_CH1FEN_POS 2U
#define TIMER_CHMR1_OUTPUT_CH1FEN_MSK BIT(TIMER_CHMR1_OUTPUT_CH1FEN_POS)
#define TIMER_CHMR1_OUTPUT_CH1FEN     TIMER_CHMR1_OUTPUT_CH1FEN_MSK

#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_OUTPUT_CC1SSEL_MSK  BITS(TIMER_CHMR1_OUTPUT_CC1SSEL_POSS, TIMER_CHMR1_OUTPUT_CC1SSEL_POSE)
#define TIMER_CHMR1_OUTPUT_CC1SSEL      TIMER_CHMR1_OUTPUT_CC1SSEL_MSK

/****************** Bit definition for AD16C4T_CHMR1_INPUT register ************************/

#define TIMER_CHMR1_INPUT_I2FLT_POSS 12U
#define TIMER_CHMR1_INPUT_I2FLT_POSE 15U
#define TIMER_CHMR1_INPUT_I2FLT_MSK  BITS(TIMER_CHMR1_INPUT_I2FLT_POSS,TIMER_CHMR1_INPUT_I2FLT_POSE)
#define TIMER_CHMR1_INPUT_I2FLT      TIMER_CHMR1_INPUT_I2FLT_MSK

#define TIMER_CHMR1_INPUT_I2PRES_POSS 10U
#define TIMER_CHMR1_INPUT_I2PRES_POSE 11U
#define TIMER_CHMR1_INPUT_I2PRES_MSK  BITS(TIMER_CHMR1_INPUT_I2PRES_POSS,TIMER_CHMR1_INPUT_I2PRES_POSE)
#define TIMER_CHMR1_INPUT_I2PRES      TIMER_CHMR1_INPUT_I2PRES_MSK

#define TIMER_CHMR1_INPUT_CC2SSEL_POSS 8U
#define TIMER_CHMR1_INPUT_CC2SSEL_POSE 9U
#define TIMER_CHMR1_INPUT_CC2SSEL_MSK  BITS(TIMER_CHMR1_INPUT_CC2SSEL_POSS,TIMER_CHMR1_INPUT_CC2SSEL_POSE)
#define TIMER_CHMR1_INPUT_CC2SSEL      TIMER_CHMR1_INPUT_CC2SSEL_MSK

#define TIMER_CHMR1_INPUT_I1FLT_POSS 4U
#define TIMER_CHMR1_INPUT_I1FLT_POSE 7U
#define TIMER_CHMR1_INPUT_I1FLT_MSK  BITS(TIMER_CHMR1_INPUT_I1FLT_POSS,TIMER_CHMR1_INPUT_I1FLT_POSE)
#define TIMER_CHMR1_INPUT_I1FLT      TIMER_CHMR1_INPUT_I1FLT_MSK

#define TIMER_CHMR1_INPUT_I1PRES_POSS 2U
#define TIMER_CHMR1_INPUT_I1PRES_POSE 3U
#define TIMER_CHMR1_INPUT_I1PRES_MSK  BITS(TIMER_CHMR1_INPUT_I1PRES_POSS,TIMER_CHMR1_INPUT_I1PRES_POSE)
#define TIMER_CHMR1_INPUT_I1PRES      TIMER_CHMR1_INPUT_I1PRES_MSK

#define TIMER_CHMR1_INPUT_CC1SSEL_POSS 0U
#define TIMER_CHMR1_INPUT_CC1SSEL_POSE 1U
#define TIMER_CHMR1_INPUT_CC1SSEL_MSK  BITS(TIMER_CHMR1_INPUT_CC1SSEL_POSS,TIMER_CHMR1_INPUT_CC1SSEL_POSE)
#define TIMER_CHMR1_INPUT_CC1SSEL      TIMER_CHMR1_INPUT_CC1SSEL_MSK

/****************** Bit definition for TIMER_CHMR2_OUTPUT register ************************/

#define TIMER_CHMR2_OUTPUT_CH4OCLREN_POS 15U
#define TIMER_CHMR2_OUTPUT_CH4OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4OCLREN_POS)
#define TIMER_CHMR2_OUTPUT_CH4OCLREN     TIMER_CHMR2_OUTPUT_CH4OCLREN_MSK

#define TIMER_CHMR2_OUTPUT_CH4MOD_POSS 12U
#define TIMER_CHMR2_OUTPUT_CH4MOD_POSE 14U
#define TIMER_CHMR2_OUTPUT_CH4MOD_MSK  BITS(TIMER_CHMR2_OUTPUT_CH4MOD_POSS, TIMER_CHMR2_OUTPUT_CH4MOD_POSE)
#define TIMER_CHMR2_OUTPUT_CH4MOD      TIMER_CHMR2_OUTPUT_CH4MOD_MSK

#define TIMER_CHMR2_OUTPUT_CH4PEN_POS 11U
#define TIMER_CHMR2_OUTPUT_CH4PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4PEN_POS)
#define TIMER_CHMR2_OUTPUT_CH4PEN     TIMER_CHMR2_OUTPUT_CH4PEN_MSK

#define TIMER_CHMR2_OUTPUT_CH4FEN_POS 10U
#define TIMER_CHMR2_OUTPUT_CH4FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH4FEN_POS)
#define TIMER_CHMR2_OUTPUT_CH4FEN     TIMER_CHMR2_OUTPUT_CH4FEN_MSK

#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_OUTPUT_CC4SSEL_MSK  BITS(TIMER_CHMR2_OUTPUT_CC4SSEL_POSS, TIMER_CHMR2_OUTPUT_CC4SSEL_POSE)
#define TIMER_CHMR2_OUTPUT_CC4SSEL      TIMER_CHMR2_OUTPUT_CC4SSEL_MSK

#define TIMER_CHMR2_OUTPUT_CH3OCLREN_POS 7U
#define TIMER_CHMR2_OUTPUT_CH3OCLREN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3OCLREN_POS)
#define TIMER_CHMR2_OUTPUT_CH3OCLREN     TIMER_CHMR2_OUTPUT_CH3OCLREN_MSK

#define TIMER_CHMR2_OUTPUT_CH3MOD_POSS 4U
#define TIMER_CHMR2_OUTPUT_CH3MOD_POSE 6U
#define TIMER_CHMR2_OUTPUT_CH3MOD_MSK  BITS(TIMER_CHMR2_OUTPUT_CH3MOD_POSS, TIMER_CHMR2_OUTPUT_CH3MOD_POSE)
#define TIMER_CHMR2_OUTPUT_CH3MOD      TIMER_CHMR2_OUTPUT_CH3MOD_MSK

#define TIMER_CHMR2_OUTPUT_CH3PEN_POS 3U
#define TIMER_CHMR2_OUTPUT_CH3PEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3PEN_POS)
#define TIMER_CHMR2_OUTPUT_CH3PEN     TIMER_CHMR2_OUTPUT_CH3PEN_MSK

#define TIMER_CHMR2_OUTPUT_CH3FEN_POS 2U
#define TIMER_CHMR2_OUTPUT_CH3FEN_MSK BIT(TIMER_CHMR2_OUTPUT_CH3FEN_POS)
#define TIMER_CHMR2_OUTPUT_CH3FEN     TIMER_CHMR2_OUTPUT_CH3FEN_MSK

#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_OUTPUT_CC3SSEL_MSK  BITS(TIMER_CHMR2_OUTPUT_CC3SSEL_POSS, TIMER_CHMR2_OUTPUT_CC3SSEL_POSE)
#define TIMER_CHMR2_OUTPUT_CC3SSEL      TIMER_CHMR2_OUTPUT_CC3SSEL_MSK

/****************** Bit definition for TIMER_CHMR2_INPUT register ************************/

#define TIMER_CHMR2_INPUT_I4FLT_POSS 12U
#define TIMER_CHMR2_INPUT_I4FLT_POSE 15U
#define TIMER_CHMR2_INPUT_I4FLT_MSK  BITS(TIMER_CHMR2_INPUT_I4FLT_POSS, TIMER_CHMR2_INPUT_I4FLT_POSE)
#define TIMER_CHMR2_INPUT_I4FLT      TIMER_CHMR2_INPUT_I4FLT_MSK

#define TIMER_CHMR2_INPUT_I4PRES_POSS 10U
#define TIMER_CHMR2_INPUT_I4PRES_POSE 11U
#define TIMER_CHMR2_INPUT_I4PRES_MSK  BITS(TIMER_CHMR2_INPUT_I4PRES_POSS, TIMER_CHMR2_INPUT_I4PRES_POSE)
#define TIMER_CHMR2_INPUT_I4PRES      TIMER_CHMR2_INPUT_I4PRES_MSK

#define TIMER_CHMR2_INPUT_CC4SSEL_POSS 8U
#define TIMER_CHMR2_INPUT_CC4SSEL_POSE 9U
#define TIMER_CHMR2_INPUT_CC4SSEL_MSK  BITS(TIMER_CHMR2_INPUT_CC4SSEL_POSS, TIMER_CHMR2_INPUT_CC4SSEL_POSE)
#define TIMER_CHMR2_INPUT_CC4SSEL      TIMER_CHMR2_INPUT_CC4SSEL_MSK

#define TIMER_CHMR2_INPUT_I3FLT_POSS 4U
#define TIMER_CHMR2_INPUT_I3FLT_POSE 7U
#define TIMER_CHMR2_INPUT_I3FLT_MSK  BITS(TIMER_CHMR2_INPUT_I3FLT_POSS, TIMER_CHMR2_INPUT_I3FLT_POSE)
#define TIMER_CHMR2_INPUT_I3FLT      TIMER_CHMR2_INPUT_I3FLT_MSK

#define TIMER_CHMR2_INPUT_I3PRES_POSS 2U
#define TIMER_CHMR2_INPUT_I3PRES_POSE 3U
#define TIMER_CHMR2_INPUT_I3PRES_MSK  BITS(TIMER_CHMR2_INPUT_I3PRES_POSS, TIMER_CHMR2_INPUT_I3PRES_POSE)
#define TIMER_CHMR2_INPUT_I3PRES      TIMER_CHMR2_INPUT_I3PRES_MSK

#define TIMER_CHMR2_INPUT_CC3SSEL_POSS 0U
#define TIMER_CHMR2_INPUT_CC3SSEL_POSE 1U
#define TIMER_CHMR2_INPUT_CC3SSEL_MSK  BITS(TIMER_CHMR2_INPUT_CC3SSEL_POSS, TIMER_CHMR2_INPUT_CC3SSEL_POSE)
#define TIMER_CHMR2_INPUT_CC3SSEL      TIMER_CHMR2_INPUT_CC3SSEL_MSK

/****************** Bit definition for TIMER_CCEP register ************************/

#define  TIMER_CCEP_CC4NPOL_POS  15U
#define  TIMER_CCEP_CC4NPOL_MSK  BIT(TIMER_CCEP_CC4NPOL_POS)
#define  TIMER_CCEP_CC4NPOL      TIMER_CCEP_CC4NPOL_MSK

#define  TIMER_CCEP_CC4POL_POS  13U
#define  TIMER_CCEP_CC4POL_MSK  BIT(TIMER_CCEP_CC4POL_POS)
#define  TIMER_CCEP_CC4POL      TIMER_CCEP_CC4POL_MSK

#define  TIMER_CCEP_CC4EN_POS  12U
#define  TIMER_CCEP_CC4EN_MSK  BIT(TIMER_CCEP_CC4EN_POS)
#define  TIMER_CCEP_CC4EN      TIMER_CCEP_CC4EN_MSK

#define  TIMER_CCEP_CC3NPOL_POS  11U
#define  TIMER_CCEP_CC3NPOL_MSK  BIT(TIMER_CCEP_CC3NPOL_POS)
#define  TIMER_CCEP_CC3NPOL      TIMER_CCEP_CC3NPOL_MSK

#define  TIMER_CCEP_CC3NEN_POS  10U
#define  TIMER_CCEP_CC3NEN_MSK  BIT(TIMER_CCEP_CC3NEN_POS)
#define  TIMER_CCEP_CC3NEN      TIMER_CCEP_CC3NEN_MSK

#define  TIMER_CCEP_CC3POL_POS  9U
#define  TIMER_CCEP_CC3POL_MSK  BIT(TIMER_CCEP_CC3POL_POS)
#define  TIMER_CCEP_CC3POL      TIMER_CCEP_CC3POL_MSK

#define  TIMER_CCEP_CC3EN_POS  8U
#define  TIMER_CCEP_CC3EN_MSK  BIT(TIMER_CCEP_CC3EN_POS)
#define  TIMER_CCEP_CC3EN      TIMER_CCEP_CC3EN_MSK

#define  TIMER_CCEP_CC2NPOL_POS  7U
#define  TIMER_CCEP_CC2NPOL_MSK  BIT(TIMER_CCEP_CC2NPOL_POS)
#define  TIMER_CCEP_CC2NPOL      TIMER_CCEP_CC2NPOL_MSK

#define  TIMER_CCEP_CC2NEN_POS  6U
#define  TIMER_CCEP_CC2NEN_MSK  BIT(TIMER_CCEP_CC2NEN_POS)
#define  TIMER_CCEP_CC2NEN      TIMER_CCEP_CC2NEN_MSK

#define  TIMER_CCEP_CC2POL_POS  5U
#define  TIMER_CCEP_CC2POL_MSK  BIT(TIMER_CCEP_CC2POL_POS)
#define  TIMER_CCEP_CC2POL      TIMER_CCEP_CC2POL_MSK

#define  TIMER_CCEP_CC2EN_POS  4U
#define  TIMER_CCEP_CC2EN_MSK  BIT(TIMER_CCEP_CC2EN_POS)
#define  TIMER_CCEP_CC2EN      TIMER_CCEP_CC2EN_MSK

#define  TIMER_CCEP_CC1NPOL_POS  3U
#define  TIMER_CCEP_CC1NPOL_MSK  BIT(TIMER_CCEP_CC1NPOL_POS)
#define  TIMER_CCEP_CC1NPOL      TIMER_CCEP_CC1NPOL_MSK

#define  TIMER_CCEP_CC1NEN_POS  2U
#define  TIMER_CCEP_CC1NEN_MSK  BIT(TIMER_CCEP_CC1NEN_POS)
#define  TIMER_CCEP_CC1NEN      TIMER_CCEP_CC1NEN_MSK

#define  TIMER_CCEP_CC1POL_POS  1U
#define  TIMER_CCEP_CC1POL_MSK  BIT(TIMER_CCEP_CC1POL_POS)
#define  TIMER_CCEP_CC1POL      TIMER_CCEP_CC1POL_MSK

#define  TIMER_CCEP_CC1EN_POS  0U
#define  TIMER_CCEP_CC1EN_MSK  BIT(TIMER_CCEP_CC1EN_POS)
#define  TIMER_CCEP_CC1EN      TIMER_CCEP_CC1EN_MSK

/****************** Bit definition for TIMER_COUNT register ************************/

#define  TIMER_COUNT_CNTV_POSS  0U
#define  TIMER_COUNT_CNTV_POSE  31U
#define  TIMER_COUNT_CNTV_MSK   BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)
#define  TIMER_COUNT_CNTV       TIMER_COUNT_CNTV_MSK

/****************** Bit definition for TIMER_PRES register ************************/

#define  TIMER_PRES_PSCV_POSS  0U
#define  TIMER_PRES_PSCV_POSE  15U
#define  TIMER_PRES_PSCV_MSK   BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)
#define  TIMER_PRES_PSCV       TIMER_PRES_PSCV_MSK

/****************** Bit definition for TIMER_AR register ************************/

#define TIMER_AR_ARV_POSS 0U
#define TIMER_AR_ARV_POSE 31U
#define TIMER_AR_ARV_MSK  BITS(TIMER_AR_ARV_POSS, TIMER_AR_ARV_POSE)
#define TIMER_AR_ARV      TIMER_AR_ARV_MSK

/****************** Bit definition for TIMER_REPAR register ************************/

#define TIMER_REPAR_REPV_POSS 0U
#define TIMER_REPAR_REPV_POSE 7U
#define TIMER_REPAR_REPV_MSK  BITS(TIMER_REPAR_REPV_POSS, TIMER_REPAR_REPV_POSE)
#define TIMER_REPAR_REPV      TIMER_REPAR_REPV_MSK

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define TIMER_CCVAL1_CCRV1_POSS 0U
#define TIMER_CCVAL1_CCRV1_POSE 31U
#define TIMER_CCVAL1_CCRV1_MSK  BITS(TIMER_CCVAL1_CCRV1_POSS, TIMER_CCVAL1_CCRV1_POSE)
#define TIMER_CCVAL1_CCRV1      TIMER_CCVAL1_CCRV1_MSK

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define TIMER_CCVAL2_CCRV2_POSS 0U
#define TIMER_CCVAL2_CCRV2_POSE 31U
#define TIMER_CCVAL2_CCRV2_MSK  BITS(TIMER_CCVAL2_CCRV2_POSS, TIMER_CCVAL2_CCRV2_POSE)
#define TIMER_CCVAL2_CCRV2      TIMER_CCVAL2_CCRV2_MSK

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define TIMER_CCVAL3_CCRV3_POSS 0U
#define TIMER_CCVAL3_CCRV3_POSE 31U
#define TIMER_CCVAL3_CCRV3_MSK  BITS(TIMER_CCVAL3_CCRV3_POSS, TIMER_CCVAL3_CCRV3_POSE)
#define TIMER_CCVAL3_CCRV3      TIMER_CCVAL3_CCRV3_MSK

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define TIMER_CCVAL4_CCRV4_POSS 0U
#define TIMER_CCVAL4_CCRV4_POSE 31U
#define TIMER_CCVAL4_CCRV4_MSK  BITS(TIMER_CCVAL4_CCRV4_POSS, TIMER_CCVAL4_CCRV4_POSE)
#define TIMER_CCVAL4_CCRV4      TIMER_CCVAL4_CCRV4_MSK

/****************** Bit definition for TIMER_BDCFG register ************************/
#define  TIMER_BDCFG_GOEN_POS  15U
#define  TIMER_BDCFG_GOEN_MSK  BIT(TIMER_BDCFG_GOEN_POS)
#define  TIMER_BDCFG_GOEN      TIMER_BDCFG_GOEN_MSK

#define  TIMER_BDCFG_AOEN_POS  14U
#define  TIMER_BDCFG_AOEN_MSK  BIT(TIMER_BDCFG_AOEN_POS)
#define  TIMER_BDCFG_AOEN      TIMER_BDCFG_AOEN_MSK

#define  TIMER_BDCFG_BRKP_POS  13U
#define  TIMER_BDCFG_BRKP_MSK  BIT(TIMER_BDCFG_BRKP_POS)
#define  TIMER_BDCFG_BRKP      TIMER_BDCFG_BRKP_MSK

#define  TIMER_BDCFG_BRKEN_POS  12U
#define  TIMER_BDCFG_BRKEN_MSK  BIT(TIMER_BDCFG_BRKEN_POS)
#define  TIMER_BDCFG_BRKEN      TIMER_BDCFG_BRKEN_MSK

#define  TIMER_BDCFG_OFFSSR_POS  11U
#define  TIMER_BDCFG_OFFSSR_MSK  BIT(TIMER_BDCFG_OFFSSR_POS)
#define  TIMER_BDCFG_OFFSSR      TIMER_BDCFG_OFFSSR_MSK

#define  TIMER_BDCFG_OFFSSI_POS  10U
#define  TIMER_BDCFG_OFFSSI_MSK  BIT(TIMER_BDCFG_OFFSSI_POS)
#define  TIMER_BDCFG_OFFSSI      TIMER_BDCFG_OFFSSI_MSK

#define  TIMER_BDCFG_LOCKLVL_POSS  8U
#define  TIMER_BDCFG_LOCKLVL_POSE  9U
#define  TIMER_BDCFG_LOCKLVL_MSK   BITS(TIMER_BDCFG_LOCKLVL_POSS, TIMER_BDCFG_LOCKLVL_POSE)
#define  TIMER_BDCFG_LOCKLVL       TIMER_BDCFG_LOCKLVL_MSK

#define  TIMER_BDCFG_DT_POSS  0U
#define  TIMER_BDCFG_DT_POSE  7U
#define  TIMER_BDCFG_DT_MSK   BITS(TIMER_BDCFG_DT_POSS, TIMER_BDCFG_DT_POSE)
#define  TIMER_BDCFG_DT       TIMER_BDCFG_DT_MSK

/****************** Bit definition for TIMER_DMAEN register ************************/
#define  TIMER_DMAEN_TRGI_POS  6U
#define  TIMER_DMAEN_TRGI_MSK  BIT(TIMER_DMAEN_TRGI_POS)
#define  TIMER_DMAEN_TRGI      TIMER_DMAEN_TRGI_MSK

#define  TIMER_DMAEN_COM_POS  5U
#define  TIMER_DMAEN_COM_MSK  BIT(TIMER_DMAEN_COM_POS)
#define  TIMER_DMAEN_COM      TIMER_DMAEN_COM_MSK

#define  TIMER_DMAEN_CH4_POS  4U
#define  TIMER_DMAEN_CH4_MSK  BIT(TIMER_DMAEN_CH4_POS)
#define  TIMER_DMAEN_CH4      TIMER_DMAEN_CH4_MSK

#define  TIMER_DMAEN_CH3_POS  3U
#define  TIMER_DMAEN_CH3_MSK  BIT(TIMER_DMAEN_CH3_POS)
#define  TIMER_DMAEN_CH3      TIMER_DMAEN_CH3_MSK

#define  TIMER_DMAEN_CH2_POS  2U
#define  TIMER_DMAEN_CH2_MSK  BIT(TIMER_DMAEN_CH2_POS)
#define  TIMER_DMAEN_CH2      TIMER_DMAEN_CH2_MSK

#define  TIMER_DMAEN_CH1_POS  1U
#define  TIMER_DMAEN_CH1_MSK  BIT(TIMER_DMAEN_CH1_POS)
#define  TIMER_DMAEN_CH1      TIMER_DMAEN_CH1_MSK

#define  TIMER_DMAEN_UPD_POS  0U
#define  TIMER_DMAEN_UPD_MSK  BIT(TIMER_DMAEN_UPD_POS)
#define  TIMER_DMAEN_UPD      TIMER_DMAEN_UPD_MSK

/****************** Bit definition for TIMER_OPTR register ************************/

#define TIMER_OPTR_ETR_RMP_POSS 8U
#define TIMER_OPTR_ETR_RMP_POSE 9U
#define TIMER_OPTR_ETR_RMP_MSK  BITS(TIMER_OPTR_ETR_RMP_POSS, TIMER_OPTR_ETR_RMP_POSE)
#define TIMER_OPTR_ETR_RMP      TIMER_OPTR_ETR_RMP_MSK

#define TIMER_OPTR_CH4_RMP_POSS 6U
#define TIMER_OPTR_CH4_RMP_POSE 7U
#define TIMER_OPTR_CH4_RMP_MSK  BITS(TIMER_OPTR_CH4_RMP_POSS, TIMER_OPTR_CH4_RMP_POSE)
#define TIMER_OPTR_CH4_RMP      TIMER_OPTR_CH4_RMP_MSK

#define TIMER_OPTR_CH3_RMP_POSS 4U
#define TIMER_OPTR_CH3_RMP_POSE 5U
#define TIMER_OPTR_CH3_RMP_MSK  BITS(TIMER_OPTR_CH3_RMP_POSS, TIMER_OPTR_CH3_RMP_POSE)
#define TIMER_OPTR_CH3_RMP      TIMER_OPTR_CH3_RMP_MSK

#define TIMER_OPTR_CH2_RMP_POSS 2U
#define TIMER_OPTR_CH2_RMP_POSE 3U
#define TIMER_OPTR_CH2_RMP_MSK  BITS(TIMER_OPTR_CH2_RMP_POSS, TIMER_OPTR_CH2_RMP_POSE)
#define TIMER_OPTR_CH2_RMP      TIMER_OPTR_CH2_RMP_MSK

#define TIMER_OPTR_CH1_RMP_POSS 0U
#define TIMER_OPTR_CH1_RMP_POSE 1U
#define TIMER_OPTR_CH1_RMP_MSK  BITS(TIMER_OPTR_CH1_RMP_POSS, TIMER_OPTR_CH1_RMP_POSE)
#define TIMER_OPTR_CH1_RMP      TIMER_OPTR_CH1_RMP_MSK

typedef struct
{
    __IO uint32_t CON1;                     // 0x000
    __IO uint32_t CON2;                     // 0x004
    __IO uint32_t SMCON;                    // 0x008
    __O  uint32_t IER;                      // 0x00c
    __O  uint32_t IDR;                      // 0x010
    __I  uint32_t IVS;                      // 0x014
    __I  uint32_t RIF;                      // 0x018
    __I  uint32_t IFM;                      // 0x01c
    __O  uint32_t ICR;                      // 0x020
    __O  uint32_t SGE;                      // 0x024
    __IO uint32_t CHMR1;                    // 0x028
    __IO uint32_t CHMR2;                    // 0x02c
    __IO uint32_t CCEP;                     // 0x030
    __IO uint32_t COUNT;                    // 0x034
    __IO uint32_t PRES;                     // 0x038
    __IO uint32_t AR;                       // 0x03c
    __IO uint32_t REPAR;                    // 0x040
    __IO uint32_t CCVAL1;                   // 0x044
    __IO uint32_t CCVAL2;                   // 0x048
    __IO uint32_t CCVAL3;                   // 0x04c
    __IO uint32_t CCVAL4;                   // 0x050
    __IO uint32_t BDCFG;                    // 0x054
    __IO uint32_t DMAEN;                    // 0x058
    __IO uint32_t OPTR;                     // 0x05c
} TIMER_TypeDef;


#endif
