/**********************************************************************************
 *
 * @file    reg_syscfg.h
 * @brief   SYSCFG Head File
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov 2021     Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __SYSCFG_H__
#define __SYSCFG_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for SYSCFG_REMAP register ************************/

# define  SYSCFG_REMAP_REALBASE_POSS 12U
# define  SYSCFG_REMAP_REALBASE_POSE 16U
# define  SYSCFG_REMAP_REALBASE_MSK  BITS(SYSCFG_REMAP_REALBASE_POSS, SYSCFG_REMAP_REALBASE_POSE)
# define  SYSCFG_REMAP_REALBASE      SYSCFG_REMAP_REALBASE_MSK

# define  SYSCFG_REMAP_REALMOD_POSS 10U
# define  SYSCFG_REMAP_REALMOD_POSE 11U
# define  SYSCFG_REMAP_REALMOD_MSK  BITS(SYSCFG_REMAP_REALMOD_POSS, SYSCFG_REMAP_REALMOD_POSE)
# define  SYSCFG_REMAP_REALMOD      SYSCFG_REMAP_REALMOD_MSK

# define  SYSCFG_REMAP_EFBASE_POSS 4U
# define  SYSCFG_REMAP_EFBASE_POSE 8U
# define  SYSCFG_REMAP_EFBASE_MSK  BITS(SYSCFG_REMAP_EFBASE_POSS, SYSCFG_REMAP_EFBASE_POSE)
# define  SYSCFG_REMAP_EFBASE      SYSCFG_REMAP_EFBASE_MSK

# define  SYSCFG_REMAP_MEMMOD_POSS 2U
# define  SYSCFG_REMAP_MEMMOD_POSE 3U
# define  SYSCFG_REMAP_MEMMOD_MSK  BITS(SYSCFG_REMAP_MEMMOD_POSS, SYSCFG_REMAP_MEMMOD_POSE)
# define  SYSCFG_REMAP_MEMMOD      SYSCFG_REMAP_MEMMOD_MSK

# define  SYSCFG_REMAP_REMAP_POS 0U
# define  SYSCFG_REMAP_REMAP_MSK BIT(SYSCFG_REMAP_REMAP_POS)
# define  SYSCFG_REMAP_REMAP     SYSCFG_REMAP_REMAP_MSK

/****************** Bit definition for SYSCFG_ENGEN register ************************/

# define  SYSCFG_ENGEN_ENGEN_POSS 0U
# define  SYSCFG_ENGEN_ENGEN_POSE 31U
# define  SYSCFG_ENGEN_ENGEN_MSK  BITS(SYSCFG_ENGEN_ENGEN_POSS, SYSCFG_ENGEN_ENGEN_POSE)
# define  SYSCFG_ENGEN_ENGEN      SYSCFG_ENGEN_ENGEN_MSK

# define  SYSCFG_ENGEN_ENGFLAG_POS 0U
# define  SYSCFG_ENGEN_ENGFLAG_MSK BIT(SYSCFG_ENGEN_ENGFLAG_POS)
# define  SYSCFG_ENGEN_ENGFLAG     SYSCFG_ENGEN_ENGFLAG_MSK

/****************** Bit definition for SYSCFG_PWR register ************************/

# define  SYSCFG_PWR_LDOUSBSBY_POS 5U
# define  SYSCFG_PWR_LDOUSBSBY_MSK BIT(SYSCFG_PWR_LDOUSBSBY_POS)
# define  SYSCFG_PWR_LDOUSBSBY     SYSCFG_PWR_LDOUSBSBY_MSK

# define  SYSCFG_PWR_LDOUSBEN_POS 4U
# define  SYSCFG_PWR_LDOUSBEN_MSK BIT(SYSCFG_PWR_LDOUSBEN_POS)
# define  SYSCFG_PWR_LDOUSBEN     SYSCFG_PWR_LDOUSBEN_MSK

# define  SYSCFG_PWR_RESSRC_POS 1U
# define  SYSCFG_PWR_RESSRC_MSK BIT(SYSCFG_PWR_RESSRC_POS)
# define  SYSCFG_PWR_RESSRC     SYSCFG_PWR_RESSRC_MSK

# define  SYSCFG_PWR_RESEN_POS 0U
# define  SYSCFG_PWR_RESEN_MSK BIT(SYSCFG_PWR_RESEN_POS)
# define  SYSCFG_PWR_RESEN     SYSCFG_PWR_RESEN_MSK

/****************** Bit definition for SYSCFG_IRSEL register ************************/

# define  SYSCFG_IRSEL_PLR_POS 8U
# define  SYSCFG_IRSEL_PLR_MSK BIT(SYSCFG_IRSEL_PLR_POS)
# define  SYSCFG_IRSEL_PLR     SYSCFG_IRSEL_PLR_MSK

# define  SYSCFG_IRSEL_SEL2_POSS 4U
# define  SYSCFG_IRSEL_SEL2_POSE 7U
# define  SYSCFG_IRSEL_SEL2_MSK  BITS(SYSCFG_IRSEL_SEL2_POSS, SYSCFG_IRSEL_SEL2_POSE)
# define  SYSCFG_IRSEL_SEL2      SYSCFG_IRSEL_SEL2_MSK

# define  SYSCFG_IRSEL_SEL1_POSS 0U
# define  SYSCFG_IRSEL_SEL1_POSE 3U
# define  SYSCFG_IRSEL_SEL1_MSK  BITS(SYSCFG_IRSEL_SEL1_POSS, SYSCFG_IRSEL_SEL1_POSE)
# define  SYSCFG_IRSEL_SEL1      SYSCFG_IRSEL_SEL1_MSK

/****************** Bit definition for SYSCFG_SYSTRIM register ************************/

# define  SYSCFG_SYSTRIM_USBLDOTRIM_POSS 16U
# define  SYSCFG_SYSTRIM_USBLDOTRIM_POSE 18U
# define  SYSCFG_SYSTRIM_USBLDOTRIM_MSK  BITS(SYSCFG_SYSTRIM_USBLDOTRIM_POSS, SYSCFG_SYSTRIM_USBLDOTRIM_POSE)
# define  SYSCFG_SYSTRIM_USBLDOTRIM      SYSCFG_SYSTRIM_USBLDOTRIM_MSK

# define  SYSCFG_SYSTRIM_LVDTRIM_POSS 8U
# define  SYSCFG_SYSTRIM_LVDTRIM_POSE 9U
# define  SYSCFG_SYSTRIM_LVDTRIM_MSK  BITS(SYSCFG_SYSTRIM_LVDTRIM_POSS, SYSCFG_SYSTRIM_LVDTRIM_POSE)
# define  SYSCFG_SYSTRIM_LVDTRIM      SYSCFG_SYSTRIM_LVDTRIM_MSK

# define  SYSCFG_SYSTRIM_BGTRIM_POSS 0U
# define  SYSCFG_SYSTRIM_BGTRIM_POSE 3U
# define  SYSCFG_SYSTRIM_BGTRIM_MSK  BITS(SYSCFG_SYSTRIM_BGTRIM_POSS, SYSCFG_SYSTRIM_BGTRIM_POSE)
# define  SYSCFG_SYSTRIM_BGTRIM      SYSCFG_SYSTRIM_BGTRIM_MSK

/****************** Bit definition for SYSCFG_CLKTRIM register ************************/

# define  SYSCFG_CLKTRIM_PLLFNS_POSS 28U
# define  SYSCFG_CLKTRIM_PLLFNS_POSE 29U
# define  SYSCFG_CLKTRIM_PLLFNS_MSK  BITS(SYSCFG_CLKTRIM_PLLFNS_POSS, SYSCFG_CLKTRIM_PLLFNS_POSE)
# define  SYSCFG_CLKTRIM_PLLFNS      SYSCFG_CLKTRIM_PLLFNS_MSK

# define  SYSCFG_CLKTRIM_HRC48TRIM_POSS 16U
# define  SYSCFG_CLKTRIM_HRC48TRIM_POSE 24U
# define  SYSCFG_CLKTRIM_HRC48TRIM_MSK  BITS(SYSCFG_CLKTRIM_HRC48TRIM_POSS, SYSCFG_CLKTRIM_HRC48TRIM_POSE)
# define  SYSCFG_CLKTRIM_HRC48TRIM      SYSCFG_CLKTRIM_HRC48TRIM_MSK

# define  SYSCFG_CLKTRIM_LRCTRIM_POSS 8U
# define  SYSCFG_CLKTRIM_LRCTRIM_POSE 14U
# define  SYSCFG_CLKTRIM_LRCTRIM_MSK  BITS(SYSCFG_CLKTRIM_LRCTRIM_POSS, SYSCFG_CLKTRIM_LRCTRIM_POSE)
# define  SYSCFG_CLKTRIM_LRCTRIM      SYSCFG_CLKTRIM_LRCTRIM_MSK

# define  SYSCFG_CLKTRIM_HRCTRIMM_POSS 0U
# define  SYSCFG_CLKTRIM_HRCTRIM_POSE  7U
# define  SYSCFG_CLKTRIM_HRCTRIM_MSK   BITS(SYSCFG_CLKTRIM_HRCTRIMM_POSS, SYSCFG_CLKTRIM_HRCTRIM_POSE)
# define  SYSCFG_CLKTRIM_HRCTRIM       SYSCFG_CLKTRIM_HRCTRIM_MSK

/****************** Bit definition for SYSCFG_OSCTRIM register ************************/

# define  SYSCFG_OSCTRIM_LOSCRCNT_POSS 12U
# define  SYSCFG_OSCTRIM_LOSCRCNT_POSE 13U
# define  SYSCFG_OSCTRIM_LOSCRCNT_MSK  BITS(SYSCFG_OSCTRIM_LOSCRCNT_POSS, SYSCFG_OSCTRIM_LOSCRCNT_POSE)
# define  SYSCFG_OSCTRIM_LOSCRCNT      SYSCFG_OSCTRIM_LOSCRCNT_MSK

# define  SYSCFG_OSCTRIM_LOSCCURSEL_POSS 8U
# define  SYSCFG_OSCTRIM_LOSCCURSEL_POSE 10U
# define  SYSCFG_OSCTRIM_LOSCCURSEL_MSK  BITS(SYSCFG_OSCTRIM_LOSCCURSEL_POSS, SYSCFG_OSCTRIM_LOSCCURSEL_POSE)
# define  SYSCFG_OSCTRIM_LOSCCURSEL      SYSCFG_OSCTRIM_LOSCCURSEL_MSK

# define  SYSCFG_OSCTRIM_HOSCRCNT_POSS 4U
# define  SYSCFG_OSCTRIM_HOSCRCNT_POSE 5U
# define  SYSCFG_OSCTRIM_HOSCRCNT_MSK  BITS(SYSCFG_OSCTRIM_HOSCRCNT_POSS, SYSCFG_OSCTRIM_HOSCRCNT_POSE)
# define  SYSCFG_OSCTRIM_HOSCRCNT      SYSCFG_OSCTRIM_HOSCRCNT_MSK

# define  SYSCFG_OSCTRIM_HOSCCURSEL_POSS 0U
# define  SYSCFG_OSCTRIM_HOSCCURSEL_POSE 1U
# define  SYSCFG_OSCTRIM_HOSCCURSEL_MSK  BITS(SYSCFG_OSCTRIM_HOSCCURSEL_POSS, SYSCFG_OSCTRIM_HOSCCURSEL_POSE)
# define  SYSCFG_OSCTRIM_HOSCCURSEL      SYSCFG_OSCTRIM_HOSCCURSEL_MSK

/****************** Bit definition for SYSCFG_IPTRIM register ************************/

# define  SYSCFG_IPTRIM_CMP2TRIM_POSS 8U
# define  SYSCFG_IPTRIM_CMP2TRIM_POSE 15U
# define  SYSCFG_IPTRIM_CMP2TRIM_MSK  BITS(SYSCFG_IPTRIM_CMP2TRIM_POSS, SYSCFG_IPTRIM_CMP2TRIM_POSE)
# define  SYSCFG_IPTRIM_CMP2TRIM      SYSCFG_IPTRIM_CMP2TRIM_MSK

# define  SYSCFG_IPTRIM_CMP1TRIM_POSS 0U
# define  SYSCFG_IPTRIM_CMP1TRIM_POSE 7U
# define  SYSCFG_IPTRIM_CMP1TRIM_MSK  BITS(SYSCFG_IPTRIM_CMP1TRIM_POSS, SYSCFG_IPTRIM_CMP1TRIM_POSE)
# define  SYSCFG_IPTRIM_CMP1TRIM      SYSCFG_IPTRIM_CMP1TRIM_MSK

/****************** Bit definition for SYSCFG_AHBIPEN register ************************/

# define  SYSCFG_AHBIPEN_GPDEN_POS 19U
# define  SYSCFG_AHBIPEN_GPDEN_MSK BIT(SYSCFG_AHBIPEN_GPDEN_POS)
# define  SYSCFG_AHBIPEN_GPDEN     SYSCFG_AHBIPEN_GPDEN_MSK

# define  SYSCFG_AHBIPEN_GPCEN_POS 18U
# define  SYSCFG_AHBIPEN_GPCEN_MSK BIT(SYSCFG_AHBIPEN_GPCEN_POS)
# define  SYSCFG_AHBIPEN_GPCEN     SYSCFG_AHBIPEN_GPCEN_MSK

# define  SYSCFG_AHBIPEN_GPBEN_POS 17U
# define  SYSCFG_AHBIPEN_GPBEN_MSK BIT(SYSCFG_AHBIPEN_GPBEN_POS)
# define  SYSCFG_AHBIPEN_GPBEN     SYSCFG_AHBIPEN_GPBEN_MSK

# define  SYSCFG_AHBIPEN_GPAEN_POS 16U
# define  SYSCFG_AHBIPEN_GPAEN_MSK BIT(SYSCFG_AHBIPEN_GPAEN_POS)
# define  SYSCFG_AHBIPEN_GPAEN     SYSCFG_AHBIPEN_GPAEN_MSK

# define  SYSCFG_AHBIPEN_CALCEN_POS 15U
# define  SYSCFG_AHBIPEN_CALCEN_MSK BIT(SYSCFG_AHBIPEN_CALCEN_POS)
# define  SYSCFG_AHBIPEN_CALCEN     SYSCFG_AHBIPEN_CALCEN_MSK

# define  SYSCFG_AHBIPEN_USBEN_POS 14U
# define  SYSCFG_AHBIPEN_USBEN_MSK BIT(SYSCFG_AHBIPEN_USBEN_POS)
# define  SYSCFG_AHBIPEN_USBEN     SYSCFG_AHBIPEN_USBEN_MSK

# define  SYSCFG_AHBIPEN_AESEN_POS 13U
# define  SYSCFG_AHBIPEN_AESEN_MSK BIT(SYSCFG_AHBIPEN_AESEN_POS)
# define  SYSCFG_AHBIPEN_AESEN     SYSCFG_AHBIPEN_AESEN_MSK

# define  SYSCFG_AHBIPEN_CRCEN_POS 12U
# define  SYSCFG_AHBIPEN_CRCEN_MSK BIT(SYSCFG_AHBIPEN_CRCEN_POS)
# define  SYSCFG_AHBIPEN_CRCEN     SYSCFG_AHBIPEN_CRCEN_MSK

# define  SYSCFG_AHBIPEN_MSWDEN_POS 11U
# define  SYSCFG_AHBIPEN_MSWDEN_MSK BIT(SYSCFG_AHBIPEN_MSWDEN_POS)
# define  SYSCFG_AHBIPEN_MSWDEN     SYSCFG_AHBIPEN_MSWDEN_MSK

# define  SYSCFG_AHBIPEN_CSUEN_POS 10U
# define  SYSCFG_AHBIPEN_CSUEN_MSK BIT(SYSCFG_AHBIPEN_CSUEN_POS)
# define  SYSCFG_AHBIPEN_CSUEN     SYSCFG_AHBIPEN_CSUEN_MSK

# define  SYSCFG_AHBIPEN_KBCUEN_POS 7U
# define  SYSCFG_AHBIPEN_KBCUEN_MSK BIT(SYSCFG_AHBIPEN_KBCUEN_POS)
# define  SYSCFG_AHBIPEN_KBCUEN     SYSCFG_AHBIPEN_KBCUEN_MSK

# define  SYSCFG_AHBIPEN_RTCEN_POS 6U
# define  SYSCFG_AHBIPEN_RTCEN_MSK BIT(SYSCFG_AHBIPEN_RTCEN_POS)
# define  SYSCFG_AHBIPEN_RTCEN     SYSCFG_AHBIPEN_RTCEN_MSK

# define  SYSCFG_AHBIPEN_DMA1EN_POS 0U
# define  SYSCFG_AHBIPEN_DMA1EN_MSK BIT(SYSCFG_AHBIPEN_DMA1EN_POS)
# define  SYSCFG_AHBIPEN_DMA1EN     SYSCFG_AHBIPEN_DMA1EN_MSK

/****************** Bit definition for SYSCFG_APB1IPEN register ************************/

# define  SYSCFG_APB1IPEN_I2C2EN_POS 22U
# define  SYSCFG_APB1IPEN_I2C2EN_MSK BIT(SYSCFG_APB1IPEN_I2C2EN_POS)
# define  SYSCFG_APB1IPEN_I2C2EN     SYSCFG_APB1IPEN_I2C2EN_MSK

# define  SYSCFG_APB1IPEN_I2C1EN_POS 21U
# define  SYSCFG_APB1IPEN_I2C1EN_MSK BIT(SYSCFG_APB1IPEN_I2C1EN_POS)
# define  SYSCFG_APB1IPEN_I2C1EN     SYSCFG_APB1IPEN_I2C1EN_MSK

# define  SYSCFG_APB1IPEN_UART4EN_POS 19U
# define  SYSCFG_APB1IPEN_UART4EN_MSK BIT(SYSCFG_APB1IPEN_UART4EN_POS)
# define  SYSCFG_APB1IPEN_UART4EN     SYSCFG_APB1IPEN_UART4EN_MSK

# define  SYSCFG_APB1IPEN_UART3EN_POS 18U
# define  SYSCFG_APB1IPEN_UART3EN_MSK BIT(SYSCFG_APB1IPEN_UART3EN_POS)
# define  SYSCFG_APB1IPEN_UART3EN     SYSCFG_APB1IPEN_UART3EN_MSK

# define  SYSCFG_APB1IPEN_UART2EN_POS 17U
# define  SYSCFG_APB1IPEN_UART2EN_MSK BIT(SYSCFG_APB1IPEN_UART2EN_POS)
# define  SYSCFG_APB1IPEN_UART2EN     SYSCFG_APB1IPEN_UART2EN_MSK

# define  SYSCFG_APB1IPEN_SPI3EN_POS 15U
# define  SYSCFG_APB1IPEN_SPI3EN_MSK BIT(SYSCFG_APB1IPEN_SPI3EN_POS)
# define  SYSCFG_APB1IPEN_SPI3EN     SYSCFG_APB1IPEN_SPI3EN_MSK

# define  SYSCFG_APB1IPEN_SPI2EN_POS 14U
# define  SYSCFG_APB1IPEN_SPI2EN_MSK BIT(SYSCFG_APB1IPEN_SPI2EN_POS)
# define  SYSCFG_APB1IPEN_SPI2EN     SYSCFG_APB1IPEN_SPI2EN_MSK

# define  SYSCFG_APB1IPEN_IWDTEN_POS 12U
# define  SYSCFG_APB1IPEN_IWDTEN_MSK BIT(SYSCFG_APB1IPEN_IWDTEN_POS)
# define  SYSCFG_APB1IPEN_IWDTEN     SYSCFG_APB1IPEN_IWDTEN_MSK

# define  SYSCFG_APB1IPEN_WWDTEN_POS 11U
# define  SYSCFG_APB1IPEN_WWDTEN_MSK BIT(SYSCFG_APB1IPEN_WWDTEN_POS)
# define  SYSCFG_APB1IPEN_WWDTEN     SYSCFG_APB1IPEN_WWDTEN_MSK

# define  SYSCFG_APB1IPEN_BS16T1EN_POS 4U
# define  SYSCFG_APB1IPEN_BS16T1EN_MSK BIT(SYSCFG_APB1IPEN_BS16T1EN_POS)
# define  SYSCFG_APB1IPEN_BS16T1EN     SYSCFG_APB1IPEN_BS16T1EN_MSK

# define  SYSCFG_APB1IPEN_GP16C4T3EN_POS 3U
# define  SYSCFG_APB1IPEN_GP16C4T3EN_MSK BIT(SYSCFG_APB1IPEN_GP16C4T3EN_POS)
# define  SYSCFG_APB1IPEN_GP16C4T3EN     SYSCFG_APB1IPEN_GP16C4T3EN_MSK

# define  SYSCFG_APB1IPEN_GP16C4T2EN_POS 2U
# define  SYSCFG_APB1IPEN_GP16C4T2EN_MSK BIT(SYSCFG_APB1IPEN_GP16C4T2EN_POS)
# define  SYSCFG_APB1IPEN_GP16C4T2EN     SYSCFG_APB1IPEN_GP16C4T2EN_MSK

# define  SYSCFG_APB1IPEN_GP16C4T1EN_POS 1U
# define  SYSCFG_APB1IPEN_GP16C4T1EN_MSK BIT(SYSCFG_APB1IPEN_GP16C4T1EN_POS)
# define  SYSCFG_APB1IPEN_GP16C4T1EN     SYSCFG_APB1IPEN_GP16C4T1EN_MSK

# define  SYSCFG_APB1IPEN_GP32C4T1EN_POS 1U
# define  SYSCFG_APB1IPEN_GP32C4T1EN_MSK BIT(SYSCFG_APB1IPEN_GP32C4T1EN_POS)
# define  SYSCFG_APB1IPEN_GP32C4T1EN     SYSCFG_APB1IPEN_GP32C4T1EN_MSK

/****************** Bit definition for SYSCFG_APB2IPEN register ************************/

# define  SYSCFG_APB2IPEN_CMPEN_POS 23U
# define  SYSCFG_APB2IPEN_CMPEN_MSK BIT(SYSCFG_APB2IPEN_CMPEN_POS)
# define  SYSCFG_APB2IPEN_CMPEN     SYSCFG_APB2IPEN_CMPEN_MSK

# define  SYSCFG_APB2IPEN_GP16C2T4EN_POS 19U
# define  SYSCFG_APB2IPEN_GP16C2T4EN_MSK BIT(SYSCFG_APB2IPEN_GP16C2T4EN_POS)
# define  SYSCFG_APB2IPEN_GP16C2T4EN     SYSCFG_APB2IPEN_GP16C2T4EN_MSK

# define  SYSCFG_APB2IPEN_GP16C2T3EN_POS 18U
# define  SYSCFG_APB2IPEN_GP16C2T3EN_MSK BIT(SYSCFG_APB2IPEN_GP16C2T3EN_POS)
# define  SYSCFG_APB2IPEN_GP16C2T3EN     SYSCFG_APB2IPEN_GP16C2T3EN_MSK

# define  SYSCFG_APB2IPEN_GP16C2T2EN_POS 17U
# define  SYSCFG_APB2IPEN_GP16C2T2EN_MSK BIT(SYSCFG_APB2IPEN_GP16C2T2EN_POS)
# define  SYSCFG_APB2IPEN_GP16C2T2EN     SYSCFG_APB2IPEN_GP16C2T2EN_MSK

# define  SYSCFG_APB2IPEN_GP16C2T1EN_POS 16U
# define  SYSCFG_APB2IPEN_GP16C2T1EN_MSK BIT(SYSCFG_APB2IPEN_GP16C2T1EN_POS)
# define  SYSCFG_APB2IPEN_GP16C2T1EN     SYSCFG_APB2IPEN_GP16C2T1EN_MSK

# define  SYSCFG_APB2IPEN_UART1EN_POS 14U
# define  SYSCFG_APB2IPEN_UART1EN_MSK BIT(SYSCFG_APB2IPEN_UART1EN_POS)
# define  SYSCFG_APB2IPEN_UART1EN     SYSCFG_APB2IPEN_UART1EN_MSK

# define  SYSCFG_APB2IPEN_SPI1EN_POS 12U
# define  SYSCFG_APB2IPEN_SPI1EN_MSK BIT(SYSCFG_APB2IPEN_SPI1EN_POS)
# define  SYSCFG_APB2IPEN_SPI1EN     SYSCFG_APB2IPEN_SPI1EN_MSK

# define  SYSCFG_APB2IPEN_AD16C4T1EN_POS 11U
# define  SYSCFG_APB2IPEN_AD16C4T1EN_MSK BIT(SYSCFG_APB2IPEN_AD16C4T1EN_POS)
# define  SYSCFG_APB2IPEN_AD16C4T1EN     SYSCFG_APB2IPEN_AD16C4T1EN_MSK

# define  SYSCFG_APB2IPEN_ADCEN_POS 9U
# define  SYSCFG_APB2IPEN_ADCEN_MSK BIT(SYSCFG_APB2IPEN_ADCEN_POS)
# define  SYSCFG_APB2IPEN_ADCEN     SYSCFG_APB2IPEN_ADCEN_MSK

/****************** Bit definition for SYSCFG_MEMMOD register ************************/

# define  SYSCFG_MEMMOD_SMOD_POSS 8U
# define  SYSCFG_MEMMOD_SMOD_POSE 15U
# define  SYSCFG_MEMMOD_SMOD_MSK  BITS(SYSCFG_MEMMOD_SMOD_POSS, SYSCFG_MEMMOD_SMOD_POSE)
# define  SYSCFG_MEMMOD_SMOD      SYSCFG_MEMMOD_SMOD_MSK

# define  SYSCFG_MEMMOD_FMOD_POSS 0U
# define  SYSCFG_MEMMOD_FMOD_POSE 7U
# define  SYSCFG_MEMMOD_FMOD_MSK  BITS(SYSCFG_MEMMOD_FMOD_POSS, SYSCFG_MEMMOD_FMOD_POSE)
# define  SYSCFG_MEMMOD_FMOD      SYSCFG_MEMMOD_FMOD_MSK

/****************** Bit definition for SYSCFG_ADCVREF register ************************/

# define  SYSCFG_ADCVREF_ADCVREF_POSS 0U
# define  SYSCFG_ADCVREF_ADCVREF_POSE 11U
# define  SYSCFG_ADCVREF_ADCVREF_MSK  BITS(SYSCFG_ADCVREF_ADCVREF_POSS, SYSCFG_ADCVREF_ADCVREF_POSE)
# define  SYSCFG_ADCVREF_ADCVREF      SYSCFG_ADCVREF_ADCVREF_MSK

/****************** Bit definition for SYSCFG_ADCTEMP register ************************/

# define  SYSCFG_ADCTEMP_ADCTEMPH_POSS 16U
# define  SYSCFG_ADCTEMP_ADCTEMPH_POSE 27U
# define  SYSCFG_ADCTEMP_ADCTEMPH_MSK  BITS(SYSCFG_ADCTEMP_ADCTEMPH_POSS, SYSCFG_ADCTEMP_ADCTEMPH_POSE)
# define  SYSCFG_ADCTEMP_ADCTEMPH      SYSCFG_ADCTEMP_ADCTEMPH_MSK

# define  SYSCFG_ADCTEMP_ADCTEMPL_POSS 0U
# define  SYSCFG_ADCTEMP_ADCTEMPL_POSE 11U
# define  SYSCFG_ADCTEMP_ADCTEMPL_MSK  BITS(SYSCFG_ADCTEMP_ADCTEMPL_POSS, SYSCFG_ADCTEMP_ADCTEMPL_POSE)
# define  SYSCFG_ADCTEMP_ADCTEMPL      SYSCFG_ADCTEMP_ADCTEMPL_MSK

/****************** Bit definition for SYSCFG_SYSSET register ************************/

# define  SYSCFG_SYSSET_SYS_IWDTEN_POSS 16U
# define  SYSCFG_SYSSET_SYS_IWDTEN_POSE 23U
# define  SYSCFG_SYSSET_SYS_IWDTEN_MSK  BITS(SYSCFG_SYSSET_SYS_IWDTEN_POSS, SYSCFG_SYSSET_SYS_IWDTEN_POSE)
# define  SYSCFG_SYSSET_SYS_IWDTEN      SYSCFG_SYSSET_SYS_IWDTEN_MSK

# define  SYSCFG_SYSSET_SYS_BOREN_POSS 8U
# define  SYSCFG_SYSSET_SYS_BOREN_POSE 15U
# define  SYSCFG_SYSSET_SYS_BOREN_MSK  BITS(SYSCFG_SYSSET_SYS_BOREN_POSS, SYSCFG_SYSSET_SYS_BOREN_POSE)
# define  SYSCFG_SYSSET_SYS_BOREN      SYSCFG_SYSSET_SYS_BOREN_MSK

# define  SYSCFG_SYSSET_SYS_BORLS_POSS 0U
# define  SYSCFG_SYSSET_SYS_BORLS_POSE 2U
# define  SYSCFG_SYSSET_SYS_BORLS_MSK  BITS(SYSCFG_SYSSET_SYS_BORLS_POSS, SYSCFG_SYSSET_SYS_BORLS_POSE)
# define  SYSCFG_SYSSET_SYS_BORLS      SYSCFG_SYSSET_SYS_BORLS_MSK

/****************** Bit definition for SYSCFG_CFG register ************************/

# define  SYSCFG_CFG_DBGHEN_POSS 16U
# define  SYSCFG_CFG_DBGHEN_POSE 31U
# define  SYSCFG_CFG_DBGHEN_MSK  BITS(SYSCFG_CFG_DBGHEN_POSS, SYSCFG_CFG_DBGHEN_POSE)
# define  SYSCFG_CFG_DBGHEN      SYSCFG_CFG_DBGHEN_MSK

# define  SYSCFG_CFG_LVDLCK_POS 14U
# define  SYSCFG_CFG_LVDLCK_MSK BIT(SYSCFG_CFG_LVDLCK_POS)
# define  SYSCFG_CFG_LVDLCK     SYSCFG_CFG_LVDLCK_MSK

# define  SYSCFG_CFG_CSSLCK_POS 13U
# define  SYSCFG_CFG_CSSLCK_MSK BIT(SYSCFG_CFG_CSSLCK_POS)
# define  SYSCFG_CFG_CSSLCK     SYSCFG_CFG_CSSLCK_MSK

# define  SYSCFG_CFG_CPULCK_POS 12U
# define  SYSCFG_CFG_CPULCK_MSK BIT(SYSCFG_CFG_CPULCK_POS)
# define  SYSCFG_CFG_CPULCK     SYSCFG_CFG_CPULCK_MSK

# define  SYSCFG_CFG_VTESTSEL_POSS 8U
# define  SYSCFG_CFG_VTESTSEL_POSE 11U
# define  SYSCFG_CFG_VTESTSEL_MSK  BITS(SYSCFG_CFG_VTESTSEL_POSS, SYSCFG_CFG_VTESTSEL_POSE)
# define  SYSCFG_CFG_VTESTSEL      SYSCFG_CFG_VTESTSEL_MSK

# define  SYSCFG_CFG_BKREADY_POS 0U
# define  SYSCFG_CFG_BKREADY_MSK BIT(SYSCFG_CFG_BKREADY_POS)
# define  SYSCFG_CFG_BKREADY     SYSCFG_CFG_BKREADY_MSK

/****************** Bit definition for SYSCFG_PWRCON register ************************/

# define  SYSCFG_PWRCON_IWDTEN_POSS 15U
# define  SYSCFG_PWRCON_IWDTEN_MSK  BIT(SYSCFG_PWRCON_IWDTEN_POSS)
# define  SYSCFG_PWRCON_IWDTEN      SYSCFG_PWRCON_IWDTEN_MSK

# define  SYSCFG_PWRCON_BOREN_POSS 11U
# define  SYSCFG_PWRCON_BOREN_MSK  BIT(SYSCFG_PWRCON_BOREN_POSS)
# define  SYSCFG_PWRCON_BOREN      SYSCFG_PWRCON_BOREN_MSK

# define  SYSCFG_PWRCON_BORLS_POSS 8U
# define  SYSCFG_PWRCON_BORLS_POSE 10U
# define  SYSCFG_PWRCON_BORLS_MSK  BITS(SYSCFG_PWRCON_BORLS_POSS, SYSCFG_PWRCON_BORLS_POSE)
# define  SYSCFG_PWRCON_BORLS      SYSCFG_PWRCON_BORLS_MSK

# define  SYSCFG_PWRCON_LVDEN_POS 4U
# define  SYSCFG_PWRCON_LVDEN_MSK BIT(SYSCFG_PWRCON_LVDEN_POS)
# define  SYSCFG_PWRCON_LVDEN     SYSCFG_PWRCON_LVDEN_MSK

# define  SYSCFG_PWRCON_LVDLS_POSS 0U
# define  SYSCFG_PWRCON_LVDLS_POSE 3U
# define  SYSCFG_PWRCON_LVDLS_MSK  BITS(SYSCFG_PWRCON_LVDLS_POSS, SYSCFG_PWRCON_LVDLS_POSE)
# define  SYSCFG_PWRCON_LVDLS      SYSCFG_PWRCON_LVDLS_MSK

/****************** Bit definition for SYSCFG_WKTRIM register ************************/

# define  SYSCFG_WKTRIM_LOSCRCNT_POSS 28U
# define  SYSCFG_WKTRIM_LOSCRCNT_POSE 29U
# define  SYSCFG_WKTRIM_LOSCRCNT_MSK  BITS(SYSCFG_WKTRIM_LOSCRCNT_POSS, SYSCFG_WKTRIM_LOSCRCNT_POSE)
# define  SYSCFG_WKTRIM_LOSCRCNT      SYSCFG_WKTRIM_LOSCRCNT_MSK

# define  SYSCFG_WKTRIM_LOSCCURSEL_POSS 24U
# define  SYSCFG_WKTRIM_LOSCCURSEL_POSE 26U
# define  SYSCFG_WKTRIM_LOSCCURSEL_MSK  BITS(SYSCFG_WKTRIM_LOSCCURSEL_POSS, SYSCFG_WKTRIM_LOSCCURSEL_POSE)
# define  SYSCFG_WKTRIM_LOSCCURSEL      SYSCFG_WKTRIM_LOSCCURSEL_MSK

# define  SYSCFG_WKTRIM_LDOCKVT_POSS 16U
# define  SYSCFG_WKTRIM_LDOCKVT_POSE 18U
# define  SYSCFG_WKTRIM_LDOCKVT_MSK  BITS(SYSCFG_WKTRIM_LDOCKVT_POSS, SYSCFG_WKTRIM_LDOCKVT_POSE)
# define  SYSCFG_WKTRIM_LDOCKVT      SYSCFG_WKTRIM_LDOCKVT_MSK

# define  SYSCFG_WKTRIM_LVDTRIM_POSS 12U
# define  SYSCFG_WKTRIM_LVDTRIM_POSE 13U
# define  SYSCFG_WKTRIM_LVDTRIM_MSK  BITS(SYSCFG_WKTRIM_LVDTRIM_POSS, SYSCFG_WKTRIM_LVDTRIM_POSE)
# define  SYSCFG_WKTRIM_LVDTRIM      SYSCFG_WKTRIM_LVDTRIM_MSK

# define  SYSCFG_WKTRIM_BGTRIM_POSS 8U
# define  SYSCFG_WKTRIM_BGTRIM_POSE 11U
# define  SYSCFG_WKTRIM_BGTRIM_MSK  BITS(SYSCFG_WKTRIM_BGTRIM_POSS, SYSCFG_WKTRIM_BGTRIM_POSE)
# define  SYSCFG_WKTRIM_BGTRIM      SYSCFG_WKTRIM_BGTRIM_MSK

# define  SYSCFG_WKTRIM_LRCTRIM_POSS 0U
# define  SYSCFG_WKTRIM_LRCTRIM_POSE 6U
# define  SYSCFG_WKTRIM_LRCTRIM_MSK  BITS(SYSCFG_WKTRIM_LRCTRIM_POSS, SYSCFG_WKTRIM_LRCTRIM_POSE)
# define  SYSCFG_WKTRIM_LRCTRIM      SYSCFG_WKTRIM_LRCTRIM_MSK

/****************** Bit definition for SYSCFG_WKUP register ************************/

# define  SYSCFG_WKUP_WKEG_POSS 16U
# define  SYSCFG_WKUP_WKEG_POSE 31U
# define  SYSCFG_WKUP_WKEG_MSK  BITS(SYSCFG_WKUP_WKEG_POSS, SYSCFG_WKUP_WKEG_POSE)
# define  SYSCFG_WKUP_WKEG      SYSCFG_WKUP_WKEG_MSK

# define  SYSCFG_WKUP_WKEN_POSS 0U
# define  SYSCFG_WKUP_WKEN_POSE 15U
# define  SYSCFG_WKUP_WKEN_MSK  BITS(SYSCFG_WKUP_WKEN_POSS, SYSCFG_WKUP_WKEN_POSE)
# define  SYSCFG_WKUP_WKEN      SYSCFG_WKUP_WKEN_MSK

/****************** Bit definition for SYSCFG_WKSR register ************************/

# define  SYSCFG_WKSR_WKCLR_POSS 31U
# define  SYSCFG_WKSR_WKCLR_MSK  BIT(SYSCFG_WKSR_WKCLR_POSS)
# define  SYSCFG_WKSR_WKCLR      SYSCFG_WKSR_WKCLR_MSK

# define  SYSCFG_WKSR_LPLS_POSS 28U
# define  SYSCFG_WKSR_LPLS_POSE 29U
# define  SYSCFG_WKSR_LPLS_MSK  BITS(SYSCFG_WKSR_LPLS_POSS, SYSCFG_WKSR_LPLS_POSE)
# define  SYSCFG_WKSR_LPLS      SYSCFG_WKSR_LPLS_MSK

# define  SYSCFG_WKSR_FLAG_POSS 16U
# define  SYSCFG_WKSR_FLAG_MSK  BIT(SYSCFG_WKSR_FLAG_POSS)
# define  SYSCFG_WKSR_FLAG      SYSCFG_WKSR_FLAG_MSK

# define  SYSCFG_WKSR_FG_POSS 0U
# define  SYSCFG_WKSR_FG_POSE 15U
# define  SYSCFG_WKSR_FG_MSK  BITS(SYSCFG_WKSR_FG_POSS, SYSCFG_WKSR_FG_POSE)
# define  SYSCFG_WKSR_FG      SYSCFG_WKSR_FG_MSK

/****************** Bit definition for SYSCFG_BKREG0 register ************************/

# define  SYSCFG_BKREG0_BKREG0_POSS 0U
# define  SYSCFG_BKREG0_BKREG0_POSE 31U
# define  SYSCFG_BKREG0_BKREG0_MSK  BITS(SYSCFG_BKREG0_BKREG0_POSS, SYSCFG_BKREG0_BKREG0_POSE)
# define  SYSCFG_BKREG0_BKREG0      SYSCFG_BKREG0_BKREG0_MSK

/****************** Bit definition for SYSCFG_BKREG1 register ************************/

# define  SYSCFG_BKREG1_BKREG1_POSS 0U
# define  SYSCFG_BKREG1_BKREG1_POSE 31U
# define  SYSCFG_BKREG1_BKREG1_MSK  BITS(SYSCFG_BKREG1_BKREG1_POSS, SYSCFG_BKREG1_BKREG1_POSE)
# define  SYSCFG_BKREG1_BKREG1      SYSCFG_BKREG1_BKREG1_MSK

/****************** Bit definition for SYSCFG_BKREG2 register ************************/

# define  SYSCFG_BKREG2_BKREG2_POSS 0U
# define  SYSCFG_BKREG2_BKREG2_POSE 31U
# define  SYSCFG_BKREG2_BKREG2_MSK  BITS(SYSCFG_BKREG2_BKREG2_POSS, SYSCFG_BKREG2_BKREG2_POSE)
# define  SYSCFG_BKREG2_BKREG2      SYSCFG_BKREG2_BKREG2_MSK

/****************** Bit definition for SYSCFG_BKREG3 register ************************/

# define  SYSCFG_BKREG3_BKREG3_POSS 0U
# define  SYSCFG_BKREG3_BKREG3_POSE 31U
# define  SYSCFG_BKREG3_BKREG3_MSK  BITS(SYSCFG_BKREG3_BKREG3_POSS, SYSCFG_BKREG3_BKREG3_POSE)
# define  SYSCFG_BKREG3_BKREG3      SYSCFG_BKREG3_BKREG3_MSK

/****************** Bit definition for SYSCFG_OPBERR register ************************/

# define  SYSCFG_OPBERR_opt64_err_POS 25U
# define  SYSCFG_OPBERR_opt64_err_MSK BIT(SYSCFG_OPBERR_opt64_err_POS)
# define  SYSCFG_OPBERR_opt64_err     SYSCFG_OPBERR_opt64_err_MSK

# define  SYSCFG_OPBERR_opt60_err_POS 24U
# define  SYSCFG_OPBERR_opt60_err_MSK BIT(SYSCFG_OPBERR_opt60_err_POS)
# define  SYSCFG_OPBERR_opt60_err     SYSCFG_OPBERR_opt60_err_MSK

# define  SYSCFG_OPBERR_opt5C_err_POS 23U
# define  SYSCFG_OPBERR_opt5C_err_MSK BIT(SYSCFG_OPBERR_opt5C_err_POS)
# define  SYSCFG_OPBERR_opt5C_err     SYSCFG_OPBERR_opt5C_err_MSK

# define  SYSCFG_OPBERR_opt58_err_POS 22U
# define  SYSCFG_OPBERR_opt58_err_MSK BIT(SYSCFG_OPBERR_opt58_err_POS)
# define  SYSCFG_OPBERR_opt58_err     SYSCFG_OPBERR_opt58_err_MSK

# define  SYSCFG_OPBERR_opt54_err_POS 21U
# define  SYSCFG_OPBERR_opt54_err_MSK BIT(SYSCFG_OPBERR_opt54_err_POS)
# define  SYSCFG_OPBERR_opt54_err     SYSCFG_OPBERR_opt54_err_MSK

# define  SYSCFG_OPBERR_opt50_err_POS 20U
# define  SYSCFG_OPBERR_opt50_err_MSK BIT(SYSCFG_OPBERR_opt50_err_POS)
# define  SYSCFG_OPBERR_opt50_err     SYSCFG_OPBERR_opt50_err_MSK

# define  SYSCFG_OPBERR_opt4C_err_POS 19U
# define  SYSCFG_OPBERR_opt4C_err_MSK BIT(SYSCFG_OPBERR_opt4C_err_POS)
# define  SYSCFG_OPBERR_opt4C_err     SYSCFG_OPBERR_opt4C_err_MSK

# define  SYSCFG_OPBERR_opt48_err_POS 18U
# define  SYSCFG_OPBERR_opt48_err_MSK BIT(SYSCFG_OPBERR_opt48_err_POS)
# define  SYSCFG_OPBERR_opt48_err     SYSCFG_OPBERR_opt48_err_MSK

# define  SYSCFG_OPBERR_opt44_err_POS 17U
# define  SYSCFG_OPBERR_opt44_err_MSK BIT(SYSCFG_OPBERR_opt44_err_POS)
# define  SYSCFG_OPBERR_opt44_err     SYSCFG_OPBERR_opt44_err_MSK

# define  SYSCFG_OPBERR_opt40_err_POS 16U
# define  SYSCFG_OPBERR_opt40_err_MSK BIT(SYSCFG_OPBERR_opt40_err_POS)
# define  SYSCFG_OPBERR_opt40_err     SYSCFG_OPBERR_opt40_err_MSK

# define  SYSCFG_OPBERR_opt3C_err_POS 15U
# define  SYSCFG_OPBERR_opt3C_err_MSK BIT(SYSCFG_OPBERR_opt3C_err_POS)
# define  SYSCFG_OPBERR_opt3C_err     SYSCFG_OPBERR_opt3C_err_MSK

# define  SYSCFG_OPBERR_opt38_err_POS 14U
# define  SYSCFG_OPBERR_opt38_err_MSK BIT(SYSCFG_OPBERR_opt38_err_POS)
# define  SYSCFG_OPBERR_opt38_err     SYSCFG_OPBERR_opt38_err_MSK

# define  SYSCFG_OPBERR_opt34_err_POS 13U
# define  SYSCFG_OPBERR_opt34_err_MSK BIT(SYSCFG_OPBERR_opt34_err_POS)
# define  SYSCFG_OPBERR_opt34_err     SYSCFG_OPBERR_opt34_err_MSK

# define  SYSCFG_OPBERR_opt20_err_POS 8U
# define  SYSCFG_OPBERR_opt20_err_MSK BIT(SYSCFG_OPBERR_opt20_err_POS)
# define  SYSCFG_OPBERR_opt20_err     SYSCFG_OPBERR_opt20_err_MSK

# define  SYSCFG_OPBERR_opt1C_err_POS 7U
# define  SYSCFG_OPBERR_opt1C_err_MSK BIT(SYSCFG_OPBERR_opt1C_err_POS)
# define  SYSCFG_OPBERR_opt1C_err     SYSCFG_OPBERR_opt1C_err_MSK

# define  SYSCFG_OPBERR_opt18_err_POS 6U
# define  SYSCFG_OPBERR_opt18_err_MSK BIT(SYSCFG_OPBERR_opt18_err_POS)
# define  SYSCFG_OPBERR_opt18_err     SYSCFG_OPBERR_opt18_err_MSK

# define  SYSCFG_OPBERR_opt14_err_POS 5U
# define  SYSCFG_OPBERR_opt14_err_MSK BIT(SYSCFG_OPBERR_opt14_err_POS)
# define  SYSCFG_OPBERR_opt14_err     SYSCFG_OPBERR_opt14_err_MSK

# define  SYSCFG_OPBERR_opt10_err_POS 4U
# define  SYSCFG_OPBERR_opt10_err_MSK BIT(SYSCFG_OPBERR_opt10_err_POS)
# define  SYSCFG_OPBERR_opt10_err     SYSCFG_OPBERR_opt10_err_MSK

# define  SYSCFG_OPBERR_opt0C_err_POS 3U
# define  SYSCFG_OPBERR_opt0C_err_MSK BIT(SYSCFG_OPBERR_opt0C_err_POS)
# define  SYSCFG_OPBERR_opt0C_err     SYSCFG_OPBERR_opt0C_err_MSK

# define  SYSCFG_OPBERR_opt08_err_POS 2U
# define  SYSCFG_OPBERR_opt08_err_MSK BIT(SYSCFG_OPBERR_opt08_err_POS)
# define  SYSCFG_OPBERR_opt08_err     SYSCFG_OPBERR_opt08_err_MSK

# define  SYSCFG_OPBERR_opt04_err_POS 1U
# define  SYSCFG_OPBERR_opt04_err_MSK BIT(SYSCFG_OPBERR_opt04_err_POS)
# define  SYSCFG_OPBERR_opt04_err     SYSCFG_OPBERR_opt04_err_MSK

typedef struct
{
    __IO uint32_t REMAP;                    // 0x000
    __IO uint32_t ENGEN;                    // 0x004
    __IO uint32_t PWR;                      // 0x008
    __IO uint32_t IRSEL;                    // 0x00c
    __I  uint32_t SYSTRIM;                  // 0x010
    __I  uint32_t CLKTRIM;                  // 0x014
    __I  uint32_t OSCTRIM;                  // 0x018
    __I  uint32_t IPTRIM;                   // 0x01c
    __I  uint32_t AHBIPEN;                  // 0x020
    __I  uint32_t APB1IPEN;                 // 0x024
    __I  uint32_t APB2IPEN;                 // 0x028
    __I  uint32_t MEMMOD;                   // 0x02c
    __I  uint32_t ADCVREF;                  // 0x030
    __I  uint32_t ADCTEMP;                  // 0x034
    __I  uint32_t SYSSET;                   // 0x038
    __IO uint32_t CFG;                      // 0x03c
    __IO uint32_t PWRCON;                   // 0x040
    __IO uint32_t WKTRIM;                   // 0x044
    __IO uint32_t WKUP;                     // 0x048
    __IO  uint32_t WKSR;                     // 0x04c
    __IO uint32_t BKREG0;                   // 0x050
    __IO uint32_t BKREG1;                   // 0x054
    __IO uint32_t BKREG2;                   // 0x058
    __IO uint32_t BKREG3;                   // 0x05c
    __IO uint32_t RESERVED0[36];            // 0x060-0x0ec
    __I  uint32_t OPBERR;                   // 0x0f0
} SYSCFG_TypeDef;


#endif
