/**********************************************************************************
 *
 * @file    reg_kbcu.h
 * @brief   KBCU Head File
 *
 * @date    23 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          23 Nov 2021     Ginger          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __KBCU_H__
#define __KBCU_H__


/******************************************************************************/
/*              Device Specific Peripheral registers structures               */
/******************************************************************************/

/*  Support for anonymous structures and unions.  */
//#pragma anon_unions

/****************** Bit definition for KBCU_IER register ************************/

# define  KBCU_IER_KEY_POS 2U
# define  KBCU_IER_KEY_MSK BIT(KBCU_IER_KEY_POS)
# define  KBCU_IER_KEY     KBCU_IER_KEY_MSK

# define  KBCU_IER_COLUMN_POS 1U
# define  KBCU_IER_COLUMN_MSK BIT(KBCU_IER_COLUMN_POS)
# define  KBCU_IER_COLUMN     KBCU_IER_COLUMN_MSK

# define  KBCU_IER_FRAME_POS 0U
# define  KBCU_IER_FRAME_MSK BIT(KBCU_IER_FRAME_POS)
# define  KBCU_IER_FRAME     KBCU_IER_FRAME_MSK

/****************** Bit definition for KBCU_IDR register ************************/

# define  KBCU_IDR_KEY_POS 2U
# define  KBCU_IDR_KEY_MSK BIT(KBCU_IDR_KEY_POS)
# define  KBCU_IDR_KEY     KBCU_IDR_KEY_MSK

# define  KBCU_IDR_COLUMN_POS 1U
# define  KBCU_IDR_COLUMN_MSK BIT(KBCU_IDR_COLUMN_POS)
# define  KBCU_IDR_COLUMN     KBCU_IDR_COLUMN_MSK

# define  KBCU_IDR_FRAME_POS 0U
# define  KBCU_IDR_FRAME_MSK BIT(KBCU_IDR_FRAME_POS)
# define  KBCU_IDR_FRAME     KBCU_IDR_FRAME_MSK

/****************** Bit definition for KBCU_IVS register ************************/

# define  KBCU_IVS_KEY_POS 2U
# define  KBCU_IVS_KEY_MSK BIT(KBCU_IVS_KEY_POS)
# define  KBCU_IVS_KEY     KBCU_IVS_KEY_MSK

# define  KBCU_IVS_COLUMN_POS 1U
# define  KBCU_IVS_COLUMN_MSK BIT(KBCU_IVS_COLUMN_POS)
# define  KBCU_IVS_COLUMN     KBCU_IVS_COLUMN_MSK

# define  KBCU_IVS_FRAME_POS 0U
# define  KBCU_IVS_FRAME_MSK BIT(KBCU_IVS_FRAME_POS)
# define  KBCU_IVS_FRAME     KBCU_IVS_FRAME_MSK

/****************** Bit definition for KBCU_RIF register ************************/

# define  KBCU_RIF_KEY_POS 2U
# define  KBCU_RIF_KEY_MSK BIT(KBCU_RIF_KEY_POS)
# define  KBCU_RIF_KEY     KBCU_RIF_KEY_MSK

# define  KBCU_RIF_COLUMN_POS 1U
# define  KBCU_RIF_COLUMN_MSK BIT(KBCU_RIF_COLUMN_POS)
# define  KBCU_RIF_COLUMN     KBCU_RIF_COLUMN_MSK

# define  KBCU_RIF_FRAME_POS 0U
# define  KBCU_RIF_FRAME_MSK BIT(KBCU_RIF_FRAME_POS)
# define  KBCU_RIF_FRAME     KBCU_RIF_FRAME_MSK

/****************** Bit definition for KBCU_IFM register ************************/

# define  KBCU_IFM_KEY_POS 2U
# define  KBCU_IFM_KEY_MSK BIT(KBCU_IFM_KEY_POS)
# define  KBCU_IFM_KEY     KBCU_IFM_KEY_MSK

# define  KBCU_IFM_COLUMN_POS 1U
# define  KBCU_IFM_COLUMN_MSK BIT(KBCU_IFM_COLUMN_POS)
# define  KBCU_IFM_COLUMN     KBCU_IFM_COLUMN_MSK

# define  KBCU_IFM_FRAME_POS 0U
# define  KBCU_IFM_FRAME_MSK BIT(KBCU_IFM_FRAME_POS)
# define  KBCU_IFM_FRAME     KBCU_IFM_FRAME_MSK

/****************** Bit definition for KBCU_ICR register ************************/

# define  KBCU_ICR_KEY_POS 2U
# define  KBCU_ICR_KEY_MSK BIT(KBCU_ICR_KEY_POS)
# define  KBCU_ICR_KEY     KBCU_ICR_KEY_MSK

# define  KBCU_ICR_COLUMN_POS 1U
# define  KBCU_ICR_COLUMN_MSK BIT(KBCU_ICR_COLUMN_POS)
# define  KBCU_ICR_COLUMN     KBCU_ICR_COLUMN_MSK

# define  KBCU_ICR_FRAME_POS 0U
# define  KBCU_ICR_FRAME_MSK BIT(KBCU_ICR_FRAME_POS)
# define  KBCU_ICR_FRAME     KBCU_ICR_FRAME_MSK

/****************** Bit definition for KBCU_CON1 register ************************/

# define  KBCU_CON1_COL_CTRL_POS 18U
# define  KBCU_CON1_COL_CTRL_MSK BIT(KBCU_CON1_COL_CTRL_POS)
# define  KBCU_CON1_COL_CTRL     KBCU_CON1_COL_CTRL_MSK

# define  KBCU_CON1_LED_CTRL_POS 17U
# define  KBCU_CON1_LED_CTRL_MSK BIT(KBCU_CON1_LED_CTRL_POS)
# define  KBCU_CON1_LED_CTRL     KBCU_CON1_LED_CTRL_MSK

# define  KBCU_CON1_KEY_CTRL_POS 16U
# define  KBCU_CON1_KEY_CTRL_MSK BIT(KBCU_CON1_KEY_CTRL_POS)
# define  KBCU_CON1_KEY_CTRL     KBCU_CON1_KEY_CTRL_MSK

# define  KBCU_CON1_COL_FLAG_POS 15U
# define  KBCU_CON1_COL_FLAG_MSK BIT(KBCU_CON1_COL_FLAG_POS)
# define  KBCU_CON1_COL_FLAG     KBCU_CON1_COL_FLAG_MSK

# define  KBCU_CON1_COL_MASK_POSS 8U
# define  KBCU_CON1_COL_MASK_POSE 12U
# define  KBCU_CON1_COL_MASK_MSK  BITS(KBCU_CON1_COL_MASK_POSS, KBCU_CON1_COL_MASK_POSE)
# define  KBCU_CON1_COL_MASK      KBCU_CON1_COL_MASK_MSK

# define  KBCU_CON1_COLUMN_SEL_POSS 2U
# define  KBCU_CON1_COLUMN_SEL_POSE 5U
# define  KBCU_CON1_COLUMN_SEL_MSK  BITS(KBCU_CON1_COLUMN_SEL_POSS, KBCU_CON1_COLUMN_SEL_POSE)
# define  KBCU_CON1_COLUMN_SEL      KBCU_CON1_COLUMN_SEL_MSK

# define  KBCU_CON1_BLINK_POS 1U
# define  KBCU_CON1_BLINK_MSK BIT(KBCU_CON1_BLINK_POS)
# define  KBCU_CON1_BLINK     KBCU_CON1_BLINK_MSK

# define  KBCU_CON1_KBEN_POS 0U
# define  KBCU_CON1_KBEN_MSK BIT(KBCU_CON1_KBEN_POS)
# define  KBCU_CON1_KBEN     KBCU_CON1_KBEN_MSK

/****************** Bit definition for KBCU_CON2 register ************************/

# define  KBCU_CON2_COLVALUE_POSS 27U
# define  KBCU_CON2_COLVALUE_POSE 31U
# define  KBCU_CON2_COLVALUE_MSK  BITS(KBCU_CON2_COLVALUE_POSS, KBCU_CON2_COLVALUE_POSE)
# define  KBCU_CON2_COLVALUE      KBCU_CON2_COLVALUE_MSK

# define  KBCU_CON2_DTVALUE_POSS 24U
# define  KBCU_CON2_DTVALUE_POSE 26U
# define  KBCU_CON2_DTVALUE_MSK  BITS(KBCU_CON2_DTVALUE_POSS, KBCU_CON2_DTVALUE_POSE)
# define  KBCU_CON2_DTVALUE      KBCU_CON2_DTVALUE_MSK

# define  KBCU_CON2_FCVALUE_POSS 16U
# define  KBCU_CON2_FCVALUE_POSE 23U
# define  KBCU_CON2_FCVALUE_MSK  BITS(KBCU_CON2_FCVALUE_POSS, KBCU_CON2_FCVALUE_POSE)
# define  KBCU_CON2_FCVALUE      KBCU_CON2_FCVALUE_MSK

# define  KBCU_CON2_FRDIV_POSS 8U
# define  KBCU_CON2_FRDIV_POSE 15U
# define  KBCU_CON2_FRDIV_MSK  BITS(KBCU_CON2_FRDIV_POSS, KBCU_CON2_FRDIV_POSE)
# define  KBCU_CON2_FRDIV      KBCU_CON2_FRDIV_MSK

# define  KBCU_CON2_ARVALUE_POSS 0U
# define  KBCU_CON2_ARVALUE_POSE 7U
# define  KBCU_CON2_ARVALUE_MSK  BITS(KBCU_CON2_ARVALUE_POSS, KBCU_CON2_ARVALUE_POSE)
# define  KBCU_CON2_ARVALUE      KBCU_CON2_ARVALUE_MSK

/****************** Bit definition for KBCU_SCAN0 register ************************/

# define  KBCU_SCAN0_COLUMN3_POSS 24U
# define  KBCU_SCAN0_COLUMN3_POSE 30U
# define  KBCU_SCAN0_COLUMN3_MSK  BITS(KBCU_SCAN0_COLUMN3_POSS, KBCU_SCAN0_COLUMN3_POSE)
# define  KBCU_SCAN0_COLUMN3      KBCU_SCAN0_COLUMN3_MSK

# define  KBCU_SCAN0_COLUMN2_POSS 16U
# define  KBCU_SCAN0_COLUMN2_POSE 22U
# define  KBCU_SCAN0_COLUMN2_MSK  BITS(KBCU_SCAN0_COLUMN2_POSS, KBCU_SCAN0_COLUMN2_POSE)
# define  KBCU_SCAN0_COLUMN2      KBCU_SCAN0_COLUMN2_MSK

# define  KBCU_SCAN0_COLUMN1_POSS 8U
# define  KBCU_SCAN0_COLUMN1_POSE 14U
# define  KBCU_SCAN0_COLUMN1_MSK  BITS(KBCU_SCAN0_COLUMN1_POSS, KBCU_SCAN0_COLUMN1_POSE)
# define  KBCU_SCAN0_COLUMN1      KBCU_SCAN0_COLUMN1_MSK

# define  KBCU_SCAN0_COLUMN0_POSS 0U
# define  KBCU_SCAN0_COLUMN0_POSE 6U
# define  KBCU_SCAN0_COLUMN0_MSK  BITS(KBCU_SCAN0_COLUMN0_POSS, KBCU_SCAN0_COLUMN0_POSE)
# define  KBCU_SCAN0_COLUMN0      KBCU_SCAN0_COLUMN0_MSK

/****************** Bit definition for KBCU_SCAN1 register ************************/

# define  KBCU_SCAN1_COLUMN7_POSS 24U
# define  KBCU_SCAN1_COLUMN7_POSE 30U
# define  KBCU_SCAN1_COLUMN7_MSK  BITS(KBCU_SCAN1_COLUMN7_POSS, KBCU_SCAN1_COLUMN7_POSE)
# define  KBCU_SCAN1_COLUMN7      KBCU_SCAN1_COLUMN7_MSK

# define  KBCU_SCAN1_COLUMN6_POSS 16U
# define  KBCU_SCAN1_COLUMN6_POSE 22U
# define  KBCU_SCAN1_COLUMN6_MSK  BITS(KBCU_SCAN1_COLUMN6_POSS, KBCU_SCAN1_COLUMN6_POSE)
# define  KBCU_SCAN1_COLUMN6      KBCU_SCAN1_COLUMN6_MSK

# define  KBCU_SCAN1_COLUMN5_POSS 8U
# define  KBCU_SCAN1_COLUMN5_POSE 14U
# define  KBCU_SCAN1_COLUMN5_MSK  BITS(KBCU_SCAN1_COLUMN5_POSS, KBCU_SCAN1_COLUMN5_POSE)
# define  KBCU_SCAN1_COLUMN5      KBCU_SCAN1_COLUMN5_MSK

# define  KBCU_SCAN1_COLUMN4_POSS 0U
# define  KBCU_SCAN1_COLUMN4_POSE 6U
# define  KBCU_SCAN1_COLUMN4_MSK  BITS(KBCU_SCAN1_COLUMN4_POSS, KBCU_SCAN1_COLUMN4_POSE)
# define  KBCU_SCAN1_COLUMN4      KBCU_SCAN1_COLUMN4_MSK

/****************** Bit definition for KBCU_SCAN2 register ************************/

# define  KBCU_SCAN2_COLUMN11_POSS 24U
# define  KBCU_SCAN2_COLUMN11_POSE 30U
# define  KBCU_SCAN2_COLUMN11_MSK  BITS(KBCU_SCAN2_COLUMN11_POSS, KBCU_SCAN2_COLUMN11_POSE)
# define  KBCU_SCAN2_COLUMN11      KBCU_SCAN2_COLUMN11_MSK

# define  KBCU_SCAN2_COLUMN10_POSS 16U
# define  KBCU_SCAN2_COLUMN10_POSE 22U
# define  KBCU_SCAN2_COLUMN10_MSK  BITS(KBCU_SCAN2_COLUMN10_POSS, KBCU_SCAN2_COLUMN10_POSE)
# define  KBCU_SCAN2_COLUMN10      KBCU_SCAN2_COLUMN10_MSK

# define  KBCU_SCAN2_COLUMN9_POSS 8U
# define  KBCU_SCAN2_COLUMN9_POSE 14U
# define  KBCU_SCAN2_COLUMN9_MSK  BITS(KBCU_SCAN2_COLUMN9_POSS, KBCU_SCAN2_COLUMN9_POSE)
# define  KBCU_SCAN2_COLUMN9      KBCU_SCAN2_COLUMN9_MSK

# define  KBCU_SCAN2_COLUMN8_POSS 0U
# define  KBCU_SCAN2_COLUMN8_POSE 6U
# define  KBCU_SCAN2_COLUMN8_MSK  BITS(KBCU_SCAN2_COLUMN8_POSS, KBCU_SCAN2_COLUMN8_POSE)
# define  KBCU_SCAN2_COLUMN8      KBCU_SCAN2_COLUMN8_MSK

/****************** Bit definition for KBCU_SCAN3 register ************************/

# define  KBCU_SCAN3_COLUMN15_POSS 24U
# define  KBCU_SCAN3_COLUMN15_POSE 30U
# define  KBCU_SCAN3_COLUMN15_MSK  BITS(KBCU_SCAN3_COLUMN15_POSS, KBCU_SCAN3_COLUMN15_POSE)
# define  KBCU_SCAN3_COLUMN15      KBCU_SCAN3_COLUMN15_MSK

# define  KBCU_SCAN3_COLUMN14_POSS 16U
# define  KBCU_SCAN3_COLUMN14_POSE 22U
# define  KBCU_SCAN3_COLUMN14_MSK  BITS(KBCU_SCAN3_COLUMN14_POSS, KBCU_SCAN3_COLUMN14_POSE)
# define  KBCU_SCAN3_COLUMN14      KBCU_SCAN3_COLUMN14_MSK

# define  KBCU_SCAN3_COLUMN13_POSS 8U
# define  KBCU_SCAN3_COLUMN13_POSE 14U
# define  KBCU_SCAN3_COLUMN13_MSK  BITS(KBCU_SCAN3_COLUMN13_POSS, KBCU_SCAN3_COLUMN13_POSE)
# define  KBCU_SCAN3_COLUMN13      KBCU_SCAN3_COLUMN13_MSK

# define  KBCU_SCAN3_COLUMN12_POSS 0U
# define  KBCU_SCAN3_COLUMN12_POSE 6U
# define  KBCU_SCAN3_COLUMN12_MSK  BITS(KBCU_SCAN3_COLUMN12_POSS, KBCU_SCAN3_COLUMN12_POSE)
# define  KBCU_SCAN3_COLUMN12      KBCU_SCAN3_COLUMN12_MSK

/****************** Bit definition for KBCU_SCAN4 register ************************/

# define  KBCU_SCAN4_COLUMN19_POSS 24U
# define  KBCU_SCAN4_COLUMN19_POSE 30U
# define  KBCU_SCAN4_COLUMN19_MSK  BITS(KBCU_SCAN4_COLUMN19_POSS, KBCU_SCAN4_COLUMN19_POSE)
# define  KBCU_SCAN4_COLUMN19      KBCU_SCAN4_COLUMN19_MSK

# define  KBCU_SCAN4_COLUMN18_POSS 16U
# define  KBCU_SCAN4_COLUMN18_POSE 22U
# define  KBCU_SCAN4_COLUMN18_MSK  BITS(KBCU_SCAN4_COLUMN18_POSS, KBCU_SCAN4_COLUMN18_POSE)
# define  KBCU_SCAN4_COLUMN18      KBCU_SCAN4_COLUMN18_MSK

# define  KBCU_SCAN4_COLUMN17_POSS 8U
# define  KBCU_SCAN4_COLUMN17_POSE 14U
# define  KBCU_SCAN4_COLUMN17_MSK  BITS(KBCU_SCAN4_COLUMN17_POSS, KBCU_SCAN4_COLUMN17_POSE)
# define  KBCU_SCAN4_COLUMN17      KBCU_SCAN4_COLUMN17_MSK

# define  KBCU_SCAN4_COLUMN16_POSS 0U
# define  KBCU_SCAN4_COLUMN16_POSE 6U
# define  KBCU_SCAN4_COLUMN16_MSK  BITS(KBCU_SCAN4_COLUMN16_POSS, KBCU_SCAN4_COLUMN16_POSE)
# define  KBCU_SCAN4_COLUMN16      KBCU_SCAN4_COLUMN16_MSK

/****************** Bit definition for KBCU_SCAN5 register ************************/

# define  KBCU_SCAN5_COLUMN23_POSS 24U
# define  KBCU_SCAN5_COLUMN23_POSE 30U
# define  KBCU_SCAN5_COLUMN23_MSK  BITS(KBCU_SCAN5_COLUMN23_POSS, KBCU_SCAN5_COLUMN23_POSE)
# define  KBCU_SCAN5_COLUMN23      KBCU_SCAN5_COLUMN23_MSK

# define  KBCU_SCAN5_COLUMN22_POSS 16U
# define  KBCU_SCAN5_COLUMN22_POSE 22U
# define  KBCU_SCAN5_COLUMN22_MSK  BITS(KBCU_SCAN5_COLUMN22_POSS, KBCU_SCAN5_COLUMN22_POSE)
# define  KBCU_SCAN5_COLUMN22      KBCU_SCAN5_COLUMN22_MSK

# define  KBCU_SCAN5_COLUMN21_POSS 8U
# define  KBCU_SCAN5_COLUMN21_POSE 14U
# define  KBCU_SCAN5_COLUMN21_MSK  BITS(KBCU_SCAN5_COLUMN21_POSS, KBCU_SCAN5_COLUMN21_POSE)
# define  KBCU_SCAN5_COLUMN21      KBCU_SCAN5_COLUMN21_MSK

# define  KBCU_SCAN5_COLUMN20_POSS 0U
# define  KBCU_SCAN5_COLUMN20_POSE 6U
# define  KBCU_SCAN5_COLUMN20_MSK  BITS(KBCU_SCAN5_COLUMN20_POSS, KBCU_SCAN5_COLUMN20_POSE)
# define  KBCU_SCAN5_COLUMN20      KBCU_SCAN5_COLUMN20_MSK

/****************** Bit definition for KBCU_STAT register ************************/

# define  KBCU_STAT_COLUMN_POSS 0U
# define  KBCU_STAT_COLUMN_POSE 23U
# define  KBCU_STAT_COLUMN_MSK  BITS(KBCU_STAT_COLUMN_POSS, KBCU_STAT_COLUMN_POSE)
# define  KBCU_STAT_COLUMN      KBCU_STAT_COLUMN_MSK

/****************** Bit definition for KBCU_LED0 register ************************/

# define  KBCU_LED0_MASK_POSS 27U
# define  KBCU_LED0_MASK_POSE 31U
# define  KBCU_LED0_MASK_MSK  BITS(KBCU_LED0_MASK_POSS, KBCU_LED0_MASK_POSE)
# define  KBCU_LED0_MASK      KBCU_LED0_MASK_MSK

# define  KBCU_LED0_DUTY2_H_POS 26U
# define  KBCU_LED0_DUTY2_H_MSK BIT(KBCU_LED0_DUTY2_H_POS)
# define  KBCU_LED0_DUTY2_H     KBCU_LED0_DUTY2_H_MSK

# define  KBCU_LED0_DUTY1_H_POS 25U
# define  KBCU_LED0_DUTY1_H_MSK BIT(KBCU_LED0_DUTY1_H_POS)
# define  KBCU_LED0_DUTY1_H     KBCU_LED0_DUTY1_H_MSK

# define  KBCU_LED0_DUTY0_H_POS 24U
# define  KBCU_LED0_DUTY0_H_MSK BIT(KBCU_LED0_DUTY0_H_POS)
# define  KBCU_LED0_DUTY0_H     KBCU_LED0_DUTY0_H_MSK

# define  KBCU_LED0_DUTY2_POSS 16U
# define  KBCU_LED0_DUTY2_POSE 23U
# define  KBCU_LED0_DUTY2_MSK  BITS(KBCU_LED0_DUTY2_POSS, KBCU_LED0_DUTY2_POSE)
# define  KBCU_LED0_DUTY2      KBCU_LED0_DUTY2_MSK

# define  KBCU_LED0_DUTY1_POSS 8U
# define  KBCU_LED0_DUTY1_POSE 15U
# define  KBCU_LED0_DUTY1_MSK  BITS(KBCU_LED0_DUTY1_POSS, KBCU_LED0_DUTY1_POSE)
# define  KBCU_LED0_DUTY1      KBCU_LED0_DUTY1_MSK

# define  KBCU_LED0_DUTY0_POSS 0U
# define  KBCU_LED0_DUTY0_POSE 7U
# define  KBCU_LED0_DUTY0_MSK  BITS(KBCU_LED0_DUTY0_POSS, KBCU_LED0_DUTY0_POSE)
# define  KBCU_LED0_DUTY0      KBCU_LED0_DUTY0_MSK

/****************** Bit definition for KBCU_LED1 register ************************/

# define  KBCU_LED1_MASK_POSS 27U
# define  KBCU_LED1_MASK_POSE 31U
# define  KBCU_LED1_MASK_MSK  BITS(KBCU_LED1_MASK_POSS, KBCU_LED1_MASK_POSE)
# define  KBCU_LED1_MASK      KBCU_LED1_MASK_MSK

# define  KBCU_LED1_DUTY2_H_POS 26U
# define  KBCU_LED1_DUTY2_H_MSK BIT(KBCU_LED1_DUTY2_H_POS)
# define  KBCU_LED1_DUTY2_H     KBCU_LED1_DUTY2_H_MSK

# define  KBCU_LED1_DUTY1_H_POS 25U
# define  KBCU_LED1_DUTY1_H_MSK BIT(KBCU_LED1_DUTY1_H_POS)
# define  KBCU_LED1_DUTY1_H     KBCU_LED1_DUTY1_H_MSK

# define  KBCU_LED1_DUTY0_H_POS 24U
# define  KBCU_LED1_DUTY0_H_MSK BIT(KBCU_LED1_DUTY0_H_POS)
# define  KBCU_LED1_DUTY0_H     KBCU_LED1_DUTY0_H_MSK

# define  KBCU_LED1_DUTY2_POSS 16U
# define  KBCU_LED1_DUTY2_POSE 23U
# define  KBCU_LED1_DUTY2_MSK  BITS(KBCU_LED1_DUTY2_POSS, KBCU_LED1_DUTY2_POSE)
# define  KBCU_LED1_DUTY2      KBCU_LED1_DUTY2_MSK

# define  KBCU_LED1_DUTY1_POSS 8U
# define  KBCU_LED1_DUTY1_POSE 15U
# define  KBCU_LED1_DUTY1_MSK  BITS(KBCU_LED1_DUTY1_POSS, KBCU_LED1_DUTY1_POSE)
# define  KBCU_LED1_DUTY1      KBCU_LED1_DUTY1_MSK

# define  KBCU_LED1_DUTY0_POSS 0U
# define  KBCU_LED1_DUTY0_POSE 7U
# define  KBCU_LED1_DUTY0_MSK  BITS(KBCU_LED1_DUTY0_POSS, KBCU_LED1_DUTY0_POSE)
# define  KBCU_LED1_DUTY0      KBCU_LED1_DUTY0_MSK

/****************** Bit definition for KBCU_LED2 register ************************/

# define  KBCU_LED2_MASK_POSS 27U
# define  KBCU_LED2_MASK_POSE 31U
# define  KBCU_LED2_MASK_MSK  BITS(KBCU_LED2_MASK_POSS, KBCU_LED2_MASK_POSE)
# define  KBCU_LED2_MASK      KBCU_LED2_MASK_MSK

# define  KBCU_LED2_DUTY2_H_POS 26U
# define  KBCU_LED2_DUTY2_H_MSK BIT(KBCU_LED2_DUTY2_H_POS)
# define  KBCU_LED2_DUTY2_H     KBCU_LED2_DUTY2_H_MSK

# define  KBCU_LED2_DUTY1_H_POS 25U
# define  KBCU_LED2_DUTY1_H_MSK BIT(KBCU_LED2_DUTY1_H_POS)
# define  KBCU_LED2_DUTY1_H     KBCU_LED2_DUTY1_H_MSK

# define  KBCU_LED2_DUTY0_H_POS 24U
# define  KBCU_LED2_DUTY0_H_MSK BIT(KBCU_LED2_DUTY0_H_POS)
# define  KBCU_LED2_DUTY0_H     KBCU_LED2_DUTY0_H_MSK

# define  KBCU_LED2_DUTY2_POSS 16U
# define  KBCU_LED2_DUTY2_POSE 23U
# define  KBCU_LED2_DUTY2_MSK  BITS(KBCU_LED2_DUTY2_POSS, KBCU_LED2_DUTY2_POSE)
# define  KBCU_LED2_DUTY2      KBCU_LED2_DUTY2_MSK

# define  KBCU_LED2_DUTY1_POSS 8U
# define  KBCU_LED2_DUTY1_POSE 15U
# define  KBCU_LED2_DUTY1_MSK  BITS(KBCU_LED2_DUTY1_POSS, KBCU_LED2_DUTY1_POSE)
# define  KBCU_LED2_DUTY1      KBCU_LED2_DUTY1_MSK

# define  KBCU_LED2_DUTY0_POSS 0U
# define  KBCU_LED2_DUTY0_POSE 7U
# define  KBCU_LED2_DUTY0_MSK  BITS(KBCU_LED2_DUTY0_POSS, KBCU_LED2_DUTY0_POSE)
# define  KBCU_LED2_DUTY0      KBCU_LED2_DUTY0_MSK

/****************** Bit definition for KBCU_LED3 register ************************/

# define  KBCU_LED3_MASK_POSS 27U
# define  KBCU_LED3_MASK_POSE 31U
# define  KBCU_LED3_MASK_MSK  BITS(KBCU_LED3_MASK_POSS, KBCU_LED3_MASK_POSE)
# define  KBCU_LED3_MASK      KBCU_LED3_MASK_MSK

# define  KBCU_LED3_DUTY2_H_POS 26U
# define  KBCU_LED3_DUTY2_H_MSK BIT(KBCU_LED3_DUTY2_H_POS)
# define  KBCU_LED3_DUTY2_H     KBCU_LED3_DUTY2_H_MSK

# define  KBCU_LED3_DUTY1_H_POS 25U
# define  KBCU_LED3_DUTY1_H_MSK BIT(KBCU_LED3_DUTY1_H_POS)
# define  KBCU_LED3_DUTY1_H     KBCU_LED3_DUTY1_H_MSK

# define  KBCU_LED3_DUTY0_H_POS 24U
# define  KBCU_LED3_DUTY0_H_MSK BIT(KBCU_LED3_DUTY0_H_POS)
# define  KBCU_LED3_DUTY0_H     KBCU_LED3_DUTY0_H_MSK

# define  KBCU_LED3_DUTY2_POSS 16U
# define  KBCU_LED3_DUTY2_POSE 23U
# define  KBCU_LED3_DUTY2_MSK  BITS(KBCU_LED3_DUTY2_POSS, KBCU_LED3_DUTY2_POSE)
# define  KBCU_LED3_DUTY2      KBCU_LED3_DUTY2_MSK

# define  KBCU_LED3_DUTY1_POSS 8U
# define  KBCU_LED3_DUTY1_POSE 15U
# define  KBCU_LED3_DUTY1_MSK  BITS(KBCU_LED3_DUTY1_POSS, KBCU_LED3_DUTY1_POSE)
# define  KBCU_LED3_DUTY1      KBCU_LED3_DUTY1_MSK

# define  KBCU_LED3_DUTY0_POSS 0U
# define  KBCU_LED3_DUTY0_POSE 7U
# define  KBCU_LED3_DUTY0_MSK  BITS(KBCU_LED3_DUTY0_POSS, KBCU_LED3_DUTY0_POSE)
# define  KBCU_LED3_DUTY0      KBCU_LED3_DUTY0_MSK

/****************** Bit definition for KBCU_LED4 register ************************/

# define  KBCU_LED4_MASK_POSS 27U
# define  KBCU_LED4_MASK_POSE 31U
# define  KBCU_LED4_MASK_MSK  BITS(KBCU_LED4_MASK_POSS, KBCU_LED4_MASK_POSE)
# define  KBCU_LED4_MASK      KBCU_LED4_MASK_MSK

# define  KBCU_LED4_DUTY2_H_POS 26U
# define  KBCU_LED4_DUTY2_H_MSK BIT(KBCU_LED4_DUTY2_H_POS)
# define  KBCU_LED4_DUTY2_H     KBCU_LED4_DUTY2_H_MSK

# define  KBCU_LED4_DUTY1_H_POS 25U
# define  KBCU_LED4_DUTY1_H_MSK BIT(KBCU_LED4_DUTY1_H_POS)
# define  KBCU_LED4_DUTY1_H     KBCU_LED4_DUTY1_H_MSK

# define  KBCU_LED4_DUTY0_H_POS 24U
# define  KBCU_LED4_DUTY0_H_MSK BIT(KBCU_LED4_DUTY0_H_POS)
# define  KBCU_LED4_DUTY0_H     KBCU_LED4_DUTY0_H_MSK

# define  KBCU_LED4_DUTY2_POSS 16U
# define  KBCU_LED4_DUTY2_POSE 23U
# define  KBCU_LED4_DUTY2_MSK  BITS(KBCU_LED4_DUTY2_POSS, KBCU_LED4_DUTY2_POSE)
# define  KBCU_LED4_DUTY2      KBCU_LED4_DUTY2_MSK

# define  KBCU_LED4_DUTY1_POSS 8U
# define  KBCU_LED4_DUTY1_POSE 15U
# define  KBCU_LED4_DUTY1_MSK  BITS(KBCU_LED4_DUTY1_POSS, KBCU_LED4_DUTY1_POSE)
# define  KBCU_LED4_DUTY1      KBCU_LED4_DUTY1_MSK

# define  KBCU_LED4_DUTY0_POSS 0U
# define  KBCU_LED4_DUTY0_POSE 7U
# define  KBCU_LED4_DUTY0_MSK  BITS(KBCU_LED4_DUTY0_POSS, KBCU_LED4_DUTY0_POSE)
# define  KBCU_LED4_DUTY0      KBCU_LED4_DUTY0_MSK

/****************** Bit definition for KBCU_LED5 register ************************/

# define  KBCU_LED5_MASK_POSS 27U
# define  KBCU_LED5_MASK_POSE 31U
# define  KBCU_LED5_MASK_MSK  BITS(KBCU_LED5_MASK_POSS, KBCU_LED5_MASK_POSE)
# define  KBCU_LED5_MASK      KBCU_LED5_MASK_MSK

# define  KBCU_LED5_DUTY2_H_POS 26U
# define  KBCU_LED5_DUTY2_H_MSK BIT(KBCU_LED5_DUTY2_H_POS)
# define  KBCU_LED5_DUTY2_H     KBCU_LED5_DUTY2_H_MSK

# define  KBCU_LED5_DUTY1_H_POS 25U
# define  KBCU_LED5_DUTY1_H_MSK BIT(KBCU_LED5_DUTY1_H_POS)
# define  KBCU_LED5_DUTY1_H     KBCU_LED5_DUTY1_H_MSK

# define  KBCU_LED5_DUTY0_H_POS 24U
# define  KBCU_LED5_DUTY0_H_MSK BIT(KBCU_LED5_DUTY0_H_POS)
# define  KBCU_LED5_DUTY0_H     KBCU_LED5_DUTY0_H_MSK

# define  KBCU_LED5_DUTY2_POSS 16U
# define  KBCU_LED5_DUTY2_POSE 23U
# define  KBCU_LED5_DUTY2_MSK  BITS(KBCU_LED5_DUTY2_POSS, KBCU_LED5_DUTY2_POSE)
# define  KBCU_LED5_DUTY2      KBCU_LED5_DUTY2_MSK

# define  KBCU_LED5_DUTY1_POSS 8U
# define  KBCU_LED5_DUTY1_POSE 15U
# define  KBCU_LED5_DUTY1_MSK  BITS(KBCU_LED5_DUTY1_POSS, KBCU_LED5_DUTY1_POSE)
# define  KBCU_LED5_DUTY1      KBCU_LED5_DUTY1_MSK

# define  KBCU_LED5_DUTY0_POSS 0U
# define  KBCU_LED5_DUTY0_POSE 7U
# define  KBCU_LED5_DUTY0_MSK  BITS(KBCU_LED5_DUTY0_POSS, KBCU_LED5_DUTY0_POSE)
# define  KBCU_LED5_DUTY0      KBCU_LED5_DUTY0_MSK

/****************** Bit definition for KBCU_LED6 register ************************/

# define  KBCU_LED6_MASK_POSS 27U
# define  KBCU_LED6_MASK_POSE 31U
# define  KBCU_LED6_MASK_MSK  BITS(KBCU_LED6_MASK_POSS, KBCU_LED6_MASK_POSE)
# define  KBCU_LED6_MASK      KBCU_LED6_MASK_MSK

# define  KBCU_LED6_DUTY2_H_POS 26U
# define  KBCU_LED6_DUTY2_H_MSK BIT(KBCU_LED6_DUTY2_H_POS)
# define  KBCU_LED6_DUTY2_H     KBCU_LED6_DUTY2_H_MSK

# define  KBCU_LED6_DUTY1_H_POS 25U
# define  KBCU_LED6_DUTY1_H_MSK BIT(KBCU_LED6_DUTY1_H_POS)
# define  KBCU_LED6_DUTY1_H     KBCU_LED6_DUTY1_H_MSK

# define  KBCU_LED6_DUTY0_H_POS 24U
# define  KBCU_LED6_DUTY0_H_MSK BIT(KBCU_LED6_DUTY0_H_POS)
# define  KBCU_LED6_DUTY0_H     KBCU_LED6_DUTY0_H_MSK

# define  KBCU_LED6_DUTY2_POSS 16U
# define  KBCU_LED6_DUTY2_POSE 23U
# define  KBCU_LED6_DUTY2_MSK  BITS(KBCU_LED6_DUTY2_POSS, KBCU_LED6_DUTY2_POSE)
# define  KBCU_LED6_DUTY2      KBCU_LED6_DUTY2_MSK

# define  KBCU_LED6_DUTY1_POSS 8U
# define  KBCU_LED6_DUTY1_POSE 15U
# define  KBCU_LED6_DUTY1_MSK  BITS(KBCU_LED6_DUTY1_POSS, KBCU_LED6_DUTY1_POSE)
# define  KBCU_LED6_DUTY1      KBCU_LED6_DUTY1_MSK

# define  KBCU_LED6_DUTY0_POSS 0U
# define  KBCU_LED6_DUTY0_POSE 7U
# define  KBCU_LED6_DUTY0_MSK  BITS(KBCU_LED6_DUTY0_POSS, KBCU_LED6_DUTY0_POSE)
# define  KBCU_LED6_DUTY0      KBCU_LED6_DUTY0_MSK

typedef struct
{
    __O  uint32_t IER;                      // 0x000
    __O  uint32_t IDR;                      // 0x004
    __I  uint32_t IVS;                      // 0x008
    __I  uint32_t RIF;                      // 0x00c
    __I  uint32_t IFM;                      // 0x010
    __O  uint32_t ICR;                      // 0x014
    __IO uint32_t CON1;                     // 0x018
    __IO uint32_t CON2;                     // 0x01c
    __I  uint32_t SCAN0;                    // 0x020
    __I  uint32_t SCAN1;                    // 0x024
    __I  uint32_t SCAN2;                    // 0x028
    __I  uint32_t SCAN3;                    // 0x02c
    __I  uint32_t SCAN4;                    // 0x030
    __I  uint32_t SCAN5;                    // 0x034
    __I  uint32_t STAT;                     // 0x038
    __IO uint32_t RESERVED0;                // 0x03c
    __IO uint32_t LED0;                     // 0x040
    __IO uint32_t LED1;                     // 0x044
    __IO uint32_t LED2;                     // 0x048
    __IO uint32_t LED3;                     // 0x04c
    __IO uint32_t LED4;                     // 0x050
    __IO uint32_t LED5;                     // 0x054
    __IO uint32_t LED6;                     // 0x058
} KBCU_TypeDef;


#endif
