;*******************************************************************************
; file       : startup_es32f010x.s
; description: es32f010x Device Startup File
; author     : Eastsoft MCU Software Team
; data       : 10 Nov 2020
; Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
;*******************************************************************************

        MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)
        SECTION .intvec:CODE:NOROOT(2)

        EXTERN  __iar_program_start
        PUBLIC  __vector_table

        DATA
        
__vector_table
                DCD     sfe(CSTACK)                    ; Top of Stack
                DCD     Reset_Handler          ;1, Reset Handler
                DCD     NMI_Handler          ;2, NMI Handler
                DCD     HardFault_Handler          ;3, HardFault Handler
                DCD     0                    ;4, Reserved
                DCD     0                    ;5, Reserved
                DCD     0                    ;6, Reserved
                DCD     0                    ;7, Reserved
                DCD     0                    ;8, Reserved
                DCD     0                    ;9, Reserved
                DCD     0                    ;10, Reserved
                DCD     SVCall_Handler          ;11, SVCall Handler
                DCD     0                    ;12, Reserved
                DCD     0                    ;13, Reserved
                DCD     PendSV_Handler          ;14, PendSV Handler
                DCD     SysTick_Handler          ;15, SysTick Handler
                DCD     WWDT_Handler          ;16, WWDT IRQHandler
                DCD     IWDT_Handler          ;17, IWDT IRQHandler
                DCD     LVD_Handler          ;18, LVD IRQHandler
                DCD     0                    ;19, Reserved
                DCD     CMU_Handler          ;20, CMU IRQHandler
                DCD     EXTI0_3_Handler          ;21, EXTI0_3 IRQHandler
                DCD     EXTI4_7_Handler          ;22, EXTI4_7 IRQHandler
                DCD     EXTI8_11_Handler          ;23, EXTI8_11 IRQHandler
                DCD     EXTI12_15_Handler          ;24, EXTI12_15 IRQHandler
                DCD     DMA_Handler          ;25, DMA IRQHandler
                DCD     ACMP0_Handler          ;26, CMP0 IRQHandler
                DCD     ACMP1_Handler          ;27, CMP1 IRQHandler
                DCD     ADC0_Handler          ;28, ADC IRQHandler
                DCD     AD16C4T_UP_Handler          ;29, AD16C4T_UP IRQHandler
                DCD     AD16C4T_CC_Handler          ;30, AD16C4T_CC IRQHandler
                DCD     BSTIM0_Handler          ;31, BSTIM0 IRQHandler
                DCD     0                       ;32, 　 Reserved
                DCD     GPTIMC0_Handler          ;33, GPTIMC0 IRQHandler
                DCD     GPTIMC1_Handler          ;34, GPTIMC1 IRQHandler
                DCD     GPTIMC2_Handler          ;35, GPTIMC2 IRQHandler
                DCD     0                           ;36, 　 Reserved
                DCD     AD16C4T_Handler          ;37, AD16C4T IRQHandler
                DCD     0                           ;38, 　 Reserved
                DCD     I2C0_Handler          ;39, I2C0 IRQHandler
                DCD     I2C1_Handler          ;40, I2C1 IRQHandler
                DCD     SPI0_Handler          ;41, SPI0 IRQHandler
                DCD     0                        ;42, 　 Reserved
                DCD     0                        ;43, 　 Reserved
                DCD     0                        ;44, 　　 Reserved
                DCD     USART0_Handler          ;45, USART0 IRQHandler
                DCD     USART1_Handler          ;46, USART1 IRQHandler
                DCD     0                        ;47, 　 Reserved
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .text:CODE:NOROOT:REORDER(2) 
Reset_Handler
        LDR     R0, =__iar_program_start
        BX      R0

        PUBWEAK NMI_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
NMI_Handler
        B NMI_Handler

        PUBLIC HardFault_Handler
        SECTION .text:CODE:NOROOT:REORDER(2)
HardFault_Handler
        ISB
        PUSH	        {R0-R3, LR}
        LDR		R0,		=0x40080000
        LDR		R1,		=0x55AA6996
        STR		R1,		[R0]

        LDR		R2,		=0x40080824
        LDR		R3,		=0x00000001
        STR		R3,		[R2]
        
        NOP

        PUBWEAK SVCall_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
SVCall_Handler
        B SVCall_Handler

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
PendSV_Handler
        B PendSV_Handler

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
SysTick_Handler
        B SysTick_Handler

        PUBWEAK WWDT_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
WWDT_Handler
        B WWDT_Handler

        PUBWEAK IWDT_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
IWDT_Handler
        B IWDT_Handler

        PUBWEAK LVD_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
LVD_Handler
        B LVD_Handler

        PUBWEAK CMU_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
CMU_Handler
        B CMU_Handler

        PUBWEAK EXTI0_3_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
EXTI0_3_Handler
        B EXTI0_3_Handler

        PUBWEAK EXTI4_7_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
EXTI4_7_Handler
        B EXTI4_7_Handler

        PUBWEAK EXTI8_11_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
EXTI8_11_Handler
        B EXTI8_11_Handler

        PUBWEAK EXTI12_15_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
EXTI12_15_Handler
        B EXTI12_15_Handler

        PUBWEAK DMA_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
DMA_Handler
        B DMA_Handler

        PUBWEAK ACMP0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
ACMP0_Handler
        B ACMP0_Handler

        PUBWEAK ACMP1_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
ACMP1_Handler
        B ACMP1_Handler

        PUBWEAK ADC0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
ADC0_Handler
        B ADC0_Handler

        PUBWEAK AD16C4T_UP_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
AD16C4T_UP_Handler
        B AD16C4T_UP_Handler

        PUBWEAK AD16C4T_CC_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
AD16C4T_CC_Handler
        B AD16C4T_CC_Handler

        PUBWEAK BSTIM0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
BSTIM0_Handler
        B BSTIM0_Handler

        PUBWEAK GPTIMC0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
GPTIMC0_Handler
        B GPTIMC0_Handler

        PUBWEAK GPTIMC1_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
GPTIMC1_Handler
        B GPTIMC1_Handler

        PUBWEAK GPTIMC2_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
GPTIMC2_Handler
        B GPTIMC2_Handler

        PUBWEAK AD16C4T_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
AD16C4T_Handler
        B AD16C4T_Handler

        PUBWEAK I2C0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
I2C0_Handler
        B I2C0_Handler

        PUBWEAK I2C1_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
I2C1_Handler
        B I2C1_Handler

        PUBWEAK SPI0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
SPI0_Handler
        B SPI0_Handler

        PUBWEAK USART0_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
USART0_Handler
        B USART0_Handler

        PUBWEAK USART1_Handler
        SECTION .text:CODE:NOROOT:REORDER(1) 
USART1_Handler
        B USART1_Handler

        END