/**
  *********************************************************************************
  *
  * @file    bsp_led.c
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#include <stdio.h>
#include "bsp_led.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup LED led 
  * @{
  */

/** @defgroup LED_Public_Functions led Public Functions
  * @brief    BSP LED Functions
  * @{
  */

/**
  * @brief  led pin initiation
  * @retval None
  */
void bsp_led_init(void)
{
	gpio_init_t x;
	
	bsp_led_off(2);
	bsp_led_off(3);
	x.mode = GPIO_MODE_OUTPUT;
	x.pupd = GPIO_PUSH_UP;
	x.odos = GPIO_PUSH_PULL;
	x.nodrv = GPIO_OUT_DRIVE_1;
	x.podrv = GPIO_OUT_DRIVE_1;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;
	ald_gpio_init(GPIO_PORT_LED2, GPIO_PIN_LED2, &x);	
	ald_gpio_init(GPIO_PORT_LED3, GPIO_PIN_LED3, &x);	
}

/**
  * @brief  Led on
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_on(uint8_t num)
{
	if (num == 2) {
		GPIO_PORT_LED2->BSRR = (GPIO_PIN_LED2 << 15);
	}
	else if (num == 3) {
		GPIO_PORT_LED3->BSRR = (GPIO_PIN_LED3 << 15);
	}
}

/**
  * @brief  Led off
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_off(uint8_t num)
{

	if (num == 2) {
		GPIO_PORT_LED2->BSRR = GPIO_PIN_LED2;
	}
	else if (num == 3) {
		GPIO_PORT_LED3->BSRR = GPIO_PIN_LED3;
	}
}

/**
  * @brief  Led toggle
  * @param  num: number of the led
  * @retval None
  */
void bsp_led_toggle(uint8_t num)
{
	if (num == 2) {
		GPIO_PORT_LED2->BIR = GPIO_PIN_LED2;
	}
	else if (num == 3) {
		GPIO_PORT_LED3->BIR = GPIO_PIN_LED3;
	}
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
