/**
  *********************************************************************************
  *
  * @file    bsp_uart_fifo.h
  * @brief   uart driver
  *
  * @version V1.0
  * @date    16 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef _BSP_USART_FIFO_H_
#define _BSP_USART_FIFO_H_

#include "ald_uart.h"

/** @addtogroup ES32F03xxx_BSP
  * @{
  */

/** @addtogroup UART
  * @{
  */

/** @defgroup UART_Private_Micros UART Private Micros
  * @{
  */
#if !defined RT_THREAD  
#define	UART2_FIFO_EN	1
#endif
#define	UART5_FIFO_EN	1
/* UART2 -ISP */
#define UART2_TX_PORT    GPIOE
#define UART2_TX_PIN     GPIO_PIN_2
#define UART2_RX_PORT    GPIOE
#define UART2_RX_PIN     GPIO_PIN_3
/* UART5 -RS485 */
#define UART5_TX_PORT    GPIOB
#define UART5_TX_PIN     GPIO_PIN_9
#define UART5_RX_PORT    GPIOB
#define UART5_RX_PIN     GPIO_PIN_8
#define PORT_RS485_TXEN  GPIOC
#define PIN_RS485_TXEN	 GPIO_PIN_13
#define RS485_RX_EN()	 ald_gpio_write_pin(GPIOC, GPIO_PIN_13, 0)
#define RS485_TX_EN()	 ald_gpio_write_pin(GPIOC, GPIO_PIN_13, 1)
#define ENABLE_INT()	__set_PRIMASK(0)	
#define DISABLE_INT()	__set_PRIMASK(1)	

/* UART index */
typedef enum {
	ISP_UART    = 2,	/* UART2, PE2, PE3 */
	RS485_UART  = 5,	/* UART5, PB9, PB8 */
} uart_idx_e;

#if UART2_FIFO_EN == 1
	#define UART2_BAUD		115200
	#define UART2_TX_BUF_SIZE	1*512
	#define UART2_RX_BUF_SIZE	1*512
#endif
#if UART5_FIFO_EN == 1
	#define UART5_BAUD		9600
	#define UART5_TX_BUF_SIZE	1*512
	#define UART5_RX_BUF_SIZE	1*512
#endif

typedef struct {
	uart_handle_t* uart;		
	uint8_t *p_txbuf;		
	uint8_t *p_rxbuf;		
	uint16_t txbuf_size;		
	uint16_t rxbuf_size;		
	__IO uint16_t idx_txwrite;	
	__IO uint16_t idx_txread;		
	__IO uint16_t tx_count;	
	__IO uint8_t frame_flag;
	__IO uint16_t idx_rxwrite;	
	__IO uint16_t idx_rxread;		
	__IO uint16_t rx_count;	
	void (*send_before)(void); 	
	void (*send_over)(void); 	
	void (*receive)(uint8_t _byte);	
} uart_transceiver_t;
/**
  * @}
  */

/** @addtogroup UART_Public_Functions
  * @{
  */
void bsp_uart_init(void);
void uart_send_buf(uart_idx_e idx, uint8_t *srcbuf, uint16_t dlen);
void uart_send_char(uart_idx_e idx, uint8_t dat);
uint8_t uart_get_char(uart_idx_e idx, uint8_t *des);
void uart_clear_tx_fifo(uart_idx_e idx);
void uart_clear_rx_fifo(uart_idx_e idx);
void uart5_frame_monitor(uart_idx_e idx);
void uart2_frame_monitor(uart_idx_e port);
uint8_t uart_get_frame_flag(uart_idx_e idx);
void uart_clear_frame_flag(uart_idx_e idx);
uint8_t uart_get_frame(uart_idx_e idx, uint8_t *desbuf);
void rs485_send_buf(uint8_t *srcbuf, uint16_t dlen);
void rs485_send_str(char *srcbuf);
/**
  * @}
  */
  
/**
  * @}
  */

/**
  * @}
  */
#endif



