/**
  *********************************************************************************
  *
  * @file    bsp_sram.h
  * @brief   SRAM driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_SRAM_H__
#define __BSP_SRAM_H__

#include "ald_gpio.h"
#include "ald_sram.h"
#include "ald_ebi.h"

#ifdef _cplusplus
extern "C" {
#endif
/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @addtogroup SRAM
  * @{
  */

/** @defgroup SRAM_Public_Macros SRAM Public Macros
  * @{
  */

extern sram_handle_t hsram;
extern ald_ebi_nor_sram_timing_t sram_timing;

#define BUFFER_SIZE                    4
#define SRAM_MEMORY_WIDTH               EBI_NORSRAM_MEM_BUS_WIDTH_16
#define SRAM_BANK_ADDR                 ((uint32_t)0x68000000)

#define 	EBI_SRAM_ADDRESS_PORTn	19
#define		EBI_SRAM_ADDRESS_PINn	19
#define		EBI_SRAM_DATA_PORTn	16
#define		EBI_SRAM_DATA_PINn	16

#define 	EBI_A0_PORT		GPIOC
#define 	EBI_A0_PIN		GPIO_PIN_0 
#define 	EBI_A1_PORT		GPIOC
#define 	EBI_A1_PIN		GPIO_PIN_1 
#define 	EBI_A2_PORT		GPIOC
#define 	EBI_A2_PIN		GPIO_PIN_2 
#define 	EBI_A3_PORT		GPIOC
#define 	EBI_A3_PIN		GPIO_PIN_3 
#define 	EBI_A4_PORT		GPIOA
#define 	EBI_A4_PIN		GPIO_PIN_4 
#define 	EBI_A5_PORT		GPIOA
#define 	EBI_A5_PIN		GPIO_PIN_5 
#define 	EBI_A6_PORT		GPIOA
#define 	EBI_A6_PIN		GPIO_PIN_6 
#define 	EBI_A7_PORT		GPIOA
#define 	EBI_A7_PIN		GPIO_PIN_7 
#define 	EBI_A8_PORT		GPIOC
#define 	EBI_A8_PIN		GPIO_PIN_4 
#define 	EBI_A9_PORT		GPIOC
#define 	EBI_A9_PIN		GPIO_PIN_5 
#define 	EBI_A10_PORT		GPIOB
#define 	EBI_A10_PIN		GPIO_PIN_10 
#define 	EBI_A11_PORT		GPIOB
#define 	EBI_A11_PIN		GPIO_PIN_11 
#define 	EBI_A12_PORT		GPIOB
#define 	EBI_A12_PIN		GPIO_PIN_12 
#define 	EBI_A13_PORT		GPIOB
#define 	EBI_A13_PIN		GPIO_PIN_13 
#define 	EBI_A14_PORT		GPIOB
#define 	EBI_A14_PIN		GPIO_PIN_14 
#define 	EBI_A15_PORT		GPIOB
#define 	EBI_A15_PIN		GPIO_PIN_15 
#define 	EBI_A16_PORT		GPIOD
#define 	EBI_A16_PIN		GPIO_PIN_11 
#define 	EBI_A17_PORT		GPIOD
#define 	EBI_A17_PIN		GPIO_PIN_12 
#define 	EBI_A18_PORT		GPIOD
#define 	EBI_A18_PIN		GPIO_PIN_13 
	
#define 	EBI_D0_PORT		GPIOD
#define 	EBI_D0_PIN		GPIO_PIN_14
#define 	EBI_D1_PORT		GPIOD
#define 	EBI_D1_PIN		GPIO_PIN_15
#define 	EBI_D2_PORT		GPIOD
#define 	EBI_D2_PIN		GPIO_PIN_0
#define 	EBI_D3_PORT		GPIOD
#define 	EBI_D3_PIN		GPIO_PIN_1
#define 	EBI_D4_PORT		GPIOE
#define 	EBI_D4_PIN		GPIO_PIN_7
#define 	EBI_D5_PORT		GPIOE
#define 	EBI_D5_PIN		GPIO_PIN_8
#define 	EBI_D6_PORT		GPIOE
#define 	EBI_D6_PIN		GPIO_PIN_9
#define 	EBI_D7_PORT		GPIOE
#define 	EBI_D7_PIN		GPIO_PIN_10
#define 	EBI_D8_PORT		GPIOE
#define 	EBI_D8_PIN		GPIO_PIN_11
#define 	EBI_D9_PORT		GPIOE
#define 	EBI_D9_PIN		GPIO_PIN_12
#define 	EBI_D10_PORT		GPIOE
#define 	EBI_D10_PIN		GPIO_PIN_13
#define 	EBI_D11_PORT		GPIOE
#define 	EBI_D11_PIN		GPIO_PIN_14
#define 	EBI_D12_PORT		GPIOE
#define 	EBI_D12_PIN		GPIO_PIN_15
#define 	EBI_D13_PORT		GPIOD
#define 	EBI_D13_PIN		GPIO_PIN_8
#define 	EBI_D14_PORT		GPIOD
#define 	EBI_D14_PIN		GPIO_PIN_9
#define 	EBI_D15_PORT		GPIOD
#define 	EBI_D15_PIN		GPIO_PIN_10

#define 	EBI_NE3_PORT		GPIOC
#define 	EBI_NE3_PIN		GPIO_PIN_11

#define 	EBI_NOE_PORT		GPIOD
#define 	EBI_NOE_PIN		GPIO_PIN_4
#define 	EBI_NWE_PORT		GPIOD
#define 	EBI_NWE_PIN		GPIO_PIN_5

#define 	EBI_NBL0_PORT		GPIOE
#define 	EBI_NBL0_PIN		GPIO_PIN_0
#define 	EBI_NBL1_PORT		GPIOE
#define 	EBI_NBL1_PIN		GPIO_PIN_1

/**
  * @}
  */

/** @addtogroup SRAM_Public_Functions
  * @{
  */
void bsp_sram_pin_init(void);
void bsp_sram_init(void);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
