/**
  *********************************************************************************
  *
  * @file    bsp_record.c
  * @brief   Header of Record driver
  *
  * @version V1.0
  * @date    10 May 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          10 May 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef	__BSP_RECORD_H__
#define	__BSP_RECORD_H__

#include "utils.h"
#include "ald_spi.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @defgroup Record
  * @{
  */
  
/** @defgroup Record_Private_Typedef Record Private Typedef
  * @{
  */

/* Riff chunk */
typedef __packed struct {
    uint32_t chunk_id;    /* "RIFF",0X46464952 */
    uint32_t chunk_size ; 		
    uint32_t format;	  /* wav format 0x45564157 */	
} chunk_riff_t ;

/* Fmt chunk */
typedef __packed struct {
	uint32_t chunk_id;        /* "fmt ", 0x20746D66*/		   
	uint32_t chunk_size ;	  /* exclude id and size, 20 */	   	
	uint16_t audio_format;	  /* 0x10,PCM; 0x11, IMA ADPCM */  	
	uint16_t num_of_channels; /* 1, single-channle; 2, double-channel */		
	uint32_t sample_rate;	  /* 0x1f40, 8k */		
	uint32_t byte_rate;			
	uint16_t block_align;			
	uint16_t bits_persample;  /* 4 ADPCM */					
} chunk_fmt_t;

/* Fact chunk */ 
typedef __packed struct {
	uint32_t chunk_id;      /* "fact", 0x74636166*/		
	uint32_t chunk_size ;   /* exclude id and size, 4 */	
	uint32_t num_of_samples; 
} chunk_fact_t;

/* Data chunk */
typedef __packed struct {
    uint32_t chunk_id;    /* "data", 0X61746164 */			   	
    uint32_t chunk_size ; /* exclude id and size, 60 */			   	
} chunk_data_t;

/* Wav header */
typedef __packed struct {
	chunk_riff_t riff;	
	chunk_fmt_t fmt;  	
	chunk_data_t data;			 
} wave_header_t; 

/* Record flag */
typedef union {
    struct f{
        uint8_t save : 1;
        uint8_t stop : 1;
        uint8_t rec  : 1;
        uint8_t pause: 1;
        uint8_t reserved: 4;
    } f;
    uint8_t flg;
} record_flag_t;
/**
  * @}
  */

/** @defgroup Record_Public_Variable Record Public Variable
  * @{
  */

extern uint8_t recbuf[512];
extern record_flag_t recf;
extern wave_header_t wvh;
/**
  * @}
  */

/** @addtogroup Record_Public_Functions
  * @{
  */
void bps_record_init(void);
void record_header_default_init(wave_header_t *whead);
void record_time_stamp_dislay(uint32_t stamp);
void record_check_new_name(char *name);
/**
  * @}
  */

/**
  * @}
  */
  
/**
  * @}
  */
  
#endif

