/**
  *********************************************************************************
  *
  * @file    bsp_pwm.h
  * @brief   Header of pwm driver
  *
  * @version V1.0
  * @date    16 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
#ifndef __BSP_PWM_H__
#define __BSP_PWM_H__

#include "ald_timer.h"

/** @addtogroup ES32F03xxx_BSP
  * @{
  */

/** @addtogroup PWM
  * @{
  */

/** @defgroup PWM_Public_Micros pwm Public Micros
  * @{
  */
extern timer_handle_t  h_timer;
extern struct pwm_config pwm_cfg;

#define PWM_CMD_ENABLE      (128 + 0)
#define PWM_CMD_DISABLE     (128 + 1)
#define PWM_CMD_SET         (128 + 2)
#define PWM_CMD_GET         (128 + 3)
/**
  * @}
  */

/** @defgroup PWM_Public_struct pwm Public struct
  * @{
  */
struct pwm_config {
	uint32_t channel; /* 0-n */
	uint32_t period;  /* unit:ns 1ns~4.29s:1Ghz~0.23hz */
	uint32_t pulse;   /* unit:ns (pulse <= period) */
};
/**
  * @}
  */

/** @addtogroup PWM_Public_Functions
  * @{
  */
void bsp_pwm_init(timer_handle_t *hperh);
void bsp_pwm_enable(timer_handle_t *hperh, int channel);
void bsp_pwm_disable(timer_handle_t *hperh, int channel);
void bsp_pwm_set(timer_handle_t *hperh, int channel, uint32_t period, uint32_t pulse);
void bsp_pwm_control(timer_handle_t *hperh, int cmd, void *arg);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#endif
