/**
  *********************************************************************************
  *
  * @file    bsp_led.h
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_LED_H__
#define __BSP_LED_H__

#include "ald_gpio.h"

#ifdef _cplusplus
extern "C" {
#endif
/** @addtogroup ES32F3xxx_BSP
  * @{
  */
  
/** @addtogroup LED
  * @{
  */
  
/** @defgroup LED_Private_Macros LED Private Macros
  * @{
  */
#define BSP_LED_MAX	2

#define GPIO_PORT_LED3	  GPIOC
#define GPIO_PIN_LED3     GPIO_PIN_13
#define GPIO_PORT_LED2	  GPIOC
#define GPIO_PIN_LED2     GPIO_PIN_10

/**
  * @}
  */
/** @addtogroup LED_Public_Functions
  * @{
  */
void bsp_led_init(void);
void bsp_led_on(uint8_t num);
void bsp_led_off(uint8_t num);
void bsp_led_toggle(uint8_t num);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
