/**
  *********************************************************************************
  *
  * @file    bsp_key.c
  * @brief   KEY driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_KEY_H__
#define __BSP_KEY_H__

#ifdef _cplusplus
extern "C" {
#endif

/** @addtogroup ES32F3xxx_BSP
  * @{
  */
  
/** @addtogroup KEY
  * @{
  */

/** @defgroup KEY_Private_Macros key Private Macros
  * @{
  */

#define KEY_COUNT    2	   		  

/* Rename key state name according to application */
#define KEY_DOWN_K3		KEY_3_DOWN
#define KEY_UP_K3		KEY_3_UP
#define KEY_LONG_K3		KEY_3_LONG

#define KEY_DOWN_K2		KEY_2_DOWN
#define KEY_UP_K2		KEY_2_UP
#define KEY_LONG_K2		KEY_2_LONG

/* Key ID, the parameter of bsp_key_state() function */
typedef enum {
	KID_K3 = 0,
	KID_K2,
} key_id_e;

/* Key detect time and long time detecte time */
#define KEY_FILTER_TIME   5
#define KEY_LONG_TIME     100
#define KEY_FIFO_SIZE	10

/* Every key gloable variable */
typedef struct {
	uint8_t (*key_pressed_detect)(void); /* Key pressed down read function */
	uint8_t  count;			     /* Filter counter */
	uint16_t long_count;		     /* Long pressed counter */
	uint16_t long_time;		     /* Long pressed time */
	uint8_t  state;			     /* Key state */
	uint8_t  repeat_speed;	             /* Press continous period */
	uint8_t  repeat_count;	        
} key_property_t;

typedef enum {
	KEY_NONE = 0,			
	KEY_3_DOWN,				
	KEY_3_UP,				
	KEY_3_LONG,				
	KEY_2_DOWN,				
	KEY_2_UP,				
	KEY_2_LONG,				
} KEY_ENUM;

typedef struct {
	uint8_t buffer[KEY_FIFO_SIZE];		
	uint8_t read;					
	uint8_t write;					
	uint8_t read2;					
} key_fifo_t;

/**
  * @}
  */

/** @addtogroup KEY_Public_Functions
  * @{
  */
void bsp_key_init(void);
void bsp_key_scan(void);
void bsp_put_key(uint8_t keycode);
uint8_t bsp_get_key(void);
uint8_t bsp_get_key2(void);
uint8_t bsp_get_key_state(key_id_e keyid);
void bsp_set_key_param(uint8_t keyid, uint16_t longtime, uint8_t  repeatspeed);
void bsp_clear_key(void);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif	

#endif

