/**
  *********************************************************************************
  *
  * @file    bsp_infrared.c
  * @brief   Infrared driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
#ifndef __BSP_INFRARED_H__
#define __BSP_INFRARED_H__

#include "ald_timer.h"

#ifdef _cplusplus
extern "C" {
#endif

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @addtogroup Infrared
  * @{
  */

/** @defgroup Infrared_Public_Variable_and_Macros Infrared Public Variable and Macros
  * @{
  */
extern timer_handle_t h_tim;

#define INFRARED_PORT GPIOC
#define INFRARED_PIN  GPIO_PIN_6
/**
  * @}
  */

/** @addtogroup Infrared_Public_Functions
  * @{
  */
void bsp_infrared_init(void);
uint8_t bsp_infrared_scan(void);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif

