/**
  *********************************************************************************
  *
  * @file    bsp_eeprom.h
  * @brief   Header of eeprom driver
  *
  * @version V1.0
  * @date    16 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __EEPROM_H__
#define __EEPROM_H__

#ifdef _cplusplus
extern "C" {
#endif

#include "ald_i2c.h"
#include "string.h"

/** @addtogroup ES32F3xxx_BSP
  * @{
  */

/** @addtogroup EEPROM
  * @{
  */

/** @defgroup EEPROM_Private_Micros eeprom Private Micros
  * @{
  */
#define EEPROM_SCL_PORT	GPIOB
#define EEPROM_SCL_PIN	GPIO_PIN_6
#define EEPROM_SCL_FUN	GPIO_FUNC_5

#define EEPROM_SDA_PORT	GPIOB
#define EEPROM_SDA_PIN	GPIO_PIN_7
#define EEPROM_SDA_FUN	GPIO_FUNC_5

/**
  * @}
  */

/** @defgroup EEPROM_Public_enum eeprom Public Enums
  * @{
  */

typedef enum eep_operat_s {
	EEP_OK    = 0,
	EEP_ERROR = 1,
} eep_operat_t;

extern i2c_handle_t h_i2c;

/**
  * @}
  */

/** @addtogroup EEPROM_Public_Functions
  * @{
  */
extern void bsp_eeprom_init(void);
extern eep_operat_t bsp_eeprom_write(uint16_t dev_addr, uint16_t mem_addr,
				 i2c_addr_size_t add_size, uint8_t *buf, uint16_t size);

extern eep_operat_t bsp_eeprom_read(uint16_t dev_addr, uint16_t mem_addr,
				i2c_addr_size_t add_size, uint8_t *buf, uint16_t size);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
