/**
  *********************************************************************************
  *
  * @file    bsp_can.c
  * @brief   Can driver
  *
  * @version V1.0
  * @date    24 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_CAN_H__
#define __BSP_CAN_H__

#include "ald_gpio.h"
#include "string.h"
#include "ald_can.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F0xx_BSP
  * @{
  */

/**
  * @addtogroup CAN
  * @{
  */

/** @defgroup Can_Public_Variables CAN Public Variable
  * @{
  */
typedef enum can_status_s {
	CAN_OK      = 0,
	CAN_ERROR   = 1,
	CAN_BUSY    = 2,
	CAN_TIMEOUT = 3
} can_status_t;

extern can_handle_t h_can;
extern can_rx_msg_t rx_msg;
extern uint8_t can_flag;

/**
  * @}
  */
	
/** @defgroup Can_Public_Macros Can Public Macros
  * @{
  */
#define CAN_ID_EXTEND

#define CAN_TX_PORT  GPIOB
#define CAN_RX_PORT  GPIOB
#define CAN_TX_PIN   GPIO_PIN_9
#define CAN_RX_PIN   GPIO_PIN_8
#define CAN_TX_FUNC  GPIO_FUNC_3
#define CAN_RX_FUNC  GPIO_FUNC_3
/**
  * @}
  */

/** @addtogroup Can_Public_Functions
  * @{
  */
void bsp_can_init(void);
can_status_t can_send_msg(void);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
