/**
  *********************************************************************************
  *
  * @file    bsp_audio.h
  * @brief   Audio driver
  *
  * @version V1.0
  * @date    10 May 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          10 May 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
#ifndef __BSP_AUDIO_H__
#define __BSP_AUDIO_H__

#include <stdint.h>

#ifdef _cplusplus
extern "C" {
#endif

/** @defgroup VS1053_SPI_Bus_Macros VS1053 SPI Bus Macros 
  * @{
  */
#define VS1053_SCK_PORT	GPIOH
#define VS1053_SCK_PIN	GPIO_PIN_3
#define VS1053_MISO_PORT GPIOH
#define VS1053_MISO_PIN	 GPIO_PIN_4
#define VS1053_MOSI_PORT GPIOF
#define VS1053_MOSI_PIN  GPIO_PIN_7


/**
  * @}
  */

/** @defgroup VS1053_Macros VS1053 Macros 
  * @{
  */
#define VS1053_CS_0()	GPIOF->BSRR = (GPIO_PIN_6 << 16)
#define VS1053_CS_1()	GPIOF->BSRR = GPIO_PIN_6
#define VS1053_DS_0()	GPIOD->BSRR = (GPIO_PIN_6 << 16)
#define VS1053_DS_1()	GPIOD->BSRR = GPIO_PIN_6
#define VS1053_RST_0()  GPIOF->BSRR = (GPIO_PIN_0 << 16)
#define VS1053_RST_1()  GPIOF->BSRR = (GPIO_PIN_0)
/* VS1053_DREQ = PE6 */
#define VS1053_IS_BUSY() ((GPIOE->DIN & GPIO_PIN_6) == 0)
/**
  * @}
  */
  
/**
  * @defgroup VS1053_Private_Macros VS1053 Private Macros
  * @{
  */
enum
{
	VS1053 = 4,
};

#define VS_WRITE_COMMAND 	0x02
#define VS_READ_COMMAND 	0x03

#define GPIO_DDR		0XC017
#define GPIO_IDATA		0XC018
#define GPIO_ODATA		0XC019

#define SCI_MODE        	0x00
#define SCI_STATUS      	0x01
#define SCI_BASS        	0x02
#define SCI_CLOCKF      	0x03
#define SCI_DECODE_TIME 	0x04
#define SCI_AUDATA      	0x05
#define SCI_WRAM        	0x06
#define SCI_WRAMADDR    	0x07
#define SCI_HDAT0       	0x08
#define SCI_HDAT1       	0x09

#define SCI_AIADDR      	0x0a
#define SCI_VOL         	0x0b
#define SCI_AICTRL0     	0x0c
#define SCI_AICTRL1     	0x0d
#define SCI_AICTRL2     	0x0e
#define SCI_AICTRL3     	0x0f
#define SM_DIFF         	0x01
#define SM_JUMP         	0x02
#define SM_RESET        	0x04
#define SM_OUTOFWAV     	0x08
#define SM_PDOWN        	0x10
#define SM_TESTS        	0x20
#define SM_STREAM       	0x40
#define SM_PLUSV        	0x80
#define SM_DACT         	0x100
#define SM_SDIORD       	0x200
#define SM_SDISHARE     	0x400
#define SM_SDINEW       	0x800
#define SM_ADPCM        	0x1000
#define SM_ADPCM_HP     	0x2000

#define VS_VOL_MUTE		0    
#define VS_VOL_MAX		254  
#define VS_VOL_MIN		0    

/**
  * @}
  */


/** @addtogroup VS1053_SPI_Bus_Public_Functions
  * @{
  */
void bsp_init_spi(void);
void bsp_spi_write0(uint8_t ucbyte);
uint8_t bsp_spi_read0(void);
void bsp_spi_write1(uint8_t ucbyte);
uint8_t bsp_spi_read1(void);
uint8_t bsp_spi_bus_busy(void);
void bsp_spi_bus_enter(void);
void bsp_spi_bus_exit(void);
uint8_t bsp_spi_bus_busy(void);
void bsp_set_spi_sck(uint8_t data);
/**
  * @}
  */

/** @addtogroup VS1053_Public_Functions
  * @{
  */
void bsp_audio_init(void);
void vs1053_init(void);
uint8_t vs1053_test_ram(void);
void vs1053_test_sine(void);
void vs1053_soft_reset(void);
void vs1053_hd_reset(void);
void reset_decode_time(void);
uint8_t vs1053_req_new_data(void);
void vs1053_write_data(uint8_t data);
void vs1053_set_volume(uint8_t vol);
uint8_t vs1053_read_chip_id(void);
uint8_t vs1053_wait_timeout(void);
void vs1053_prewrite_data(void);
void vs1053_set_bass(int8_t highamp, uint16_t highfreqcut, uint8_t lowamp, uint16_t lowfreqcut);
void vs1053_spk_set(uint8_t sw);
uint16_t vs1053_read_reg(uint8_t addr);
void vs1053_write_cmd(uint8_t addr, uint16_t data);
void vs1053_write_mp3(uint8_t data);
/**
  * @}
  */

#ifdef _cplusplus
}
#endif	

#endif
