/**
  *********************************************************************************
  *
  * @file    bsp_adc.c
  * @brief   Header of adc driver
  *
  * @version V1.0
  * @date    16 Apr 2020
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2020     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_ADC_H__
#define _BSP_ADC_H__

#include "ald_gpio.h"
#include "ald_adc.h"

#ifdef _cplusplus
extern "C" {
#endif
 /** @addtogroup ES32F3xx_BSP
   * @{
   */

/** @addtogroup ADC
  * @{
  */
#define ADC_IN_PORT	GPIOA
#define ADC_IN5_PIN	GPIO_PIN_1

/** @addtogroup ADC_Public_Functions
  * @{
  */
void adc_pin_init(void);
void adc_key_pin_init(void);

void adc_module_init(void);
void adc_key_module_init(void);
uint32_t adc_average(void);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#ifdef _cplusplus
}
#endif

#endif
