/**********************************************************************************
 *
 * @file    bsp_led.h
 * @brief   header file of bsp_led.c
 *
 * @date    12 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Jul 2022     Kevin           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BS_LED_H__
#define __BS_LED_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes -------------------------------------------------------------------*/
#include "es32f0943.h"

/** @addtogroup Micro_Driver
  * @{
  */

/** @defgroup BSP_Board LED
  * @brief LED micro driver
  * @{
  */

/** @defgroup BSP_Board_Public_Functions Initialization
  * @{
  */
void bsp_led_gpio_init(void);
void bsp_led_rcu_init(void);
void bsp_led_init(void);

void bsp_led1_gpio_init(void);
void bsp_led2_gpio_init(void);
void bsp_led3_gpio_init(void);
void bsp_led4_gpio_init(void);

void bsp_Led1_On(void);
void bsp_Led1_Off(void);
void bsp_Led2_On(void);
void bsp_Led2_Off(void);
void bsp_Led3_On(void);
void bsp_Led3_Off(void);
void bsp_Led4_On(void);
void bsp_Led4_Off(void);
#endif
/**
  * @}
  */


/**
  * @}
  */

/**
  * @}
  */

/**
  * @} Micro_Driver
  */


#ifdef __cplusplus
}
#endif

