/**********************************************************************************
 *
 * @file    bsp_led.h
 * @brief   header file of bsp_led.c
 *
 * @date    12 Jul 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Jul 2022     Kevin          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __BS_LED_H__
#define __BS_LED_H__

#ifdef __cplusplus
extern "C" {
#endif

/* Includes -------------------------------------------------------------------*/
#include "ES32F0930.h"

/** @addtogroup Micro_Driver
  * @{
  */
/** @defgroup BSP Board function ES32F0930 GPIO
  * @brief BSP Board function ES32F0930 GPIO micro driver
  * @{
  */

/** @defgroup BSP Board function ES32F0930 GPIO Pubulic Types
  * @{
  */



/** @defgroup MD Board function ES32F0930_Public_Functions_Group
  * @{
  */

void bsp_led_init(void);

void bsp_led1_gpio_init(void);
void bsp_led2_gpio_init(void);
void bsp_led3_gpio_init(void);
void bsp_led4_gpio_init(void);

void bsp_led1_on(void);
void bsp_led1_off(void);
void bsp_led2_on(void);
void bsp_led2_off(void);
void bsp_led3_on(void);
void bsp_led3_off(void);
void bsp_led4_on(void);
void bsp_led4_off(void);


#endif
/**
  * @}
  */


/**
  * @}
  */

/**
  * @}
  */

/**
  * @} Micro_Driver
  */


#ifdef __cplusplus
}
#endif

