/**
  *********************************************************************************
  *
  * @file    bsp_rtc.c
  * @brief   RTC driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#include <stdio.h>
#include "bsp_rtc.h"

/** @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @defgroup RTC rtc
  * @{
  */

/**
  * @defgroup RTC_Public_Functions rtc Public Functions
  * @brief    BSP RTC Functions
  * @verbatim
=========================================================================================
              ##### BSP RTC Functions #####
=========================================================================================
   [..]   This section provides functions allowing to:
      (+) Initialize bsp rtc module.

    @endverbatim
  * @{
  */

/**
  * @brief  rtc module initialize function
  * @retval None
  */
void rtc_module_init(void *rtc_param)
{
	rtc_param_t *p_rtc = (rtc_param_t *)rtc_param;

	/* Initialize RTC */
	p_rtc->init.asynch_pre_div  = 0;
	p_rtc->init.synch_pre_div   = 32767;
	p_rtc->init.hour_format     = RTC_HOUR_FORMAT_24;
	p_rtc->init.output          = RTC_OUTPUT_DISABLE;
	p_rtc->init.output_polarity = RTC_OUTPUT_POLARITY_HIGH;
	ald_rtc_init(&p_rtc->init);

	/* Set current time and date */
	p_rtc->time.hour    = 21;
	p_rtc->time.minute  = 22;
	p_rtc->time.second  = 43;
	p_rtc->time.sub_sec = 123;
	p_rtc->date.day     = 11;
	p_rtc->date.month   = 9;
	p_rtc->date.year    = 17;
	p_rtc->date.week    = 1;
	ald_rtc_set_time(&p_rtc->time, RTC_FORMAT_DEC);
	ald_rtc_set_date(&p_rtc->date, RTC_FORMAT_DEC);

	/* Enable second interrupt */
	ald_rtc_interrupt_config(RTC_IT_SEC, ENABLE);
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
