/**
  *********************************************************************************
  *
  * @file    bsp_led.c
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#include <stdio.h>
#include "bsp_led.h"

/** @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @defgroup LED led 
  * @{
  */

/**
  * @defgroup LED_Public_Functions led Public Functions
  * @brief    BSP LED Functions
  * @verbatim
====================================================================================
              ##### BSP RTC Functions #####
====================================================================================
   [..]   This section provides functions allowing to:
      (+) Initialize bsp led moudule.
      (+) Control specific led light or extinguish.

    @endverbatim
  * @{
  */

/**
  * @brief  led pin initialization
  * @retval None
  */
void led_module_init(void)
{
	/* Initialize led pin */
	gpio_init_t x;

	/* Initialize PC9 pin */
	x.mode = GPIO_MODE_OUTPUT;
	x.pupd = GPIO_PUSH_UP;
	x.odos = GPIO_PUSH_PULL;
	x.odrv = GPIO_OUT_DRIVE_NORMAL;
	x.flt  = GPIO_FILTER_DISABLE;
	x.type = GPIO_TYPE_CMOS;
	x.func = GPIO_FUNC_1;

	ald_gpio_init(BSP_LED0_PORT, BSP_LED0_PIN, &x);	/* LED0 */
	ald_gpio_init(BSP_LED1_PORT, BSP_LED1_PIN, &x);	/* LED1 */
	ald_gpio_init(BSP_LED2_PORT, BSP_LED2_PIN, &x);	/* LED2 */
	ald_gpio_init(BSP_LED3_PORT, BSP_LED3_PIN, &x);	/* LED3 */
	ald_gpio_init(BSP_LED4_PORT, BSP_LED4_PIN, &x);	/* LED4 */
	ald_gpio_init(BSP_LED5_PORT, BSP_LED5_PIN, &x);	/* LED5 */	

	ald_gpio_write_pin(BSP_LED0_PORT, BSP_LED0_PIN, LED_OFF);	/* LED0 */
	ald_gpio_write_pin(BSP_LED1_PORT, BSP_LED1_PIN, LED_OFF);	/* LED1 */
	ald_gpio_write_pin(BSP_LED2_PORT, BSP_LED2_PIN, LED_OFF);	/* LED2 */
	ald_gpio_write_pin(BSP_LED3_PORT, BSP_LED3_PIN, LED_OFF);	/* LED3 */
	ald_gpio_write_pin(BSP_LED4_PORT, BSP_LED4_PIN, LED_OFF);	/* LED4 */
	ald_gpio_write_pin(BSP_LED5_PORT, BSP_LED5_PIN, LED_OFF);	/* LED5 */

	ald_gpio_init(GPIOA, GPIO_PIN_15, &x);
	ald_gpio_write_pin(GPIOA, GPIO_PIN_15, 1);
}

/**
  * @brief  control specific led light or extinguish
  * @param  led: which led want to operate
  * @param  flag: led light or extinguish 
  * @retval None
  */
void led_operate(int8_t led, led_ctl_t flag)
{
	GPIO_TypeDef *p_group = NULL;
	uint16_t p_num;

	if ((led < 0) || (led > 6))
		return;

	switch (led) {
	case 0:
		p_group = BSP_LED0_PORT;
		p_num   = BSP_LED0_PIN;
		break;
	case 1:
		p_group = BSP_LED1_PORT;
		p_num   = BSP_LED1_PIN;
		break;
	case 2:
		p_group = BSP_LED2_PORT;
		p_num   = BSP_LED2_PIN;
		break;
	case 3:
		p_group = BSP_LED3_PORT;
		p_num   = BSP_LED3_PIN;
		break;
	case 4:
		p_group = BSP_LED4_PORT;
		p_num   = BSP_LED4_PIN;
		break;
	case 5:
		p_group = BSP_LED5_PORT;
		p_num   = BSP_LED5_PIN;
		break;
	default:
		break;
	}

	if (flag == LED_ON) {
		ald_gpio_write_pin(p_group, p_num, LED_ON);
	} else {
		ald_gpio_write_pin(p_group, p_num, LED_OFF);
	}

	return;
}
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
