/**
  *********************************************************************************
  *
  * @file    bsp_w25q32.h
  * @brief   Header of w25q32 driver
  *
  * @version V1.0
  * @date    16 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef _BSP_W25Q32_H
#define _BSP_W25Q32_H

#ifdef _cplusplus
extern "C" {
#endif

#include "ald_spi.h"
#include "string.h"

/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup W25Q32
  * @{
  */

/**
  * @defgroup W25Q32_Private_Micros spi flash Private Micros
  * @{
  */

#define W25Q32_CS_SET()	ald_gpio_write_pin(GPIOE, GPIO_PIN_0, 1)
#define W25Q32_CS_CLR()	ald_gpio_write_pin(GPIOE, GPIO_PIN_0, 0)

/**
  * @}
  */

/**
  * @defgroup W25Q32_Private_enum spi flash Private Enums
  * @{
  */

typedef enum w25_status_s {
	W25_OK    = 0,
	W25_ERROR = 1,
} w25_status_t;

/**
  * @}
  */

/**
  * @addtogroup W25Q32_Public_Functions
  * @{
  */
extern void w25q32_module_init(void);
extern w25_status_t w25q32_read(uint32_t addr, uint8_t *buf, uint16_t size);
extern w25_status_t w25q32_write(uint32_t addr, uint8_t *buf, uint16_t size);
extern w25_status_t w25q32_sector_erase(uint8_t addr);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
