/**
  *********************************************************************************
  *
  * @file    bsp_uart_485.c
  * @brief   UART_485 driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_UART_485_H
#define _BSP_UART_485_H

#include "ald_gpio.h"
#include "ald_uart.h"
#include "string.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup UART_485
  * @{
  */

/**
  * @defgroup UART_485_Private_Enum uart 485 Private Enums
  * @{
  */
typedef enum uart_485_status_s {
	UART_485_OK    = 0,
	UART_485_ERROR = 1,
} uart_485_status_t;
/**
  * @}
  */

/**
  * @addtogroup UART_485_Public_Functions
  * @{
  */

extern void uart_485_module_init(uint32_t baud, uint8_t addr);
extern uart_485_status_t bsp_uart_485_send_addr(uint16_t addr);
extern uart_485_status_t bsp_uart_485_send(uint8_t *buf, uint16_t size);
extern uart_485_status_t bsp_uart_485_recv(uint8_t *buf, uint16_t size);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
