/**
  *********************************************************************************
  *
  * @file    bsp_uart_38k.c
  * @brief   UART_38K driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_UART_38K_H
#define _BSP_UART_38K_H

#include "ald_gpio.h"
#include "ald_uart.h"
#include "ald_timer.h"
#include "string.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup UART_38K
  * @{
  */

/**
  * @defgroup UART_38K_Parivate_Enum uart 38k Private Enums
  * @{
  */
typedef enum uart_38k_status_s {
	UART_38K_OK    = 0,
	UART_38K_ERROR = 1,
} uart_38k_status_t;

/**
  * @}
  */

/**
  * @addtogroup UART_38K_Public_Functions
  * @{
  */

extern void uart_38k_module_init(uint32_t baud, uint8_t mode);
extern uart_38k_status_t bsp_uart_38k_send(uint8_t *buf, uint16_t size);
extern uart_38k_status_t bsp_uart_38k_recv(uint8_t *buf, uint16_t size);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
