/**
  *********************************************************************************
  *
  * @file    bsp_uart_usb.c
  * @brief   UART_USB driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_UART_232_H
#define _BSP_UART_232_H

#include "ald_gpio.h"
#include "ald_uart.h"
#include "string.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup UART_232
  * @{
  */

/**
  * @defgroup UART_232_Parivate_Enum uart 232 Parivate Enums
  * @{
  */
typedef enum uart_232_status_s {
	UART_232_OK    = 0,
	UART_232_ERROR = 1,
} uart_232_status_t;

/**
  * @}
  */

/**
  * @addtogroup UART_232_Public_Functions
  * @{
  */

extern void uart_232_module_init(uint32_t baud);
extern uart_232_status_t bsp_uart_232_send(uint8_t *buf, uint16_t size);
extern uart_232_status_t bsp_uart_232_recv(uint8_t *buf, uint16_t size);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
