/**
  *********************************************************************************
  *
  * @file    bsp_rtc.c
  * @brief   RTC driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_RTC_H
#define _BSP_RTC_H

#include "ald_rtc.h"

#ifdef _cplusplus
extern "C" {
#endif
 /**
   * @addtogroup ES32F03xx_BSP
   * @{
   */

/**
  * @addtogroup RTC
  * @{
  */

/**
  * @defgroup RTC_Parivate_Types rtc Parivate Types
  * @{
  */

/**
  * @brief RTC module structure
  */
typedef struct rtc_param_s {
	rtc_time_t time;
	rtc_date_t date;
	rtc_init_t init;
} rtc_param_t;

/**
  * @}
  */

/**
  * @addtogroup RTC_Public_Functions
  * @{
  */

void rtc_module_init(void *rtc_param);

/**
  * @}
  */

/**
  * @}
  */
/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
