/**
  *********************************************************************************
  *
  * @file    bsp_rgb.c
  * @brief   Header of rgb driver
  *
  * @version V1.0
  * @date    16 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
  
#ifndef _BSP_RGB_H
#define _BSP_RGB_H

#ifdef _cplusplus
extern "C" {
#endif

#include "ald_gpio.h"
#include "ald_timer.h"

#ifdef ES32F0334
#include "ald_lptim.h"
#endif

#include "ald_cmu.h"

/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup RGB
  * @{
  */

/**
  * @defgroup RGB_Private_Type rgb Private Types
  * @{
  */
/**
  * @brief RGB module timer structure
  */
typedef struct rgb_tim3_env_s {
	timer_handle_t tim_h; 
	timer_oc_init_t tim_ocinit;
	timer_clock_config_t tim_clock;
} rgb_tim3_env_t;

#ifdef ES32F0334
typedef struct rgb_lptim0_env_s {
	lptim_handle_t lptim_h;
	lptim_trigger_init_t lptim_trig;
	lptim_clock_source_init_t lptim_clk;
} rgb_lptim0_env_t;
#endif

/**
  * @}
  */

/**
  * @addtogroup RGB_Public_Function
  * @{
  */

extern void rgb_module_init(void *rgb_tim3, void *rgb_lptim0);
extern void lptim_pwm_set_duty(void *rgb_lptim0, uint8_t duty);

/**
  * @}
  */
 
/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
