/**
  *********************************************************************************
  *
  * @file    bsp_rf.h
  * @brief   Header of rf driver.
  *
  * @version V1.0
  * @date    04 Jul 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          04 Jul 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_RF_H__
#define __BSP_RF_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "utils.h"
#include "ald_spi.h"
#include "ald_gpio.h"

/** @addtogroup ES32F03xx_BSP
  * @{
  */

/** @addtogroup RF
  * @{
  */

/** @defgroup RF_Private_Macros rf Private Macros
  * @{
  */
#define ADDR_READ_RESET	0X7F
#define ADDR_WRITE_SET	0X80

/*CS  --->PD9*/
#define PORT_CS		GPIOD
#define PIN_CS		GPIO_PIN_9

/*SCK---->PB3*/
#define PORT_SCK	GPIOB
#define PIN_SCK		GPIO_PIN_3

/*MISO--->PB4*/
#define PORT_MISO	GPIOB
#define PIN_MISO	GPIO_PIN_4

/*MOSI--->PB5*/
#define PORT_MOSI	GPIOB
#define PIN_MOSI	GPIO_PIN_5

/*PDN--->PC8*/
#define PORT_PDN	GPIOC
#define PIN_PDN		GPIO_PIN_8

/*IRQ--->PD8*/
#define PORT_IRQ	GPIOD
#define PIN_IRQ		GPIO_PIN_8

/*GP1--->PD10*/
#define PORT_GP1	GPIOD
#define PIN_GP1		GPIO_PIN_10

/*GP2--->PD11*/
#define PORT_GP2	GPIOD
#define PIN_GP2		GPIO_PIN_11

#define RF_CS_0()	ald_gpio_write_pin(PORT_CS, PIN_CS, 0)
#define RF_CS_1()	ald_gpio_write_pin(PORT_CS, PIN_CS, 1)

/*˵296SPI0HW3000SPIʱڰͨǴֽƥ*/
#define SWAP(data) data =(((data & 0x00ff)<<8)|((data & 0xff00)>>8))   /* 16-bitݸߵ8λ*/

/* bank0 register */
#define RFID		0x00
#define TRCTRL		0x01
#define PKTCTRL		0x02
#define PKTCFG0		0x03
#define CRCSEED		0x04
#define PKTCFG1		0x05
#define FIFOTHRES	0x06
#define TXPHR0		0x07
#define TXPHR1		0x08
#define PSDULEN		0x09
#define RXPHR0		0x0A
#define RXPHR1		0x0B
#define FIFOCTRL	0x0C
#define LEN0PKLEN	0x0D
#define FIFOSTA		0x0E
#define INTFLAG		0x0F //INT
#define INTIE		0x10
#define INTIC		0x11
#define CRCVAL		0x12
#define PIPECTRL	0x13
#define P0ADDR0		0x14
#define P0ADDR1		0x15
#define P0ADDR2		0x16
#define P1ADDR0		0x17
#define	P1ADDR1		0x18
#define P1ADDR2		0x19
#define P23ADDR		0x1A
#define CHIPSTA0	0x1B
#define MODECTRL	0x1C
#define GPIOCFG0	0x1D
#define GPIOCFG1	0x1E
#define WDTCFG0		0x1F
#define WDTCFG1		0x20
#define WDTWDV		0x21
#define AGCGAIN		0x22
#define RSSI		0x23
#define PREACFG		0x24
#define MODEMCTRL	0x25
#define MIXFW		0x26 //IFSET
#define CDTH		0x27
#define CHCFG0		0x28
#define CHCFG1		0x29
#define CHCFG2		0x2A
#define CHCFG3		0x2B
#define DEVIATION	0x2C
#define HOPCFG		0x2D
#define FILTERBAND	0x2E
#define FREQCFG0	0x2F
#define FREQCFG1	0x30
#define FREQCFG2	0x31
#define SYMRATE0	0x32
#define SYMRATE1	0x33
#define RFCFG		0x35
#define CHIPSTA1	0x36
#define XOSCCAL		0x37
#define RCCFG0		0x38
#define RCSTA		0x39
#define RCCFG1		0x3A
#define HOPSPACE0	0x3C
#define HOPSPACE1	0x3D
#define RSSICFG		0x3E
#define HOPCH		0x3F
#define PACFG		0x40
#define ACKCFG		0x45
#define FIFOPTR		0x4D
#define LEN0RXADD	0x4E
#define INVSFDTIME	0x4F
#define SFTRST0		0x60
#define SFTRST1		0x61
#define REGCHECK	0x6F
#define FIFODATA	0x70

/* bank1 register */
#define BK03	0x03
#define BK11	0x11
#define BK14	0x14
#define BK17	0x17
#define BK1B	0x1B
#define BK1C	0x1C
#define BK1D	0x1D
#define BK1E	0x1E
#define BK1F	0x1F
#define BK20	0x20
#define BK21	0x21
#define BK22	0x22
#define BK23	0x23
#define BK24	0x24
#define BK25	0x25
#define BK26	0x26
#define BK27	0x27
#define BK28	0x28
#define BK29	0x29
#define BK2A	0x2A
#define BK40	0x40
#define BK41	0x41
#define BK42	0x42
#define BK43	0x43
#define BK51	0x51
#define BK55	0x55
#define BK56	0x56
#define BK62	0x62

/**
  * @}
  */

/** @defgroup RF_Public_Types rf Public Enums
  * @{
  */

typedef enum {
	POWER_20dBm   = 0,
	POWER_18dBm   = 1,
	POWER_15dBm   = 2,
	POWER_10dBm   = 3,
	POWER_5dBm    = 4,
	POWER_0dBm    = 5,
	POWER_N_5dBm  = 6,
	POWER_N_10dBm = 7,
	POWER_N_16dBm = 8,
	POWER_N_40dBm = 9
} POWER_e;

/**
  * @}
  */

/** @addtogroup RF_Public_Functions
  * @{
  */
extern void hw3000_power_set(POWER_e powerdbm);
extern void bsp_InitHW3000(void);
extern uint16_t hw3000_read_reg(uint8_t addr);
extern void hw3000_write_reg(uint8_t addr, uint16_t data);
extern void hw3000_tx_data(uint8_t *txBuf, uint8_t len);
extern uint8_t hw3000_ReadFIFO(uint8_t * buf);
extern void hw3000_rx_enable(void);
/**
  * @}
  */

/** @addtogroup RF_Public_Variable
  * @{
  */

extern volatile uint8_t RF_Irq_Flag;

/**
  * @}
  */

/**
  * @}
  */
/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif
