/**
  *********************************************************************************
  *
  * @file    bsp_mpu9250.c
  * @brief   Header of mpu9250 driver
  *
  * @version V1.0
  * @date    06 Jun 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          06 Jun 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef __BSP_MPU9250_H__
#define __BSP_MPU9250_H__

#include "utils.h"
#include "stdlib.h"
#include "ald_gpio.h"
#include "ald_i2c.h"

//#define MPU9250

#define LOOP_TIME		3

#define MPU9250_ADDR		0XD0

#define MPU_ID			0X71


#define MPU_SELF_TESTX_REG	0X0D
#define MPU_SELF_TESTY_REG	0X0E
#define MPU_SELF_TESTZ_REG	0X0F
#define MPU_SELF_TESTA_REG	0X10
#define MPU_SAMPLE_RATE_REG	0X19
#define MPU_CFG_REG		0X1A
#define MPU_GYRO_CFG_REG	0X1B
#define MPU_ACCEL_CFG_REG	0X1C
#define MPU_MOTION_DET_REG	0X1F
#define MPU_FIFO_EN_REG		0X23
#define MPU_I2CMST_CTRL_REG	0X24
#define MPU_I2CSLV0_ADDR_REG	0X25
#define MPU_I2CSLV0_REG		0X26
#define MPU_I2CSLV0_CTRL_REG	0X27
#define MPU_I2CSLV1_ADDR_REG	0X28
#define MPU_I2CSLV1_REG		0X29
#define MPU_I2CSLV1_CTRL_REG	0X2A
#define MPU_I2CSLV2_ADDR_REG	0X2B
#define MPU_I2CSLV2_REG		0X2C
#define MPU_I2CSLV2_CTRL_REG	0X2D
#define MPU_I2CSLV3_ADDR_REG	0X2E
#define MPU_I2CSLV3_REG		0X2F
#define MPU_I2CSLV3_CTRL_REG	0X30
#define MPU_I2CSLV4_ADDR_REG	0X31
#define MPU_I2CSLV4_REG		0X32
#define MPU_I2CSLV4_DO_REG	0X33
#define MPU_I2CSLV4_CTRL_REG	0X34
#define MPU_I2CSLV4_DI_REG	0X35

#define MPU_I2CMST_STA_REG	0X36
#define MPU_INTBP_CFG_REG	0X37
#define MPU_INT_EN_REG		0X38
#define MPU_INT_STA_REG		0X3A

#define MPU_ACCEL_XOUTH_REG	0X3B
#define MPU_ACCEL_XOUTL_REG	0X3C
#define MPU_ACCEL_YOUTH_REG	0X3D
#define MPU_ACCEL_YOUTL_REG	0X3E
#define MPU_ACCEL_ZOUTH_REG	0X3F
#define MPU_ACCEL_ZOUTL_REG	0X40

#define MPU_TEMP_OUTH_REG	0X41
#define MPU_TEMP_OUTL_REG	0X42

#define MPU_GYRO_XOUTH_REG	0X43
#define MPU_GYRO_XOUTL_REG	0X44
#define MPU_GYRO_YOUTH_REG	0X45
#define MPU_GYRO_YOUTL_REG	0X46
#define MPU_GYRO_ZOUTH_REG	0X47
#define MPU_GYRO_ZOUTL_REG	0X48

#define MPU_I2CSLV0_DO_REG	0X63
#define MPU_I2CSLV1_DO_REG	0X64
#define MPU_I2CSLV2_DO_REG	0X65
#define MPU_I2CSLV3_DO_REG	0X66

#define MPU_I2CMST_DELAY_REG	0X67
#define MPU_SIGPATH_RST_REG	0X68
#define MPU_MDETECT_CTRL_REG	0X69
#define MPU_USER_CTRL_REG	0X6A
#define MPU_PWR_MGMT1_REG	0X6B
#define MPU_PWR_MGMT2_REG	0X6C
#define MPU_FIFO_CNTH_REG	0X72
#define MPU_FIFO_CNTL_REG	0X73
#define MPU_FIFO_RW_REG		0X74
#define MPU_DEVICE_ID_REG	0X75

#define BIT_I2C_MST_VDDIO   (0x80)
#define BIT_FIFO_EN         (0x40)
#define BIT_DMP_EN          (0x80)
#define BIT_FIFO_RST        (0x04)
#define BIT_DMP_RST         (0x08)
#define BIT_FIFO_OVERFLOW   (0x10)
#define BIT_DATA_RDY_EN     (0x01)
#define BIT_DMP_INT_EN      (0x02)
#define BIT_MOT_INT_EN      (0x40)
#define BITS_FSR            (0x18)
#define BITS_LPF            (0x07)
#define BITS_HPF            (0x07)
#define BITS_CLK            (0x07)
#define BIT_FIFO_SIZE_1024  (0x40)
#define BIT_FIFO_SIZE_2048  (0x80)
#define BIT_FIFO_SIZE_4096  (0xC0)
#define BIT_RESET           (0x80)
#define BIT_SLEEP           (0x40)
#define BIT_S0_DELAY_EN     (0x01)
#define BIT_S2_DELAY_EN     (0x04)
#define BITS_SLAVE_LENGTH   (0x0F)
#define BIT_SLAVE_BYTE_SW   (0x40)
#define BIT_SLAVE_GROUP     (0x10)
#define BIT_SLAVE_EN        (0x80)
#define BIT_I2C_READ        (0x80)
#define BITS_I2C_MASTER_DLY (0x1F)
#define BIT_AUX_IF_EN       (0x20)
#define BIT_ACTL            (0x80)
#define BIT_LATCH_EN        (0x20)
#define BIT_ANY_RD_CLR      (0x10)
#define BIT_BYPASS_EN       (0x02)
#define BITS_WOM_EN         (0xC0)
#define BIT_LPA_CYCLE       (0x20)
#define BIT_STBY_XA         (0x20)
#define BIT_STBY_YA         (0x10)
#define BIT_STBY_ZA         (0x08)
#define BIT_STBY_XG         (0x04)
#define BIT_STBY_YG         (0x02)
#define BIT_STBY_ZG         (0x01)
#define BIT_STBY_XYZA       (BIT_STBY_XA | BIT_STBY_YA | BIT_STBY_ZA)
#define BIT_STBY_XYZG       (BIT_STBY_XG | BIT_STBY_YG | BIT_STBY_ZG)

#define INV_X_GYRO      (0x40)
#define INV_Y_GYRO      (0x20)
#define INV_Z_GYRO      (0x10)
#define INV_XYZ_GYRO    (INV_X_GYRO | INV_Y_GYRO | INV_Z_GYRO)
#define INV_XYZ_ACCEL   (0x08)
#define INV_XYZ_COMPASS (0x01)




typedef struct bsp_mpu9250_env_s {
	/* other variables */
	i2c_handle_t h_i2c;	/**< Pointer to i2c_handle_t structure */
	uint8_t temperature;
	uint16_t pitch;
	uint16_t roll;
	uint16_t yaw;
} bsp_mpu9250_env_t;

typedef struct bsp_mpu9250_data_s {
	uint16_t gyro[3];
	uint16_t acce[3];
	uint32_t temperature;
} bsp_mpu9250_data_t;


void mpu_i2c_pin_init(void);
ald_status_t bsp_mpu_init(bsp_mpu9250_env_t *h_mpu);
uint32_t bsp_mpu_get_temperature(bsp_mpu9250_env_t *h_mpu);
ald_status_t bsp_mpu_get_gyro(bsp_mpu9250_env_t *h_mpu, uint16_t *gx, uint16_t *gy, uint16_t *gz);
ald_status_t bsp_mpu_get_acce(bsp_mpu9250_env_t *h_mpu, uint16_t *ax, uint16_t *ay, uint16_t *az);
ald_status_t bsp_mpu_data_measure(bsp_mpu9250_env_t *h_mpu, bsp_mpu9250_data_t *mpu_data);

#endif
