/**
  *********************************************************************************
  *
  * @file    bsp_micro_sd.c
  * @brief   Header of MICRO-SD driver
  *
  * @version V1.0
  * @date    10 May 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          10 May 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef	__BSP_MICRO_SD_H__
#define	__BSP_MICRO_SD_H__

#include "utils.h"
#include "ald_spi.h"


/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @defgroup SD micro-sd
  * @{
  */
/**
  * @defgroup SD_Variable_Micro Private Micros
  * @{
  */
#define SECTOR_SIZE	512
#define DELAY_CNT	25

#define SD_SCS_PIN	GPIO_PIN_15
#define SD_SCS_PORT	GPIOD
#define SD_SCS_FUNC	GPIO_FUNC_1
#define SD_SCK_PIN	GPIO_PIN_3
#define SD_SCK_PORT	GPIOB
#define SD_SCK_FUNC	GPIO_FUNC_4
#define SD_MOSI_PIN	GPIO_PIN_5
#define SD_MOSI_PORT	GPIOB
#define SD_MOSI_FUNC	GPIO_FUNC_4
#define SD_MISO_PIN	GPIO_PIN_4
#define SD_MISO_PORT	GPIOB
#define SD_MISO_FUNC	GPIO_FUNC_4

#define SD_TYPE_ERR     0x00
#define SD_TYPE_MMC     0x01
#define SD_TYPE_V1      0x02
#define SD_TYPE_V2      0x04
#define SD_TYPE_V2HC    0x06
/**
  * @}
  */

/**
  * @defgroup SD_Variable_Type Private Types
  * @{
  */
/**
  * @brief The status of card
  */
typedef enum {
	SD_SUCCESSED   = 0x00,	/*< Success */
	SD_CMD0_ERROR  = 0x01,	/*< CMD0 error */
	SD_CMD1_ERROR  = 0x02,	/*< CMD1 error */
	SD_CMD8_ERROR  = 0x08,	/*< CMD8 error */
	SD_WRITE_ERROR = 0x03,	/*< Write error */
	SD_READ_ERROR  = 0x04,	/*< Read error */
	SD_CMD9_ERROR  = 0x09,	/*< CMD9 error */
	SD_CMD41_ERROR = 0x41,	/*< CMD41 error */
	SD_CMD55_ERROR = 0x55,	/*< CMD55 error */
} sd_card_state_t;

/**
  * @brief The Types of command
  */
typedef enum {
	SD_CMD0   = 0,	/*< CMD0 */
	SD_CMD1   = 1,	/*< CMD1 */
	SD_CMD8   = 8,	/*< CMD8 */
	SD_CMD9   = 9,	/*< CMD9 */
	SD_CMD10  = 10,	/*< CMD10 */
	SD_CMD12  = 12,	/*< CMD12 */
	SD_CMD17  = 17,	/*< CMD17 */
	SD_CMD18  = 18,	/*< CMD18 */
	SD_CMD24  = 24,	/*< CMD24 */
	SD_CMD25  = 25,	/*< CMD25 */
	SD_CMD32  = 32,	/*< CMD32 */
	SD_CMD33  = 33,	/*< CMD33 */
	SD_CMD38  = 38,	/*< CMD38 */
	SD_CMD55  = 55,	/*< CMD55 */
	SD_CMD58  = 58,	/*< CMD58 */
	SD_ACMD41 = 41,	/*< CMD41 */
} sd_card_cmd_t;

/**
  * @brief The environment of sd module
  */
typedef struct bsp_sd_env_s {
	spi_handle_t h_spi;
} bsp_sd_env_t;
/**
  * @}
  */

/**
  * @addtogroup SD_Public_Variable
  * @{
  */
extern bsp_sd_env_t bsp_sd_env;
/**
  * @}
  */

/**
  * @addtogroup SD_Public_Function
  * @{
  */
/* extern function */
extern int bsp_sd_init(void);
extern int bsp_sd_read_sector(uint8_t *buf, uint32_t idx_sector);
extern int bsp_sd_write_sector(uint8_t *buf, uint32_t idx_sector);
extern int bsp_sd_erase(uint32_t s_sector, uint32_t e_sector);
extern uint32_t bsp_sd_get_size(void);
extern int bsp_sd_get_cid(uint8_t *buf);
/**
  *@}
  */

/**
  *@}
  */

/**
  *@}
  */

#endif
