/**
  *********************************************************************************
  *
  * @file    bsp_led.c
  * @brief   LED driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef _BSP_LED_H
#define _BSP_LED_H

#include "ald_gpio.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup LED
  * @{
  */

/**
  * @defgroup LED_Private_Macros led Private Macros
  * @{
  */
#define BSP_LED_MAX	6
#define BSP_LED0_PORT	GPIOC
#define BSP_LED0_PIN    GPIO_PIN_9
#define BSP_LED1_PORT	GPIOA
#define BSP_LED1_PIN    GPIO_PIN_8
#define BSP_LED2_PORT	GPIOA
#define BSP_LED2_PIN    GPIO_PIN_9
#define BSP_LED3_PORT	GPIOA
#define BSP_LED3_PIN    GPIO_PIN_10
#define BSP_LED4_PORT	GPIOA
#define BSP_LED4_PIN    GPIO_PIN_11
#define BSP_LED5_PORT	GPIOA
#define BSP_LED5_PIN    GPIO_PIN_12

/**
  * @}
  */

/**
  * @defgroup LED_Private_Types led Private Types
  * @{
  */

typedef enum {
	LED_ON  = 0,
	LED_OFF = 1,
} led_ctl_t;

/**
  * @}
  */

/**
  * @addtogroup LED_Public_Functions
  * @{
  */

extern void led_module_init(void);
extern void led_operate(int8_t led, led_ctl_t flag);

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
