/**
  *********************************************************************************
  *
  * @file    bsp_key.h
  * @brief   Header of key driver.
  *
  * @version V1.0
  * @date    04 Jul 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          04 Jul 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_KEY_H__
#define __BSP_KEY_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "utils.h"
#include "ald_gpio.h"

/** @addtogroup ES32F03xx_BSP
  * @{
  */

/** @addtogroup Key
  * @{
  */

/** @defgroup Key_Private_Macros Key Private Macros
  * @{
  */
#define BSP_KEY_MAX	4
#define BSP_KEY1_PORT	GPIOA
#define BSP_KEY1_PIN	GPIO_PIN_0
#define BSP_KEY2_PORT	GPIOE
#define BSP_KEY2_PIN	GPIO_PIN_4
#define BSP_KEY3_PORT	GPIOE
#define BSP_KEY3_PIN	GPIO_PIN_5
#define BSP_KEY4_PORT	GPIOE
#define BSP_KEY4_PIN	GPIO_PIN_6
/**
  * @}
  */

/** @defgroup Key_Public_Types Key Public Types
  * @{
  */
/**
  * @brief Event of key
  */
typedef enum {
	BSP_KEY1_PRESS   = 0,		/**< KEY1 press */
	BSP_KEY1_RELEASE = 1,		/**< KEY1 release */
	BSP_KEY2_PRESS   = 2,		/**< KEY2 press */
	BSP_KEY2_RELEASE = 3,		/**< KEY2 release */
	BSP_KEY3_PRESS   = 4,		/**< KEY3 press */
	BSP_KEY3_RELEASE = 5,		/**< KEY3 release */
	BSP_KEY4_PRESS   = 6,		/**< KEY4 press */
	BSP_KEY4_RELEASE = 7,		/**< KEY4_release */
	BSP_KEY_ALL      = 0xFF,	/**< ALL event */
} bsp_key_event_t;

typedef void (*bsp_key_cbk_t)(bsp_key_event_t event);
typedef uint8_t (*bsp_key_read_cbk_t)(void);

/**
  * @brief Key state
  */
typedef union {
	struct {
		uint8_t press :1;	/**< Key press */
		uint8_t hold  :3;	/**< Hold times */
		uint8_t rsv   :4;	/**< Reserve */
	};
	uint8_t Byte;
} bsp_key_state_t;

/**
  * @brief Key environment variable
  */
typedef struct {
	uint32_t valid;					/**< Bit feild */
	bsp_key_state_t state[BSP_KEY_MAX];		/**< Key's state */
	bsp_key_read_cbk_t read_cbk[BSP_KEY_MAX];	/**< Read key callback */
	bsp_key_cbk_t cbk[BSP_KEY_MAX << 1];		/**< Callback of the event */
} bsp_key_env_t;
/**
  * @}
  */

/** @addtogroup Key_Public_Functions
  * @{
  */
/** @addtogroup Key_Public_Functions_Group1
  * @{
  */
/* Key initialization functions */
void bsp_key_init(void);
/**
  * @}
  */

/** @addtogroup Key_Public_Functions_Group2
  * @{
  */
/* key functions */
void bsp_key_scan(void);
void bsp_key_bond_func(bsp_key_event_t event, bsp_key_cbk_t cbk);
void bsp_key_unbond_func(bsp_key_event_t event);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#ifdef __cplusplus
}
#endif

#endif	/* __BSP_KEY_H__ */
