/**
  *********************************************************************************
  *
  * @file    bsp_dht11.h
  * @brief   Header of dht11 driver
  *
  * @version V1.0
  * @date    06 Jun 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          06 Jun 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */ 

#ifndef __BSP_DHT11_H__
#define __BSP_DHT11_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "utils.h"
#include "ald_gpio.h"

/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  *@addtogroup DHT11
  *@{
  */

/**
  *@defgroup DHT11_Private_Macro dht11 Private Macros
  *@{
  */
#define DHT11_PIN_OUTPUT()	 {MODIFY_REG(GPIOF->MODE, GPIO_MODE_MODE_MSK, 2 << 14);}
#define DHT11_PIN_INPUT()	 {MODIFY_REG(GPIOF->MODE, GPIO_MODE_MODE_MSK, 1 << 14);}
/**
  *@}
  */

/**
  *@addtogroup DHT11_Public_Functions
  *@{
  */
uint8_t bsp_dht11_init(void);
uint8_t bsp_dht11_read_data(uint8_t *temp, uint8_t *humi);
/**
  *@}
  */

/**
  *@}
  */

/**
  *@}
  */

#ifdef __cplusplus
"} "
#endif

#endif
