/**
  *********************************************************************************
  *
  * @file    bsp_can.c
  * @brief   Can driver
  *
  * @version V1.0
  * @date    24 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          24 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef __BSP_CAN_H__
#define __BSP_CAN_H__

#include "ald_gpio.h"
#include "string.h"
#include "ald_can.h"

#ifdef _cplusplus
extern "C" {
#endif
/**
  * @addtogroup ES32F0xx_BSP
  * @{
  */

/**
  * @addtogroup CAN
  * @{
  */

#define CAN_ID_EXTEND

/**
  * @defgroup Can_Parivate_Enum can Private Enums
  * @{
  */
typedef enum can_status_s {
	CAN_OK      = 0,
	CAN_ERROR   = 1,
	CAN_BUSY    = 2,
	CAN_TIMEOUT = 3
} can_status_t;

/**
  * @}
  */
	
/** @defgroup Can_Private_Macros Can Private Macros
  * @{
  */
#define CAN_TX_PORT GPIOB
#define CAN_RX_PORT GPIOB
#define CAN_TX_PIN  GPIO_PIN_9
#define CAN_RX_PIN  GPIO_PIN_8
#define CAN_TX_FUNC  GPIO_FUNC_3
#define CAN_RX_FUNC  GPIO_FUNC_3
/**
  * @}
  */

/**
  * @addtogroup Can_Public_Functions
  * @{
  */
extern void can_module_init(void);
extern can_status_t can_send_msg(can_tx_msg_t tx_msg);
extern can_status_t can_recv_msg(can_rx_msg_t* rx_msg);


/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
