/**
  *********************************************************************************
  *
  * @file    bsp_buzzer.h
  * @brief   Header of buzzer driver
  *
  * @version V1.0
  * @date    16 Apr 2018
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          16 Apr 2018     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */
#ifndef _BSP_BUZZER_H
#define _BSP_BUZZER_H

#ifdef _cplusplus
extern "C" {
#endif

#include "ald_timer.h"

/**
  * @addtogroup ES32F03xx_BSP
  * @{
  */

/**
  * @addtogroup BUZZER
  * @{
  */

/**
  * @addtogroup BUZZER_Public_Variable
  * @{
  */
extern const uint8_t Music[];
/**
  * @}
  */

/**
  * @addtogroup BUZZER_Public_Functions
  * @{
  */
extern void bsp_buzzer_init(void);
extern void PlayMusic(const uint8_t *sheet);
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef _cplusplus
}
#endif

#endif
