/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2022/1/28
*描  述:  FreeRTOS例程，printf打印，TX:PA8
          可调用标准库使用，需要以下三个步骤
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR的Library选择Full
*备  注:  适用于ES8H018x芯片
          本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include <stdio.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>
#include <stream_buffer.h>
#include <semphr.h>
#include "main.h"

#define BIT_ALL 0xFFFFFFFF
#define BIT(x) (1<<(x))

/*任务句柄*/
static TaskHandle_t g_task_app_handle = NULL;
static TaskHandle_t g_task_1_handle = NULL;
static TaskHandle_t g_task_2_handle = NULL;
static TaskHandle_t g_task_3_handle = NULL;
static EventGroupHandle_t g_event_test = NULL;

/* 任务 */
static void task_app(void *arg);
static void task_1(void *arg);
static void task_2(void *arg);
static void task_3(void *arg);

int main(void)
{
    int retval;
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    UARTInit();                         //UART初始化(115200,8,NO,1)
    printf("Startup\r\n");

    retval = xTaskCreate(task_app, "AppTaskCreate", 128, NULL, 1, &g_task_app_handle);

    /* Start task schedule*/
    if (pdPASS == retval)
        vTaskStartScheduler();
    else
        return -1;

    /* Should nerver run to here */
    while (1)
    {
    }
}

static void task_app(void *arg)
{
    BaseType_t retval = pdPASS;

    taskENTER_CRITICAL();

    /* Create event group */
    g_event_test = xEventGroupCreate();

    if (g_event_test != NULL)
        printf("Create Event OK\r\n");

    /* Create task 1 */
    retval = xTaskCreate(task_1, "Task_1", 128, NULL, 2, &g_task_1_handle);

    if (pdPASS == retval)
        printf("Task 1 Created\r\n");

    /* Create task 2 */
    retval = xTaskCreate(task_2, "Task_2", 128, NULL, 3, &g_task_2_handle);

    if (pdPASS == retval)
        printf("Task 2 Created\r\n");

    /* Create notify generator task*/
    retval = xTaskCreate(task_3, "Notify_Task", 128, NULL, 4, &g_task_3_handle);

    if (pdPASS == retval)
        printf("Task Notify Gen Created\r\n");

    /* Delete self */
    vTaskDelete(g_task_app_handle);

    taskEXIT_CRITICAL();
}
static void task_1(void *arg)
{
    while (1)
    {
        /* Waiting for notify bit1 */
        xEventGroupWaitBits(g_event_test, BIT(0), pdTRUE, pdTRUE, portMAX_DELAY);
        printf("Task1 get events ok!\r\n");
    }
}
static void task_2(void *arg)
{
    for (;;)
    {
        xEventGroupWaitBits(g_event_test, (BIT(0) | BIT(1)), pdTRUE, pdTRUE, portMAX_DELAY);
        printf("Task2 get events ok!\r\n");
    }
}

static void task_3(void *arg)
{
    uint32_t val = 0U;
    uint32_t i = 0U;
    const uint32_t EV_SEQ[] = {BIT(0), BIT(1), BIT(2), (BIT(0) | BIT(1)), (BIT(1) | BIT(2)), (BIT(0) | BIT(1) | BIT(2)) };

    for (;;)
    {
        /* Generate notify sequence 001 010 100 011 110 111 */
        for (i = 0; i < 6; i++)
        {
            val = EV_SEQ[i];
            printf("Signal gen %u\r\n", val);
            xEventGroupSetBits(g_event_test, val);
            vTaskDelay(500);
        }

        val = 0;
    }
}
