/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2022/1/28
*描  述:  FreeRTOS例程，printf打印，TX:PA8
          可调用标准库使用，需要以下三个步骤
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR的Library选择Full
*备  注:  适用于ES8H018x芯片
          本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include <stdio.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>
#include <stream_buffer.h>
#include <semphr.h>
#include "main.h"

/*任务句柄*/
static TaskHandle_t g_task_app_handle = NULL;
static TaskHandle_t g_task_1_handle = NULL;
static TimerHandle_t g_timer_test;

/* 任务 */
static void task_app(void *arg);
static void task_1(void *arg);

/* 定时器回调函数 */
static void timer_callback(TimerHandle_t timer);

int main(void)
{
    int retval;
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    UARTInit();                         //UART初始化(115200,8,NO,1)
    printf("Startup\r\n");

    retval = xTaskCreate(task_app, "AppTaskCreate", 128, NULL, 1, &g_task_app_handle);

    /* Start task schedule*/
    if (pdPASS == retval)
        vTaskStartScheduler();
    else
        return -1;

    /* Should nerver run to here */
    while (1)
    {
    }
}

static void task_app(void *arg)
{
    BaseType_t retval = pdPASS;

    taskENTER_CRITICAL();

    /* Create and start timer for every 1000ms */
    g_timer_test = xTimerCreate("Test", 1000, pdTRUE, 0, timer_callback);

    if (g_timer_test != NULL)
        printf("Timer created\r\n");

    xTimerStart(g_timer_test, 0);
    /* Create task 1 */
    retval = xTaskCreate(task_1, "Task_1", 128, NULL, 2, &g_task_1_handle);

    if (pdPASS == retval)
        printf("Task 1 Created\r\n");

    /* Delete self */
    vTaskDelete(g_task_app_handle);

    taskEXIT_CRITICAL();
}

static void task_1(void *arg)
{
    uint32_t i = 0U;

    while (1)
    {
        printf("Task1 Running, count %d\r\n", i);

        vTaskDelay(500);

        i++;
    }
}

static void timer_callback(TimerHandle_t timer)
{
    printf("Timer cal\r\n");
}
