/*********************************************************
*Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
*文件名:  main.c
*作  者:  AE Team
*版  本:  V1.00
*日  期:  2022/1/28
*描  述:  FreeRTOS例程，printf打印，TX:PA8
          可调用标准库使用，需要以下三个步骤
          1、keil勾选Use MicroLIB ，2、main.c #include "stdio.h"，3、 #define __PRINTF_USE_UART3__
          2、IAR的Library选择Full
*备  注:  适用于ES8H018x芯片
          本软件仅供学习和演示使用，对用户直接引用代码所带来的风险或后果不承担任何法律责任。
**********************************************************/
#include <stdio.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>
#include <stream_buffer.h>
#include <semphr.h>
#include "main.h"

/* 任务句柄 */
static TaskHandle_t g_task_app_handle = NULL;
static TaskHandle_t g_task_1_handle = NULL;
static TaskHandle_t g_task_2_handle = NULL;
static QueueHandle_t s_queue_test = NULL;

/* 测试数据 */
static uint32_t g_producer_val = 0, g_consumer_val = 0;
static volatile uint32_t g_producer_err = 0, g_consumer_err = 0;

/* 任务定义 */
static void task_app(void *arg);
static void task_1(void *arg);
static void task_2(void *arg);

int main(void)
{
    int retval;
    SystemHRCSelect(SCU_HRC_16M);       //HRC选择16MHz
    SystemClockConfig();                //配置时钟HRC
    DeviceClockAllEnable();             //打开所有外设时钟

    UARTInit();                         //UART初始化(115200,8,NO,1)
    printf("Startup\r\n");

    retval = xTaskCreate(task_app, "AppTaskCreate", 128, NULL, 1, &g_task_app_handle);

    /* Start task schedule*/
    if (pdPASS == retval)
        vTaskStartScheduler();
    else
        return -1;

    /* Should nerver run to here */
    while (1)
    {
    }
}

static void task_app(void *arg)
{
    BaseType_t retval = pdPASS;

    taskENTER_CRITICAL();

    /* Create Queue length = 5, item_size = 4 */
    s_queue_test = xQueueCreate(5, 4);

    if (s_queue_test != NULL)
        printf("Create Test_Queue OK\r\n");

    /* Create task 1 */
    retval = xTaskCreate(task_1, "Task_1", 128, NULL, 2, &g_task_1_handle);

    if (pdPASS == retval)
        printf("Task 1 Created\r\n");

    /* Create task 2 */
    retval = xTaskCreate(task_2, "Task_2", 128, NULL, 3, &g_task_2_handle);

    if (pdPASS == retval)
        printf("Task 2 Created\r\n");

    /* Delete self */
    vTaskDelete(g_task_app_handle);

    taskEXIT_CRITICAL();
}
static void task_1(void *arg)
{
    while (1)
    {
        /* Send message to queue */
        if (xQueueSend(s_queue_test, &g_producer_val, 3000) != pdTRUE)
        {
            /* Error */
            ++g_producer_err;
            printf("Send error count:%d\r\n", g_producer_err);
        }
        else
        {
            /* Update producer count */
            ++g_producer_val;
            /* Toggle 1 and print send count */
            printf("Send count:%d\r\n", g_producer_val);

            vTaskDelay(1000);
        }
    }
}
static void task_2(void *arg)
{
    uint32_t val = 0U;

    while (1)
    {
        /* Receive message from queue */
        if (xQueueReceive(s_queue_test, &val, 800) == pdTRUE)
        {
            /* Check if value received data correct */
            if (val == g_consumer_val)
            {
                /* Update producer count */
                ++g_consumer_val;
                printf("Recv count:%d\r\n", g_consumer_val);
            }
            else
            {
                /* Error */
                ++g_consumer_err;
                printf("Recv error count:%d\r\n", g_consumer_err);
            }
        }
        else
        {
            printf("Recv nothing!\r\n");
        }
    }
}
