/***************************************************************
 *Copyright (C), 2021, Shanghai Eastsoft Microelectronics Co., Ltd.
 *文件名： lib_iap.h
 *作  者:  AE Team
 *版  本:  V1.00
 *日  期:  2021/11/3
 *描  述：
 *备  注： 适用于ES8H018x芯片
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ***************************************************************/
#ifndef __LIB_IAP_H
#define __LIB_IAP_H

#include "ES8H018x.h"
#include "type.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef uint32_t (*iap_pageerase_t)(uint32_t address, uint32_t addressInv, uint32_t sector);
#define  IAP_PageErase  ((iap_pageerase_t)(*((uint32_t *)0x10000004)))

typedef uint32_t (*iap_wordprogrm_t)(uint32_t address, uint32_t addressInv, uint32_t data);
#define  IAP_WordProgram  ((iap_wordprogrm_t)(*((uint32_t *)0x10000008)))

typedef uint32_t (*iap_wordsprogrm_t)(uint32_t address, uint32_t addressInv, uint8_t data[], uint32_t length, uint32_t erase);
#define  IAP_WordsProgram  ((iap_wordsprogrm_t)(*((uint32_t *)0x10000000)))

void IAP_FLASH_Unlock(void);
void IAP_INFO_Unlock(void);
void IAP_FLASH_Lock(void);
void IAP_INFO_Lock(void);

uint32_t get_cusum32(uint32_t *data_ptr, uint32_t len);
uint8_t check_empty(uint32_t *data_ptr, uint32_t len);

#define PageEraseEnable             0x00000001
#define PageEraseDisable            0x00000000

#define  REMAP_DIS        SCU->TBLREMAPEN.EN = 1; SCU->TBLOFF.Word = 0;

#if defined(ES8H0184) || defined(ES8H0354) || defined(ES8H0364) || defined(ES8H0384) || defined(ES8H0394)
#define  REMAP_EN         SCU->TBLREMAPEN.EN = 1; SCU->TBLOFF.Word = 0x3E000;
#elif defined(ES8H0163) || defined(ES8H0173) || defined(ES8H0183) || defined(ES8H0193)
#define  REMAP_EN         SCU->TBLREMAPEN.EN = 1; SCU->TBLOFF.Word = 0x1E000;
#elif defined(ES8H0161) || defined(ES8H0181)
#define  REMAP_EN         SCU->TBLREMAPEN.EN = 1; SCU->TBLOFF.Word = 0x10000;
#else
    #error The chip model is not defined
#endif

#ifdef __cplusplus
}
#endif

#endif
/*************************END OF FILE**********************/
